/*************************************************************************
 *
 *  $RCSfile: sdoutl.cxx,v $
 *
 *  $Revision: 1.14 $
 *
 *  last change: $Author: dl $ $Date: 2001/12/14 07:44:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif
#ifndef _EEITEMID_HXX //autogen
#include <svx/eeitemid.hxx>
#endif
#ifndef _SVX_FONTITEM_HXX //autogen
#include <svx/fontitem.hxx>
#endif
#ifndef _SVX_FHGTITEM_HXX //autogen
#include <svx/fhgtitem.hxx>
#endif
#ifdef ITEMID_SEARCH
#undef ITEMID_SEARCH
#endif
#define ITEMID_SEARCH			SID_SEARCH_ITEM
#ifndef _SVXIDS_HRC
#include <svx/svxids.hrc>
#endif
#ifndef _SRCHITEM_HXX
#include <svx/srchitem.hxx>
#endif
#ifndef _OSPLCFG_HXX
#include <offmgr/osplcfg.hxx>
#endif
#ifndef _SVX_COLRITEM_HXX //autogen
#include <svx/colritem.hxx>
#endif
#ifndef _EEITEM_HXX //autogen
#include <svx/eeitem.hxx>
#endif
#ifndef _EDITSTAT_HXX //autogen
#include <svx/editstat.hxx>
#endif
#ifndef _SV_OUTDEV_HXX //autogen
#include <vcl/outdev.hxx>
#endif
#ifndef _DLGUTIL_HXX
#include <svx/dlgutil.hxx>
#endif
#ifndef _XTABLE_HXX
#include <svx/xtable.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFX_PRINTER_HXX //autogen
#include <sfx2/printer.hxx>
#endif
#ifndef _SVXERR_HXX //autogen
#include <svx/svxerr.hxx>
#endif
#ifndef _SVDOTEXT_HXX //autogen
#include <svx/svdotext.hxx>
#endif
#ifndef _OFFAPP_HXX //autogen
#include <offmgr/app.hxx>
#endif
#ifndef _SVDITER_HXX //autogen
#include <svx/svditer.hxx>
#endif
#ifndef _UNO_LINGU_HXX
#include <svx/unolingu.hxx>
#endif
#include <comphelper/extract.hxx>
#ifndef _COM_SUN_STAR_LINGUISTIC2_XLINGUSERVICEMANAGER_HPP_
#include <com/sun/star/linguistic2/XLinguServiceManager.hpp>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#ifndef _EEITEM_HXX
#include <svx/eeitem.hxx>
#endif

#ifndef _FORBIDDENCHARACTERSTABLE_HXX
#include <svx/forbiddencharacterstable.hxx>
#endif

// #95227#
#ifndef _SVX_SRCHDLG_HXX
#include <svx/srchdlg.hxx>
#endif

#pragma hdrstop

#include "strings.hrc"
#include "eetext.hxx"
#include "sdpage.hxx"
#include "app.hxx"
#include "sdoutl.hxx"
#include "sdwindow.hxx"
#include "sdresid.hxx"
#include "drviewsh.hxx"
#include "outlnvsh.hxx"
#include "drawdoc.hxx"
#include "docshell.hxx"
#include "frmview.hxx"
#include "optsitem.hxx"

using namespace ::rtl;
using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::linguistic2;

class SfxStyleSheetPool;


/*************************************************************************
|*
|* Ctor
|*
\************************************************************************/

SdOutliner::SdOutliner( SdDrawDocument* pDoc, USHORT nMode ) :
	SdrOutliner( &pDoc->GetItemPool(), nMode ),
	pDrDoc(pDoc),
	pIter(NULL),
	pTextObj(NULL),
	pOutlView(NULL),
	eEditMode(EM_PAGE),
	ePageKind(PK_STANDARD),
	pViewShell(NULL),
	pView(NULL),
	bError(FALSE),
	bStringFound(FALSE)
{
	SetStyleSheetPool((SfxStyleSheetPool*) pDrDoc->GetStyleSheetPool());
	SetEditTextObjectPool( &pDoc->GetItemPool() );
	SetCalcFieldValueHdl(LINK(SD_MOD(), SdModule, CalcFieldValueHdl));
	SetForbiddenCharsTable( pDoc->GetForbiddenCharsTable() );

	ULONG nCntrl = GetControlWord();
	nCntrl |= EE_CNTRL_ALLOWBIGOBJS;
	nCntrl |= EE_CNTRL_URLSFXEXECUTE;
	nCntrl |= EE_CNTRL_MARKFIELDS;
	nCntrl |= EE_CNTRL_AUTOCORRECT;

	BOOL bHideSpell = TRUE;
	BOOL bOnlineSpell = FALSE;

	SdDrawDocShell* pDocSh = pDrDoc->GetDocSh();

	if (pDocSh)
	{
		bHideSpell = pDrDoc->GetHideSpell();
		bOnlineSpell = pDrDoc->GetOnlineSpell();
	}
	else
	{
		bHideSpell = sal_True;
		bOnlineSpell = sal_False;

		uno::Reference< beans::XPropertySet > xProp( SvxGetLinguPropertySet() );
		if( xProp.is() )
		{
			try
			{
				bHideSpell 	 = ::cppu::any2bool( xProp->getPropertyValue(
					rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "IsSpellHide" ))));
				bOnlineSpell = ::cppu::any2bool( xProp->getPropertyValue(
					rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "IsSpellAuto" ))));
			}
			catch(...)
			{
				DBG_ERROR( "Ill. type in linguistic property" );
			}
		}
	}

	if (bHideSpell)
		nCntrl |= EE_CNTRL_NOREDLINES;
	else
		nCntrl &= ~EE_CNTRL_NOREDLINES;

	if (bOnlineSpell)
		nCntrl |= EE_CNTRL_ONLINESPELLING;
	else
		nCntrl &= ~EE_CNTRL_ONLINESPELLING;

	SetControlWord(nCntrl);

	Reference< XMultiServiceFactory > xMgr( ::comphelper::getProcessServiceFactory() );
	Reference< XLinguServiceManager > xLinguServiceManager( xMgr->createInstance(
		OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.linguistic2.LinguServiceManager" ))),
														uno::UNO_QUERY );

	if ( xLinguServiceManager.is() )
	{
		Reference< XSpellChecker1 > xSpellChecker( xLinguServiceManager->getSpellChecker(), UNO_QUERY );
		if ( xSpellChecker.is() )
			SetSpeller( xSpellChecker );

		Reference< XHyphenator > xHyphenator( xLinguServiceManager->getHyphenator(), UNO_QUERY );
		if( xHyphenator.is() )
			SetHyphenator( xHyphenator );
	}

	SetDefaultLanguage( pDrDoc->GetLanguage( EE_CHAR_LANGUAGE ) );
}

/*************************************************************************
|*
|* Dtor
|*
\************************************************************************/

SdOutliner::~SdOutliner()
{
}


/*************************************************************************
|*
|* Spelling oder Search&Replace vorbereiten
|*
|* Ist die aktuelle ViewShell eine SdDrawViewShell, so wird eine OutlinerView
|* erzeugt und es wird in folgender Reihenfolge gesucht
|* (ausgehend von der aktuellen Sicht):
|*	 1. Zeichenmodus, alle Pages
|*	 2. Zeichenmodus, alle MasterPages
|*	 3. Notizmodus, alle Pages
|*	 4. Notizmodus, alle MasterPages
|*	 5. Handzettelmodus, alle MasterPages
|*	 6. Handzettelmodus, alle MasterPages
|*
|* Ist die aktuelle ViewShell eine SdOutlineViewShell, so wird in der schon
|* vorhandenen View gesucht. Eine Verzweigung in andere Arbeitsmodi gibt es
|* nicht.
|*
|* Ist die aktuelle ViewShell eine SdSlideViewShell, so erfolgt keine Aktion.
|*
\************************************************************************/

void SdOutliner::PrepareSpelling()
{
	SetRefDevice( pDrDoc->GetDocSh()->GetPrinter(TRUE) );

	pViewShell = PTR_CAST( SdViewShell, SfxViewShell::Current() );

	if( pViewShell )
	{
		pView = pViewShell->GetView();
		pWindow = pViewShell->GetActiveWindow();
		bStringFound = FALSE;

		if ( pViewShell->ISA(SdDrawViewShell) )
		{
			pOutlView = new OutlinerView( this, pWindow );
			ULONG nStat = pOutlView->GetControlWord();
			nStat &= ~EV_CNTRL_AUTOSCROLL;
			pOutlView->SetControlWord(nStat);
			InsertView( pOutlView );
			SetUpdateMode(FALSE);
			pOutlView->SetOutputArea( Rectangle( Point(), Size(1, 1) ) );
			SetPaperSize( Size(1, 1) );
			SetText( String(), GetParagraph( 0 ) );

			ePageKind = ( (SdDrawViewShell*) pViewShell)->GetPageKind();
			eEditMode = ( (SdDrawViewShell*) pViewShell)->GetEditMode();

			if ( eEditMode == EM_PAGE )
				nPageCount = pDrDoc->GetSdPageCount(ePageKind);
			else
				nPageCount = pDrDoc->GetMasterSdPageCount(ePageKind);

			nPage = (USHORT) -1;

			nObj = (ULONG) -1;

			if ( pView->HasMarkedObj() )
			{
				/******************************************************************
				* Nur selektierte Objekte pruefen
				******************************************************************/
				const SdrMarkList& rMarkList = pView->GetMarkList();
				nObjCount= rMarkList.GetMarkCount();
			}
			else
			{
				nObjCount = 0;
			}
		}
		else if ( pViewShell->ISA(SdOutlineViewShell) )
		{
			pOutlView = GetView(0);
		}
	}

	ClearModifyFlag();
}

/*************************************************************************
|*
|* Spelling oder Search&Replace beenden
|*
\************************************************************************/

void SdOutliner::EndSpelling()
{
	pViewShell = PTR_CAST( SdViewShell, SfxViewShell::Current() );
	sal_Bool bViewIsDrawViewShell(pViewShell && pViewShell->ISA(SdDrawViewShell));

	if ( bViewIsDrawViewShell )
	{
		pView = pViewShell->GetView();
		pView->EndTextEdit();

		RemoveView( pOutlView );
		delete pOutlView;
		SetUpdateMode(TRUE);
	}

	// #95811# Before clearing the modify flag use it as a hint that
	// changes were done at SpellCheck
	if(IsModified())
	{
		if(pView && pView->ISA(SdOutlineView))
			((SdOutlineView*)pView)->PrepareClose(FALSE);
		if(pDrDoc && !pDrDoc->IsChanged())
			pDrDoc->SetChanged(TRUE);
	}

	// #95811# now clear the modify flag to have a specified state of SdOutliner
	ClearModifyFlag();

	delete pIter;
	pIter = NULL;

}


/*************************************************************************
|*
|* Spelling: Pruefung starten
|*
\************************************************************************/

void SdOutliner::StartSpelling()
{
	BOOL bMultiDoc = FALSE;

	if ( pViewShell->ISA(SdDrawViewShell) )
		bMultiDoc = TRUE;

	EESpellState eState = pOutlView->StartSpeller( bMultiDoc );

	if (bMultiDoc)
	{
		ESelection aSelection;
		pOutlView->SetSelection(aSelection);
		pView->EndTextEdit();
	}

	if (eState == EE_SPELL_NOLANGUAGE)
	{
		ErrorBox(pWindow, WB_OK, String(SdResId(STR_NOLANGUAGE))).Execute();
	}
	else
	{
		if (pView->HasMarkedObj())
		{
			InfoBox(pWindow, String(SdResId(STR_END_SPELLING_OBJ))).Execute();
		}
		else
		{
			InfoBox(pWindow, String(SdResId(STR_END_SPELLING))).Execute();
		}
	}
}


/*************************************************************************
|*
|* Spelling: naechstes TextObjekt pruefen
|*
\************************************************************************/

BOOL SdOutliner::SpellNextDocument()
{
	pDrDoc->GetDocSh()->SetWaitCursor( TRUE );
	BOOL bNextDoc = FALSE;
	BOOL bEndSpelling = FALSE;

	pView->EndTextEdit();
	SetUpdateMode(FALSE);
	pOutlView->SetOutputArea( Rectangle( Point(), Size(1, 1) ) );
	SetPaperSize( Size(1, 1) );
	SetText( String(), GetParagraph( 0 ) );

	const SdrMarkList& rMarkList = pView->GetMarkList();
	SdrObject* pObj = pTextObj = NULL;
	OutlinerParaObject* pParaObj = NULL;

	do
	{
		pObj = NULL;
		pParaObj = NULL;

		if ( pView->HasMarkedObj() )
		{
			/******************************************************************
			* Nur selektierte Objekte pruefen
			******************************************************************/
			nObj++;

			if ( nObj < nObjCount )
			{
				SdrMark* pMark = rMarkList.GetMark(nObj);
				pObj = pMark->GetObj();
			}
			else
			{
				// Ende
				pObj = NULL;
				bEndSpelling = TRUE;
			}
		}
		else
		{
			/**********************************************************************
			* Alle Objekte auf allen Seiten pruefen
			**********************************************************************/
			nObj++;

			if ( !pIter || !pIter->IsMore() )
			{
				nPage++;

				if ( nPage < nPageCount || nPage == (USHORT) -1 )
				{
					/******************************************************
					* Naechste Seite
					******************************************************/
					if ( eEditMode == EM_PAGE )
					{
						delete pIter;
						const SdPage* pPage = pDrDoc->GetSdPage(nPage, ePageKind);
						pIter = new SdrObjListIter(*pPage);
						nObjCount = pPage->GetObjCount();
					}
					else
					{
						delete pIter;
						const SdPage* pMPage = pDrDoc->GetMasterSdPage(nPage, ePageKind);
						pIter = new SdrObjListIter(*pMPage);
						nObjCount = pMPage->GetObjCount();
					}

					if (nObjCount == 0)
					{
						nObj = (ULONG) -1;
					}
					else
					{
						nObj = 0;
					}
				}
				else
				{
					if ( eEditMode == EM_PAGE )
					{
						/**************************************************
						* Jetzt MasterPages durchsuchen
						**************************************************/
						eEditMode = EM_MASTERPAGE;
						nPageCount = pDrDoc->GetMasterSdPageCount(ePageKind);
					}
					else if ( ePageKind == PK_STANDARD )
					{
						/**************************************************
						* Jetzt Notizseiten durchsuchen
						**************************************************/
						ePageKind = PK_NOTES;
						eEditMode = EM_PAGE;
						nPageCount = pDrDoc->GetSdPageCount(ePageKind);
					}
					else if ( ePageKind == PK_NOTES )
					{
						/**************************************************
						* Jetzt Handzettelseiten durchsuchen
						**************************************************/
						ePageKind = PK_HANDOUT;
						eEditMode = EM_PAGE;
						nPageCount = pDrDoc->GetSdPageCount(ePageKind);
					}
					else
					{
						/**************************************************
						* Alles durchsucht: Ende
						**************************************************/
						delete pIter;
						pIter = NULL;
						bEndSpelling = TRUE;
					}

					nObj = (ULONG) -1;
					nObjCount = 0;
					nPage = (USHORT) -1;
				}
			}

			if ( pIter && nObj != (ULONG) -1 )
			{
				pObj = pIter->Next();
			}
		}

		if ( pObj && pObj->ISA(SdrTextObj)    &&
			 ( (SdrTextObj*) pObj)->HasText() &&
			 !pObj->IsEmptyPresObj() )
		{
			/******************************************************************
			* Text in den Outliner setzen
			******************************************************************/
			pTextObj = (SdrTextObj*) pObj;
			pParaObj = pTextObj->GetOutlinerParaObject();

			if ( pParaObj )
			{
				pViewShell = PTR_CAST( SdViewShell,  SfxViewShell::Current() );

				if( pViewShell )
				{
					pView = pViewShell->GetView();
					pWindow = pViewShell->GetActiveWindow();
					pOutlView->SetWindow(pWindow);

					SetText(*pParaObj);

					ClearModifyFlag();
					EESpellState eState = HasSpellErrors();

					DBG_ASSERT(eState != EE_SPELL_NOSPELLER, "No SpellChecker");

					if (eState == EE_SPELL_NOLANGUAGE)
					{
						bError = TRUE;
						ErrorBox(pWindow, WB_OK, String(SdResId(STR_NOLANGUAGE))).
						Execute();
					}
					else if (eState != EE_SPELL_OK)
					{
						/**********************************************************
						* Fehler: Seite anwaehlen und View auf das Objekt aufmachen
						**********************************************************/
						if ( ePageKind != ( (SdDrawViewShell*) pViewShell)->GetPageKind() )
						{
							/******************************************************
							* ViewShell wechseln
							******************************************************/
							SetStatusEventHdl(Link());
							pViewShell->GetFrameView()->SetPageKind(ePageKind);
							pViewShell->GetViewFrame()->GetDispatcher()->Execute(
								SID_VIEWSHELL0, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD );
                            pViewShell = pDrDoc->GetDocSh()->GetViewShell();
							pView = pViewShell->GetView();
							pWindow = pViewShell->GetActiveWindow();
							pOutlView->SetWindow( pWindow );
						}

						if ( !pView->HasMarkedObj() )
						{
							/******************************************************
							* Seite bzw. MasterPage waehlen
							******************************************************/
							( (SdDrawViewShell*) pViewShell )->ChangeEditMode(eEditMode, FALSE);
							( (SdDrawViewShell*) pViewShell )->SwitchPage(nPage);
						}

						pOutlView->SetOutputArea( Rectangle( Point(), Size(1, 1) ) );
						SetPaperSize( pTextObj->GetLogicRect().GetSize() );
						SdrPageView* pPV = pView->GetPageViewPvNum(0);
						FASTBOOL bIsNewObj = TRUE;
						pView->BegTextEdit(pTextObj, pPV, pWindow, bIsNewObj, this,
									   	pOutlView, TRUE, TRUE);
						SetUpdateMode(TRUE);
						bNextDoc = TRUE;
					}
				}
			}
		}
		else
		{
			pTextObj = NULL;
		}
	}
	while ( !bEndSpelling && !bNextDoc && !bError );

	pDrDoc->GetDocSh()->SetWaitCursor( FALSE );
	ClearModifyFlag();

	return(bNextDoc);
}



/*************************************************************************
|*
|* Search&Replace: naechstes TextObjekt pruefen
|*
\************************************************************************/

BOOL SdOutliner::StartSearchAndReplace( const SvxSearchItem* pSearchItem )
{
	if (pView->HasMarkedObj() && pView->GetMarkList().GetMarkCount() != (ULONG) nObjCount)
	{
		// Anzahl Objekt hat sich geaendert
		nObj = (ULONG) -1;
		nObjCount = pView->GetMarkList().GetMarkCount();
	}

	if ((eEditMode == EM_PAGE && pDrDoc->GetSdPageCount(ePageKind) != nPageCount) ||
		(eEditMode == EM_MASTERPAGE && pDrDoc->GetMasterSdPageCount(ePageKind) != nPageCount))
	{
		// Anzahl Seiten hat sich geaendert
		nPage = (USHORT) -1;

		if ( eEditMode == EM_PAGE )
			nPageCount = pDrDoc->GetSdPageCount(ePageKind);
		else
			nPageCount = pDrDoc->GetMasterSdPageCount(ePageKind);
	}

	BOOL bEndSearching = FALSE;

	pDrDoc->GetDocSh()->SetWaitCursor( TRUE );
	pViewShell = PTR_CAST( SdViewShell, SfxViewShell::Current() );

	if( pViewShell )
	{
		pView = pViewShell->GetView();
		pWindow = pViewShell->GetActiveWindow();
		pOutlView->SetWindow(pWindow);

		if ( pViewShell->ISA(SdDrawViewShell) )
		{
			if (pOutlView->StartSearchAndReplace(*pSearchItem) == 0)
			{
				BOOL bNextDoc = FALSE;

				OutlinerView* pEditOutlinerView = pView->GetTextEditOutlinerView();
				pView->EndTextEdit();
				SetUpdateMode(FALSE);
				pOutlView->SetOutputArea( Rectangle( Point(), Size(1, 1) ) );
				SetText( String(), GetParagraph( 0 ) );

				const SdrMarkList& rMarkList = pView->GetMarkList();
				SdrObject* pObj = pTextObj = NULL;
				OutlinerParaObject* pParaObj = NULL;

				do
				{
					pObj = NULL;
					pParaObj = NULL;

					if ( pView->HasMarkedObj() )
					{
						/**************************************************************
						* Nur selektierte Objekte pruefen
						**************************************************************/
						nObj++;

						if ( nObj < nObjCount )
						{
							SdrMark* pMark = rMarkList.GetMark(nObj);
							pObj = pMark->GetObj();
						}
						else
						{
							// Ende
							pObj = NULL;
							nObj = (ULONG) -1;
							bEndSearching = TRUE;

							String aString;

							if (bStringFound)
							{
								aString = String( SdResId(STR_END_SEARCHING) );
							}
							else
							{
								aString = String( SdResId(STR_STRING_NOTFOUND) );
							}

							// #95227# use correct parent
							SvxSearchDialog* pSearchDialog =
								((SvxSearchDialog*)(SfxViewFrame::Current()->GetChildWindow(
								SvxSearchDialogWrapper::GetChildWindowId())->GetWindow()));
							if(pSearchDialog)
								InfoBox(pSearchDialog, aString).Execute();
							else
								InfoBox(pWindow, aString).Execute();
						}
					}
					else
					{
						/**************************************************************
						* Alle Objekte auf allen Seiten pruefen
						**************************************************************/
						nObj++;

						if ( !pIter || !pIter->IsMore() )
						{
							nPage++;

							if ( nPage < nPageCount || nPage == (USHORT) -1 )
							{
								/**************************************************
								* Naechste Seite
								**************************************************/
								if ( eEditMode == EM_PAGE )
								{
									delete pIter;
									const SdrPage* pPage = pDrDoc->GetSdPage(nPage, ePageKind);
									pIter = new SdrObjListIter(*pPage);
									nObjCount = pPage->GetObjCount();
								}
								else
								{
									delete pIter;
									const SdrPage* pMPage = pDrDoc->GetMasterSdPage(nPage, ePageKind);
									pIter = new SdrObjListIter(*pMPage);
									nObjCount = pMPage->GetObjCount();
								}

								if (nObjCount == 0)
								{
									nObj = (ULONG) -1;
								}
								else
								{
									nObj = 0;
								}
							}
							else
							{
								if ( eEditMode == EM_PAGE )
								{
									/**************************************************
									* Jetzt MasterPages durchsuchen
									**************************************************/
									eEditMode = EM_MASTERPAGE;
									nPageCount = pDrDoc->GetMasterSdPageCount(ePageKind);
								}
								else if ( ePageKind == PK_STANDARD )
								{
									/**************************************************
									* Jetzt Notizseiten durchsuchen
									**************************************************/
									ePageKind = PK_NOTES;
									eEditMode = EM_PAGE;
									nPageCount = pDrDoc->GetSdPageCount(ePageKind);
								}
								else if ( ePageKind == PK_NOTES )
								{
									/**************************************************
									* Jetzt Handzettelseiten durchsuchen
									**************************************************/
									ePageKind = PK_HANDOUT;
									eEditMode = EM_PAGE;
									nPageCount = pDrDoc->GetSdPageCount(ePageKind);
								}
								else
								{
									/**************************************************
									* Alles durchsucht: Ende
									**************************************************/
									bEndSearching = TRUE;
									delete pIter;
									pIter = NULL;

									String aString;

									if (bStringFound)
									{
										aString = String( SdResId(STR_END_SEARCHING) );
									}
									else
									{
										aString = String( SdResId(STR_STRING_NOTFOUND) );
									}

									// #95227# use correct parent
									SvxSearchDialog* pSearchDialog =
										((SvxSearchDialog*)(SfxViewFrame::Current()->GetChildWindow(
										SvxSearchDialogWrapper::GetChildWindowId())->GetWindow()));
									if(pSearchDialog)
										InfoBox(pSearchDialog, aString).Execute();
									else
										InfoBox(pWindow, aString).Execute();
								}

								nObj = (ULONG) -1;
								nObjCount = 0;
								nPage = (USHORT) -1;
							}
						}

						if ( pIter && nObj != (ULONG) -1 )
						{
							pObj = pIter->Next();
						}
					}

					if ( pObj && pObj->ISA(SdrTextObj)    &&
					 	( (SdrTextObj*) pObj)->HasText() &&
					 	!pObj->IsEmptyPresObj() )
					{
						/**************************************************************
						* Text in den Outliner setzen
						**************************************************************/
						pTextObj = (SdrTextObj*) pObj;
						pParaObj = pTextObj->GetOutlinerParaObject();

						if ( pParaObj )
						{
							pViewShell = (SdViewShell*) SfxViewShell::Current();
							pView = pViewShell->GetView();
							pWindow = pViewShell->GetActiveWindow();
							pOutlView->SetWindow(pWindow);

							SetText(*pParaObj);
							ClearModifyFlag();

							if ( HasText( *pSearchItem ) )
							{
								/**********************************************************
								* Gefunden: Seite anwaehlen und View auf das Objekt aufmachen
								**********************************************************/
								bStringFound = TRUE;

								if ( ePageKind !=
									( (SdDrawViewShell*) pViewShell)->GetPageKind() )
								{
									/******************************************************
									* ViewShell wechseln
									******************************************************/
									SetStatusEventHdl(Link());
									pViewShell->GetFrameView()->SetPageKind(ePageKind);
									pViewShell->GetViewFrame()->GetDispatcher()->Execute(
										SID_VIEWSHELL0, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD );
                                    pViewShell = pDrDoc->GetDocSh()->GetViewShell();
									pView = pViewShell->GetView();
									pWindow = pViewShell->GetActiveWindow();
									pOutlView->SetWindow( pWindow );
								}

								if ( !pView->HasMarkedObj() )
								{
									/******************************************************
									* Seite bzw. MasterPage waehlen
									******************************************************/
									( (SdDrawViewShell*) pViewShell )->ChangeEditMode(eEditMode, FALSE);
									( (SdDrawViewShell*) pViewShell )->SwitchPage(nPage);
								}

								pOutlView->SetOutputArea( Rectangle( Point(), Size(1, 1) ) );
								SetPaperSize( pTextObj->GetLogicRect().GetSize() );
								SdrPageView* pPV = pView->GetPageViewPvNum(0);
								FASTBOOL bIsNewObj = TRUE;
								pView->BegTextEdit(pTextObj, pPV, pWindow, bIsNewObj,
											   	this, pOutlView, TRUE, TRUE);
								SetUpdateMode(TRUE);
								bNextDoc = TRUE;
								pDrDoc->GetDocSh()->SetWaitCursor( FALSE );
								pOutlView->StartSearchAndReplace(*pSearchItem);
							}
						}
					}
					else
					{
						pTextObj = NULL;
					}
				}
				while ( !bEndSearching && !bNextDoc && !bError );
			}
			else
			{
				pDrDoc->GetDocSh()->SetWaitCursor( FALSE );
			}

		}
		else if ( pViewShell->ISA(SdOutlineViewShell) )
		{
			pDrDoc->GetDocSh()->SetWaitCursor( FALSE );
			USHORT nRet = pOutlView->StartSearchAndReplace(*pSearchItem);
		}
	}

	pDrDoc->GetDocSh()->SetWaitCursor( FALSE );

	return(bEndSearching);
}



/*************************************************************************
|*
|* SpellChecker: Error-LinkHdl
|*
\************************************************************************/

IMPL_LINK_INLINE_START( SdOutliner, SpellError, void *, nLang )
{
	bError = TRUE;
	String aError( ::GetLanguageString( (LanguageType)(ULONG)nLang ) );
	ErrorHandler::HandleError(* new StringErrorInfo(
								ERRCODE_SVX_LINGU_LANGUAGENOTEXISTS, aError) );
	return 0;
}
IMPL_LINK_INLINE_END( SdOutliner, SpellError, void *, nLang )



