/*************************************************************************
 *
 *  $RCSfile: fuslprms.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: ka $ $Date: 2000/09/21 16:11:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFX_BINDINGS_HXX //autogen
#include <sfx2/bindings.hxx>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <sfx2/request.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif
#ifndef _SFX_OBJSH_HXX //autogen
#include <sfx2/objsh.hxx>
#endif

#include "app.hrc"

#include "fuslprms.hxx"
#include "sdpage.hxx"
#include "pres.hxx"
#include "drawdoc.hxx"
#include "sdattr.hxx"
#include "sdwindow.hxx"
#include "viewshel.hxx"
#include "slidvish.hxx"
#include "slidview.hxx"
#include "unslprms.hxx"                 // Undo-Action
#include "sdundogr.hxx"                 // Undo Gruppe
#include "sdresid.hxx"
#include "strings.hrc"
#include "preview.hxx"
#include "prevchld.hxx"

using namespace ::com::sun::star;

TYPEINIT1( FuSlideParameters, FuPoor );

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

FuSlideParameters::FuSlideParameters(SdViewShell*	 pViewSh,
									 SdWindow*		 pWin,
									 SdView*		 pView,
									 SdDrawDocument* pDoc,
									 SfxRequest&	 rReq)
	: FuPoor(pViewSh, pWin, pView, pDoc, rReq)
{
	SdPage* pPage	   = NULL;
	USHORT	nNoOfPages = pDoc->GetSdPageCount(PK_STANDARD);
	USHORT	nPage;

	// falls nichts selektiert ist, machen wir das schnell selbst
	for (USHORT i = 0; i < nNoOfPages; i++)
	{
		pPage = pDoc->GetSdPage(i, PK_STANDARD);
		if (pPage->IsSelected())
		{
			break;
		}
	}
	if (!(pPage->IsSelected()))
	{
		pPage = pDoc->GetSdPage(0, PK_STANDARD);
		pDoc->SetSelected(pPage, TRUE);

		// ist Selektion sichtbar?
		if (pViewShell->ISA(SdSlideViewShell))
		{
			((SdSlideView*)pView)->DrawSelectionRect((USHORT)0);
		}
	}

	const SfxItemSet* pArgs = rReq.GetArgs();

	// Undo Gruppe erzeugen
	SdUndoGroup* pUndoGroup = new SdUndoGroup(pDoc);
	String aComment(SdResId(STR_UNDO_SLIDE_PARAMS));
	pUndoGroup->SetComment(aComment);

	for (nPage = 0; nPage < nNoOfPages; nPage++)
	{
		pPage = pDoc->GetSdPage(nPage, PK_STANDARD);
		if (pPage->IsSelected())
		{
			// alte Attribute fuer UndoAction merken
			FadeSpeed  eOldFadeSpeed  = pPage->GetFadeSpeed();
			presentation::FadeEffect eOldFadeEffect = pPage->GetFadeEffect();
			PresChange eOldChange	  = pPage->GetPresChange();
			UINT32	   nOldTime 	  = pPage->GetTime();
			BOOL	   bOldSoundOn	  = pPage->IsSoundOn();
			String	   aOldSoundFile  = pPage->GetSoundFile();

			if (pArgs->GetItemState(ATTR_DIA_EFFECT) == SFX_ITEM_SET)
			{
			   presentation::FadeEffect eOldEffect = pPage->GetFadeEffect();
			   presentation::FadeEffect eNewEffect = (presentation::FadeEffect)((const DiaEffectItem&)
										   pArgs->Get(ATTR_DIA_EFFECT)).
											   GetValue();

				pPage->SetFadeEffect((presentation::FadeEffect)((const DiaEffectItem&)
						pArgs->Get(ATTR_DIA_EFFECT)).GetValue());

				// ist es eine Aenderung und kann man sie sehen?
				if (((eOldEffect != presentation::FadeEffect_NONE &&
					  eNewEffect == presentation::FadeEffect_NONE)	  ||
					 (eOldEffect == presentation::FadeEffect_NONE &&
					  eNewEffect != presentation::FadeEffect_NONE))	 &&
					(pViewShell->ISA(SdSlideViewShell)))
				{
					pView->InvalidateAllWin(((SdSlideView*)pView)->
												  GetFadeIconArea(nPage));
				}
			}

			if (pArgs->GetItemState(ATTR_DIA_SPEED) == SFX_ITEM_SET)
				pPage->SetFadeSpeed((FadeSpeed)((const DiaSpeedItem&)
						pArgs->Get(ATTR_DIA_SPEED)).GetValue());

			if (pArgs->GetItemState(ATTR_DIA_TIME) == SFX_ITEM_SET)
				pPage->SetTime(((DiaTimeItem&)
						pArgs->Get(ATTR_DIA_TIME)).GetValue());

			if (pArgs->GetItemState(ATTR_DIA_AUTO) == SFX_ITEM_SET)
				pPage->SetPresChange(((DiaAutoItem&)
						pArgs->Get(ATTR_DIA_AUTO)).GetValue());

			if (pArgs->GetItemState(ATTR_DIA_SOUND) == SFX_ITEM_SET)
				pPage->SetSound(((SfxBoolItem&)
						pArgs->Get(ATTR_DIA_SOUND)).GetValue());

			if (pArgs->GetItemState(ATTR_DIA_SOUNDFILE) == SFX_ITEM_SET)
			{
				String aTemp(((SfxStringItem&)pArgs->Get(ATTR_DIA_SOUNDFILE)).GetValue());
				pPage->SetSoundFile(aTemp);
			}

			// Undo-Action erzeugen und in Gruppe stellen
			SdUndoAction* pUndoAction = new SlideParametersUndoAction
							(pDoc, pPage,
							 eOldFadeSpeed,  pPage->GetFadeSpeed(),
							 eOldFadeEffect, pPage->GetFadeEffect(),
							 eOldChange,	 pPage->GetPresChange(),
							 nOldTime,		 pPage->GetTime(),
							 bOldSoundOn,	 pPage->IsSoundOn(),
							 aOldSoundFile,  pPage->GetSoundFile());
			pUndoGroup->AddAction(pUndoAction);
		}
	}

	// Undo Gruppe dem Undo Manager uebergeben
	pViewSh->GetViewFrame()->GetObjectShell()->GetUndoManager()->
				AddUndoAction(pUndoGroup);

	/***************************************************************
	|* ggfs. in Preview anzeigen
	\**************************************************************/
	SfxChildWindow* pPreviewChildWindow =
		pViewShell->GetViewFrame()->GetChildWindow(SdPreviewChildWindow::GetChildWindowId());
	if (pPreviewChildWindow)
	{
		SdPreviewWin* pPreviewWin =
			(SdPreviewWin*)pPreviewChildWindow->GetWindow();
		if (pPreviewWin && pPreviewWin->GetDoc() == pDoc)
		{
			pPreviewWin->AnimatePage();
		}
	}


	static USHORT SidArray[] = {
					SID_DIA_EFFECT,
					SID_DIA_SPEED,
					SID_DIA_AUTO,
					SID_DIA_TIME,
					0 };

	pViewShell->GetViewFrame()->GetBindings().Invalidate( SidArray );
	pViewShell->UpdateSlideChangeWindow(); // Diawechsel-Window

	// Model geaendert
	pDoc->SetChanged();
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

FuSlideParameters::~FuSlideParameters()
{
}

/*************************************************************************
|*
|* Function aktivieren
|*
\************************************************************************/

void FuSlideParameters::Activate()
{
	FuPoor::Activate();

}

/*************************************************************************
|*
|* Function deaktivieren
|*
\************************************************************************/

void FuSlideParameters::Deactivate()
{
	FuPoor::Deactivate();
}


