/*************************************************************************
 *
 *  $RCSfile: databrws.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:46:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SCH_DATABRWS_HXX
#define _SCH_DATABRWS_HXX
//------------------------------------------------------------------
//
// dieses Define dient nur zum Testen und darf auf keinen Fall aktiv bleiben
// Bei Umstellungen alle Files nach SIG_CHARTMODELDEFSCHDOC durchsuchen
// #define ChartModel SchChartDocument
//------------------------------------------------------------------

#ifndef _SVX_BRWBOX_HXX //autogen
#include <svtools/brwbox.hxx>
#endif


#ifndef _SV_OUTDEV_HXX //autogen
#include <vcl/outdev.hxx>
#endif

#include "datalog.hxx"
class ChartModel;
class SchMemChart;

/*************************************************************************
|*
|* Browser fuer Chart-Daten
|*
\************************************************************************/

class ChartDataBrowseBox : public BrowseBox
{
private:
	const ChartModel*	pModel;
	SchMemChart*		pMemChart;
	SchDataLogBook*     pLogBook;
	long				nRow;
	Link				aCursorMovedHdlLink;
	Link				aEditFieldHdlLink;
	Link				aClickHdlLink;
	KeyEvent            aKeyEvent;
	BOOL                bValidKey;

	void RenewTable();
	String GetColString(USHORT nColumnId) const;
	String GetRowString(long nRow) const;

	void KeyLeft ();

	void KeyRight ();

	void KeyUp ();

	void KeyDown ();

protected:
	virtual BOOL SeekRow(long nR);
	virtual void PaintField(OutputDevice& rDev, const Rectangle& rRect,
							USHORT nColumnId) const;
	virtual void CursorMoved();
	virtual void KeyInput(const KeyEvent& rEvt);
	virtual void MouseButtonDown(const BrowserMouseEvent& rEvt);

public:
	ChartDataBrowseBox(Window* pParent, const ResId& rId);
	virtual ~ChartDataBrowseBox();

	void SetData(const ChartModel* pDoc);
	const SchMemChart* GetData() const { return pMemChart; }
	BOOL CanModifyColumn() { return GetCurColumnId() > 1; }
	BOOL CanModifyRow() { return GetCurRow() > 0; }
	void InsertColumn();
	void RemoveColumn();
	void InsertRow();
	void RemoveRow();
	void SwapColumn();
	void SwapRow();
	String GetActString() const;
	BOOL SetActString(const String& aString);
	String GetActPosString() const;
	void SetCursorMovedHdl(const Link& rLink) { aCursorMovedHdlLink = rLink; }
	const Link& GetCursorMovedHdl() const { return aCursorMovedHdlLink; }
	void SetEditFieldHdl(const Link& rLink) { aEditFieldHdlLink = rLink; }
	const Link& GetEditFieldHdl() const { return aEditFieldHdlLink; }
	void SetClickHdl(const Link& rLink) { aClickHdlLink = rLink; }
	const Link& GetClickHdl() const { return aClickHdlLink; }
	const KeyEvent& LoadKey () const
	{
		return aKeyEvent;
	}

	BOOL IsValidKey () const
	{
		return bValidKey;
	}

	void QuickSortCols ();

	void QuickSortRows ();

	void QuickSortTableCols ();

	void QuickSortTableRows ();

};

#endif	// _SCH_DATABRSW_HXX


