/*************************************************************************
 *
 *  $RCSfile: tabvwshh.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: nn $ $Date: 2001/10/05 14:33:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PCH
#include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

#include <svx/svdmark.hxx>
#include <svx/svdoole2.hxx>
#include <svx/svdview.hxx>
#include <sfx2/app.hxx>
#include <sfx2/objsh.hxx>
#include <sfx2/request.hxx>
#include <svtools/sbxcore.hxx>
#include <so3/ipobj.hxx>
#include <svtools/whiter.hxx>

#include "tabvwsh.hxx"
#include "client.hxx"
#include "document.hxx"
#include "docsh.hxx"
#include "sc.hrc"
#include "drwlayer.hxx"		// GetVisibleName

//------------------------------------------------------------------

void ScTabViewShell::ExecuteSbx( SfxRequest& rReq )
{
	//	SID_RANGE_OFFSET (Offset),
	//	SID_PIVOT_CREATE (DataPilotCreate) - removed (old Basic)
}

void ScTabViewShell::GetSbxState( SfxItemSet& rSet )
{
	//	SID_RANGE_REGION (CurrentRegion) - removed (old Basic)
}

//------------------------------------------------------------------

void ScTabViewShell::ExecuteObject( SfxRequest& rReq )
{
	USHORT nSlotId = rReq.GetSlot();
	const SfxItemSet* pReqArgs = rReq.GetArgs();

		//	Objekte aktivieren/deaktivieren immer auf der sichtbaren View

	ScTabViewShell* pVisibleSh = this;
	if ( nSlotId == SID_OLE_SELECT || nSlotId == SID_OLE_ACTIVATE || nSlotId == SID_OLE_DEACTIVATE )
	{
		DBG_ERROR("old slot SID_OLE...");
	}

	switch (nSlotId)
	{
		case SID_OLE_SELECT:
		case SID_OLE_ACTIVATE:
			{
				//	in beiden Faellen erstmal auf der sichtbaren View selektieren

				String aName;
				SdrView* pDrView = GetSdrView();
				if (pDrView)
				{
					const SdrMarkList& rMarkList = pDrView->GetMarkList();
					if (rMarkList.GetMarkCount() == 1)
						aName = ScDrawLayer::GetVisibleName( rMarkList.GetMark(0)->GetObj() );
				}
				pVisibleSh->SelectObject( aName );

				//	aktivieren

				if ( nSlotId == SID_OLE_ACTIVATE )
					pVisibleSh->DoVerb( 0 );
			}
			break;
		case SID_OLE_DEACTIVATE:
			{
				ScClient* pClient = (ScClient*) pVisibleSh->GetIPClient();
				if ( pClient && pClient->IsInPlaceActive() )
				{
					pClient->GetProtocol().Reset2Open();
					SFX_APP()->SetViewFrame(pVisibleSh->GetViewFrame());
				}
			}
			break;

		case SID_OBJECT_LEFT:
		case SID_OBJECT_TOP:
		case SID_OBJECT_WIDTH:
		case SID_OBJECT_HEIGHT:
			{
				BOOL bDone = FALSE;
				const SfxPoolItem* pItem;
				if ( pReqArgs && pReqArgs->GetItemState( nSlotId, TRUE, &pItem ) == SFX_ITEM_SET )
				{
					long nNewVal = ((const SfxInt32Item*)pItem)->GetValue();
					if ( nNewVal < 0 )
						nNewVal = 0;

					//!	von irgendwas in 1/100mm umrechnen ??????

					SdrView* pDrView = GetSdrView();
					if ( pDrView )
					{
						const SdrMarkList& rMarkList = pDrView->GetMarkList();
						if (rMarkList.GetMarkCount() == 1)
						{
							SdrObject* pObj = rMarkList.GetMark(0)->GetObj();
							Rectangle aRect = pObj->GetLogicRect();

							if ( nSlotId == SID_OBJECT_LEFT )
								pDrView->MoveMarkedObj( Size( nNewVal - aRect.Left(), 0 ) );
							else if ( nSlotId == SID_OBJECT_TOP )
								pDrView->MoveMarkedObj( Size( 0, nNewVal - aRect.Top() ) );
							else if ( nSlotId == SID_OBJECT_WIDTH )
								pDrView->ResizeMarkedObj( aRect.TopLeft(),
												Fraction( nNewVal, aRect.GetWidth() ),
												Fraction( 1, 1 ) );
							else // if ( nSlotId == SID_OBJECT_HEIGHT )
								pDrView->ResizeMarkedObj( aRect.TopLeft(),
												Fraction( 1, 1 ),
												Fraction( nNewVal, aRect.GetHeight() ) );
							bDone = TRUE;
						}
					}
				}
				if (!bDone)
					SbxBase::SetError( SbxERR_BAD_PARAMETER );	// Basic-Fehler
			}
			break;

	}
}

SvInPlaceObjectRef lcl_GetSelectedObj( SdrView* pDrView )		//! Member von ScDrawView?
{
	SvInPlaceObjectRef xRet;

	if (pDrView)
	{
		const SdrMarkList& rMarkList = pDrView->GetMarkList();
		if (rMarkList.GetMarkCount() == 1)
		{
			SdrObject* pObj = rMarkList.GetMark(0)->GetObj();
			if (pObj->GetObjIdentifier() == OBJ_OLE2)
			{
				SdrOle2Obj* pOle2Obj = (SdrOle2Obj*) pObj;
				xRet = pOle2Obj->GetObjRef();
			}
		}
	}

	return xRet;
}

void ScTabViewShell::GetObjectState( SfxItemSet& rSet )
{
	//	SID_OLE_OBJECT - removed (old Basic)

	SfxWhichIter aIter(rSet);
	USHORT nWhich = aIter.FirstWhich();
	while ( nWhich )
	{
		switch (nWhich)
		{
			case SID_ACTIVE_OBJ_NAME:
				{
					String aName;
					SvInPlaceObjectRef xOLE = lcl_GetSelectedObj( GetSdrView() );
					if (xOLE.Is())
					{
						SvInfoObject* pInfoObj = GetViewData()->GetSfxDocShell()->Find( xOLE );
						if ( pInfoObj )
							aName = pInfoObj->GetObjName();
					}
					rSet.Put( SfxStringItem( nWhich, aName ) );
				}
				break;
			case SID_OBJECT_LEFT:
			case SID_OBJECT_TOP:
			case SID_OBJECT_WIDTH:
			case SID_OBJECT_HEIGHT:
				{
					SdrView* pDrView = GetSdrView();
					if ( pDrView )
					{
						const SdrMarkList& rMarkList = pDrView->GetMarkList();
						if (rMarkList.GetMarkCount() == 1)
						{
							SdrObject* pObj = rMarkList.GetMark(0)->GetObj();
							Rectangle aRect = pObj->GetLogicRect();

							long nVal;
							if ( nWhich == SID_OBJECT_LEFT )
								nVal = aRect.Left();
							else if ( nWhich == SID_OBJECT_TOP )
								nVal = aRect.Top();
							else if ( nWhich == SID_OBJECT_WIDTH )
								nVal = aRect.GetWidth();
							else // if ( nWhich == SID_OBJECT_HEIGHT )
								nVal = aRect.GetHeight();

							//!	von 1/100mm in irgendwas umrechnen ??????

							rSet.Put( SfxInt32Item( nWhich, nVal ) );
						}
					}
				}
				break;
		}
		nWhich = aIter.NextWhich();
	}
}





