/*************************************************************************
 *
 *  $RCSfile: AccessiblePreviewCell.hxx,v $
 *
 *  $Revision: 1.6.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/31 16:28:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _SC_ACCESSIBLEPREVIEWCELL_HXX
#define _SC_ACCESSIBLEPREVIEWCELL_HXX

#ifndef _SC_ACCESSIBLECELLBASE_HXX
#include "AccessibleCellBase.hxx"
#endif

class ScPreviewShell;
class SvxAccessibleTextHelper;

class ScAccessiblePreviewCell : public ScAccessibleCellBase
{
public:
	//=====  internal  ========================================================
	ScAccessiblePreviewCell(
        const ::com::sun::star::uno::Reference<
	        ::drafts::com::sun::star::accessibility::XAccessible>& rxParent,
		ScPreviewShell* pViewShell, /* const */ ScAddress& rCellAddress, sal_Int32 nIndex );

protected:
	virtual ~ScAccessiblePreviewCell();

public:

    virtual void SAL_CALL disposing();

	//=====  XAccessibleComponent  ============================================

    virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::accessibility::XAccessible > SAL_CALL
    						getAccessibleAt( const ::com::sun::star::awt::Point& aPoint )
    							throw (::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL	grabFocus() throw (::com::sun::star::uno::RuntimeException);

	//=====  XAccessibleContext  ==============================================

    // overloaded to calculate this on demand
    virtual sal_Int32 SAL_CALL getAccessibleChildCount() throw (::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::accessibility::XAccessible > SAL_CALL
    						getAccessibleChild( sal_Int32 i )
    							throw (::com::sun::star::lang::IndexOutOfBoundsException,
    								::com::sun::star::uno::RuntimeException);

    virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::accessibility::XAccessibleStateSet > SAL_CALL
    						getAccessibleStateSet() throw (::com::sun::star::uno::RuntimeException);

	//=====  XServiceInfo  ====================================================

	virtual ::rtl::OUString SAL_CALL getImplementationName()
								throw(::com::sun::star::uno::RuntimeException);
	virtual ::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL getSupportedServiceNames()
								throw(::com::sun::star::uno::RuntimeException);

	///=====  XTypeProvider  ===================================================

    /**	Returns a implementation id.
    */
    virtual ::com::sun::star::uno::Sequence<sal_Int8> SAL_CALL
        getImplementationId(void)
        throw (::com::sun::star::uno::RuntimeException);

protected:
	virtual Rectangle GetBoundingBoxOnScreen(void) throw(::com::sun::star::uno::RuntimeException);
	virtual Rectangle GetBoundingBox(void) throw (::com::sun::star::uno::RuntimeException);

private:
	ScPreviewShell* mpViewShell;

	SvxAccessibleTextHelper* mpTextHelper;

	sal_Bool IsDefunc(
		const com::sun::star::uno::Reference<
		::drafts::com::sun::star::accessibility::XAccessibleStateSet>& rxParentStates);
	virtual sal_Bool IsEditable(
		const com::sun::star::uno::Reference<
		::drafts::com::sun::star::accessibility::XAccessibleStateSet>& rxParentStates);
	sal_Bool IsOpaque(
		const com::sun::star::uno::Reference<
		::drafts::com::sun::star::accessibility::XAccessibleStateSet>& rxParentStates);
	sal_Bool IsSelected(
		const com::sun::star::uno::Reference<
		::drafts::com::sun::star::accessibility::XAccessibleStateSet>& rxParentStates);

	void CreateTextHelper();

};

#endif

