/*************************************************************************
 *
 *  $RCSfile: XclImpStyleBuffer.hxx,v $
 *
 *  $Revision: 1.7.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2003/03/26 13:19:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SC_XCLIMPSTYLEBUFFER_HXX
#define _SC_XCLIMPSTYLEBUFFER_HXX

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _SVMEMPOOL_HXX
#include <tools/mempool.hxx>
#endif
#ifndef _VCL_VCLENUM_HXX
#include <vcl/vclenum.hxx>
#endif
#ifndef _SVX_SVXENUM_HXX
#include <svx/svxenum.hxx>
#endif

#ifndef SC_RANGELST_HXX
#include "rangelst.hxx"
#endif
#ifndef SC_SCPATATR_HXX
#include "patattr.hxx"
#endif

#ifndef _SC_FILTERTOOLS_HXX
#include "FilterTools.hxx"
#endif
#ifndef _SC_XCLTOOLS_HXX
#include "XclTools.hxx"
#endif

#ifndef _ROOT_HXX
#include "root.hxx"
#endif


class SvxBorderLine;
class XclImpStream;


//___________________________________________________________________
// Buffers for style records (FONT, PALETTE, FORMAT, XF)
// and a container for XF indexes for every used cell in a sheet

//___________________________________________________________________
// FONT RECORDS - font information
//___________________________________________________________________

/** Enumeration to choose the which IDs for font items. */
enum XclFontWhichIDMode
{
    xlFontScIDs,                /// Calc which IDs (ATTR_*).
    xlFontEEIDs                 /// Edit engine which IDs (EE_CHAR_*).
};


/** Stores all data of an Excel font and provides import of FONT records. */
class XclImpFont : private XclFontData, private ExcRoot
{
private:
    FontFamily                  eFontFamily;    /// Font family for later use.
    CharSet                     eFontCharSet;   /// Font character set for later use.
    sal_Bool                    bIsWestern;     /// sal_True = font contains ASCII characters.
    sal_Bool                    bIsAsian;       /// sal_True = font contains CJK characters.
    sal_Bool                    bIsComplex;     /// sal_True = font contains CTL characters.

    XclImpFont&                 operator=( const XclImpFont& );

                                /** Reads and sets height and flags. */
    void                        ReadFontData2( XclImpStream& rStrm );
                                /** Reads and sets height, flags, color, boldness, script, family and charset. */
    void                        ReadFontData5( XclImpStream& rStrm );

                                /** Reads and sets a byte string as font name. */
    void                        ReadFontName2( XclImpStream& rStrm );
                                /** Reads and sets a Unicode string as font name. */
    void                        ReadFontName8( XclImpStream& rStrm );

                                /** Tests whether the font contains CJK or CTL characters.
                                    This is only a weak guess using preselected characters. */
    void                        GuessScriptType();

public:
    inline                      XclImpFont( RootData& rRootData );
    inline                      XclImpFont( const XclImpFont& rCopy );

                                /** @return  Read-only access to font data. */
    inline const XclFontData&   GetFontData() const         { return *this; }
                                /** @return  sal_True, if the font contains superscript or subscript. */
    inline sal_Bool             HasEscapement() const       { return eEscapem != xlEscNone; }

                                /** Reads a FONT record for all BIFF versions. */
    void                        ReadFont( XclImpStream& rStrm, XclBiff eBiff );

                                /** Calculates a column scaling factor using the current printer settings. */
    double                      CalcColumnScale() const;

                                /** Fills all font properties to the ItemSet.
                                    @param  rItemSet
                                    The destination ItemSet.
                                    @param  eMode
                                    The type of which IDs: Calc or Edit engine. */
    void                        FillToItemSet(
                                    SfxItemSet& rItemSet,
                                    XclFontWhichIDMode eMode ) const;

                                /** Calculates the Calc font family from the Excel family. */
    static FontFamily           GetScFontFamily( sal_uInt8 nXclFamily, const String& aName, CharSet eDefCharSet );
                                /** Calculates the Calc font character set from the Excel character set. */
    static CharSet              GetScFontCharSet( sal_uInt8 nXclCharSet );
                                /** Calculates the Calc font weight from the Excel weight. */
    static FontWeight           GetScFontWeight( sal_uInt16 nXclWeight );
                                /** Calculates the Calc font underline style from the Excel underline style. */
    static FontUnderline        GetScFontUnderline( XclUnderline eXclUnderl );
                                /** Calculates the Calc escapement style from the Excel escapement style. */
    static SvxEscapement        GetScFontEscapement( XclEscapement eXclEscapem );
};

inline XclImpFont::XclImpFont( RootData& rRootData ) :
    ExcRoot( &rRootData ),
    eFontFamily( FAMILY_DONTKNOW ),
    eFontCharSet( ScfTools::GetSystemCharSet() ),
    bIsWestern( sal_True ),
    bIsAsian( sal_False ),
    bIsComplex( sal_False )
{
}

inline XclImpFont::XclImpFont( const XclImpFont& rCopy ) :
    XclFontData( rCopy ),
    ExcRoot( rCopy ),
    eFontFamily( rCopy.eFontFamily ),
    eFontCharSet( rCopy.eFontCharSet ),
    bIsWestern( rCopy.bIsWestern ),
    bIsAsian( rCopy.bIsAsian ),
    bIsComplex( rCopy.bIsComplex )
{
}


//___________________________________________________________________

/** Stores the data of all fonts occurred in an Excel file. */
class XclImpFontBuffer : private ExcRoot
{
private:
    ScfObjList< XclImpFont >    aFontList;          /// List of all FONT records in the Excel file.

                                XclImpFontBuffer( const XclImpFontBuffer& );
    XclImpFontBuffer&           operator=( const XclImpFontBuffer& );

public:
    inline                      XclImpFontBuffer( RootData& rRootData ) : ExcRoot( &rRootData ) {}

                                /// @return  The object that stores all contents of a FONT record.
    inline const XclImpFont*    GetFont( sal_uInt16 nFontIndex ) const
                                    { return aFontList.GetObject( nFontIndex ); }

                                /** Reads a FONT record. */
    void                        ReadFont( XclImpStream& rStrm, XclBiff eBiff );

                                /** Fills all font properties to the ItemSet.
                                    @param  nFontIndex
                                    The list index of the font.
                                    @param  rItemSet
                                    The destination ItemSet.
                                    @param  eMode
                                    The type of which IDs: Calc or Edit engine. */
    void                        FillToItemSet(
                                    sal_uInt16 nFontIndex,
                                    SfxItemSet& rItemSet,
                                    XclFontWhichIDMode eMode ) const;
};


//___________________________________________________________________
// FORMAT RECORDS - number formats
//___________________________________________________________________

class XclImpNumFmtBuffer : private ExcRoot
{
private:
    ScfUInt32List               aKeyList;       /// List of SvNumberFomatter format keys.
    sal_uInt32                  nStandard;      /// Key for standard format.

                                XclImpNumFmtBuffer( const XclImpNumFmtBuffer& );
    XclImpNumFmtBuffer&         operator=( const XclImpNumFmtBuffer& );

                                /** Inserts the built-in number formats that Excel omits in BIFF5+. */
    void                        InsertBuiltinFormats();

                                /** Inserts a format key exactly at the given position. The list will be
                                    extended, if it is too short, using the standard format key. */
    void                        InsertKey( sal_uInt32 nFormatKey, sal_uInt16 nIndex );

public:
    inline                      XclImpNumFmtBuffer( RootData& rRootData, sal_uInt32 nStandardKey );

                                /** @return  The format key with the Excel index nIndex or standard key, if invalid index. */
    sal_uInt32                  GetFormat( sal_uInt16 nIndex );

                                /** Reads a FORMAT record. */
    void                        ReadFormat( XclImpStream& rStrm, XclBiff eBiff );
};

XclImpNumFmtBuffer::XclImpNumFmtBuffer( RootData& rRootData, sal_uInt32 nStandardKey ) :
    ExcRoot( &rRootData ),
    nStandard( nStandardKey )
{
}


//___________________________________________________________________
// XF RECORDS
//___________________________________________________________________

/// Contains color and line style for each cell border line.
struct XclImpXFBorder
{
    sal_uInt16                  nLeftColor;     /// Index to color for left line.
    sal_uInt16                  nRightColor;    /// Index to color for right line.
    sal_uInt16                  nTopColor;      /// Index to color for top line.
    sal_uInt16                  nBottomColor;   /// Index to color for bottom line.
    sal_uInt8                   nLeftLine;      /// Style of left line.
    sal_uInt8                   nRightLine;     /// Style of right line.
    sal_uInt8                   nTopLine;       /// Style of top line.
    sal_uInt8                   nBottomLine;    /// Style of bottom line.

    inline                      XclImpXFBorder() {}
    inline                      XclImpXFBorder( const XclImpXFBorder& rCopy )
                                    { *this = rCopy; }
    inline XclImpXFBorder&      operator=( const XclImpXFBorder& rCopy )
                                    { memcpy( this, &rCopy, sizeof( XclImpXFBorder ) ); return *this; }
};


/// Contains background colors and pattern.
struct XclImpXFArea
{
    sal_uInt16                  nForeColor;     /// Index to foreground color.
    sal_uInt16                  nBackColor;     /// Index to background color.
    sal_uInt8                   nPattern;       /// Fill pattern.

    inline                      XclImpXFArea() {}
    inline                      XclImpXFArea( const XclImpXFArea& rCopy )
                                    { *this = rCopy; }
    inline XclImpXFArea&        operator=( const XclImpXFArea& rCopy )
                                    { memcpy( this, &rCopy, sizeof( XclImpXFArea ) ); return *this; }
};


//___________________________________________________________________

/// Contains all data of a XF record and an ScPatternAttr (SetItem).
class XclImpXF
{
private:
    ScPatternAttr*              pPattern;           /// Calc SetItem.
    XclImpXFBorder*             pBorder;            /// Border line style.
    XclImpXFArea*               pArea;              /// Background area style.

    XclHorAlign                 eHorAlign;          /// Horizontal alignment.
    XclVerAlign                 eVerAlign;          /// Vertical alignment.
    XclTextWrap                 eWrap;              /// Automatic line break.
    XclTextOrient               eOrient;            /// Text orientation.
    sal_uInt8                   nRotation;          /// Rotation angle.

    sal_uInt32                  nValFormat;         /// Id for value format.
    sal_uInt16                  nIndent;            /// Text indent.
    sal_uInt16                  nFont;              /// Index to font record.
    sal_uInt16                  nParent;            /// Index to parent style XF.

    sal_Bool                    bCellXF     : 1;    /// sal_True = cell XF, sal_False = style XF.
    sal_Bool                    bLocked     : 1;    /// sal_True = cell is locked.
    sal_Bool                    bHidden     : 1;    /// sal_True = formulas are hidden.
    sal_Bool                    bMerged     : 1;    /// sal_True = part of a merged cell range.
    sal_Bool                    bFontValid  : 1;    /// nFont != parent->nFont?
    sal_Bool                    bFmtValid   : 1;    /// nValFormat != parent->nValFormat?
    sal_Bool                    bProtValid  : 1;    /// bLocked != parent->bLocked or bHidden != parent-bHidden?

                                XclImpXF( const XclImpXF& );
    XclImpXF&                   operator=( const XclImpXF& );

                                /// Initializes with default values.
    void                        Init();

                                /// Creates and returns the border data struct.
    inline XclImpXFBorder&      GetBorder();
                                /// Creates and returns the area data struct.
    inline XclImpXFArea&        GetArea();

                                /// Reads an XF record (BIFF2).
    void                        ReadXF2( XclImpStream& rStrm, RootData& rRootData );
                                /// Reads an XF record (BIFF3).
    void                        ReadXF3( XclImpStream& rStrm, RootData& rRootData );
                                /// Reads an XF record (BIFF4).
    void                        ReadXF4( XclImpStream& rStrm, RootData& rRootData );
                                /// Reads an XF record (BIFF5/BIFF7).
    void                        ReadXF5( XclImpStream& rStrm, RootData& rRootData );
                                /// Reads an XF record (BIFF8).
    void                        ReadXF8( XclImpStream& rStrm, RootData& rRootData );

                                /// Mixes color values with given ratio.
    static sal_uInt8            GetMixedColor( sal_uInt8 nBack, sal_uInt8 nFore, sal_uInt16 nRatio );

                                /// Creates a new border line item.
    static SvxBorderLine*       CreateBorderItem( sal_uInt8 nLine, sal_uInt16 nColor, ColorBuffer& rColorBuffer );

public:
    inline                      XclImpXF()                          { Init(); }
                                ~XclImpXF();

                                /// Reads an XF record.
    void                        ReadXF( XclImpStream& rStrm, RootData& rRootData, XclBiff eBiff );

                                /** Creates a Calc SetItem containing an item set with all cell properties.
                                    @return  A read-only reference to the SetItem stored internally. */
    const ScPatternAttr&        GetPattern( RootData& rRootData );

    inline sal_Bool             IsCellXF() const                    { return bCellXF; }
    inline sal_Bool             IsStyleXF() const                   { return !bCellXF; }

    inline XclHorAlign          GetHorAlign() const                 { return eHorAlign; }
    inline XclVerAlign          GetVerAlign() const                 { return eVerAlign; }
    inline sal_uInt16           GetFont() const                     { return nFont; }

                                /// Inserts Excel border line styles into the ItemSet.
    static void                 SetBorder(
                                    SfxItemSet& rItemSet,
                                    ColorBuffer& rColorBuffer,
                                    sal_uInt8 nLeftLine,    sal_uInt16 nLeftColor,
                                    sal_uInt8 nRightLine,   sal_uInt16 nRightColor,
                                    sal_uInt8 nTopLine,     sal_uInt16 nTopColor,
                                    sal_uInt8 nBottomLine,  sal_uInt16 nBottomColor );

                                /// Inserts an Excel area style into the ItemSet.
    static void                 SetArea(
                                    SfxItemSet& rItemSet,
                                    ColorBuffer& rColorBuffer,
                                    sal_uInt8 nPattern,
                                    sal_uInt16 nForeColor, sal_uInt16 nBackColor );
};

inline XclImpXFBorder& XclImpXF::GetBorder()
{
    if( !pBorder )
        pBorder = new XclImpXFBorder;
    return *pBorder;
}

inline XclImpXFArea& XclImpXF::GetArea()
{
    if( !pArea )
        pArea = new XclImpXFArea;
    return *pArea;
}


//___________________________________________________________________

/** Contains all XF records occured in the file. This class is able to read
    XF records (BIFF2 - BIFF8) and STYLE records (BIFF8). */
class XclImpXFBuffer : private ExcRoot
{
private:
    ScfObjList< XclImpXF >      aXFList;        /// List of contents of all XF record.
    ScPatternAttr               aDefPattern;    /// This SetItem is used if no other could be found or created.

                                XclImpXFBuffer( const XclImpXFBuffer& );
    XclImpXFBuffer&             operator=( const XclImpXFBuffer& );

public:
                                XclImpXFBuffer( RootData& rRootData );

                                /// Reads an XF record.
    void                        ReadXF( XclImpStream& rStrm, XclBiff eBiff );
                                /// Reads a STYLE record.
    void                        ReadStyle( XclImpStream& rStrm, XclBiff eBiff );

                                /** Creates a SetItem with all properties stored in the XF record.
                                    @return  A read-only reference to the SetItem stored internally. */
    const ScPatternAttr&        GetPattern( sal_uInt16 nXFIndex );

                                /// @return  The object that stores all contents of an XF record.
    inline const XclImpXF*      GetXF( sal_uInt16 nXFIndex ) const
                                    { return aXFList.GetObject( nXFIndex ); }
                                /// @return  The index to the Excel font used in this XF record.
    sal_uInt16                  GetFontIndex( sal_uInt16 nXFIndex ) const;
                                /// @return  sal_True, if either superscript or subscript is used in the font.
    sal_Bool                    HasEscapement( sal_uInt16 nXFIndex ) const;
};


//___________________________________________________________________
// Buffer for XF indexes in cells
//___________________________________________________________________

/// Contains an XF index for a range of rows.
class XclImpCellStyle
{
    DECL_FIXEDMEMPOOL_NEWDEL( XclImpCellStyle )

public:
    sal_uInt16                  nFirstRow;      /// The first row of an equal-formatted range.
    sal_uInt16                  nLastRow;       /// The last row of an equal-formatted range.
    sal_uInt16                  nXF;            /// Index to the XF record.

    inline                      XclImpCellStyle( sal_uInt16 nRow, sal_uInt16 nXFIndex );
    inline                      XclImpCellStyle( sal_uInt16 nFRow, sal_uInt16 nLRow, sal_uInt16 nXFIndex );

                                /// @return  sal_True, if nRow is contained in own row range.
    inline sal_Bool             Contains( sal_uInt16 nRow ) const;

                                /// @return  sal_True, if the range has been expanded.
    sal_Bool                    Expand( sal_uInt16 nRow, sal_uInt16 nXFIndex );
                                /// @return  sal_True, if the range has been expanded.
    sal_Bool                    Expand( const XclImpCellStyle& rNextStyle );
};

inline XclImpCellStyle::XclImpCellStyle( sal_uInt16 nRow, sal_uInt16 nXFIndex ) :
    nFirstRow( nRow ),
    nLastRow( nRow ),
    nXF( nXFIndex )
{
}

inline XclImpCellStyle::XclImpCellStyle( sal_uInt16 nFRow, sal_uInt16 nLRow, sal_uInt16 nXFIndex ) :
    nFirstRow( nFRow ),
    nLastRow( nLRow ),
    nXF( nXFIndex )
{
}

inline sal_Bool XclImpCellStyle::Contains( sal_uInt16 nRow ) const
{
    return (nFirstRow <= nRow) && (nRow <= nLastRow);
}


//___________________________________________________________________

/// Contains the XF indexes for every used cell in a column.
class XclImpCellStyleColumn : private ScfObjList< XclImpCellStyle >
{
private:
                                XclImpCellStyleColumn( const XclImpCellStyleColumn& );
    XclImpXFBuffer&             operator=( const XclImpCellStyleColumn& );

                                /** Finds the previous and next row range from row position nRow.
                                    If an XF still exists, it is contained in rpPrevStyle. */
    void                        Find(
                                    XclImpCellStyle*& rpPrevStyle,
                                    XclImpCellStyle*& rpNextStyle,
                                    sal_uInt32& rnNextIndex,
                                    sal_uInt16 nRow ) const;

                                /** Tries to concatenate a range with its predecessor.
                                    The ranges must have the same XF index and must not have a gap.
                                    The resulting range has the index nIndex-1. */
    void                        TryConcatPrev( sal_uInt32 nIndex );

public:
    inline                      XclImpCellStyleColumn() {}

                                ScfObjList< XclImpCellStyle >::First;
                                ScfObjList< XclImpCellStyle >::Next;

                                /// Inserts a new XF index (first try to expand the last range).
    void                        SetXF( sal_uInt16 nRow, sal_uInt16 nXFIndex );
};


//___________________________________________________________________

/// Contains the XF indexes for every used cell in a single sheet.
class XclImpCellStyleBuffer : private ExcRoot
{
private:
    XclImpCellStyleColumn**     ppColumns;      /// Array of column XF index buffers.
    sal_uInt32                  nUsedCount;     /// Column width of formatted columns (last used + 1).

    ScRangeList                 aMergeList;     /// List of merged cell ranges.

                                XclImpCellStyleBuffer( const XclImpCellStyleBuffer& );
    XclImpXFBuffer&             operator=( const XclImpCellStyleBuffer& );

                                /** Copies border of the last cell of the range to the first cell to keep it visible when the range is merged.
                                    @param  nLine
                                    BOX_LINE_RIGHT = copy most-right border of top row;
                                    BOX_LINE_BOTTOM = copy most-bottom border of first column. */
    void                        SetBorderLine( const ScRange& rRange, sal_uInt16 nTab, sal_uInt16 nLine );

                                /// Clears all buffered data, set up for new sheet.
    void                        Reset();

public:
                                XclImpCellStyleBuffer( RootData& rRootData );
    virtual                     ~XclImpCellStyleBuffer();

                                /// Inserts a new XF index.
    void                        SetXF( sal_uInt16 nCol, sal_uInt16 nRow, sal_uInt16 nXFIndex, sal_Bool bBlank = sal_False );
                                /// Inserts a row default XF.
    void                        SetRowDefXF( sal_uInt16 nRow, sal_uInt16 nXFIndex );
                                /// Inserts the first cell of a merged cell range.
    void                        SetMerge( sal_uInt16 nCol, sal_uInt16 nRow );
                                /// Inserts a complete merged cell range.
    void                        SetMerge( sal_uInt16 nFirstCol, sal_uInt16 nFirstRow, sal_uInt16 nLastCol, sal_uInt16 nLastRow );

                                /// Applies styles and cell merging to document.
    void                        Apply( sal_uInt16 nTab );
};


//___________________________________________________________________

#endif

