/*************************************************************************
 *
 *  $RCSfile: FilterTools.hxx,v $
 *
 *  $Revision: 1.5.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/11/01 07:54:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SC_FILTERTOOLS_HXX
#define _SC_FILTERTOOLS_HXX

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _LIST_HXX
#include <tools/list.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

class SvStream;


//___________________________________________________________________
// global static helpers

/// @return  sal_True, if at least one of the bits set in nMask is set in nValue.
inline sal_Bool hasFlag( sal_uInt32 nValue, sal_uInt32 nMask )
{ return (nValue & nMask) != 0; }

/// @return  sal_True, if all bits set in rMask are set in rValue.
inline sal_Bool hasAllFlags( sal_uInt32 nValue, sal_uInt32 nMask )
{ return (nValue & nMask) == nMask; }

/// @return  sal_True, if none of the bits set in rMask is set in rValue.
inline sal_Bool hasNoFlag( sal_uInt32 nValue, sal_uInt32 nMask )
{ return (nValue & nMask) == 0; }


//___________________________________________________________________

/// Contains static methods used anywhere in the filters.
class ScfTools
{
public:

// *** common methods ***

                                /// Reads a 10-byte-long-double and converts it to double.
    static double               ReadLongDouble( SvStream& rStrm );
                                /// @return  System charset for byte string conversion.
    static CharSet              GetSystemCharSet();
                                /// @return  A string representing the hexadecimal value of nValue.
    static String               GetHexStr( sal_uInt16 nValue );

// *** token handling ***

                                /// Adds the token rToken to rTokenList, using separator cSep.
    static void                 AddToken( String& rTokenList, const String& rToken, sal_Unicode cSep = ';' );
                                /// Inserts the character cQuote at beginning and end of rString.
    static void                 AddQuotes( String& rString, sal_Unicode cQuote = '"' );
                                /// Erases the character cQuote from rString, if it exists at beginning AND end.
    static void                 EraseQuotes( String& rString, sal_Unicode cQuote = '"' );

// *** conversion of names ***
                                /** Converts an Excel name to a valid Calc name.
                                    @param  bCheckPeriod
                                    sal_True = '.' will be converted to '_'; sal_False = '.' leaves unmodified. */
    static void                 ConvertName( String& rName, sal_Bool bCheckPeriod = sal_False );

// *** byte string import operations ***

                                /// Reads and returns a zero terminted byte string.
    static ByteString           ReadCString( SvStream& rStrm );
                                /// Reads and returns a zero terminted byte string.
    static inline String        ReadCString( SvStream& rStrm, CharSet eSrc )
                                    { return String( ReadCString( rStrm ), eSrc ); }

                                /// Reads and returns a zero terminted byte string and decreases a stream counter.
    static ByteString           ReadCString( SvStream& rStrm, sal_Int32& rnBytesLeft );
                                /// Reads and returns a zero terminted byte string and decreases a stream counter.
    static inline String        ReadCString( SvStream& rStrm, sal_Int32& rnBytesLeft, CharSet eSrc )
                                    { return String( ReadCString( rStrm, rnBytesLeft ), eSrc ); }

                                /// Appends a zero terminted byte string.
    static void                 AppendCString( SvStream& rStrm, ByteString& rString );
                                /// Appends a zero terminted byte string.
    static void                 AppendCString( SvStream& rStrm, String& rString, CharSet eSrc );

// *** HTML table names <-> named range names ***

                                /// @return  The built-in range name for an HTML document.
    static String               GetHTMLDocName();
                                /// @return  The built-in range name for all HTML tables.
    static String               GetHTMLTablesName();
                                /// @return  The built-in range name for an HTML table, specified by table index.
    static String               GetNameFromHTMLIndex( sal_uInt32 nIndex );
                                /// @return  The built-in range name for an HTML table, specified by table name.
    static String               GetNameFromHTMLName( const String& rTabName );

                                /// @return  sal_True, if rSource is the built-in range name for an HTML document.
    static sal_Bool             IsHTMLDocName( const String& rSource );
                                /// @return  sal_True, if rSource is the built-in range name for all HTML tables.
    static sal_Bool             IsHTMLTablesName( const String& rSource );
                                /** Converts a built-in range name to an HTML table name.
                                    @param  rSource
                                    The string to be determined.
                                    @param  rName
                                    The HTML table name.
                                    @return  sal_True, if conversion was successful. */
    static sal_Bool             GetHTMLNameFromName( const String& rSource, String& rName );
};


//___________________________________________________________________

/** List template using tools/list. This list stores pointers to objects and deletes
    the objects itself on destruction. The Clear() method deletes all objects too! */
template< typename Type > class ScfObjList : private List
{
public:
    inline                      ScfObjList( sal_uInt16 _nInitSize = 16, sal_uInt16 _nResize = 16 ) :
                                    List( _nInitSize, _nResize ) {}
    virtual                     ~ScfObjList();

    inline void                 Insert( Type* pObj, sal_uInt32 nIndex ) { if( pObj ) List::Insert( pObj, nIndex ); }
    inline void                 Append( Type* pObj )                    { if( pObj ) List::Insert( pObj, LIST_APPEND ); }
                                /// Removes the object without deletion.
    inline Type*                Remove( sal_uInt32 nIndex )             { return static_cast< Type* >( List::Remove( nIndex ) ); }
                                /// Replaces the object without deletion.
    inline Type*                Replace( Type* pObj, sal_uInt32 nIndex ){ return static_cast< Type* >( List::Replace( pObj, nIndex ) ); }

    inline void                 Clear();
    inline sal_uInt32           Count() const                           { return List::Count(); }
    inline sal_Bool             Empty() const                           { return List::Count() == 0; }

    inline Type*                GetCurObject() const                    { return static_cast< Type* >( List::GetCurObject() ); }
    inline sal_uInt32           GetCurPos() const                       { return List::GetCurPos(); }
    inline Type*                GetObject( sal_uInt32 nIndex ) const    { return static_cast< Type* >( List::GetObject( nIndex ) ); }

    inline Type*                First()                                 { return static_cast< Type* >( List::First() ); }
    inline Type*                Last()                                  { return static_cast< Type* >( List::Last() ); }
    inline Type*                Next()                                  { return static_cast< Type* >( List::Next() ); }
    inline Type*                Prev()                                  { return static_cast< Type* >( List::Prev() ); }
};

template< typename Type > ScfObjList< Type >::~ScfObjList()
{
    Clear();
}

template< typename Type > inline void ScfObjList< Type >::Clear()
{
    for( Type* pObj = First(); pObj; pObj = Next() )
        delete pObj;
    List::Clear();
}


//___________________________________________________________________

/** Stack template. This stack stores pointers to objects and deletes the objects
    itself on destruction. The Clear() method deletes all objects too!
    The Pop() method removes the top object from stack without deletion. */
template< typename Type > class ScfObjStack : private ScfObjList< Type >
{
public:
    inline                      ScfObjStack( sal_uInt16 _nInitSize = 16, sal_uInt16 _nResize = 16 ) :
                                    ScfObjList< Type >( _nInitSize, _nResize ) {}

    inline void                 Push( Type* pObj )      { ScfObjList< Type >::Append( pObj ); }
                                /// Removes the top object without deletion.
    inline Type*                Pop()                   { return ScfObjList< Type >::Remove( Count() - 1 ); }

    inline Type*                Top() const             { return ScfObjList< Type >::GetObject( Count() - 1 ); }

                                ScfObjList< Type >::Clear;
                                ScfObjList< Type >::Count;
                                ScfObjList< Type >::Empty;
};


//___________________________________________________________________

/// List class for sal_uInt16 values.
class ScfUInt16List : protected List
{
public:
    inline                      ScfUInt16List() : List() {}
    inline                      ScfUInt16List( const ScfUInt16List& rCopy ) : List( rCopy ) {}

    inline ScfUInt16List&       operator=( const ScfUInt16List& rSource )
                                        { List::operator=( rSource ); return *this; }

								List::Clear;
								List::Count;
    inline sal_Bool             Empty() const   { return List::Count() == 0; }

    inline sal_uInt16           First() { return (sal_uInt16)(sal_uInt32) List::First(); }
    inline sal_uInt16           Last()  { return (sal_uInt16)(sal_uInt32) List::Last(); }
    inline sal_uInt16           Next()  { return (sal_uInt16)(sal_uInt32) List::Next(); }
    inline sal_uInt16           Prev()  { return (sal_uInt16)(sal_uInt32) List::Prev(); }

    inline sal_uInt16           GetValue( sal_uInt32 nIndex ) const
                                        { return (sal_uInt16)(sal_uInt32) List::GetObject( nIndex ); }

    inline void                 Insert( sal_uInt16 nValue, sal_uInt32 nIndex )
                                        { List::Insert( (void*)(sal_uInt32) nValue, nIndex ); }
    inline void                 Append( sal_uInt16 nValue )
                                        { List::Insert( (void*)(sal_uInt32) nValue, LIST_APPEND ); }
    inline sal_uInt16           Replace( sal_uInt16 nValue, sal_uInt32 nIndex )
                                        { return (sal_uInt16)(sal_uInt32) List::Replace( (void*)(sal_uInt32) nValue, nIndex ); }
    inline sal_uInt16           Remove( sal_uInt32 nIndex )
                                        { return (sal_uInt16)(sal_uInt32) List::Remove( nIndex ); }
};


//___________________________________________________________________

/// List class for sal_uInt32 values.
class ScfUInt32List : protected List
{
public:
    inline                      ScfUInt32List() : List() {}
    inline                      ScfUInt32List( const ScfUInt32List& rCopy ) : List( rCopy ) {}

    inline ScfUInt32List&       operator=( const ScfUInt32List& rSource )
                                        { List::operator=( rSource ); return *this; }

								List::Clear;
								List::Count;
    inline sal_Bool             Empty() const   { return List::Count() == 0; }

    inline sal_uInt32           First() { return (sal_uInt32) List::First(); }
    inline sal_uInt32           Last()  { return (sal_uInt32) List::Last(); }
    inline sal_uInt32           Next()  { return (sal_uInt32) List::Next(); }
    inline sal_uInt32           Prev()  { return (sal_uInt32) List::Prev(); }

    inline sal_uInt32           GetValue( sal_uInt32 nIndex ) const
                                        { return (sal_uInt32) List::GetObject( nIndex ); }

    inline void                 Insert( sal_uInt32 nValue, sal_uInt32 nIndex )
                                        { List::Insert( (void*) nValue, nIndex ); }
    inline void                 Append( sal_uInt32 nValue )
                                        { List::Insert( (void*) nValue, LIST_APPEND ); }
    inline sal_uInt32           Replace( sal_uInt32 nValue, sal_uInt32 nIndex )
                                        { return (sal_uInt32) List::Replace( (void*) nValue, nIndex ); }
    inline sal_uInt32           Remove( sal_uInt32 nIndex )
                                        { return (sal_uInt32) List::Remove( nIndex ); }
};


//___________________________________________________________________

#endif

