/*************************************************************************
 *
 *  $RCSfile: FilterProgressBar.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: dr $ $Date: 2001/11/23 12:59:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SC_FILTERPROGRESSBAR_HXX
#define _SC_FILTERPROGRESSBAR_HXX

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

#ifndef _SC_FILTERTOOLS_HXX
#include "FilterTools.hxx"
#endif

class ScProgress;


//___________________________________________________________________

/// Progress bar for complex progress representation.
class ScfProgressBar
{
private:
    /// Contains all data of a segment of the progress bar.
    struct ScfProgressSegment
    {
        ScfProgressBar*             pProgress;      /// Pointer to sub progress bar for this segment.
        sal_uInt32                  nSize;          /// Size of this segment.
        sal_uInt32                  nPos;           /// Current position of this segment.

                                    ScfProgressSegment( sal_uInt32 _nSize );
                                    ~ScfProgressSegment();
    };

    ScfObjList< ScfProgressSegment > aSegments;     /// List of progress segments.

    ScProgress*                 pSysProgress;       /// System progress bar.
    ScfProgressBar*             pParentProgress;    /// Parent progress bar, if this is a segment progress bar.
    ScfProgressSegment*         pParentSegment;     /// Parent segment, if this is a segment progress bar.
    ScfProgressSegment*         pCurrSegment;       /// Current segment for progress.

    sal_uInt32                  nTotalSize;         /// Total size of all segments.
    sal_uInt32                  nTotalPos;          /// Sum of positions of all segments.
    sal_uInt32                  nUnitSize;          /// Size between two calls of system progress.
    sal_uInt32                  nNextUnitPos;       /// Limit for next system progress call.
    sal_uInt16                  nResId;             /// Resource id for system progress bar.
    sal_Bool                    bInProgress;        /// sal_True = progress bar started.

                                /// Used to create sub progress bars.
                                ScfProgressBar(
                                    ScfProgressBar* pParProgress,
                                    ScfProgressSegment* pParSegment );

                                /// @return  The segment specified by list index.
    ScfProgressSegment*         GetSegment( sal_uInt32 nSegment ) const;

                                /// Activates progress bar and sets current segment.
    void                        SetCurrSegment( ScfProgressSegment* pSegment );

                                /// Increases nTotalPos and calls the system progress bar.
    void                        IncreaseProgressBar( sal_uInt32 nDelta );

public:
                                /// Creates a system progress bar with a resource string.
                                ScfProgressBar( sal_uInt16 nResStrId );
                                ~ScfProgressBar();

                                /** Adds a new segment to the progress bar.
                                    @return  the identifier of the segment. */
    sal_uInt32                  AddSegment( sal_uInt32 nSize );
                                /** Returns a complete progress bar for the specified segment.
                                    The progress bar can be used to create sub segments inside
                                    of the segment. Do not delete it (done by root progress bar).
                                    @return  a reference to an ScfProgressBar connected to the segment. */
    ScfProgressBar&             GetSegmentProgressBar( sal_uInt32 nSegment );

    inline sal_Bool             IsStarted() const   { return bInProgress; }

                                /// Starts the progress bar or activates another segment.
    void                        ActivateSegment( sal_uInt32 nSegment );
                                /// Starts the progress bar (with first segment).
    inline void                 Activate()      { ActivateSegment( 0 ); }
                                /// Set current segment to the specified position.
    void                        Progress( sal_uInt32 nPos );
                                /// Increase current segment by 1.
    inline void                 Progress()      { IncreaseProgressBar( 1 ); }
};


//___________________________________________________________________

#endif

