/*************************************************************************
 *
 *  $RCSfile: FilterApiHelper.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: dr $ $Date: 2001/11/23 19:36:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _SC_FILTERAPIHELPER_HXX
#define _SC_FILTERAPIHELPER_HXX

#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XMULTIPROPERTYSET_HPP_
#include <com/sun/star/beans/XMultiPropertySet.hpp>
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _COMPHELPER_TYPES_HXX_
#include <comphelper/types.hxx>
#endif


//___________________________________________________________________

#define CSS                     ::com::sun::star
#define PROPNAME( constascii )  OUString( RTL_CONSTASCII_USTRINGPARAM( constascii ) )


//___________________________________________________________________
// Set properties.

/// Sets the value of an Any to an XPropertySet. The XPropertySet must be valid.
void setPropAny( const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp, const ::rtl::OUString& rName, const CSS::uno::Any& rAny );

/// Template for setting values to an XPropertySet. The XPropertySet must be valid.
template< typename Type >
inline void setPropValue( const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp, const ::rtl::OUString& rName, const Type& rValue )
{ ::setPropAny( xProp, rName, CSS::uno::makeAny( rValue ) ); }

/// Sets a boolean value to an XPropertySet. The XPropertySet must be valid.
inline void setPropBool( const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp, const ::rtl::OUString& rName, sal_Bool bValue )
{ ::setPropAny( xProp, rName, ::comphelper::makeBoolAny( bValue ) ); }

/// Sets a tools string to an XPropertySet. The XPropertySet must be valid.
inline void setPropString( const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp, const ::rtl::OUString& rName, const String& rText )
{ ::setPropValue( xProp, rName, ::rtl::OUString( rText ) ); }


//___________________________________________________________________
// Get properties.

/** Puts the value of a property into an Any. The XPropertySet must be valid.
    @return  sal_True, if the Any could be filled. */
sal_Bool getPropAny( CSS::uno::Any& rAny, const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp, const ::rtl::OUString& rName );

/** Template for getting data from a property. The XPropertySet must be valid.
    @return  sal_True, if the struct could be filled. */
template< typename Type >
inline sal_Bool getPropValue( Type& rValue, const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp, const ::rtl::OUString& rName )
{
    CSS::uno::Any aAny;
    return ::getPropAny( aAny, xProp, rName ) && (aAny >>= rValue);
}

/** Gets a boolean value from an XPropertySet. The XPropertySet must be valid.
    @return  sal_True, if the boolean could be filled. */
inline sal_Bool getPropBool( sal_Bool& rbValue, const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp, const ::rtl::OUString& rName )
{
    CSS::uno::Any aAny;
    sal_Bool bRet = ::getPropAny( aAny, xProp, rName ) && (aAny.getValueTypeClass() == CSS::uno::TypeClass_BOOLEAN);
    if( bRet ) rbValue = *static_cast< const sal_Bool* >( aAny.getValue() );
    return bRet;
}

/** Gets a boolean value from an XPropertySet. The XPropertySet must be valid.
    This is the short version, it returns sal_False on a property with value sal_False and on error.
    @return  sal_True, if the property contains sal_True;  sal_False, else (also on error). */
inline sal_Bool getPropBool( const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp, const ::rtl::OUString& rName )
{
    sal_Bool bRet;
    return ::getPropBool( bRet, xProp, rName ) && bRet;
}



//___________________________________________________________________

/** Generic helper class for reading from and writing to XMultiPropertySets.
    Derived classes have to call the constructor with an array of ASCII strings
    ordered alphabetically. Note: The correct order is required by the
    XMultiPropertySet. It will not be checked here!
*/
class ScfMultiPSHelper
{
private:
    CSS::uno::Sequence< ::rtl::OUString >   aNameSeq;       /// Sequence of property names.
    CSS::uno::Sequence< CSS::uno::Any >     aValueSeq;      /// Sequence of property values.

public:
                                /** @param  ppPropNames
                                    An array of ASCII property names.
                                    @param  nPropCount
                                    Count of property names contained in ppPropNames. */
                                ScfMultiPSHelper( const sal_Char** ppPropNames, sal_Int32 nPropCount );

                                /// @return  The property name.
    inline const ::rtl::OUString& getName( sal_Int32 nIndex ) const;
                                /// @return  A reference to the Any containing a property value.
    inline CSS::uno::Any&       getAny( sal_Int32 nIndex );

                                /** Reads all values from the XMultiPropertySet. Tries to read all properties from
                                    the XPropertySet, if the XMultiPropertySet is not valid.
                                    @return  sal_True on success. */
    sal_Bool                    getPropertyValues(
                                    const CSS::uno::Reference< CSS::beans::XMultiPropertySet >& xMultiPS,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xPropSet );

                                /** Applies all values to the XMultiPropertySet. Tries to set all properties to
                                    the XPropertySet, if the XMultiPropertySet is not valid.
                                    @return  sal_True on success. */
    sal_Bool                    setPropertyValues(
                                    const CSS::uno::Reference< CSS::beans::XMultiPropertySet >& xMultiPS,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xPropSet );
};


inline const ::rtl::OUString& ScfMultiPSHelper::getName( sal_Int32 nIndex ) const
{
    DBG_ASSERT( (0 <= nIndex) && (nIndex < aNameSeq.getLength()), "ScfMultiPSHelper::getName - invalid index" );
    return aNameSeq[ nIndex ];
}

inline CSS::uno::Any& ScfMultiPSHelper::getAny( sal_Int32 nIndex )
{
    DBG_ASSERT( (0 <= nIndex) && (nIndex < aValueSeq.getLength()), "ScfMultiPSHelper::getValue - invalid index" );
    return aValueSeq[ nIndex ];
}


//___________________________________________________________________

#endif

