/*************************************************************************
 *
 *  $RCSfile: testtextenc.cxx,v $
 *
 *  $Revision: 1.4.2.3 $
 *
 *  last change: $Author: mh $ $Date: 2003/03/26 08:50:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _OSL_DIAGNOSE_H_
#include "osl/diagnose.h"
#endif
#ifndef _RTL_STRING_H_
#include "rtl/string.h"
#endif
#ifndef _RTL_TEXTENC_H
#include "rtl/textenc.h"
#endif
#ifndef _RTL_TEXTCVT_H
#include "rtl/textcvt.h"
#endif
#ifndef _SAL_TYPES_H_
#include "sal/types.h"
#endif

#ifndef INCLUDED_STDIO_H
#include <stdio.h>
#define INCLUDED_STDIO_H
#endif

#if defined _DEBUG
#define TEST_ENSURE(c, m) OSL_ENSURE((c), (m))
#else // _DEBUG
#define TEST_ENSURE(c, m) OSL_VERIFY((c))
#endif // _DEBUG

namespace {

struct SingleByteCharSet
{
    rtl_TextEncoding m_nEncoding;
    sal_Unicode m_aMap[256];
};

void testSingleByteCharSet(SingleByteCharSet const & rSet)
{
    sal_Char aText[256];
    sal_Unicode aUnicode[256];

    sal_Size nNumber = 0;
    {for (int i = 0; i < 256; ++i)
        if (rSet.m_aMap[i] != 0xFFFF)
            aText[nNumber++] = static_cast< sal_Char >(i);
    }

    {
        rtl_TextToUnicodeConverter aConverter
            = rtl_createTextToUnicodeConverter(rSet.m_nEncoding);
        rtl_TextToUnicodeContext aContext
            = rtl_createTextToUnicodeContext(aConverter);
        TEST_ENSURE(aConverter && aContext, "failure");

        sal_Size nSize;
        sal_uInt32 nInfo;
        sal_Size nConverted;
        nSize = rtl_convertTextToUnicode(
                    aConverter,
                    aContext,
                    aText,
                    nNumber,
                    aUnicode,
                    nNumber,
                    RTL_TEXTTOUNICODE_FLAGS_UNDEFINED_ERROR
                        | RTL_TEXTTOUNICODE_FLAGS_MBUNDEFINED_ERROR
                        | RTL_TEXTTOUNICODE_FLAGS_INVALID_ERROR,
                    &nInfo,
                    &nConverted);
        TEST_ENSURE(nSize == nNumber && nInfo == 0 && nConverted == nNumber,
                    "failure");

        rtl_destroyTextToUnicodeContext(aConverter, aContext);
        rtl_destroyTextToUnicodeConverter(aConverter);
    }

    {
        bool bSuccess = true;
        int j = 0;
        for (int i = 0; i < 256; ++i)
            if (rSet.m_aMap[i] != 0xFFFF && aUnicode[j++] != rSet.m_aMap[i])
            {
                bSuccess = false;
                break;
            }
        TEST_ENSURE(bSuccess, "failure");
    }

    if (rSet.m_nEncoding == RTL_TEXTENCODING_ASCII_US)
        nNumber = 128;

    {
        rtl_UnicodeToTextConverter aConverter
            = rtl_createUnicodeToTextConverter(rSet.m_nEncoding);
        rtl_UnicodeToTextContext aContext
            = rtl_createUnicodeToTextContext(aConverter);
        TEST_ENSURE(aConverter && aContext, "failure");

        sal_Size nSize;
        sal_uInt32 nInfo;
        sal_Size nConverted;
        nSize = rtl_convertUnicodeToText(
                    aConverter,
                    aContext,
                    aUnicode,
                    nNumber,
                    aText,
                    nNumber,
                    RTL_UNICODETOTEXT_FLAGS_UNDEFINED_ERROR
                        | RTL_UNICODETOTEXT_FLAGS_INVALID_ERROR,
                    &nInfo,
                    &nConverted);
        TEST_ENSURE(nSize == nNumber && nInfo == 0 && nConverted == nNumber,
                    "failure");

        rtl_destroyUnicodeToTextContext(aConverter, aContext);
        rtl_destroyUnicodeToTextConverter(aConverter);
    }

    {
        bool bSuccess = true;
        int j = 0;
        for (int i = 0; i < 256; ++i)
            if (rSet.m_aMap[i] != 0xFFFF
                && aText[j++] != static_cast< sal_Char >(i))
            {
                bSuccess = false;
                break;
            }
        TEST_ENSURE(bSuccess, "failure");
    }

    {for (int i = 0; i < 256; ++i)
        if (rSet.m_aMap[i] == 0xFFFF)
        {
            aText[0] = static_cast< sal_Char >(i);

            rtl_TextToUnicodeConverter aConverter
                = rtl_createTextToUnicodeConverter(rSet.m_nEncoding);
            rtl_TextToUnicodeContext aContext
                = rtl_createTextToUnicodeContext(aConverter);
            TEST_ENSURE(aConverter && aContext, "failure");

            sal_Size nSize;
            sal_uInt32 nInfo;
            sal_Size nConverted;
            nSize = rtl_convertTextToUnicode(
                        aConverter,
                        aContext,
                        aText,
                        1,
                        aUnicode,
                        1,
                        RTL_TEXTTOUNICODE_FLAGS_UNDEFINED_ERROR
                            | RTL_TEXTTOUNICODE_FLAGS_MBUNDEFINED_ERROR
                            | RTL_TEXTTOUNICODE_FLAGS_INVALID_ERROR,
                        &nInfo,
                        &nConverted);
            TEST_ENSURE(nSize == 0
                        && nInfo == (RTL_TEXTTOUNICODE_INFO_ERROR
                                         | RTL_TEXTTOUNICODE_INFO_UNDEFINED)
                        && nConverted == 0,
                        "failure");

            rtl_destroyTextToUnicodeContext(aConverter, aContext);
            rtl_destroyTextToUnicodeConverter(aConverter);
        }
    }
}

int const TEST_STRING_SIZE = 100;

struct ComplexCharSetTest
{
    rtl_TextEncoding m_nEncoding;
    char const * m_pText;
    sal_Size m_nTextSize;
    sal_Unicode m_aUnicode[TEST_STRING_SIZE];
    sal_Size m_nUnicodeSize;
    bool m_bNoContext;
    bool m_bForward;
    bool m_bReverse;
};

void doComplexCharSetTest(ComplexCharSetTest const & rTest)
{
    if (rTest.m_bForward)
    {
        sal_Unicode aUnicode[TEST_STRING_SIZE];

        rtl_TextToUnicodeConverter aConverter
            = rtl_createTextToUnicodeConverter(rTest.m_nEncoding);
        rtl_TextToUnicodeContext aContext
            = rtl_createTextToUnicodeContext(aConverter);
        TEST_ENSURE(aConverter && aContext, "failure");

        sal_Size nSize;
        sal_uInt32 nInfo;
        sal_Size nConverted;
        nSize = rtl_convertTextToUnicode(
                    aConverter,
                    aContext,
                    reinterpret_cast< sal_Char const * >(rTest.m_pText),
                    rTest.m_nTextSize,
                    aUnicode,
                    TEST_STRING_SIZE,
                    RTL_TEXTTOUNICODE_FLAGS_UNDEFINED_ERROR
                        | RTL_TEXTTOUNICODE_FLAGS_MBUNDEFINED_ERROR
                        | RTL_TEXTTOUNICODE_FLAGS_INVALID_ERROR
                        | RTL_TEXTTOUNICODE_FLAGS_FLUSH,
                    &nInfo,
                    &nConverted);
        TEST_ENSURE(nSize == rTest.m_nUnicodeSize
                    && nInfo == 0
                    && nConverted == rTest.m_nTextSize,
                    "failure");

        rtl_destroyTextToUnicodeContext(aConverter, aContext);
        rtl_destroyTextToUnicodeConverter(aConverter);

        bool bSuccess = true;
        for (sal_Size i = 0; i < rTest.m_nUnicodeSize; ++i)
            if (aUnicode[i] != rTest.m_aUnicode[i])
            {
                bSuccess = false;
                break;
            }
        TEST_ENSURE(bSuccess, "failure");
    }

    if (rTest.m_bForward)
    {
        sal_Unicode aUnicode[TEST_STRING_SIZE];

        rtl_TextToUnicodeConverter aConverter
            = rtl_createTextToUnicodeConverter(rTest.m_nEncoding);
        rtl_TextToUnicodeContext aContext
            = rtl_createTextToUnicodeContext(aConverter);
        TEST_ENSURE(aConverter && aContext, "failure");

        if (aContext != (rtl_TextToUnicodeContext) 1)
        {
            sal_Size nInput = 0;
            sal_Size nOutput = 0;
            for (bool bFlush = true; nInput < rTest.m_nTextSize || bFlush;)
            {
                sal_Size nSrcBytes = 1;
                sal_uInt32 nFlags
                    = RTL_TEXTTOUNICODE_FLAGS_UNDEFINED_ERROR
                          | RTL_TEXTTOUNICODE_FLAGS_MBUNDEFINED_ERROR
                          | RTL_TEXTTOUNICODE_FLAGS_INVALID_ERROR;
                if (nInput >= rTest.m_nTextSize)
                {
                    nSrcBytes = 0;
                    nFlags |= RTL_TEXTTOUNICODE_FLAGS_FLUSH;
                    bFlush = false;
                }
                sal_uInt32 nInfo;
                sal_Size nConverted;
                sal_Size nSize = rtl_convertTextToUnicode(
                                     aConverter,
                                     aContext,
                                     reinterpret_cast< sal_Char const * >(
                                         rTest.m_pText + nInput),
                                     nSrcBytes,
                                     aUnicode + nOutput,
                                     TEST_STRING_SIZE - nOutput,
                                     nFlags,
                                     &nInfo,
                                     &nConverted);
                nOutput += nSize;
                nInput += nConverted;
                TEST_ENSURE((nInfo & ~RTL_TEXTTOUNICODE_INFO_SRCBUFFERTOSMALL)
                                == 0,
                            "failure");
            }
            TEST_ENSURE(nOutput == rTest.m_nUnicodeSize
                        && nInput == rTest.m_nTextSize,
                        "failure");

            bool bSuccess = true;
            for (sal_Size i = 0; i < rTest.m_nUnicodeSize; ++i)
                if (aUnicode[i] != rTest.m_aUnicode[i])
                {
                    bSuccess = false;
                    break;
                }
            TEST_ENSURE(bSuccess, "failure");
        }

        rtl_destroyTextToUnicodeContext(aConverter, aContext);
        rtl_destroyTextToUnicodeConverter(aConverter);
    }

    if (rTest.m_bNoContext && rTest.m_bForward)
    {
        sal_Unicode aUnicode[TEST_STRING_SIZE];
        int nSize = 0;

        rtl_TextToUnicodeConverter aConverter
            = rtl_createTextToUnicodeConverter(rTest.m_nEncoding);
        TEST_ENSURE(aConverter, "failure");

        for (sal_Size i = 0;;)
        {
            if (i == rTest.m_nTextSize)
                goto done;
            sal_Char c1 = rTest.m_pText[i++];

            sal_Unicode aUC[2];
            sal_uInt32 nInfo = 0;
            sal_Size nCvtBytes;
            sal_Size nChars
                = rtl_convertTextToUnicode(
                      aConverter,
                      0,
                      &c1,
                      1,
                      aUC,
                      2,
                      RTL_TEXTTOUNICODE_FLAGS_UNDEFINED_ERROR
                          | RTL_TEXTTOUNICODE_FLAGS_MBUNDEFINED_ERROR
                          | RTL_TEXTTOUNICODE_FLAGS_MBUNDEFINED_ERROR
                      /*| RTL_TEXTTOUNICODE_FLAGS_FLUSH*/,
                      &nInfo,
                      &nCvtBytes);
            if ((nInfo & RTL_TEXTTOUNICODE_INFO_SRCBUFFERTOSMALL) != 0)
            {
                sal_Char sBuffer[10];
                sBuffer[0] = c1;
                sal_uInt16 nLen = 1;
                while ((nInfo & RTL_TEXTTOUNICODE_INFO_SRCBUFFERTOSMALL) != 0
                       && nLen < 10)
                {
                    if (i == rTest.m_nTextSize)
                        goto done;
                    c1 = rTest.m_pText[i++];

                    sBuffer[nLen++] = c1;
                    nChars
                        = rtl_convertTextToUnicode(
                              aConverter,
                              0,
                              sBuffer,
                              nLen,
                              aUC,
                              2,
                              RTL_TEXTTOUNICODE_FLAGS_UNDEFINED_ERROR
                                  | RTL_TEXTTOUNICODE_FLAGS_MBUNDEFINED_ERROR
                                  | RTL_TEXTTOUNICODE_FLAGS_MBUNDEFINED_ERROR
                              /*| RTL_TEXTTOUNICODE_FLAGS_FLUSH*/,
                              &nInfo,
                              &nCvtBytes);
                }
                if (nChars == 1 && nInfo == 0)
                {
                    OSL_ASSERT(nCvtBytes == nLen);
                    aUnicode[nSize++] = aUC[0];
                }
                else if (nChars == 2 && nInfo == 0)
                {
                    OSL_ASSERT(nCvtBytes == nLen);
                    aUnicode[nSize++] = aUC[0];
                    aUnicode[nSize++] = aUC[1];
                }
                else
                {
                    OSL_ASSERT(
                        (nInfo & RTL_TEXTTOUNICODE_INFO_SRCBUFFERTOSMALL) == 0
                        && nChars == 0
                        && nInfo != 0);
                    aUnicode[nSize++] = sBuffer[0];
                    i -= nLen - 1;
                }
            }
            else if (nChars == 1 && nInfo == 0)
            {
                OSL_ASSERT(nCvtBytes == 1);
                aUnicode[nSize++] = aUC[0];
            }
            else if (nChars == 2 && nInfo == 0)
            {
                OSL_ASSERT(nCvtBytes == 1);
                aUnicode[nSize++] = aUC[0];
                aUnicode[nSize++] = aUC[1];
            }
            else
            {
                OSL_ASSERT(nChars == 0 && nInfo != 0);
                aUnicode[nSize++] = c1;
            }
        }
    done:

        rtl_destroyTextToUnicodeConverter(aConverter);

        bool bSuccess = true;
        {for (sal_Size i = 0; i < rTest.m_nUnicodeSize; ++i)
            if (aUnicode[i] != rTest.m_aUnicode[i])
            {
                bSuccess = false;
                break;
            }
        }
        TEST_ENSURE(bSuccess, "failure");
    }

    if (rTest.m_bReverse)
    {
        sal_Char aText[TEST_STRING_SIZE];

        rtl_UnicodeToTextConverter aConverter
            = rtl_createUnicodeToTextConverter(rTest.m_nEncoding);
        rtl_UnicodeToTextContext aContext
            = rtl_createUnicodeToTextContext(aConverter);
        TEST_ENSURE(aConverter && aContext, "failure");

        sal_Size nSize;
        sal_uInt32 nInfo;
        sal_Size nConverted;
        nSize = rtl_convertUnicodeToText(
                    aConverter,
                    aContext,
                    rTest.m_aUnicode,
                    rTest.m_nUnicodeSize,
                    aText,
                    TEST_STRING_SIZE,
                    RTL_UNICODETOTEXT_FLAGS_UNDEFINED_ERROR
                        | RTL_UNICODETOTEXT_FLAGS_INVALID_ERROR
                        | RTL_UNICODETOTEXT_FLAGS_FLUSH,
                    &nInfo,
                    &nConverted);
        TEST_ENSURE(nSize == rTest.m_nTextSize
                    && nInfo == 0
                    && nConverted == rTest.m_nUnicodeSize,
                    "failure");

        rtl_destroyUnicodeToTextContext(aConverter, aContext);
        rtl_destroyUnicodeToTextConverter(aConverter);

        bool bSuccess = true;
        for (sal_Size i = 0; i < rTest.m_nTextSize; ++i)
            if (aText[i] != rTest.m_pText[i])
            {
                bSuccess = false;
                break;
            }
        TEST_ENSURE(bSuccess, "failure");
    }
}

void doComplexCharSetCutTest(ComplexCharSetTest const & rTest)
{
    if (rTest.m_bNoContext)
    {
        sal_Unicode aUnicode[TEST_STRING_SIZE];

        rtl_TextToUnicodeConverter aConverter
            = rtl_createTextToUnicodeConverter(rTest.m_nEncoding);
        TEST_ENSURE(aConverter, "failure");

        sal_Size nSize;
        sal_uInt32 nInfo;
        sal_Size nConverted;
        nSize = rtl_convertTextToUnicode(
                    aConverter,
                    0,
                    reinterpret_cast< sal_Char const * >(rTest.m_pText),
                    rTest.m_nTextSize,
                    aUnicode,
                    TEST_STRING_SIZE,
                    RTL_TEXTTOUNICODE_FLAGS_UNDEFINED_ERROR
                        | RTL_TEXTTOUNICODE_FLAGS_MBUNDEFINED_ERROR
                        | RTL_TEXTTOUNICODE_FLAGS_INVALID_ERROR,
                    &nInfo,
                    &nConverted);
        TEST_ENSURE(nSize <= rTest.m_nUnicodeSize
                    && (nInfo == RTL_TEXTTOUNICODE_INFO_SRCBUFFERTOSMALL
                        || nInfo
                               == (RTL_TEXTTOUNICODE_INFO_ERROR
                                   | RTL_TEXTTOUNICODE_INFO_SRCBUFFERTOSMALL))
                    && nConverted < rTest.m_nTextSize,
                    "failure");

        rtl_destroyTextToUnicodeConverter(aConverter);

        bool bSuccess = true;
        for (sal_Size i = 0; i < nSize; ++i)
            if (aUnicode[i] != rTest.m_aUnicode[i])
            {
                bSuccess = false;
                break;
            }
        TEST_ENSURE(bSuccess, "failure");
    }
}

}

void test_textenc()
{
    printf("textenc test:\n");

    SingleByteCharSet aSingleByteCharSet[]
        = { { RTL_TEXTENCODING_MS_1252,
              { 0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
                0x0008,0x0009,0x000A,0x000B,0x000C,0x000D,0x000E,0x000F,
                0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,
                0x0018,0x0019,0x001A,0x001B,0x001C,0x001D,0x001E,0x001F,
                0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,
                0x0028,0x0029,0x002A,0x002B,0x002C,0x002D,0x002E,0x002F,
                0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
                0x0038,0x0039,0x003A,0x003B,0x003C,0x003D,0x003E,0x003F,
                0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
                0x0048,0x0049,0x004A,0x004B,0x004C,0x004D,0x004E,0x004F,
                0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,
                0x0058,0x0059,0x005A,0x005B,0x005C,0x005D,0x005E,0x005F,
                0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,
                0x0068,0x0069,0x006A,0x006B,0x006C,0x006D,0x006E,0x006F,
                0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,
                0x0078,0x0079,0x007A,0x007B,0x007C,0x007D,0x007E,0x007F,
                0x20AC,  0x81,0x201A,0x0192,0x201E,0x2026,0x2020,0x2021,
                0x02C6,0x2030,0x0160,0x2039,0x0152,  0x8D,0x017D,  0x8F,
                  0x90,0x2018,0x2019,0x201C,0x201D,0x2022,0x2013,0x2014,
                0x02DC,0x2122,0x0161,0x203A,0x0153,  0x9D,0x017E,0x0178,
                0x00A0,0x00A1,0x00A2,0x00A3,0x00A4,0x00A5,0x00A6,0x00A7,
                0x00A8,0x00A9,0x00AA,0x00AB,0x00AC,0x00AD,0x00AE,0x00AF,
                0x00B0,0x00B1,0x00B2,0x00B3,0x00B4,0x00B5,0x00B6,0x00B7,
                0x00B8,0x00B9,0x00BA,0x00BB,0x00BC,0x00BD,0x00BE,0x00BF,
                0x00C0,0x00C1,0x00C2,0x00C3,0x00C4,0x00C5,0x00C6,0x00C7,
                0x00C8,0x00C9,0x00CA,0x00CB,0x00CC,0x00CD,0x00CE,0x00CF,
                0x00D0,0x00D1,0x00D2,0x00D3,0x00D4,0x00D5,0x00D6,0x00D7,
                0x00D8,0x00D9,0x00DA,0x00DB,0x00DC,0x00DD,0x00DE,0x00DF,
                0x00E0,0x00E1,0x00E2,0x00E3,0x00E4,0x00E5,0x00E6,0x00E7,
                0x00E8,0x00E9,0x00EA,0x00EB,0x00EC,0x00ED,0x00EE,0x00EF,
                0x00F0,0x00F1,0x00F2,0x00F3,0x00F4,0x00F5,0x00F6,0x00F7,
                0x00F8,0x00F9,0x00FA,0x00FB,0x00FC,0x00FD,0x00FE,0x00FF } },
            { RTL_TEXTENCODING_APPLE_ROMAN,
              {   0x00,  0x01,  0x02,  0x03,  0x04,  0x05,  0x06,  0x07,
                  0x08,  0x09,  0x0A,  0x0B,  0x0C,  0x0D,  0x0E,  0x0F,
                  0x10,  0x11,  0x12,  0x13,  0x14,  0x15,  0x16,  0x17,
                  0x18,  0x19,  0x1A,  0x1B,  0x1C,  0x1D,  0x1E,  0x1F,
                0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,
                0x0028,0x0029,0x002A,0x002B,0x002C,0x002D,0x002E,0x002F,
                0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
                0x0038,0x0039,0x003A,0x003B,0x003C,0x003D,0x003E,0x003F,
                0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
                0x0048,0x0049,0x004A,0x004B,0x004C,0x004D,0x004E,0x004F,
                0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,
                0x0058,0x0059,0x005A,0x005B,0x005C,0x005D,0x005E,0x005F,
                0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,
                0x0068,0x0069,0x006A,0x006B,0x006C,0x006D,0x006E,0x006F,
                0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,
                0x0078,0x0079,0x007A,0x007B,0x007C,0x007D,0x007E,  0x7F,
                0x00C4,0x00C5,0x00C7,0x00C9,0x00D1,0x00D6,0x00DC,0x00E1,
                0x00E0,0x00E2,0x00E4,0x00E3,0x00E5,0x00E7,0x00E9,0x00E8,
                0x00EA,0x00EB,0x00ED,0x00EC,0x00EE,0x00EF,0x00F1,0x00F3,
                0x00F2,0x00F4,0x00F6,0x00F5,0x00FA,0x00F9,0x00FB,0x00FC,
                0x2020,0x00B0,0x00A2,0x00A3,0x00A7,0x2022,0x00B6,0x00DF,
                0x00AE,0x00A9,0x2122,0x00B4,0x00A8,0x2260,0x00C6,0x00D8,
                0x221E,0x00B1,0x2264,0x2265,0x00A5,0x00B5,0x2202,0x2211,
                0x220F,0x03C0,0x222B,0x00AA,0x00BA,0x03A9,0x00E6,0x00F8,
                0x00BF,0x00A1,0x00AC,0x221A,0x0192,0x2248,0x2206,0x00AB,
                0x00BB,0x2026,0x00A0,0x00C0,0x00C3,0x00D5,0x0152,0x0153,
                0x2013,0x2014,0x201C,0x201D,0x2018,0x2019,0x00F7,0x25CA,
                0x00FF,0x0178,0x2044,0x20AC,0x2039,0x203A,0xFB01,0xFB02,
                0x2021,0x00B7,0x201A,0x201E,0x2030,0x00C2,0x00CA,0x00C1,
                0x00CB,0x00C8,0x00CD,0x00CE,0x00CF,0x00CC,0x00D3,0x00D4,
                0xF8FF,0x00D2,0x00DA,0x00DB,0x00D9,0x0131,0x02C6,0x02DC,
                0x00AF,0x02D8,0x02D9,0x02DA,0x00B8,0x02DD,0x02DB,0x02C7 } },
            { RTL_TEXTENCODING_IBM_437,
              { 0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
                0x0008,0x0009,0x000A,0x000B,0x000C,0x000D,0x000E,0x000F,
                0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,
                0x0018,0x0019,0x001A,0x001B,0x001C,0x001D,0x001E,0x001F,
                0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,
                0x0028,0x0029,0x002A,0x002B,0x002C,0x002D,0x002E,0x002F,
                0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
                0x0038,0x0039,0x003A,0x003B,0x003C,0x003D,0x003E,0x003F,
                0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
                0x0048,0x0049,0x004A,0x004B,0x004C,0x004D,0x004E,0x004F,
                0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,
                0x0058,0x0059,0x005A,0x005B,0x005C,0x005D,0x005E,0x005F,
                0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,
                0x0068,0x0069,0x006A,0x006B,0x006C,0x006D,0x006E,0x006F,
                0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,
                0x0078,0x0079,0x007A,0x007B,0x007C,0x007D,0x007E,0x007F,
                0x00c7,0x00fc,0x00e9,0x00e2,0x00e4,0x00e0,0x00e5,0x00e7,
                0x00ea,0x00eb,0x00e8,0x00ef,0x00ee,0x00ec,0x00c4,0x00c5,
                0x00c9,0x00e6,0x00c6,0x00f4,0x00f6,0x00f2,0x00fb,0x00f9,
                0x00ff,0x00d6,0x00dc,0x00a2,0x00a3,0x00a5,0x20a7,0x0192,
                0x00e1,0x00ed,0x00f3,0x00fa,0x00f1,0x00d1,0x00aa,0x00ba,
                0x00bf,0x2310,0x00ac,0x00bd,0x00bc,0x00a1,0x00ab,0x00bb,
                0x2591,0x2592,0x2593,0x2502,0x2524,0x2561,0x2562,0x2556,
                0x2555,0x2563,0x2551,0x2557,0x255d,0x255c,0x255b,0x2510,
                0x2514,0x2534,0x252c,0x251c,0x2500,0x253c,0x255e,0x255f,
                0x255a,0x2554,0x2569,0x2566,0x2560,0x2550,0x256c,0x2567,
                0x2568,0x2564,0x2565,0x2559,0x2558,0x2552,0x2553,0x256b,
                0x256a,0x2518,0x250c,0x2588,0x2584,0x258c,0x2590,0x2580,
                0x03b1,0x00df,0x0393,0x03c0,0x03a3,0x03c3,0x00b5,0x03c4,
                0x03a6,0x0398,0x03a9,0x03b4,0x221e,0x03c6,0x03b5,0x2229,
                0x2261,0x00b1,0x2265,0x2264,0x2320,0x2321,0x00f7,0x2248,
                0x00b0,0x2219,0x00b7,0x221a,0x207f,0x00b2,0x25a0,0x00a0 } },
            // ...
            { RTL_TEXTENCODING_ASCII_US,
              { 0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
                0x0008,0x0009,0x000A,0x000B,0x000C,0x000D,0x000E,0x000F,
                0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,
                0x0018,0x0019,0x001A,0x001B,0x001C,0x001D,0x001E,0x001F,
                0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,
                0x0028,0x0029,0x002A,0x002B,0x002C,0x002D,0x002E,0x002F,
                0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
                0x0038,0x0039,0x003A,0x003B,0x003C,0x003D,0x003E,0x003F,
                0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
                0x0048,0x0049,0x004A,0x004B,0x004C,0x004D,0x004E,0x004F,
                0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,
                0x0058,0x0059,0x005A,0x005B,0x005C,0x005D,0x005E,0x005F,
                0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,
                0x0068,0x0069,0x006A,0x006B,0x006C,0x006D,0x006E,0x006F,
                0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,
                0x0078,0x0079,0x007A,0x007B,0x007C,0x007D,0x007E,0x007F,
                0x20AC,  0x81,0x201A,0x0192,0x201E,0x2026,0x2020,0x2021, // !
                0x02C6,0x2030,0x0160,0x2039,0x0152,  0x8D,0x017D,  0x8F, // !
                  0x90,0x2018,0x2019,0x201C,0x201D,0x2022,0x2013,0x2014, // !
                0x02DC,0x2122,0x0161,0x203A,0x0153,  0x9D,0x017E,0x0178, // !
                  0xA0,  0xA1,  0xA2,  0xA3,  0xA4,  0xA5,  0xA6,  0xA7,
                  0xA8,  0xA9,  0xAA,  0xAB,  0xAC,  0xAD,  0xAE,  0xAF,
                  0xB0,  0xB1,  0xB2,  0xB3,  0xB4,  0xB5,  0xB6,  0xB7,
                  0xB8,  0xB9,  0xBA,  0xBB,  0xBC,  0xBD,  0xBE,  0xBF,
                  0xC0,  0xC1,  0xC2,  0xC3,  0xC4,  0xC5,  0xC6,  0xC7,
                  0xC8,  0xC9,  0xCA,  0xCB,  0xCC,  0xCD,  0xCE,  0xCF,
                  0xD0,  0xD1,  0xD2,  0xD3,  0xD4,  0xD5,  0xD6,  0xD7,
                  0xD8,  0xD9,  0xDA,  0xDB,  0xDC,  0xDD,  0xDE,  0xDF,
                  0xE0,  0xE1,  0xE2,  0xE3,  0xE4,  0xE5,  0xE6,  0xE7,
                  0xE8,  0xE9,  0xEA,  0xEB,  0xEC,  0xED,  0xEE,  0xEF,
                  0xF0,  0xF1,  0xF2,  0xF3,  0xF4,  0xF5,  0xF6,  0xF7,
                  0xF8,  0xF9,  0xFA,  0xFB,  0xFC,  0xFD,  0xFE,  0xFF } },
            { RTL_TEXTENCODING_ISO_8859_1,
              { 0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
                0x0008,0x0009,0x000A,0x000B,0x000C,0x000D,0x000E,0x000F,
                0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,
                0x0018,0x0019,0x001A,0x001B,0x001C,0x001D,0x001E,0x001F,
                0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,
                0x0028,0x0029,0x002A,0x002B,0x002C,0x002D,0x002E,0x002F,
                0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
                0x0038,0x0039,0x003A,0x003B,0x003C,0x003D,0x003E,0x003F,
                0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
                0x0048,0x0049,0x004A,0x004B,0x004C,0x004D,0x004E,0x004F,
                0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,
                0x0058,0x0059,0x005A,0x005B,0x005C,0x005D,0x005E,0x005F,
                0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,
                0x0068,0x0069,0x006A,0x006B,0x006C,0x006D,0x006E,0x006F,
                0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,
                0x0078,0x0079,0x007A,0x007B,0x007C,0x007D,0x007E,0x007F,
                0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087,
                0x0088,0x0089,0x008A,0x008B,0x008C,0x008D,0x008E,0x008F,
                0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097,
                0x0098,0x0099,0x009A,0x009B,0x009C,0x009D,0x009E,0x009F,
                0x00A0,0x00A1,0x00A2,0x00A3,0x00A4,0x00A5,0x00A6,0x00A7,
                0x00A8,0x00A9,0x00AA,0x00AB,0x00AC,0x00AD,0x00AE,0x00AF,
                0x00B0,0x00B1,0x00B2,0x00B3,0x00B4,0x00B5,0x00B6,0x00B7,
                0x00B8,0x00B9,0x00BA,0x00BB,0x00BC,0x00BD,0x00BE,0x00BF,
                0x00C0,0x00C1,0x00C2,0x00C3,0x00C4,0x00C5,0x00C6,0x00C7,
                0x00C8,0x00C9,0x00CA,0x00CB,0x00CC,0x00CD,0x00CE,0x00CF,
                0x00D0,0x00D1,0x00D2,0x00D3,0x00D4,0x00D5,0x00D6,0x00D7,
                0x00D8,0x00D9,0x00DA,0x00DB,0x00DC,0x00DD,0x00DE,0x00DF,
                0x00E0,0x00E1,0x00E2,0x00E3,0x00E4,0x00E5,0x00E6,0x00E7,
                0x00E8,0x00E9,0x00EA,0x00EB,0x00EC,0x00ED,0x00EE,0x00EF,
                0x00F0,0x00F1,0x00F2,0x00F3,0x00F4,0x00F5,0x00F6,0x00F7,
                0x00F8,0x00F9,0x00FA,0x00FB,0x00FC,0x00FD,0x00FE,0x00FF } },
            { RTL_TEXTENCODING_ISO_8859_2,
              { 0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
                0x0008,0x0009,0x000A,0x000B,0x000C,0x000D,0x000E,0x000F,
                0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,
                0x0018,0x0019,0x001A,0x001B,0x001C,0x001D,0x001E,0x001F,
                0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,
                0x0028,0x0029,0x002A,0x002B,0x002C,0x002D,0x002E,0x002F,
                0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
                0x0038,0x0039,0x003A,0x003B,0x003C,0x003D,0x003E,0x003F,
                0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
                0x0048,0x0049,0x004A,0x004B,0x004C,0x004D,0x004E,0x004F,
                0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,
                0x0058,0x0059,0x005A,0x005B,0x005C,0x005D,0x005E,0x005F,
                0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,
                0x0068,0x0069,0x006A,0x006B,0x006C,0x006D,0x006E,0x006F,
                0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,
                0x0078,0x0079,0x007A,0x007B,0x007C,0x007D,0x007E,0x007F,
                0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087,
                0x0088,0x0089,0x008A,0x008B,0x008C,0x008D,0x008E,0x008F,
                0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097,
                0x0098,0x0099,0x009A,0x009B,0x009C,0x009D,0x009E,0x009F,
                0x00A0,0x0104,0x02D8,0x0141,0x00A4,0x013D,0x015A,0x00A7,
                0x00A8,0x0160,0x015E,0x0164,0x0179,0x00AD,0x017D,0x017B,
                0x00B0,0x0105,0x02DB,0x0142,0x00B4,0x013E,0x015B,0x02C7,
                0x00B8,0x0161,0x015F,0x0165,0x017A,0x02DD,0x017E,0x017C,
                0x0154,0x00C1,0x00C2,0x0102,0x00C4,0x0139,0x0106,0x00C7,
                0x010C,0x00C9,0x0118,0x00CB,0x011A,0x00CD,0x00CE,0x010E,
                0x0110,0x0143,0x0147,0x00D3,0x00D4,0x0150,0x00D6,0x00D7,
                0x0158,0x016E,0x00DA,0x0170,0x00DC,0x00DD,0x0162,0x00DF,
                0x0155,0x00E1,0x00E2,0x0103,0x00E4,0x013A,0x0107,0x00E7,
                0x010D,0x00E9,0x0119,0x00EB,0x011B,0x00ED,0x00EE,0x010F,
                0x0111,0x0144,0x0148,0x00F3,0x00F4,0x0151,0x00F6,0x00F7,
                0x0159,0x016F,0x00FA,0x0171,0x00FC,0x00FD,0x0163,0x02D9 } },
            { RTL_TEXTENCODING_ISO_8859_3,
              { 0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
                0x0008,0x0009,0x000A,0x000B,0x000C,0x000D,0x000E,0x000F,
                0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,
                0x0018,0x0019,0x001A,0x001B,0x001C,0x001D,0x001E,0x001F,
                0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,
                0x0028,0x0029,0x002A,0x002B,0x002C,0x002D,0x002E,0x002F,
                0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
                0x0038,0x0039,0x003A,0x003B,0x003C,0x003D,0x003E,0x003F,
                0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
                0x0048,0x0049,0x004A,0x004B,0x004C,0x004D,0x004E,0x004F,
                0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,
                0x0058,0x0059,0x005A,0x005B,0x005C,0x005D,0x005E,0x005F,
                0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,
                0x0068,0x0069,0x006A,0x006B,0x006C,0x006D,0x006E,0x006F,
                0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,
                0x0078,0x0079,0x007A,0x007B,0x007C,0x007D,0x007E,0x007F,
                0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087,
                0x0088,0x0089,0x008A,0x008B,0x008C,0x008D,0x008E,0x008F,
                0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097,
                0x0098,0x0099,0x009A,0x009B,0x009C,0x009D,0x009E,0x009F,
                0x00A0,0x0126,0x02D8,0x00A3,0x00A4,0xFFFF,0x0124,0x00A7,
                0x00A8,0x0130,0x015E,0x011E,0x0134,0x00AD,0xFFFF,0x017B,
                0x00B0,0x0127,0x00B2,0x00B3,0x00B4,0x00B5,0x0125,0x00B7,
                0x00B8,0x0131,0x015F,0x011F,0x0135,0x00BD,0xFFFF,0x017C,
                0x00C0,0x00C1,0x00C2,0xFFFF,0x00C4,0x010A,0x0108,0x00C7,
                0x00C8,0x00C9,0x00CA,0x00CB,0x00CC,0x00CD,0x00CE,0x00CF,
                0xFFFF,0x00D1,0x00D2,0x00D3,0x00D4,0x0120,0x00D6,0x00D7,
                0x011C,0x00D9,0x00DA,0x00DB,0x00DC,0x016C,0x015C,0x00DF,
                0x00E0,0x00E1,0x00E2,0xFFFF,0x00E4,0x010B,0x0109,0x00E7,
                0x00E8,0x00E9,0x00EA,0x00EB,0x00EC,0x00ED,0x00EE,0x00EF,
                0xFFFF,0x00F1,0x00F2,0x00F3,0x00F4,0x0121,0x00F6,0x00F7,
                0x011D,0x00F9,0x00FA,0x00FB,0x00FC,0x016D,0x015D,0x02D9 } } };
            // ...
    {
        int nCount = sizeof aSingleByteCharSet / sizeof aSingleByteCharSet[0];
        for (int i = 0; i < nCount; ++i)
            testSingleByteCharSet(aSingleByteCharSet[i]);
    }

    ComplexCharSetTest aComplexCharSetTest[]
        = { { RTL_TEXTENCODING_ASCII_US,
              RTL_CONSTASCII_STRINGPARAM("\x01\"3De$~"),
              { 0x0001,0x0022,0x0033,0x0044,0x0065,0x0024,0x007E },
              7,
              true,
              true,
              true },
            { RTL_TEXTENCODING_EUC_CN,
              RTL_CONSTASCII_STRINGPARAM("\x01\"3De$~\xA1\xB9\xF0\xC5"),
              { 0x0001,0x0022,0x0033,0x0044,0x0065,0x0024,0x007E,
                0x300D,0x9E4B },
              9,
              true,
              true,
              true },
            { RTL_TEXTENCODING_EUC_TW,
              RTL_CONSTASCII_STRINGPARAM(
                  "\x01\"3De$~\xC5\xF0\x8E\xA4\xDC\xD9"),
              { 0x0001,0x0022,0x0033,0x0044,0x0065,0x0024,0x007E,
                0x4ED9,0xD87E,0xDD68 },
              10,
              true,
              true,
              true },
            { RTL_TEXTENCODING_GB_18030,
              RTL_CONSTASCII_STRINGPARAM("\x01\"3De$~"),
              { 0x0001,0x0022,0x0033,0x0044,0x0065,0x0024,0x007E },
              7,
              true,
              true,
              true },
            { RTL_TEXTENCODING_GB_18030,
              RTL_CONSTASCII_STRINGPARAM("\x81\x40\xFE\xFE"),
              { 0x4E02,0xE4C5 },
              2,
              true,
              true,
              true },
            { RTL_TEXTENCODING_GB_18030,
              RTL_CONSTASCII_STRINGPARAM(
                  "\x81\x30\xB1\x33\x81\x30\xD3\x30\x81\x36\xA5\x31"),
              { 0x028A,0x0452,0x200F },
              3,
              true,
              true,
              true },
            { RTL_TEXTENCODING_ISO_2022_JP,
              RTL_CONSTASCII_STRINGPARAM("\x01\"3De$\\~"),
              { 0x0001,0x0022,0x0033,0x0044,0x0065,0x0024,0x005C,0x007E },
              8,
              false,
              true,
              false },
            { RTL_TEXTENCODING_ISO_2022_JP,
              RTL_CONSTASCII_STRINGPARAM("\x1B(B\x01\"3De$\\~"),
              { 0x0001,0x0022,0x0033,0x0044,0x0065,0x0024,0x005C,0x007E },
              8,
              false,
              true,
              true },
            { RTL_TEXTENCODING_ISO_2022_JP,
              RTL_CONSTASCII_STRINGPARAM("\x1B(J\x01\"3De$\\~"),
              { 0x0001,0x0022,0x0033,0x0044,0x0065,0x0024,0x00A5,0x00AF },
              8,
              false,
              true,
              false },
            { RTL_TEXTENCODING_ISO_2022_JP,
              RTL_CONSTASCII_STRINGPARAM("\x1B$B\x26\x21\x27\x71\x1B(B"),
              { 0x0391,0x044F },
              2,
              false,
              true,
              true },
            { RTL_TEXTENCODING_ISO_2022_KR,
              RTL_CONSTASCII_STRINGPARAM("\x1B$)C\x01\"3De$\\~"),
              { 0x0001,0x0022,0x0033,0x0044,0x0065,0x0024,0x005C,0x007E },
              8,
              false,
              true,
              true },
            { RTL_TEXTENCODING_ISO_2022_KR,
              RTL_CONSTASCII_STRINGPARAM(
                  "\x1B$)C\x0E\x25\x21\x0F\x0D\x0Ax\x0E\x48\x7E\x0F"),
              { 0x2170,0x000D,0x000A,0x0078,0xD79D },
              5,
              false,
              true,
              true },
            { RTL_TEXTENCODING_ISO_2022_CN,
              RTL_CONSTASCII_STRINGPARAM(
                  "\x01\"3De$\\~\x1B$)G\x0E\x45\x70\x1B$*H\x1BN\x22\x22"
                      "\x45\x70\x0F\x1B$)A\x0E\x26\x21\x0F"),
              { 0x0001,0x0022,0x0033,0x0044,0x0065,0x0024,0x005C,0x007E,
                0x4ED9,0x531F,0x4ED9,0x0391 },
              12,
              false,
              true,
              false },
            { RTL_TEXTENCODING_ISO_2022_CN,
              RTL_CONSTASCII_STRINGPARAM(
                  "\x01\"3De$\\~\x1B$)A\x0E\x26\x21\x1B$*H\x1BN\x22\x22"
                      "\x26\x21\x0F\x0D\x0A\x1B$)A\x0E\x26\x21\x0F"),
              { 0x0001,0x0022,0x0033,0x0044,0x0065,0x0024,0x005C,0x007E,
                0x0391,0x531F,0x0391,0x000D,0x000A,0x0391 },
              14,
              false,
              true,
              true },
            // The following does not work as long as Big5-HKSCS maps to
            // Unicode PUA instead of Plane 2.  Use the next two tests
            // instead:
//          { RTL_TEXTENCODING_BIG5_HKSCS,
//            RTL_CONSTASCII_STRINGPARAM(
//                "\x01\"3De$~\x88\x56\xF9\xFE\xFA\x5E\xA1\x40\xF9\xD5"),
//            { 0x0001,0x0022,0x0033,0x0044,0x0065,0x0024,0x007E,0x0100,
//              0xFFED,0xD849,0xDD13,0x3000,0x9F98 },
//            13,
//            true,
//            true,
//            true },
            { RTL_TEXTENCODING_BIG5_HKSCS,
              RTL_CONSTASCII_STRINGPARAM(
                  "\x01\"3De$~\x88\x56\xF9\xFE\xFA\x5E\xA1\x40\xF9\xD5"),
              { 0x0001,0x0022,0x0033,0x0044,0x0065,0x0024,0x007E,0x0100,
                0xFFED,0xE01E,0x3000,0x9F98 },
              12,
              true,
              true,
              true },
            { RTL_TEXTENCODING_BIG5_HKSCS,
              RTL_CONSTASCII_STRINGPARAM(
                  "\x01\"3De$~\x88\x56\xF9\xFE\xFA\x5E\xA1\x40\xF9\xD5"),
              { 0x0001,0x0022,0x0033,0x0044,0x0065,0x0024,0x007E,0x0100,
                0xFFED,0xD849,0xDD13,0x3000,0x9F98 },
              13,
              true,
              false,
              true },
            { RTL_TEXTENCODING_BIG5_HKSCS,
              RTL_CONSTASCII_STRINGPARAM(
                  "\xC6\xA1\xC6\xCF\xC6\xD3\xC6\xD5\xC6\xD7\xC6\xDE\xC6\xDF"
                  "\xC6\xFE\xC7\x40\xC7\x7E\xC7\xA1\xC7\xFE"),
              { 0x2460,0xF6E0,0xF6E4,0xF6E6,0xF6E8,0xF6EF,0xF6F0,0x3058,
                0x3059,0x30A4,0x30A5,0x041A },
              12,
              true,
              true,
              true },
            { RTL_TEXTENCODING_BIG5_HKSCS,
              RTL_CONSTASCII_STRINGPARAM("\x81\x40\x84\xFE"),
              { 0xEEB8,0xF12B },
              2,
              true,
              true,
              true },
            { RTL_TEXTENCODING_BIG5_HKSCS,
              RTL_CONSTASCII_STRINGPARAM("\xAD\xC5\x94\x55"),
              { 0x5029,0x7250 },
              2,
              true,
              true,
              true },
            { RTL_TEXTENCODING_BIG5_HKSCS,
              RTL_CONSTASCII_STRINGPARAM("\xFA\x5F\xA0\xE4"),
              { 0x5029,0x7250 },
              2,
              true,
              true,
              false },
            { RTL_TEXTENCODING_BIG5,
              RTL_CONSTASCII_STRINGPARAM(
                  "\xC6\xCF\xC6\xD3\xC6\xD5\xC6\xD7\xC6\xDE\xC6\xDF"),
              { 0x306B,0x306F,0x3071,0x3073,0x307A,0x307B },
              6,
              true,
              true,
              true },
            { RTL_TEXTENCODING_BIG5,
              RTL_CONSTASCII_STRINGPARAM(
                  "\xC7\xFD\xC7\xFE\xC8\x40\xC8\x7E\xC8\xA1\xC8\xFE"),
              { 0xF7AA,0xF7AB,0xF7AC,0xF7EA,0xF7EB,0xF848 },
              6,
              true,
              true,
              true },
            { RTL_TEXTENCODING_MS_950,
              RTL_CONSTASCII_STRINGPARAM(
                  "\xC6\xA1\xC6\xFE\xC7\x40\xC7\x7E\xC7\xA1\xC7\xFE\xC8\x40"
                  "\xC8\x7E\xC8\xA1\xC8\xFE"),
              { 0xF6B1,0xF70E,0xF70F,0xF74D,0xF74E,0xF7AB,0xF7AC,0xF7EA,
                0xF7EB,0xF848 },
              10,
              true,
              true,
              true },
            { RTL_TEXTENCODING_EUC_JP,
              RTL_CONSTASCII_STRINGPARAM("\xB9\xF5"),
              { 0x9ED2 },
              1,
              true,
              true,
              true } };
    {
        int nCount = sizeof aComplexCharSetTest
                         / sizeof aComplexCharSetTest[0];
        for (int i = 0; i < nCount; ++i)
            doComplexCharSetTest(aComplexCharSetTest[i]);
    }

    ComplexCharSetTest aComplexCharSetCutTest[]
        = { { RTL_TEXTENCODING_EUC_JP,
              RTL_CONSTASCII_STRINGPARAM("\xA1"),
              { 0 },
              0,
              true,
              false },
            { RTL_TEXTENCODING_EUC_JP,
              RTL_CONSTASCII_STRINGPARAM("\x8E"),
              { 0 },
              0,
              true,
              false },
            { RTL_TEXTENCODING_EUC_JP,
              RTL_CONSTASCII_STRINGPARAM("\x8F"),
              { 0 },
              0,
              true,
              false },
            { RTL_TEXTENCODING_EUC_JP,
              RTL_CONSTASCII_STRINGPARAM("\x8F\xA1"),
              { 0 },
              0,
              true,
              false },
            { RTL_TEXTENCODING_EUC_CN,
              RTL_CONSTASCII_STRINGPARAM("\xA1"),
              { 0 },
              0,
              true,
              false } /* ,
            { RTL_TEXTENCODING_EUC_TW,
              RTL_CONSTASCII_STRINGPARAM("\xA1"),
              { 0 },
              0,
              true,
              false },
            { RTL_TEXTENCODING_EUC_TW,
              RTL_CONSTASCII_STRINGPARAM("\x8E"),
              { 0 },
              0,
              true,
              false },
            { RTL_TEXTENCODING_EUC_TW,
              RTL_CONSTASCII_STRINGPARAM("\x8E\xA1"),
              { 0 },
              0,
              true,
              false },
            { RTL_TEXTENCODING_EUC_TW,
              RTL_CONSTASCII_STRINGPARAM("\x8E\xA1\xA1"),
              { 0 },
              0,
              true,
              false } */ };
    {
        int nCount = sizeof aComplexCharSetCutTest
                         / sizeof aComplexCharSetCutTest[0];
        for (int i = 0; i < nCount; ++i)
            doComplexCharSetCutTest(aComplexCharSetCutTest[i]);
    }

    ComplexCharSetTest aComplexCharSetCutTest[]
        = { { RTL_TEXTENCODING_EUC_JP,
              RTL_CONSTASCII_STRINGPARAM("\xA1"),
              { 0 },
              0,
              true,
              true,
              false },
            { RTL_TEXTENCODING_EUC_JP,
              RTL_CONSTASCII_STRINGPARAM("\x8E"),
              { 0 },
              0,
              true,
              true,
              false },
            { RTL_TEXTENCODING_EUC_JP,
              RTL_CONSTASCII_STRINGPARAM("\x8F"),
              { 0 },
              0,
              true,
              true,
              false },
            { RTL_TEXTENCODING_EUC_JP,
              RTL_CONSTASCII_STRINGPARAM("\x8F\xA1"),
              { 0 },
              0,
              true,
              true,
              false },
            { RTL_TEXTENCODING_EUC_CN,
              RTL_CONSTASCII_STRINGPARAM("\xA1"),
              { 0 },
              0,
              true,
              true,
              false } /* ,
            { RTL_TEXTENCODING_EUC_TW,
              RTL_CONSTASCII_STRINGPARAM("\xA1"),
              { 0 },
              0,
              true,
              true,
              false },
            { RTL_TEXTENCODING_EUC_TW,
              RTL_CONSTASCII_STRINGPARAM("\x8E"),
              { 0 },
              0,
              true,
              true,
              false },
            { RTL_TEXTENCODING_EUC_TW,
              RTL_CONSTASCII_STRINGPARAM("\x8E\xA1"),
              { 0 },
              0,
              true,
              true,
              false },
            { RTL_TEXTENCODING_EUC_TW,
              RTL_CONSTASCII_STRINGPARAM("\x8E\xA1\xA1"),
              { 0 },
              0,
              true,
              true,
              false } */ };
    {
        int nCount = sizeof aComplexCharSetCutTest
                         / sizeof aComplexCharSetCutTest[0];
        for (int i = 0; i < nCount; ++i)
            doComplexCharSetCutTest(aComplexCharSetCutTest[i]);
    }

    printf("textenc test done\n");
}
