/*************************************************************************
 *
 *  $RCSfile: StrConvert.c,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obr $ $Date: 2001/06/07 09:18:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <windows.h>
#include <string.h>

#include <assert.h>

//-----------------------------------------------------
// Precondition:	the string lpwcString points to is
//					assumed to be null-terminated
//
// Postcondition:	the caller is responsible for 
//					freeing the allocated heap space
//
int AllocNecessarySpaceAndCopyWStr2Str( LPCWSTR lpcwstrString, LPSTR* lppStr )
{
	int   nNeededStrBuffSizeInBytes;
	int   nCopiedChars = 0;
		
	if( ( NULL != lpcwstrString ) && ( NULL != lppStr ) )
	{
		nNeededStrBuffSizeInBytes = WideCharToMultiByte( CP_ACP, 0, lpcwstrString, -1, NULL, 0, NULL, NULL );
		
		if ( nNeededStrBuffSizeInBytes > 0 )
		{
			assert( nNeededStrBuffSizeInBytes < 0x7FFF8 ); // 0x7FFF8 -> see msdn "HeapAlloc"

			*lppStr = (LPSTR)HeapAlloc( GetProcessHeap(), 0, nNeededStrBuffSizeInBytes );
			assert( HeapSize( GetProcessHeap( ), 0, *lppStr ) >= (DWORD)nNeededStrBuffSizeInBytes );

			if ( NULL != *lppStr )
			{
				nCopiedChars = WideCharToMultiByte( CP_ACP, 
													0, 
													lpcwstrString, 
													-1, 
													*lppStr, 
													nNeededStrBuffSizeInBytes, 
													NULL, 
													NULL );
				assert( nCopiedChars == nNeededStrBuffSizeInBytes );
			}
		}
	}

	return nCopiedChars;
}

//-----------------------------------------------------
// Precondition:	
//
int AllocSpaceAndCopyWStr2Str( LPCWSTR lpcwstrString, DWORD nWCharsToCopy, LPSTR* lppStr )
{
	int   nNeededStrBuffSizeInBytes;
	int   nCopiedChars = 0;
		
	if( ( NULL != lpcwstrString ) && ( NULL != lppStr ) && ( nWCharsToCopy > 0 ) )
	{
		nNeededStrBuffSizeInBytes = WideCharToMultiByte( CP_ACP, 0, lpcwstrString, nWCharsToCopy, NULL, 0, NULL, NULL );
		
		if ( nNeededStrBuffSizeInBytes > 0 )
		{
			assert( nNeededStrBuffSizeInBytes < 0x7FFF8 ); // 0x7FFF8 -> see msdn "HeapAlloc"

			*lppStr = (LPSTR)HeapAlloc( GetProcessHeap(), 0, nNeededStrBuffSizeInBytes );
			assert( HeapSize( GetProcessHeap( ), 0, *lppStr ) >= (DWORD)nNeededStrBuffSizeInBytes );

			if ( NULL != *lppStr )
			{
				nCopiedChars = WideCharToMultiByte( CP_ACP, 
													0, 
													lpcwstrString, 
													nWCharsToCopy, 
													*lppStr, 
													nNeededStrBuffSizeInBytes, 
													NULL, 
													NULL );
				assert( nCopiedChars == nNeededStrBuffSizeInBytes );
			}
		}
	}
	
	return nCopiedChars;
}

//-----------------------------------------------------
// Precondition:	the memory lpszString points to 
//					must have been allocated before 
//					by HeapAlloc using GetProcessHeap
//
void FreeSpaceStr( LPSTR lpszString )
{
	if ( NULL != lpszString )
		HeapFree( GetProcessHeap( ), 0, lpszString );
}

//-----------------------------------------------------
// synopsis:		this function calculates the len
//					of a '\0' separated and double '\0'
//					ending string 
//					e.g. part1\0part2\0partn\0\0
// Precondition:	the string pointed to must be
//					double null terminated else we run
//					into trouble
//
// return:			the len of the string including the 
//					space for the '\0' between the parts
//					and the space for the trailing '\0'
size_t CalcLenDblNullTerminatedWStr( LPCWSTR lpcwstrString )
{
	LPWSTR pStr   = (LPWSTR)lpcwstrString;
	size_t lenStr = 0;
	size_t l      = 0;

	if ( NULL != pStr )
	{
		while( ( l = wcslen( pStr ) ) )
		{			
			pStr   += ( l + 1 );
			lenStr += ( l + 1 ); // add the space for the trailing '\0'			
		}

		// add the space for the trailing '\0'
		if ( lenStr > 0 )
			lenStr += 1;
	}

	return lenStr;
}

//-----------------------------------------------------
// synopsis:		this function calculates the len
//					of a '\0' separated and double '\0'
//					ending string 
//					e.g. part1\0part2\0partn\0\0
// Precondition:	the string pointed to must be
//					double null terminated else we run
//					into trouble
//
// return:			the len of the string including the 
//					space for the '\0' between the parts
//					and the space for the trailing '\0'
size_t CalcLenDblNullTerminatedStr( LPCSTR lpcstrString )
{
	LPSTR  pStr   = (LPSTR)lpcstrString;
	size_t lenStr = 0;
	size_t l      = 0;

	if ( NULL != pStr )
	{
		while( ( l = strlen( pStr ) ) )
		{
			pStr   += ( l + 1 );
			lenStr += ( l + 1 ); // include the space for the trailing '\0'			
		}

		// include the space for the trailing '\0'
		if ( lenStr > 0 )
			lenStr += 1;
	}

	return lenStr;
}

//-----------------------------------------------------
// synopsis:		this function calculates the length
//					of a '\0' separated and double '\0'
//					ending string list the corresponds
//                  to given wide char string list.
//
//					e.g. part1\0part2\0partn\0\0
//
// Precondition:	the wide char string passed in must 
//                  be double null terminated else we 
//                  run	into trouble
//
// return:			the len of the string including the 
//					space for the '\0' between the parts
//					and the space for the trailing '\0'

int WideCharListGetMultiByteLength( UINT codepage, LPCWSTR wcList )
{
    LPCWSTR lpEntry;
    int len = 0;

    // iterate over all strings and summ all needed buffer sizes.
    for( lpEntry = wcList; *lpEntry; lpEntry += wcslen( lpEntry ) + 1 )
        len += WideCharToMultiByte( codepage,  0, lpEntry, -1, NULL, 0, NULL, NULL );

    // add an extra byte for the trailing '\0'
    if( len )
        ++len;

    return len;
}

//-----------------------------------------------------
// synopsis:		this function constructs a '\0' 
//                  separated and double '\0'ended 
//                  string list that corresponds
//                  to given wide char string list.
//
//					e.g. part1\0part2\0partn\0\0
//
// Precondition:	the wide char string passed in must 
//                  be double null terminated else we 
//                  run	into trouble
//
// return:			the len of the string including the 
//					space for the '\0' between the parts
//					and the space for the trailing '\0'

int WideCharListToMultiByteList( UINT codepage, LPCWSTR wcList, LPSTR mbList, DWORD dwSize )
{
    LPCWSTR lpEntry;
    int len = 0;

    // iterate over all strings to convert.
    for( lpEntry = wcList; *lpEntry; lpEntry += wcslen( lpEntry ) + 1 )
        len += WideCharToMultiByte( codepage,  0, lpEntry, -1, mbList + len, dwSize - len, NULL, NULL );

    // add trailing '\0'
    mbList[len++] = '\0';
    return len;
}
