/*************************************************************************
 *
 *  $RCSfile: dbbrwcbx.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:32:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#pragma hdrstop
#include "dbbrwcbx.hxx"

#ifndef _APP_HXX //autogen
#include <vcl/svapp.hxx>
#endif

#ifndef _EDIT_HXX //autogen
#include <vcl/edit.hxx>
#endif

#ifndef _SV_SYMBOL_HXX //autogen
#include <vcl/symbol.hxx>
#endif

#ifndef _WLDCRD_HXX //autogen
#include <tools/wldcrd.hxx>
#endif

//==================================================================

#define COMBOBUTTON_WIDTH_PIXEL	16

//==================================================================

//------------------------------------------------------------------------------
void ListBoxCtrl::Close(BOOL bCanceled, BOOL bKeep)
{
	if ( bClosing )
		return;
	bClosing = TRUE;
	bKeepFocus = bKeep;
	bCancel	   = bCanceled;
	Application::PostUserEvent(aClosedHdl);
}

//------------------------------------------------------------------------------
void ListBoxCtrl::KeyInput(const KeyEvent& rKEvt)
{
	KeyCode aKeyAction = rKEvt.GetKeyCode();

	switch (aKeyAction.GetCode())
	{
		case KEY_F4:
		case KEY_RETURN:
			if (!aKeyAction.IsShift() && !aKeyAction.IsMod1())
			{
				Close(FALSE,TRUE);
				return;
			}
			break;

		case KEY_ESCAPE:
			if (!aKeyAction.IsShift())
			{
				Close(TRUE,TRUE);
				return;
			}
	}
	ListBox::KeyInput(rKEvt);
}

//------------------------------------------------------------------------------
void ListBoxCtrl::LoseFocus()
{
	ListBox::LoseFocus();
}

//------------------------------------------------------------------------------
long ListBoxFrame::ParentNotify(NotifyEvent& rEvt)
{
#ifdef VCL
	if ( rEvt.GetType() == EVENT_LOSEFOCUS )
	{
		Window* pFocusWindow = Application::GetFocusWindow();
		if ( !pFocusWindow || !IsChild( pFocusWindow ) )
			aListBox.Close(FALSE, FALSE);
	}
	else if ( rEvt.GetType() == EVENT_KEYINPUT )
	{
		if ( rEvt.GetWindow() != &aListBox )
			aListBox.KeyInput( *(rEvt.GetKeyEvent()) );
	}
#endif

	if (GetParent())
		return GetParent()->ParentNotify(rEvt);
	else
		return FloatingWindow::ParentNotify(rEvt);
}

//------------------------------------------------------------------------------
void ListBoxFrame::Resize()
{
	FloatingWindow::Resize();
	aListBox.SetPosSizePixel(Point(0,0), GetOutputSizePixel());
}

//------------------------------------------------------------------------------
void ButtonCtrl::MouseButtonDown( const MouseEvent& rMEvt )
{
	ImageButton::MouseButtonDown(rMEvt);

	if (rMEvt.IsLeft())
		aDropDownHdl.Call(this);
}

//------------------------------------------------------------------------------
ComboBoxCtrl::ComboBoxCtrl(Window* pParent, WinBits nWinStyle)
			 :Window(pParent, nWinStyle)
			 ,bDropping(FALSE)
			 ,nTextLen(0)
			 ,bAutoCompleteEnabled(FALSE)
{
#ifdef VCL
	pButton = new ButtonCtrl(this, WB_NOPOINTERFOCUS);
	pButton->SetSymbol(SYMBOL_SPIN_DOWN);
#else
	pButton = new ButtonCtrl(this, 0);
	pButton->SetImage(GetComboBitmap());
#endif

	pButton->SetDropDownHdl(LINK(this,ComboBoxCtrl,DropDownHdl));
	pButton->Show();

	pEdit	= new Edit(this, WB_LEFT);
	pEdit->Show();

#ifdef VCL
	pListBoxFrame = new ListBoxFrame(this, WB_BORDER);
#else
	pListBoxFrame = new ListBoxFrame(this, 0);
#endif
	pListBoxFrame->Hide();
	pListBoxFrame->Disable();
	GetListBox().SetSelectHdl(LINK(this,ComboBoxCtrl,SelectHdl));
	pListBoxFrame->GetListBox().SetCloseHdl(LINK(this,ComboBoxCtrl,CloseHdl));

	aAutoCompleteTimer.SetTimeout(100);
	aAutoCompleteTimer.SetTimeoutHdl(LINK(this,ComboBoxCtrl,AutoCompleteHdl));
}

//------------------------------------------------------------------------------
ComboBoxCtrl::~ComboBoxCtrl()
{
	delete pButton;
	delete pEdit;
	delete pListBoxFrame;
}

void ComboBoxCtrl::KeyInput(const KeyEvent& rKEvt)
{
}

//------------------------------------------------------------------------------
long ComboBoxCtrl::Notify( NotifyEvent& rNEvt )
{
	return Window::Notify( rNEvt );
}

//------------------------------------------------------------------------------
long ComboBoxCtrl::PreNotify( NotifyEvent& rNEvt )
{
	switch (rNEvt.GetType())
	{
		case EVENT_KEYINPUT:
		{
			const KeyEvent* pKeyEvent =	rNEvt.GetKeyEvent();
			if (!pKeyEvent || !pEdit->HasFocus())
				return Window::ParentNotify(rNEvt);

			KeyCode aKeyCode = pKeyEvent->GetKeyCode();
			USHORT nKey = aKeyCode.GetCode();

			//////////////////////////////////////////////////////////////
			// Aufklappen ListBox mit F4 oder CursorDown
			if( (
				(nKey == KEY_F4) &&
				!aKeyCode.IsShift() &&
				!aKeyCode.IsMod1()
				)||(
				(nKey == KEY_DOWN) &&
				!aKeyCode.IsShift() &&
				!aKeyCode.IsMod1() &&
				aKeyCode.IsMod2()
				) )
			{
				DropListBox();
				return 1;
			}

			//////////////////////////////////////////////////////////////
			// Autocomplete bei Backspace und Delete abschalten
			if( (
				(nKey == KEY_BACKSPACE) &&
				!aKeyCode.IsShift() &&
				!aKeyCode.IsMod1()
				)||(
				(nKey == KEY_DELETE) &&
				!aKeyCode.IsShift() &&
				!aKeyCode.IsMod1()
				) )
				bAutoCompleteEnabled = FALSE;
			else
				bAutoCompleteEnabled = TRUE;
		}
		default:
			return Window::PreNotify(rNEvt);
	}
}

//------------------------------------------------------------------------------
void ComboBoxCtrl::GetFocus()
{
	pEdit->GrabFocus();
}

//------------------------------------------------------------------------------
void ComboBoxCtrl::LoseFocus()
{
	if (!bDropping)
		HideListBox();
}

//------------------------------------------------------------------------------
void ComboBoxCtrl::MouseButtonUp( const MouseEvent& rEvt )
{
	pEdit->MouseButtonDown(rEvt);
	pEdit->MouseButtonUp(rEvt);
}

//------------------------------------------------------------------------------
void ComboBoxCtrl::DropListBox()
{
	Point aPoint;
	Size  aSize	 = GetSizePixel();

	aPoint.Y() += GetSizePixel().Height();
	aSize.Height() = GetTextSize("X").Height()*8;

	bDropping = TRUE;

	// aktuelle Eingabe merken, um bei Esc auf diesen wert
	// zurueckzusetzen
	aTempText = pEdit->GetText();

	pListBoxFrame->GetListBox().Init();
	pListBoxFrame->SetFont(GetFont());
	pListBoxFrame->SetPosSizePixel(OutputToScreenPixel(aPoint),aSize);
	GetListBox().SelectEntry(aTempText);
	pListBoxFrame->Enable();
	pListBoxFrame->Show();
	GetListBox().GrabFocus();
	bDropping = FALSE;
}

//------------------------------------------------------------------------------
void ComboBoxCtrl::HideListBox()
{
	pListBoxFrame->Hide();
	pListBoxFrame->Disable();
}

//------------------------------------------------------------------------------
IMPL_LINK(ComboBoxCtrl, DropDownHdl, ImageButton*, EMPTYTAG)
{
	if (pListBoxFrame->GetListBox().IsClosing())		// Listbox wird gerade geschlossen
	{
		pListBoxFrame->GetListBox().KeepFocus(TRUE);	// auf alle Faelle den Focus behalten
		return 0;
	}

	if (IsDropDownOpen())
		HideListBox();
	else
		DropListBox();
	return 0;
}

//------------------------------------------------------------------------------
IMPL_LINK(ComboBoxCtrl, SelectHdl, ListBox*, EMPTYTAG)
{
	OnSelect(GetListBox().GetSelectEntry());
	if (!GetListBox().IsTravelSelect())	// Selection ueber Maus
	{
		GrabFocus();
		HideListBox();
	}

	return 0;
}

//------------------------------------------------------------------------------
IMPL_LINK(ComboBoxCtrl, CloseHdl, ListBox*, EMPTYTAG)
{
	static nCount = 0;

	if (nCount)										// kann mehrfach aufgerufen werden
		return 0;

	nCount++;
	if (pListBoxFrame->GetListBox().KeepFocus())	// Listbox legt fest, ob der Focus
													// beibehalten wird
		GrabFocus();
	HideListBox();
	if (pListBoxFrame->GetListBox().IsCanceled())
		pEdit->SetText(aTempText);

	pListBoxFrame->GetListBox().Init();
	--nCount;

	return 0;
}

//------------------------------------------------------------------------------
void ComboBoxCtrl::Resize()
{
	Point aButtonPoint;
	Size  aEditSize  = GetSizePixel(),
		  aButtonSize;


	if (aEditSize.Width() > COMBOBUTTON_WIDTH_PIXEL)
		aEditSize.Width() -= COMBOBUTTON_WIDTH_PIXEL;
	else
		aEditSize.Width() = 0;

	aButtonSize.Width() = COMBOBUTTON_WIDTH_PIXEL;
	aButtonSize.Height()= aEditSize.Height();
	aButtonPoint.X() += aEditSize.Width();

	pEdit->SetSizePixel(aEditSize);
	pButton->SetPosSizePixel(aButtonPoint, aButtonSize);
}


//------------------------------------------------------------------------------
ListBox& ComboBoxCtrl::GetListBox() const {return pListBoxFrame->GetListBox();}

//------------------------------------------------------------------------------
BOOL ComboBoxCtrl::IsDropDownOpen() const {return pListBoxFrame->IsVisible();}

//------------------------------------------------------------------------------
void ComboBoxCtrl::SetSelectHdl( const Link& rLink )
{
	aSelLink = rLink;
	GetListBox().SetSelectHdl( aSelLink );
}

//------------------------------------------------------------------------------
void ComboBoxCtrl::SetModifyHdl(const Link& rLink)
{
	aModLink = rLink;
	pEdit->SetModifyHdl(LINK(this,ComboBoxCtrl,ModifyHdl));
}

//------------------------------------------------------------------------------
IMPL_LINK(ComboBoxCtrl, ModifyHdl, void*, EMPTYTAG)
{
	aAutoCompleteTimer.Stop();

	USHORT nNewTextLen = pEdit->GetText().Len();
//	if (nTextLen < nNewTextLen)
	if( bAutoCompleteEnabled )
		aAutoCompleteTimer.Start();

	nTextLen = nNewTextLen;
	aModLink.Call(pEdit);
	return 0;
}

//------------------------------------------------------------------------------
IMPL_LINK(ComboBoxCtrl, AutoCompleteHdl, void*, EMPTYTAG)
{
	String	aText = pEdit->GetText();
	WildCard aWc(aText + String('*'));

	USHORT nCount = GetEntryCount();
	while (--nCount != LISTBOX_ENTRY_NOTFOUND)
	{
		String aListEntry = GetEntry(nCount);
		if (aWc.Matches(aListEntry) && aListEntry != aText)
		{
			SetText(aListEntry);
			SetSelection(Selection(aText.Len(),SELECTION_MAX));
			aSelLink.Call( this );
			break;
		}
	}
	return 0;
}

//------------------------------------------------------------------------------
void ComboBoxCtrl::SetText(const String& rText)
{
	nTextLen = rText.Len();
	aAutoCompleteTimer.Stop();
	pEdit->SetText(rText);
	GetListBox().SelectEntry(rText);
}

//------------------------------------------------------------------------------
String ComboBoxCtrl::GetText() const
{
	return pEdit->GetText();
}

//------------------------------------------------------------------------------
USHORT ComboBoxCtrl::GetEntryPos( const String& rStr ) const
{
	return GetListBox().GetEntryPos(rStr);
}

//------------------------------------------------------------------------------
String ComboBoxCtrl::GetEntry( USHORT nPos ) const
{
	return GetListBox().GetEntry(nPos);
}

//------------------------------------------------------------------------------
USHORT ComboBoxCtrl::InsertEntry( const String& rStr, USHORT nPos)
{
	return GetListBox().InsertEntry(rStr,nPos);
}

//------------------------------------------------------------------------------
void ComboBoxCtrl::RemoveEntry(const String& rStr)
{
	GetListBox().RemoveEntry(rStr);
}

//------------------------------------------------------------------------------
USHORT ComboBoxCtrl::GetEntryCount() const
{
	return GetListBox().GetEntryCount();
}

//------------------------------------------------------------------------------
void ComboBoxCtrl::SetEntryData( USHORT nPos, void* pNewData )
{
	GetListBox().SetEntryData(nPos, pNewData );
}

//------------------------------------------------------------------------------
void* ComboBoxCtrl::GetEntryData( USHORT nPos ) const
{
	return GetListBox().GetEntryData(nPos);
}

//------------------------------------------------------------------------------
void ComboBoxCtrl::Clear()
{
	GetListBox().Clear();
}

//------------------------------------------------------------------------------
void ComboBoxCtrl::OnSelect(const String& rText)
{
	aAutoCompleteTimer.Stop();
	nTextLen = rText.Len();

	pEdit->SetText(rText);
	pEdit->SetSelection(Selection(0, -1));
	pEdit->SetModifyFlag();
	aModLink.Call(pEdit);
}

//------------------------------------------------------------------------------
BOOL ComboBoxCtrl::MoveAllowed(const KeyEvent& rEvt) const
{
	switch (rEvt.GetKeyCode().GetCode())
	{
		case KEY_RIGHT:
		{
			if (GetListBox().HasFocus())
				return FALSE;

			Selection aSel = pEdit->GetSelection();
			return !aSel && aSel.Max() == pEdit->GetText().Len();
		}
		case KEY_LEFT:
		{
			if (GetListBox().HasFocus())
				return FALSE;

			Selection aSel = pEdit->GetSelection();
			return !aSel && aSel.Min() == 0;
		}
		case KEY_DOWN:
			if (!rEvt.GetKeyCode().IsShift() &&
				 rEvt.GetKeyCode().IsMod1())
				return FALSE;
		case KEY_UP:
		case KEY_PAGEUP:
		case KEY_PAGEDOWN:
			if (GetListBox().HasFocus())
				return FALSE;
		default:
			return TRUE;
	}
}

//------------------------------------------------------------------------------
BOOL ComboBoxCtrl::IsModified() const
{
	return pEdit->IsModified();
}

//------------------------------------------------------------------------------
void ComboBoxCtrl::SetModifyFlag()
{
	pEdit->SetModifyFlag();
}

//------------------------------------------------------------------------------
void ComboBoxCtrl::ClearModifyFlag()
{
	pEdit->ClearModifyFlag();
}

//------------------------------------------------------------------------------
void ComboBoxCtrl::SetSelection( const Selection& rSelection )
{
	pEdit->SetSelection(rSelection);
}
//------------------------------------------------------------------------------
Selection ComboBoxCtrl::GetSelection() const
{
	return pEdit->GetSelection();
}

//------------------------------------------------------------------------------
void ComboBoxCtrl::SaveValue()
{
	pEdit->SaveValue();
}

//------------------------------------------------------------------------------
const String& ComboBoxCtrl::GetSavedValue() const
{
	return pEdit->GetSavedValue();
}


