/*************************************************************************
 *
 *  $RCSfile: optgdlg.cxx,v $
 *
 *  $Revision: 1.53 $
 *
 *  last change: $Author: os $ $Date: 2002/01/07 12:47:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "ofapch.hxx"
#endif

#pragma hdrstop

#ifndef _SV_CONFIG_HXX //autogen wg. Config
#include <vcl/config.hxx>
#endif
#ifndef _ZFORLIST_HXX //autogen
#include <svtools/zforlist.hxx>
#endif
#ifndef _GRFMGR_HXX
#include <goodies/grfmgr.hxx>
#endif
#ifndef _SFXFLAGITEM_HXX //autogen
#include <svtools/flagitem.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SVX_OPTGENRL_HXX
#include <svx/optgenrl.hxx>
#endif
#ifndef _SVX_OPTPATH_HXX
#include <svx/optpath.hxx>
#endif
#ifndef _SVX_OPTSAVE_HXX
#include <svx/optsave.hxx>
#endif
#ifndef _SVX_OPTLINGU_HXX
#include <svx/optlingu.hxx>
#endif
#ifndef _XPOOL_HXX
#include <svx/xpool.hxx>
#endif
#ifndef _SVX_DLGUTIL_HXX
#include <svx/dlgutil.hxx>
#endif
#ifndef _SVTOOLS_LINGUCFG_HXX_
#include <svtools/lingucfg.hxx>
#endif
#ifndef _SFXSZITEM_HXX
#include <svtools/szitem.hxx>
#endif
#ifndef _SFXVIEWSH_HXX
#include <sfx2/viewsh.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX
#include <sfx2/viewfrm.hxx>
#endif
#ifndef _FILEDLGHELPER_HXX
#include <sfx2/filedlghelper.hxx>
#endif
#ifndef _SVX_TAB_AREA_HXX
#include <svx/tabarea.hxx>
#endif
#ifndef _SVX_LANGTAB_HXX //autogen
#include <svx/langtab.hxx>
#endif
#ifndef _SVX_DIALOGS_HRC
#include <svx/dialogs.hrc>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#ifndef _ISOLANG_HXX
#include <tools/isolang.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_USEROPTIONS_HXX
#include <svtools/useroptions.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_CACHEOPTIONS_HXX
#include <svtools/cacheoptions.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_OPTIONS3D_HXX
#include <svtools/options3d.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_FONTOPTIONS_HXX
#include <svtools/fontoptions.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_MENUOPTIONS_HXX
#include <svtools/menuoptions.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_STARTOPTIONS_HXX
#include <svtools/startoptions.hxx>
#endif
#ifndef _SVTOOLS_CJKOPTIONS_HXX
#include <svtools/cjkoptions.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_MISCPOPT_HXX
#include <svtools/miscopt.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_PRINTOPTIONS_HXX
#include <svtools/printwarningoptions.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_SYSLOCALEOPTIONS_HXX
#include <svtools/syslocaleoptions.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_HELPOPT_HXX
#include <svtools/helpopt.hxx>
#endif
#ifndef _UTL_CONFIGITEM_HXX_
#include <unotools/configitem.hxx>
#endif
#ifndef _SFX_OBJSH_HXX
#include <sfx2/objsh.hxx>
#endif
#ifndef _UNO_LINGU_HXX
#include <svx/unolingu.hxx>
#endif
#ifndef _SVX_SVXIDS_HRC
#include <svx/svxids.hrc>
#endif
#define ITEMID_LANGUAGE 0
#ifndef _SVX_LANGITEM_HXX
#include <svx/langitem.hxx>
#endif
#ifndef _COMPHELPER_TYPES_HXX_
#include <comphelper/types.hxx>
#endif
#include "ofaids.hrc"
#include "app.hrc"
#include "app.hxx"
#include "resid.hxx"
#include "optgdlg.hrc"
#include "optgdlg.hxx"
#include "ofaitem.hxx"

#define CONFIG_LANGUAGES "OfficeLanguages"

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::beans;
using namespace ::utl;
using namespace ::rtl;
using namespace ::sfx2;

#define C2U(cChar) OUString::createFromAscii(cChar)

#if SUPD<641
#ifndef SID_OPT_MIDDLE_MOUSE
#define SID_OPT_MIDDLE_MOUSE                (SID_OPTIONS_START + 97)
#endif
#endif

#ifdef WNT
#define HELPER_PAGE_MAIL_ONLY
#else
#define HELPER_PAGE_COMPLETE
#endif

// class OfaMiscTabPage --------------------------------------------------

int OfaMiscTabPage::DeactivatePage( SfxItemSet* pSet )
{
	if ( pSet )
		FillItemSet( *pSet );
	return LEAVE_PAGE;
}

// -----------------------------------------------------------------------

OfaMiscTabPage::OfaMiscTabPage(Window* pParent, const SfxItemSet& rSet ) :

	SfxTabPage( pParent, OffResId( OFA_TP_MISC ), rSet ),

    aGbTwoFigure            ( this, ResId( GB_TWOFIGURE ) ),
	aFtInterpret		    ( this, ResId( FT_INTERPRET ) ),
	aNfYearValue		    ( this, ResId( NF_YEARVALUE ) ),
	aFtTo				    ( this, ResId( FT_TO) ),
	aHelpAgentFL			( this, ResId( FL_HELPAGENT ) ),
	aHelpAgentCB			( this, ResId( CB_HELPAGENT ) ),
	aHelpAgentResetFT		( this, ResId( FT_HELPAGENT_RESET ) ),
	aHelpAgentResetBtn		( this, ResId( PB_HELPAGENT_RESET ) ),
	aHelpAgentTimeFT		( this, ResId( FT_HELPAGENT_TIME ) ),
	aHelpAgentTimeED		( this, ResId( ED_HELPAGENT_TIME ) ),
    aHelpAgentTimeUnitFT    ( this, ResId( FT_HELPAGENT_TIME_UNIT ) ),
    aFileDlgFL(               this, ResId( FL_FILEDLG )),
    aFileDlgCB(               this, ResId( CB_FILEDLG )),
    aDocStatusFL(             this, ResId( FL_DOCSTATUS )),
    aDocStatusCB(             this, ResId( CB_DOCSTATUS ))
{
	FreeResource();

    //quick launch only available in Win
#ifndef WNT
    aFileDlgFL.Hide();
    aFileDlgCB.Hide();
#endif

    aStrDateInfo = aFtTo.GetText();
    aNfYearValue.SetModifyHdl( LINK( this, OfaMiscTabPage, TwoFigureHdl ) );
	Link aLink = LINK( this, OfaMiscTabPage, TwoFigureConfigHdl );
	aNfYearValue.SetDownHdl( aLink );
	aNfYearValue.SetUpHdl( aLink );
	aNfYearValue.SetLoseFocusHdl( aLink );
	aNfYearValue.SetFirstHdl( aLink );
	TwoFigureConfigHdl( &aNfYearValue );

    SetExchangeSupport();

	aHelpAgentCB.SetClickHdl( LINK( this, OfaMiscTabPage, HelpAgentHdl_Impl ) );
	aHelpAgentResetBtn.SetClickHdl( LINK( this, OfaMiscTabPage, HelpAgentResetHdl_Impl ) );
}

// -----------------------------------------------------------------------

OfaMiscTabPage::~OfaMiscTabPage()
{
}

// -----------------------------------------------------------------------

SfxTabPage*	OfaMiscTabPage::Create( Window* pParent, const SfxItemSet& rAttrSet )
{
	return new OfaMiscTabPage( pParent, rAttrSet );
}

// -----------------------------------------------------------------------

BOOL OfaMiscTabPage::FillItemSet( SfxItemSet& rSet )
{
	BOOL bModified = FALSE;

    SvtCacheOptions aCacheOptions;
	const SfxUInt16Item* pUInt16Item = PTR_CAST( SfxUInt16Item, GetOldItem( rSet, SID_ATTR_YEAR2000 ) );
	USHORT nNum = (USHORT)aNfYearValue.GetText().ToInt32();
	if ( pUInt16Item->GetValue() != nNum )
	{
		bModified = TRUE;
		rSet.Put( SfxUInt16Item( SID_ATTR_YEAR2000, nNum ) );
	}

	// help agent
	SvtHelpOptions aHelpOpt;
	BOOL bChecked = aHelpAgentCB.IsChecked();
	if ( bChecked != aHelpAgentCB.GetSavedValue() )
    {
        rSet.Put( SfxBoolItem( SID_ATTR_AUTOHELPAGENT, aHelpAgentCB.IsChecked() ) );
        bModified = TRUE;
    }

	if ( bChecked && aHelpAgentTimeED.GetText() != aHelpAgentTimeED.GetSavedValue() )
	{
		sal_Int32 nNewTime = aHelpAgentTimeED.GetValue();
        rSet.Put( SfxInt32Item( SID_HELPAGENT_TIMEOUT, nNewTime ) );
        bModified = TRUE;
	}

    if ( aFileDlgCB.IsChecked() != aFileDlgCB.GetSavedValue() )
    {
        SvtMiscOptions aMiscOpt;
        aMiscOpt.SetUseSystemFileDialog( !aFileDlgCB.IsChecked() );
        bModified = TRUE;
    }
    if(aDocStatusCB.IsChecked() != aDocStatusCB.GetSavedValue())
    {
        SvtPrintWarningOptions aPrintOptions;
        aPrintOptions.SetModifyDocumentOnPrintingAllowed(aDocStatusCB.IsChecked());
        bModified = TRUE;
    }
	return bModified;
}

// -----------------------------------------------------------------------

void OfaMiscTabPage::Reset( const SfxItemSet& rSet )
{
    SvtCacheOptions     aCacheOptions;
	const SfxPoolItem*  pItem;

	if ( SFX_ITEM_SET == rSet.GetItemState( SID_ATTR_YEAR2000, FALSE, &pItem ) )
		aNfYearValue.SetValue( ((SfxUInt16Item*)pItem)->GetValue() );
	else
		aNfYearValue.SetValue( SvNumberFormatter::GetYear2000Default() );
	TwoFigureConfigHdl( &aNfYearValue );

    // Undo-Schritte
    USHORT nWhich = GetWhich( SID_ATTR_UNDO_COUNT );

	// help agent
    if ( SFX_ITEM_SET == rSet.GetItemState( SID_ATTR_AUTOHELPAGENT, FALSE, &pItem ) )
        aHelpAgentCB.Check( ( (SfxBoolItem*)pItem )->GetValue() );
    if ( SFX_ITEM_SET == rSet.GetItemState( SID_HELPAGENT_TIMEOUT, FALSE, &pItem ) )
	    aHelpAgentTimeED.SetValue( ( (SfxInt32Item*)pItem )->GetValue() );

	HelpAgentHdl_Impl( &aHelpAgentCB );
	aHelpAgentCB.SaveValue();
    aHelpAgentTimeED.SaveValue();

    SvtMiscOptions aMiscOpt;
    aFileDlgCB.Check( !aMiscOpt.UseSystemFileDialog() );
    aFileDlgCB.SaveValue();

    SvtPrintWarningOptions aPrintOptions;
    aDocStatusCB.Check(aPrintOptions.IsModifyDocumentOnPrintingAllowed());
    aDocStatusCB.SaveValue();
}

// -----------------------------------------------------------------------

IMPL_LINK( OfaMiscTabPage, TwoFigureHdl, NumericField*, pEd )
{
	String aOutput( aStrDateInfo );
	String aStr( aNfYearValue.GetText() );
	aStr.EraseAllChars( aNfYearValue.GetInternational().GetNumThousandSep() );
	long nNum = aStr.ToInt32();
	if ( aStr.Len() != 4 || nNum < aNfYearValue.GetMin() || nNum > aNfYearValue.GetMax() )
		aOutput.AppendAscii("????");
	else
	{
		nNum += 99;
		aOutput += String::CreateFromInt32( nNum );
	}
	aFtTo.SetText( aOutput );
	return 0;
}

// -----------------------------------------------------------------------

IMPL_LINK( OfaMiscTabPage, TwoFigureConfigHdl, NumericField*, pEd )
{
	long nNum = aNfYearValue.GetValue();
	String aOutput( String::CreateFromInt32( nNum ) );
	aNfYearValue.SetText( aOutput );
	aNfYearValue.SetSelection( Selection( 0, aOutput.Len() ) );
	TwoFigureHdl( pEd );
	return 0;
}

// -----------------------------------------------------------------------

IMPL_LINK( OfaMiscTabPage, HelpAgentHdl_Impl, CheckBox*, pBox )
{
	BOOL bEnable = pBox->IsChecked();
	aHelpAgentResetFT.Enable( bEnable );
	aHelpAgentResetBtn.Enable( bEnable );
	aHelpAgentTimeFT.Enable( bEnable );
	aHelpAgentTimeED.Enable( bEnable );
	aHelpAgentTimeUnitFT.Enable( bEnable );
	return 0;
}

// -----------------------------------------------------------------------

IMPL_LINK( OfaMiscTabPage, HelpAgentResetHdl_Impl, PushButton*, EMPTYARG )
{
	SvtHelpOptions().resetAgentIgnoreURLCounter();
	return 0;
}

// class OfaViewTabPage --------------------------------------------------
// -----------------------------------------------------------------------
IMPL_LINK_INLINE_START( OfaViewTabPage, OpenGLHdl, CheckBox*, EMPTYARG )
{
	a3DOpenGLFasterCB.Enable( a3DOpenGLCB.IsChecked() );
	return 0;
}
IMPL_LINK_INLINE_END( OfaViewTabPage, OpenGLHdl, CheckBox*, EMPTYARG )

OfaViewTabPage::OfaViewTabPage(Window* pParent, const SfxItemSet& rSet ) :

	SfxTabPage( pParent, OffResId( OFA_TP_VIEW ), rSet ),

	aAppearanceGB		( this, ResId( GB_APPEARANCE ) ),
    aAppearanceFT       ( this, ResId( FT_APPEARANCE ) ),
	aAppearanceLB		( this, ResId( LB_APPEARANCE ) ),
	aScalingFT			( this, ResId( FT_SCALING ) ),
	aScalingMF			( this, ResId( MF_SCALING ) ),
	aBigCB				( this, ResId( CB_BIG ) ),
	aStyleCB			( this, ResId( CB_STYLE ) ),
    aMenuIconsCB        ( this, ResId( CB_MENU_ICONS )),
#if defined( UNX ) || defined ( FS_PRIV_DEBUG )
	aFontAntiAliasing	( this, ResId( CB_FONTANTIALIASING )),
	aAAPointLimitLabel	( this, ResId( FT_POINTLIMIT_LABEL )),
	aAAPointLimit		( this, ResId( NF_AA_POINTLIMIT )),
	aAAPointLimitUnits	( this, ResId( FT_POINTLIMIT_UNIT )),
#endif
    aMouseFL            ( this, ResId( FL_MOUSE ) ),
    aMousePosFT         ( this, ResId( FT_MOUSEPOS ) ),
    aMousePosLB         ( this, ResId( LB_MOUSEPOS ) ),
    aMouseMiddleFT      ( this, ResId( FT_MOUSEMIDDLE ) ),
    aMouseMiddleLB      ( this, ResId( LB_MOUSEMIDDLE ) ),
	aMouseFollowCB  	( this, ResId( CB_MOUSE_FOLLOW ) ),
	aFlatTabCtrlCB		( this, ResId( CB_FLAT_TAB_CTRL ) ),
	aColorTabCtrlCB		( this, ResId( CB_COLOR_TAB_CTRL ) ),
	aFontShowCB			( this, ResId( CB_FONT_SHOW ) ),
	aShowInactiveItemsCB( this, ResId( CB_SHOW_INACTIVE ) ),
    aFontHistoryCB      ( this, ResId( CB_FONT_HISTORY ) ),
    a3DGB               ( this, ResId( GB_3D ) ),
	a3DOpenGLCB			( this, ResId( CB_3D_OPENGL ) ),
	a3DOpenGLFasterCB	( this, ResId( CB_3D_OPENGL_FASTER ) ),
	a3DDitheringCB		( this, ResId( CB_3D_DITHERING ) ),
	a3DShowFullCB		( this, ResId( CB_3D_SHOWFULL ) ),
    aWorkingSetBox      ( this, ResId( GB_WORKINGSET ) ),
	aDocViewBtn			( this, ResId( BTN_DOCVIEW ) ),
    aOpenWinBtn         ( this, ResId( BTN_OPENWIN ) )

{
    a3DOpenGLCB.SetClickHdl( LINK( this, OfaViewTabPage, OpenGLHdl ) );

#if defined( UNX ) || defined ( FS_PRIV_DEBUG )
	aFontAntiAliasing.SetToggleHdl( LINK( this, OfaViewTabPage, OnAntialiasingToggled ) );

	// depending on the size of the text in aAAPointLimitLabel, we slightly re-arrange aAAPointLimit and aAAPointLimitUnits
	sal_Int32 nLabelWidth = aAAPointLimitLabel.GetTextWidth( aAAPointLimitLabel.GetText() );
	nLabelWidth += 3;	// small gap
	// pixels to move both controls to the left
	Size aSize = aAAPointLimitLabel.GetSizePixel();
	sal_Int32 nMoveLeft = aSize.Width() - nLabelWidth;
	// resize the first label
	aSize.Width() = nLabelWidth;
	aAAPointLimitLabel.SetSizePixel( aSize );

	// move the numeric field
	Point aPos( aAAPointLimit.GetPosPixel() );
	aPos.X() -= nMoveLeft;
	aAAPointLimit.SetPosPixel( aPos );

	// move (and resize) the units FixedText
	aPos = ( aAAPointLimitUnits.GetPosPixel() );
	aPos.X() -= nMoveLeft;
	aSize = aAAPointLimitUnits.GetSizePixel();
	aSize.Width() += nMoveLeft;
	aAAPointLimitUnits.SetPosSizePixel( aPos, aSize );
#else
	// on this platform, we do not have the anti aliasing options - move the other checkboxes accordingly
	// (in the resource, the coordinates are calculated for the AA options beeing present)
	CheckBox* pMiscOptions[] =
	{
		&aMouseFollowCB, &aFlatTabCtrlCB, &aColorTabCtrlCB, &aFontShowCB, &aShowInactiveItemsCB, &aFontHistoryCB,
		&aBigCB, &aStyleCB, &aMenuIconsCB
	};

	// temporaryly create the checkbox for the anti aliasing (we need to to determine it's pos)
	CheckBox* pFontAntiAliasing	= new CheckBox( this, ResId( CB_FONTANTIALIASING ) );
	sal_Int32 nMoveUp = aMouseFollowCB.GetPosPixel().Y() - pFontAntiAliasing->GetPosPixel().Y();
	DELETEZ( pFontAntiAliasing );

	Point aPos;
	for ( sal_Int32 i = 0; i < sizeof( pMiscOptions ) / sizeof( pMiscOptions[0] ); ++i )
	{
		aPos = pMiscOptions[i]->GetPosPixel( );
		aPos.Y() -= nMoveUp;
		pMiscOptions[i]->SetPosPixel( aPos );
	}

#endif
	FreeResource();
}

/*-----------------06.12.96 11.50-------------------

--------------------------------------------------*/

OfaViewTabPage::~OfaViewTabPage()
{
}

#if defined( UNX ) || defined ( FS_PRIV_DEBUG )
//--- 20.08.01 10:16:12 ---------------------------------------------------
IMPL_LINK( OfaViewTabPage, OnAntialiasingToggled, void*, NOTINTERESTEDIN )
{
	sal_Bool bAAEnabled = aFontAntiAliasing.IsChecked();

	aAAPointLimitLabel.Enable( bAAEnabled );
	aAAPointLimit.Enable( bAAEnabled );
	aAAPointLimitUnits.Enable( bAAEnabled );

	return 0L;
}
#endif

/*-----------------06.12.96 11.50-------------------

--------------------------------------------------*/

SfxTabPage*	OfaViewTabPage::Create( Window* pParent, const SfxItemSet& rAttrSet )
{
	return new OfaViewTabPage(pParent, rAttrSet);
}

/*-----------------06.12.96 11.50-------------------

--------------------------------------------------*/

BOOL OfaViewTabPage::FillItemSet( SfxItemSet& rSet )
{
	SvtFontOptions aFontOpt;
	SvtMenuOptions aMenuOpt;
	SvtStartOptions aStartOpt;

	BOOL bModified = FALSE;

	SfxBoolItem *pItem = PTR_CAST( SfxBoolItem, GetOldItem( rSet, SID_ATTR_BUTTON_OUTSTYLE3D ) );
	if ( pItem->GetValue() == aStyleCB.IsChecked() )
	{
		bModified = TRUE;
		rSet.Put( SfxBoolItem( SID_ATTR_BUTTON_OUTSTYLE3D, !aStyleCB.IsChecked() ) );
	}

	pItem = PTR_CAST( SfxBoolItem, GetOldItem( rSet, SID_ATTR_BUTTON_BIGSIZE ) );
	if ( pItem->GetValue() != aBigCB.IsChecked() )
	{
		bModified = TRUE;
		rSet.Put( SfxBoolItem( SID_ATTR_BUTTON_BIGSIZE, aBigCB.IsChecked() ) );
	}

	// Look & Feel Group
	SfxUInt16Item *pU16Item = PTR_CAST( SfxUInt16Item, GetOldItem(rSet, SID_OPT_SYSTEMLOOK));
	SystemLook eOldLook = (SystemLook)pU16Item->GetValue();
	SystemLook eNewLook;

	switch (aAppearanceLB.GetSelectEntryPos())
	{
		case 1:	eNewLook = LookMacintosh;		break;
		case 2:	eNewLook = LookMotif;			break;
		case 3:	eNewLook = LookOSTwo;			break;
		case 0:
		default:eNewLook = LookStardivision;	break;
	}

	if ( eNewLook != eOldLook )
	{
		bModified = TRUE;
		rSet.Put( SfxUInt16Item( SID_OPT_SYSTEMLOOK, (UINT16)eNewLook ) );
	}

	// Screen Scaling
	pU16Item = PTR_CAST( SfxUInt16Item, GetOldItem(rSet, SID_OPT_SCREENSCALING));
	UINT16 nOldScale = (UINT16)pU16Item->GetValue();
	UINT16 nNewScale = (UINT16)aScalingMF.GetValue();

	if ( nNewScale != nOldScale )
	{
		bModified = TRUE;
		rSet.Put( SfxUInt16Item( SID_OPT_SCREENSCALING, nNewScale ) );
	}

	// Mouse Snap Mode
    SfxInt16Item* p16Item = PTR_CAST( SfxInt16Item, GetOldItem(rSet, SID_OPT_SNAPTYPE) );
    short eOldSnap = (SnapType)p16Item->GetValue();
    short eNewSnap = aMousePosLB.GetSelectEntryPos();
    if(eNewSnap > 2)
        eNewSnap = 2;

	if ( eNewSnap != eOldSnap )
	{
		bModified = TRUE;
        rSet.Put( SfxInt16Item( SID_OPT_SNAPTYPE, eNewSnap ) );
	}

    // Middle Mouse Button
    p16Item = PTR_CAST( SfxInt16Item, GetOldItem(rSet, SID_OPT_MIDDLE_MOUSE) );
    short eOldMiddleMouse = p16Item->GetValue();
    short eNewMiddleMouse = aMouseMiddleLB.GetSelectEntryPos();
    if(eNewMiddleMouse > 2)
        eNewMiddleMouse = 2;

    if ( eNewMiddleMouse != eOldMiddleMouse )
	{
		bModified = TRUE;
        rSet.Put( SfxInt16Item( SID_OPT_MIDDLE_MOUSE, eNewMiddleMouse ) );
	}

#if defined( UNX ) || defined ( FS_PRIV_DEBUG )
	if ( aFontAntiAliasing.IsChecked() != aFontAntiAliasing.GetSavedValue() )
	{
		rSet.Put( SfxBoolItem( SID_OPT_FONT_ANTIALIASING_ENABLED, aFontAntiAliasing.IsChecked() ) );
		bModified = TRUE;
	}

	if ( aAAPointLimit.GetValue() != aAAPointLimit.GetSavedValue() )
	{
		rSet.Put( SfxUInt16Item( SID_OPT_FONT_ANTIALIASING_MINPIXELS, aAAPointLimit.GetValue() ) );
		bModified = TRUE;
	}
#endif

	if ( aMouseFollowCB.IsChecked() != aMouseFollowCB.GetSavedValue() )
	{
		rSet.Put( SfxBoolItem( SID_APPEAR_MENUE_MOUSE_FOLLOW, aMouseFollowCB.IsChecked() ) );
		bModified = TRUE;
	}
	if ( aFlatTabCtrlCB.IsChecked() != aFlatTabCtrlCB.GetSavedValue() )
	{
		rSet.Put( SfxBoolItem( SID_APPEAR_SINGLE_LINE_TABCTRL, aFlatTabCtrlCB.IsChecked() ) );
		bModified = TRUE;
	}

	if ( aColorTabCtrlCB.IsChecked() != aColorTabCtrlCB.GetSavedValue() )
	{
		rSet.Put( SfxBoolItem( SID_APPEAR_COLORED_TABCTRL, aColorTabCtrlCB.IsChecked() ) );
		bModified = TRUE;
	}

	if ( aFontShowCB.IsChecked() != aFontShowCB.GetSavedValue() )
	{
		aFontOpt.EnableFontWYSIWYG( aFontShowCB.IsChecked() );
		bModified = TRUE;
	}

	if ( aShowInactiveItemsCB.IsChecked() != aShowInactiveItemsCB.GetSavedValue() )
	{
		aMenuOpt.SetEntryHidingState( aShowInactiveItemsCB.IsChecked() );
		bModified = TRUE;
	}
    if(aMenuIconsCB.IsChecked() != aMenuIconsCB.GetSavedValue())
        aMenuOpt.SetMenuIconsState( aMenuIconsCB.IsChecked() );

	if ( aFontHistoryCB.IsChecked() != aFontHistoryCB.GetSavedValue() )
	{
		aFontOpt.EnableFontHistory( aFontHistoryCB.IsChecked() );
		bModified = TRUE;
	}
    // Workingset
	if ( aDocViewBtn.IsChecked() != aDocViewBtn.GetSavedValue() )
	{
		rSet.Put( SfxBoolItem( GetWhich( SID_ATTR_SAVEDOCVIEW ),
							   aDocViewBtn.IsChecked() ) );
		bModified |= TRUE;
	}

	if ( aOpenWinBtn.IsChecked() != aOpenWinBtn.GetSavedValue() )
	{
		rSet.Put( SfxBoolItem( GetWhich( SID_ATTR_SAVEDOCWINS ),
							   aOpenWinBtn.IsChecked() ) );
		bModified |= TRUE;
	}
    SvtOptions3D a3DOpt;
	BOOL bTemp = a3DOpt.IsOpenGL();

	if ( bTemp != a3DOpenGLCB.IsChecked() )
	{
		a3DOpt.SetOpenGL( a3DOpenGLCB.IsChecked() );
		bModified = TRUE;
	}

	BOOL bCheck = ( a3DOpenGLCB.IsChecked() && a3DOpenGLFasterCB.IsChecked() );
	if ( a3DOpt.IsOpenGL_Faster() != bCheck )
	{
		a3DOpt.SetOpenGL_Faster( bCheck );
		bModified = TRUE;
	}

	if ( a3DOpt.IsDithering() != a3DDitheringCB.IsChecked() )
	{
		a3DOpt.SetDithering( a3DDitheringCB.IsChecked() );
		bModified = TRUE;
	}

	if ( a3DOpt.IsShowFull() != a3DShowFullCB.IsChecked() )
	{
		a3DOpt.SetShowFull( a3DShowFullCB.IsChecked() );
		bModified = TRUE;
	}

    return bModified;
}

/*-----------------06.12.96 11.50-------------------

--------------------------------------------------*/

void OfaViewTabPage::Reset( const SfxItemSet& rSet )
{
	const SfxPoolItem* pItem;

    SvtOptions3D a3DOpt;
	a3DOpenGLCB.Check( a3DOpt.IsOpenGL() );
	a3DOpenGLFasterCB.Check( a3DOpenGLCB.IsChecked() && a3DOpt.IsOpenGL_Faster() );
	OpenGLHdl( NULL );
	a3DDitheringCB.Check( a3DOpt.IsDithering() );
	a3DShowFullCB.Check( a3DOpt.IsShowFull() );

	if( SFX_ITEM_SET == rSet.GetItemState(SID_ATTR_BUTTON_OUTSTYLE3D, FALSE, &pItem) )
		aStyleCB.Check( !((SfxBoolItem*)pItem)->GetValue() );

	if( SFX_ITEM_SET == rSet.GetItemState(SID_ATTR_BUTTON_BIGSIZE, FALSE, &pItem) )
		aBigCB.Check( ((SfxBoolItem*)pItem)->GetValue() );

	// Look & Feel
	if ( SFX_ITEM_SET ==
		 rSet.GetItemState( SID_OPT_SYSTEMLOOK, FALSE, &pItem ) )
	{
		SystemLook eLook = (SystemLook)((const SfxUInt16Item*)pItem)->GetValue();
		USHORT nPos;

		switch (eLook)
		{
			case LookMacintosh:		nPos = 1;	break;
			case LookMotif:			nPos = 2;	break;
			case LookOSTwo:			nPos = 3;	break;
			case LookStardivision:
			default:				nPos = 0;	break;
		}
		aAppearanceLB.SelectEntryPos(nPos);
	}
	aAppearanceLB.SaveValue();

	// Screen Scaling
	if ( SFX_ITEM_SET ==
		 rSet.GetItemState( SID_OPT_SCREENSCALING, FALSE, &pItem ) )
	{
		UINT16 nScaleFactor = (UINT16)((const SfxUInt16Item*)pItem )->GetValue();
		aScalingMF.SetValue ( nScaleFactor );
	}
	aScalingMF.SaveValue();

	// Mouse Snap
	if ( SFX_ITEM_SET ==
		 rSet.GetItemState( SID_OPT_SNAPTYPE, FALSE, &pItem ) )
	{
        short nSnap = (SnapType)((const SfxInt16Item*)pItem )->GetValue();
        aMousePosLB.SelectEntryPos(nSnap);
	}
	aMousePosLB.SaveValue();

    // Mouse Snap
	if ( SFX_ITEM_SET ==
         rSet.GetItemState( SID_OPT_MIDDLE_MOUSE, FALSE, &pItem ) )
	{
        short nMiddle = ((const SfxInt16Item*)pItem )->GetValue();
        aMouseMiddleLB.SelectEntryPos(nMiddle);
	}
    aMouseMiddleLB.SaveValue();

#if defined( UNX ) || defined ( FS_PRIV_DEBUG )
	if( SFX_ITEM_SET == rSet.GetItemState( SID_OPT_FONT_ANTIALIASING_ENABLED, FALSE, &pItem ) )
		aFontAntiAliasing.Check( static_cast< const SfxBoolItem* >( pItem )->GetValue() );

	if( SFX_ITEM_SET == rSet.GetItemState( SID_OPT_FONT_ANTIALIASING_MINPIXELS, FALSE, &pItem ) )
		aAAPointLimit.SetValue( static_cast< const SfxUInt16Item* >( pItem )->GetValue() );
#endif

	if(SFX_ITEM_SET == rSet.GetItemState(SID_APPEAR_MENUE_MOUSE_FOLLOW, FALSE, &pItem))
		aMouseFollowCB.Check( ((const SfxBoolItem*)pItem)->GetValue() );

	if(SFX_ITEM_SET == rSet.GetItemState(SID_APPEAR_SINGLE_LINE_TABCTRL, FALSE, &pItem))
		aFlatTabCtrlCB.Check( ((const SfxBoolItem*)pItem)->GetValue() );

	if(SFX_ITEM_SET == rSet.GetItemState(SID_APPEAR_COLORED_TABCTRL, FALSE, &pItem))
		aColorTabCtrlCB.Check(((const SfxBoolItem*)pItem)->GetValue() );

    // WorkingSet
    USHORT nWhich = GetWhich( SID_ATTR_SAVEDOCVIEW );

	if ( SFX_ITEM_SET == rSet.GetItemState( nWhich, FALSE, &pItem ) )
		aDocViewBtn.Check( ( (const SfxBoolItem*)pItem )->GetValue() );

	nWhich = GetWhich( SID_ATTR_SAVEDOCWINS );

	if ( SFX_ITEM_SET == rSet.GetItemState( nWhich, FALSE, &pItem ) )
		aOpenWinBtn.Check( ( (const SfxBoolItem*)pItem )->GetValue() );


    SvtFontOptions aFontOpt;
	aFontShowCB.Check( aFontOpt.IsFontWYSIWYGEnabled() );
    SvtMenuOptions aMenuOpt;
    aShowInactiveItemsCB.Check( aMenuOpt.IsEntryHidingEnabled() );
    aMenuIconsCB.Check(aMenuOpt.IsMenuIconsEnabled());
    aMenuIconsCB.SaveValue();

    aFontHistoryCB.Check( aFontOpt.IsFontHistoryEnabled() );

#if defined( UNX ) || defined ( FS_PRIV_DEBUG )
	aFontAntiAliasing.SaveValue();
	aAAPointLimit.SaveValue();
#endif
	aMouseFollowCB.SaveValue();
	aFlatTabCtrlCB.SaveValue();
	aColorTabCtrlCB.SaveValue();
	aFontShowCB.SaveValue();
	aShowInactiveItemsCB.SaveValue();
	aFontHistoryCB.SaveValue();
    aDocViewBtn.SaveValue();
	aOpenWinBtn.SaveValue();

#if defined( UNX ) || defined ( FS_PRIV_DEBUG )
	LINK( this, OfaViewTabPage, OnAntialiasingToggled ).Call( NULL );
#endif
}
/* -----------------------------23.11.00 14:55--------------------------------

 ---------------------------------------------------------------------------*/
class LangConfigItem_Impl : public ConfigItem
{
	Any 		aValue;
	OUString	aPropertyName;
public:
	LangConfigItem_Impl(const OUString& rTree, const OUString& rProperty);
	~LangConfigItem_Impl();

	virtual void			Commit();

	const Any& 	GetValue() const {return aValue;}
	void 		SetValue(Any& rValue)  {aValue = rValue; SetModified();}
};
/* -----------------------------23.11.00 15:06--------------------------------

 ---------------------------------------------------------------------------*/
LangConfigItem_Impl::LangConfigItem_Impl(
	const OUString& rTree, const OUString& rProperty) :
	ConfigItem(rTree),
	aPropertyName(rProperty)
{
	Sequence<OUString> aNames(1);
	aNames.getArray()[0] = aPropertyName;
	Sequence<Any> aValues = GetProperties(aNames);
	aValue = aValues.getConstArray()[0];
}
/* -----------------------------23.11.00 15:06--------------------------------

 ---------------------------------------------------------------------------*/
LangConfigItem_Impl::~LangConfigItem_Impl()
{}
/* -----------------------------23.11.00 15:10--------------------------------

 ---------------------------------------------------------------------------*/
void LangConfigItem_Impl::Commit()
{
	Sequence<OUString> aNames(1);
	aNames.getArray()[0] = aPropertyName;
	Sequence<Any> aValues(1);
	aValues.getArray()[0] = aValue;
	PutProperties(aNames, aValues);
}
/* -----------------------------23.11.00 14:47--------------------------------

 ---------------------------------------------------------------------------*/
/*class LanguageConfig_Impl
{
	LangConfigItem_Impl	aSetup;
    LangConfigItem_Impl aProfile;
public:
	LanguageConfig_Impl();
	~LanguageConfig_Impl();

	Sequence<OUString>	GetInstalledLanguages();
	OUString			GetCurrentLanguage();
	void				SetCurrentLanguage(const OUString& rSet);

};
/* -----------------------------23.11.00 14:53--------------------------------

 ---------------------------------------------------------------------------*/
/*LanguageConfig_Impl::LanguageConfig_Impl() :
	aSetup(C2U("Setup/Office"), C2U("Locales")),
	aProfile(C2U("UserProfile/International"), C2U("Locale"))
{
}
/* -----------------------------23.11.00 14:53--------------------------------

 ---------------------------------------------------------------------------*/
/*LanguageConfig_Impl::~LanguageConfig_Impl()
{
	if(aProfile.IsModified())
		aProfile.Commit();
}
/* -----------------------------23.11.00 15:12--------------------------------

 ---------------------------------------------------------------------------*/
/*Sequence<OUString>  LanguageConfig_Impl::GetInstalledLanguages()
{
	Sequence<OUString> aRet;
	aSetup.GetValue() >>= aRet;
	return aRet;
}
/* -----------------------------23.11.00 15:12--------------------------------

 ---------------------------------------------------------------------------*/
/*OUString LanguageConfig_Impl::GetCurrentLanguage()
{
	OUString sRet;
	aProfile.GetValue() >>= sRet;
	return sRet;
}
/* -----------------------------23.11.00 15:12--------------------------------

 ---------------------------------------------------------------------------*/
/*void LanguageConfig_Impl::SetCurrentLanguage(const OUString& rSet)
{
	Any aSet;
	aSet <<= rSet;
	aProfile.SetValue(aSet);
}
/* -----------------------------23.11.00 13:06--------------------------------

 ---------------------------------------------------------------------------*/
static sal_Bool bLanguageCurrentDoc_Impl = sal_False;
OfaLanguagesTabPage::OfaLanguagesTabPage( Window* pParent, const SfxItemSet& rSet ) :
	SfxTabPage( pParent, OffResId( OFA_TP_LANGUAGES ), rSet ),
	aUILanguageGB(this, 		ResId(GB_UI_LANG		)),
//    aUILanguageFT(this,         ResId(FT_UI_LANG        )),
//    aUILanguageLB(this,         ResId(LB_UI_LANG        )),
    aLocaleSettingFT(this,      ResId(FT_LOCALESETTING)),
    aLocaleSettingLB(this,      ResId(LB_LOCALESETTING)),
    aCurrencyFT( this,          ResId(FT_CURRENCY       )),
    aCurrencyLB( this,          ResId(LB_CURRENCY       )),
	aLinguLanguageGB(this, 		ResId(GB_LINGU_LANG		)),
	aWesternLanguageFT(this, 	ResId(FT_WEST_LANG		)),
	aWesternLanguageLB(this, 	ResId(LB_WEST_LANG		)),
	aAsianLanguageFT(this, 		ResId(FT_ASIAN_LANG		)),
	aAsianLanguageLB(this, 		ResId(LB_ASIAN_LANG		)),
	aComplexLanguageFT(this, 	ResId(FT_COMPLEX_LANG	)),
	aComplexLanguageLB(this, 	ResId(LB_COMPLEX_LANG	)),
	aCurrentDocCB(this, 		ResId(CB_CURRENT_DOC	)),
    aAsianSupportFL(this,       ResId(FL_ASIANSUPPORT    )),
    aAsianSupportCB(this,       ResId(CB_ASIANSUPPORT   ))//,
//    pLangConfig(new LanguageConfig_Impl)
{
	FreeResource();

    aWesternLanguageLB.SetLanguageList( LANG_LIST_WESTERN, TRUE, FALSE, TRUE );
    aAsianLanguageLB  .SetLanguageList( LANG_LIST_CJK,     TRUE, FALSE, TRUE );
    aComplexLanguageLB.SetLanguageList( LANG_LIST_CTL,     TRUE, FALSE, TRUE );
    aLocaleSettingLB.SetLanguageList( LANG_LIST_ALL | LANG_LIST_ONLY_KNOWN, FALSE, FALSE, FALSE);
    aLocaleSettingLB.InsertLanguage( LANGUAGE_SYSTEM );

    SvxLanguageTable* pLanguageTable = new SvxLanguageTable;
    // insert SYSTEM entry, no specific currency
    String aStr( pLanguageTable->GetString( LANGUAGE_SYSTEM ) );
    aCurrencyLB.InsertEntry( aStr );
    // all currencies
    String aTwoSpace( RTL_CONSTASCII_USTRINGPARAM( "  " ) );
    const NfCurrencyTable& rCurrTab = SvNumberFormatter::GetTheCurrencyTable();
    USHORT nCurrCount = rCurrTab.Count();
    // first entry is SYSTEM, skip it
    for ( USHORT j=1; j < nCurrCount; ++j )
    {
        const NfCurrencyEntry* pCurr = rCurrTab[j];
        String aStr( pCurr->GetBankSymbol() );
        aStr += aTwoSpace;
        aStr += pCurr->GetSymbol();
        aStr += aTwoSpace;
        aStr += pLanguageTable->GetString( pCurr->GetLanguage() );
        USHORT nPos = aCurrencyLB.InsertEntry( aStr );
        aCurrencyLB.SetEntryData( nPos, (void*) pCurr );
    }
    delete pLanguageTable;

    aLocaleSettingLB.SetSelectHdl( LINK( this, OfaLanguagesTabPage, LocaleSettingHdl ) );
    aAsianSupportCB.SetClickHdl(LINK(this, OfaLanguagesTabPage, AsianSupportHdl));

    SvtCJKOptions aCJKOptions;
    aAsianSupportCB.Check(aCJKOptions.IsAnyEnabled());
    aAsianSupportCB.SaveValue();
    AsianSupportHdl(0);
}
/*-- 23.11.00 13:06:40---------------------------------------------------

  -----------------------------------------------------------------------*/
OfaLanguagesTabPage::~OfaLanguagesTabPage()
{
//    delete pLangConfig;
}
/*-- 23.11.00 13:06:40---------------------------------------------------

  -----------------------------------------------------------------------*/
SfxTabPage*	OfaLanguagesTabPage::Create( Window* pParent, const SfxItemSet& rAttrSet )
{
	return new OfaLanguagesTabPage(pParent, rAttrSet);
}
/*-- 23.11.00 13:06:41---------------------------------------------------

  -----------------------------------------------------------------------*/
LanguageType lcl_LangStringToLangType(const OUString& rLang)
{
	Locale aLocale;
	aLocale.Language = rLang.copy(0, 2);
	if(rLang.getLength() >= 5)
		aLocale.Country = rLang.copy(3, 2);
	LanguageType eLangType = SvxLocaleToLanguage( aLocale );
	return eLangType;
}

/*-----------------12.02.01 09:01-------------------
 *
 * --------------------------------------------------*/
void lcl_LanguageToLocale( Locale& rLocale, const LanguageType eLang )
{
	OUString aEmpty;
	SvxLanguageToLocale( rLocale, eLang );
	switch ( eLang )
	{
		case LANGUAGE_FRENCH :
		case LANGUAGE_GERMAN :
		case LANGUAGE_ITALIAN :
		case LANGUAGE_DUTCH :
		case LANGUAGE_SPANISH :
		case LANGUAGE_PORTUGUESE :
		case LANGUAGE_DANISH :
		case LANGUAGE_GREEK :
		case LANGUAGE_JAPANESE :
		case LANGUAGE_KOREAN :
		case LANGUAGE_SWEDISH :
		case LANGUAGE_RUSSIAN :
		case LANGUAGE_POLISH :
		case LANGUAGE_TURKISH :
			rLocale.Country = aEmpty;
			break;
	}

}
/*-- 23.11.00 13:06:40---------------------------------------------------

  -----------------------------------------------------------------------*/
BOOL OfaLanguagesTabPage::FillItemSet( SfxItemSet& rSet )
{
    SvtSysLocaleOptions aSysLocaleOptions;
    aSysLocaleOptions.BlockBroadcasts( TRUE );

	// user interface language
//    OUString sLang = pLangConfig->GetCurrentLanguage();
//    LanguageType eOldLang = lcl_LangStringToLangType( sLang );
//    LanguageType eUILang = aUILanguageLB.GetSelectLanguage();
//    if ( eOldLang != eUILang )
//    {
//        Locale aLocale;
//        // DO use lcl_LanguageToLocale() for country independence
//        lcl_LanguageToLocale( aLocale, eUILang );
//        OUString sNewLang = aLocale.Language;
//        if ( aLocale.Country.getLength() > 0 )
//        {
//            sNewLang += C2U("-");
//            sNewLang += aLocale.Country;
//        }
//        if ( sNewLang.getLength() > 1 )
//            pLangConfig->SetCurrentLanguage( sNewLang );
//    }

    OUString sLang = aSysLocaleOptions.GetLocaleConfigString();
    LanguageType eOldLocale = (sLang.getLength() ?
        lcl_LangStringToLangType( sLang ) : LANGUAGE_SYSTEM);
    LanguageType eNewLocale = aLocaleSettingLB.GetSelectLanguage();
    if ( eOldLocale != eNewLocale )
	{
        // an empty string denotes SYSTEM locale
        OUString sNewLang;
        if ( eNewLocale != LANGUAGE_SYSTEM )
        {
            Locale aLocale;
            // Do NOT use lcl_LanguageToLocale() or locale won't match I18N
            SvxLanguageToLocale( aLocale, eNewLocale );
            sNewLang = aLocale.Language;
            if ( aLocale.Country.getLength() > 0 )
            {
                sNewLang += C2U("-");
                sNewLang += aLocale.Country;
            }
        }
        // Set application settings before options, so listeners at the
        // options will access the new locale.
        AllSettings aSettings( Application::GetSettings() );
        aSettings.SetLanguage( eNewLocale );
        Application::SetSettings( aSettings );
        aSysLocaleOptions.SetLocaleConfigString( sNewLang );
        rSet.Put( SfxBoolItem( SID_OPT_LOCALE_CHANGED, TRUE ) );
	}

    // Configured currency, for example, USD-en-US or EUR-de-DE, or empty for
    // locale default. This must be set _after_ the locale above in order to
    // have a valid locale for broadcasting the currency change.
    OUString sOldCurr = aSysLocaleOptions.GetCurrencyConfigString();
    USHORT nCurrPos = aCurrencyLB.GetSelectEntryPos();
    const NfCurrencyEntry* pCurr = (const NfCurrencyEntry*)
        aCurrencyLB.GetEntryData( nCurrPos );
    OUString sNewCurr;
    if ( pCurr )
        sNewCurr = SvtSysLocaleOptions::CreateCurrencyConfigString(
            pCurr->GetBankSymbol(), pCurr->GetLanguage() );
    if ( sOldCurr != sNewCurr )
        aSysLocaleOptions.SetCurrencyConfigString( sNewCurr );

    BOOL bRet = FALSE;
	SfxObjectShell* pCurrentDocShell = SfxObjectShell::Current();
	Reference< XPropertySet > xLinguProp( LinguMgr::GetLinguPropertySet(), UNO_QUERY );
	SvtLinguConfig	aLinguCfg;
	BOOL bCurrentDocCBChecked = aCurrentDocCB.IsChecked();
    if(aCurrentDocCB.IsEnabled())
        bLanguageCurrentDoc_Impl = bCurrentDocCBChecked;
	BOOL bCurrentDocCBChanged = bCurrentDocCBChecked != aCurrentDocCB.GetSavedValue();

	BOOL bValChanged = aWesternLanguageLB.GetSavedValue() != aWesternLanguageLB.GetSelectEntryPos();
	if( (bCurrentDocCBChanged && !bCurrentDocCBChecked) || bValChanged)
	{
		LanguageType eSelectLang = aWesternLanguageLB.GetSelectLanguage();
		if(!bCurrentDocCBChecked)
		{
			Any aValue;
			Locale aLocale = SvxCreateLocale( eSelectLang );
			aValue <<= aLocale;
			OUString aPropName( C2U("DefaultLocale") );
			aLinguCfg.SetProperty( aPropName, aValue );
			if (xLinguProp.is())
				xLinguProp->setPropertyValue( aPropName, aValue );
		}
		if(pCurrentDocShell)
		{
			rSet.Put(SvxLanguageItem(eSelectLang, SID_ATTR_LANGUAGE));
			bRet = TRUE;
		}
	}
	bValChanged = aAsianLanguageLB.GetSavedValue() != aAsianLanguageLB.GetSelectEntryPos();
	if( (bCurrentDocCBChanged && !bCurrentDocCBChecked) || bValChanged)
	{
		LanguageType eSelectLang = aAsianLanguageLB.GetSelectLanguage();
		if(!bCurrentDocCBChecked)
		{
			Any aValue;
			Locale aLocale = SvxCreateLocale( eSelectLang );
			aValue <<= aLocale;
			OUString aPropName( C2U("DefaultLocale_CJK") );
			aLinguCfg.SetProperty( aPropName, aValue );
			if (xLinguProp.is())
				xLinguProp->setPropertyValue( aPropName, aValue );
		}
		if(pCurrentDocShell)
		{
			rSet.Put(SvxLanguageItem(eSelectLang, SID_ATTR_CHAR_CJK_LANGUAGE));
			bRet = TRUE;
		}
	}
	bValChanged = aComplexLanguageLB.GetSavedValue() != aComplexLanguageLB.GetSelectEntryPos();
	if( (bCurrentDocCBChanged && !bCurrentDocCBChecked) || bValChanged)
	{
		LanguageType eSelectLang = aComplexLanguageLB.GetSelectLanguage();
		if(!bCurrentDocCBChecked)
		{
			Any aValue;
			Locale aLocale = SvxCreateLocale( eSelectLang );
			aValue <<= aLocale;
			OUString aPropName( C2U("DefaultLocale_CTL") );
			aLinguCfg.SetProperty( aPropName, aValue );
			if (xLinguProp.is())
				xLinguProp->setPropertyValue( aPropName, aValue );
		}
		if(pCurrentDocShell)
		{
			rSet.Put(SvxLanguageItem(eSelectLang, SID_ATTR_CHAR_CTL_LANGUAGE));
			bRet = TRUE;
		}
	}
    if(aAsianSupportCB.GetSavedValue() != aAsianSupportCB.IsChecked())
    {
        SvtCJKOptions aCJKOptions;
        sal_Bool bChecked = aAsianSupportCB.IsChecked();
        aCJKOptions.SetAll(bChecked);
        //iterate over all bindings to invalidate vertical text direction
#define STATE_COUNT 4
        SfxBoolItem* pBoolItems[STATE_COUNT];
        pBoolItems[0] = new SfxBoolItem(SID_TEXTDIRECTION_TOP_TO_BOTTOM, FALSE);
        pBoolItems[1] = new SfxBoolItem(SID_DRAW_CAPTION_VERTICAL, FALSE);
        pBoolItems[2] = new SfxBoolItem(SID_DRAW_TEXT_VERTICAL, FALSE);
        pBoolItems[3] = new SfxBoolItem(SID_TEXT_FITTOSIZE_VERTICAL, FALSE);

        SfxVoidItem* pInvalidItems[STATE_COUNT];
        pInvalidItems[0] = new SfxVoidItem(SID_TEXTDIRECTION_TOP_TO_BOTTOM);
        pInvalidItems[1] = new SfxVoidItem(SID_DRAW_CAPTION_VERTICAL);
        pInvalidItems[2] = new SfxVoidItem(SID_DRAW_TEXT_VERTICAL);
        pInvalidItems[3] = new SfxVoidItem(SID_TEXT_FITTOSIZE_VERTICAL);

        SfxViewFrame* pCurrentFrm = SfxViewFrame::Current();
        SfxViewFrame* pViewFrm = SfxViewFrame::GetFirst();
        while(pViewFrm)
        {
            SfxBindings& rBind = pViewFrm->GetBindings();
            for(sal_Int16 i = 0; i < STATE_COUNT; i++)
            {
                if(pCurrentFrm == pViewFrm)
                    rBind.InvalidateAll(sal_False);
                rBind.SetState( *pInvalidItems[i] );
                rBind.SetState( *pBoolItems[i] );
            }
            pViewFrm = SfxViewFrame::GetNext(*pViewFrm);
        }
        for(sal_Int16 i = 0; i < STATE_COUNT; i++)
        {
            delete pInvalidItems[i];
            delete pBoolItems[i] ;
        }
    }

    if ( aSysLocaleOptions.IsModified() )
        aSysLocaleOptions.Commit();
    aSysLocaleOptions.BlockBroadcasts( FALSE );

	return FALSE;
}
//-----------------------------------------------------------------------------
void OfaLanguagesTabPage::Reset( const SfxItemSet& rSet )
{
    SvtSysLocaleOptions aSysLocaleOptions;

	//user interface languages
//    Sequence <OUString> aLangs = pLangConfig->GetInstalledLanguages();
//    const OUString* pLangs = aLangs.getConstArray();
//    aUILanguageLB.Clear();
//    for(int i = 0; i < aLangs.getLength(); i++)
//    {
//        if(pLangs[i].getLength() >= 2)
//            aUILanguageLB.InsertLanguage( lcl_LangStringToLangType(pLangs[i]) );
//    }
//    OUString sLang =  pLangConfig->GetCurrentLanguage();
//    aUILanguageLB.SelectLanguage(lcl_LangStringToLangType(sLang));

    OUString sLang = aSysLocaleOptions.GetLocaleConfigString();
    if ( sLang.getLength() )
        aLocaleSettingLB.SelectLanguage(lcl_LangStringToLangType(sLang));
    else
        aLocaleSettingLB.SelectLanguage( LANGUAGE_SYSTEM );

    // configured currency, for example, USD-en-US or EUR-de-DE, or empty for locale default
    String aAbbrev;
    LanguageType eLang;
    const NfCurrencyEntry* pCurr = NULL;
    sLang = aSysLocaleOptions.GetCurrencyConfigString();
    if ( sLang.getLength() )
    {
        SvtSysLocaleOptions::GetCurrencyAbbrevAndLanguage( aAbbrev, eLang, sLang );
        pCurr = SvNumberFormatter::GetCurrencyEntry( aAbbrev, eLang );
    }
    // if pCurr==NULL the SYSTEM entry is selected
    USHORT nPos = aCurrencyLB.GetEntryPos( (void*) pCurr );
    aCurrencyLB.SelectEntryPos( nPos );

	//western/CJK/CLK language
	LanguageType eCurLang = LANGUAGE_NONE;
	LanguageType eCurLangCJK = LANGUAGE_NONE;
	LanguageType eCurLangCTL = LANGUAGE_NONE;
	SfxObjectShell* pCurrentDocShell = SfxObjectShell::Current();
	if(!pCurrentDocShell)
	{
		aCurrentDocCB.Enable(FALSE);
		//
		SvtLinguConfig	aLinguCfg;
		Any aWestLang;
		Any aCJKLang;
		Any aCTLLang;
		try
		{
			aWestLang = aLinguCfg.GetProperty(C2U("DefaultLocale"));
			Locale aLocale;
			aWestLang >>= aLocale;
			eCurLang = SvxLocaleToLanguage( aLocale );
			aCJKLang = aLinguCfg.GetProperty(C2U("DefaultLocale_CJK"));
			aCJKLang >>= aLocale;
			eCurLangCJK = SvxLocaleToLanguage( aLocale );
			aCTLLang = aLinguCfg.GetProperty(C2U("DefaultLocale_CTL"));
			aCTLLang >>= aLocale;
			eCurLangCTL = SvxLocaleToLanguage( aLocale );
		}
		catch(Exception&)
		{
		}

	}
	else
	{
        aCurrentDocCB.Check(bLanguageCurrentDoc_Impl);
		const SfxPoolItem* pLang;
		if( SFX_ITEM_SET == rSet.GetItemState(SID_ATTR_LANGUAGE, FALSE, &pLang))
			eCurLang = ((const SvxLanguageItem*)pLang)->GetValue();

		if( SFX_ITEM_SET == rSet.GetItemState(SID_ATTR_CHAR_CJK_LANGUAGE, FALSE, &pLang))
			eCurLangCJK = ((const SvxLanguageItem*)pLang)->GetValue();

		if( SFX_ITEM_SET == rSet.GetItemState(SID_ATTR_CHAR_CTL_LANGUAGE, FALSE, &pLang))
			eCurLangCTL = ((const SvxLanguageItem*)pLang)->GetValue();
	}
    if(LANGUAGE_NONE == eCurLang || LANGUAGE_DONTKNOW == eCurLang)
        aWesternLanguageLB.SelectLanguage(LANGUAGE_NONE);
	else
		aWesternLanguageLB.SelectLanguage(eCurLang);

    if(LANGUAGE_NONE == eCurLangCJK || LANGUAGE_DONTKNOW == eCurLangCJK)
        aAsianLanguageLB.SelectLanguage(LANGUAGE_NONE);
	else
		aAsianLanguageLB.SelectLanguage(eCurLangCJK);

    if(LANGUAGE_NONE == eCurLangCTL || LANGUAGE_DONTKNOW == eCurLangCTL)
        aComplexLanguageLB.SelectLanguage(LANGUAGE_NONE);
	else
		aComplexLanguageLB.SelectLanguage(eCurLangCTL);
	aWesternLanguageLB.SaveValue();
	aAsianLanguageLB.SaveValue();
	aComplexLanguageLB.SaveValue();
	aCurrentDocCB.SaveValue();
}
/* -----------------------------20.04.01 15:09--------------------------------

 ---------------------------------------------------------------------------*/
IMPL_LINK(  OfaLanguagesTabPage, AsianSupportHdl, CheckBox*, pBox )
{
    sal_Bool bCheck = aAsianSupportCB.IsChecked();
    aAsianLanguageFT.Enable(bCheck);
    aAsianLanguageLB.Enable(bCheck);
    aComplexLanguageFT.Enable(bCheck);
    aComplexLanguageLB.Enable(bCheck);
    return 0;
}


/* -----------------08.06.01 17:56-------------------

 --------------------------------------------------*/
IMPL_LINK( OfaLanguagesTabPage, LocaleSettingHdl, SvxLanguageBox*, pBox )
{
    LanguageType eLang = pBox->GetSelectLanguage();
    USHORT nPos;
    if ( eLang == LANGUAGE_SYSTEM )
        nPos = aCurrencyLB.GetEntryPos( (void*) NULL );
    else
    {
        const NfCurrencyEntry* pCurr = &SvNumberFormatter::GetCurrencyEntry( eLang );
        nPos = aCurrencyLB.GetEntryPos( (void*) pCurr );
    }
    aCurrencyLB.SelectEntryPos( nPos );
    return 0;
}
/* -----------------------------21.06.01 09:33--------------------------------

 ---------------------------------------------------------------------------*/
#ifdef HELPER_PAGE_COMPLETE
class OfaHelperProgramsCfg_Impl : public utl::ConfigItem
{
    friend class OfaHelperProgramsTabPage;
    OUString sHttp;
    OUString sHttps;
    OUString sFtp;
    OUString sFile;
    OUString sMailto;

    const Sequence<OUString> GetPropertyNames();
public:
    OfaHelperProgramsCfg_Impl();
    virtual ~OfaHelperProgramsCfg_Impl();

	virtual void	Commit();

};
#endif
/* -----------------------------21.06.01 09:41--------------------------------

 ---------------------------------------------------------------------------*/
#ifdef HELPER_PAGE_COMPLETE
OfaHelperProgramsCfg_Impl::OfaHelperProgramsCfg_Impl() :
        ConfigItem(C2U("Office.Common/ExternalApps"))
{
    const Sequence<Any> aValues = GetProperties(GetPropertyNames());
    const Any* pValues = aValues.getConstArray();
    for(sal_Int32 nProp = 0; nProp < aValues.getLength(); nProp++)
    {
        switch(nProp)
        {
            case 0 : pValues[nProp] >>= sHttp; break;//http
            case 1 : pValues[nProp] >>= sHttps;break;//https
            case 2 : pValues[nProp] >>= sFtp;  break;//ftp
            case 3 : pValues[nProp] >>= sFile; break;//file
            case 4 : pValues[nProp] >>= sMailto;break;//mailto
        }
    }
}
/* -----------------------------21.06.01 09:39--------------------------------

 ---------------------------------------------------------------------------*/
OfaHelperProgramsCfg_Impl::~OfaHelperProgramsCfg_Impl()
{}
/* -----------------------------21.06.01 09:38--------------------------------

 ---------------------------------------------------------------------------*/
const Sequence<OUString> OfaHelperProgramsCfg_Impl::GetPropertyNames()
{
    Sequence<OUString> aRet(5);
    OUString* pRet = aRet.getArray();
    pRet[0] = C2U("http");
    pRet[1] = C2U("https");
    pRet[2] = C2U("ftp");
    pRet[3] = C2U("file");
    pRet[4] = C2U("mailto");
    return aRet;
}
/* -----------------------------21.06.01 09:45--------------------------------

 ---------------------------------------------------------------------------*/
void    OfaHelperProgramsCfg_Impl::Commit()
{
    const Sequence<OUString> aNames = GetPropertyNames();
    const OUString* pNames = aNames.getConstArray();
	Sequence<Any> aValues(aNames.getLength());
	Any* pValues = aValues.getArray();
	for(int nProp = 0; nProp < aNames.getLength(); nProp++)
	{
		switch(nProp)
		{
            case  0: pValues[nProp] <<= sHttp; break;//http
            case  1: pValues[nProp] <<= sHttps;break;//https
            case  2: pValues[nProp] <<= sFtp;  break;//ftp
            case  3: pValues[nProp] <<= sFile; break;//file
            case  4: pValues[nProp] <<= sMailto;break;//mailto
        }
	}
	PutProperties(aNames, aValues);
}
#endif //HELPER_PAGE_COMPLETE
/* -----------------------------22.06.01 11:47--------------------------------

 ---------------------------------------------------------------------------*/
class OfaMailProfilesCfg_Impl : public utl::ConfigItem
{
    friend class OfaHelperProgramsTabPage;
    Sequence<OUString> aProfiles;
    OUString sCommandProfile;
    OUString sProgram;
    sal_Bool bUseDefaultMailer;

    const Sequence<OUString> GetPropertyNames();
public:
    OfaMailProfilesCfg_Impl();
    virtual ~OfaMailProfilesCfg_Impl();

	virtual void	Commit();

};
/* -----------------------------22.06.01 11:49--------------------------------

 ---------------------------------------------------------------------------*/
OfaMailProfilesCfg_Impl::OfaMailProfilesCfg_Impl() :
    utl::ConfigItem(C2U("Office.Common/ExternalMailer")),
#ifdef HELPER_PAGE_COMPLETE
    bUseDefaultMailer(sal_False)
#else
    bUseDefaultMailer(sal_True)
#endif
{
    const Sequence<Any> aValues = GetProperties(GetPropertyNames());
    const Any* pValues = aValues.getConstArray();
    for(sal_Int32 nProp = 0; nProp < aValues.getLength(); nProp++)
    {
        if(pValues[nProp].hasValue())
        {
            switch(nProp)
            {
                case 0 : pValues[nProp] >>= sCommandProfile; break;//
                case 1 : pValues[nProp] >>= sProgram;        break;//
                case 2 : bUseDefaultMailer = comphelper::getBOOL(pValues[nProp]); break;
            }
        }
    }
    aProfiles = GetNodeNames(C2U("Profiles"));
}
/* -----------------------------22.06.01 11:50--------------------------------

 ---------------------------------------------------------------------------*/
OfaMailProfilesCfg_Impl::~OfaMailProfilesCfg_Impl()
{
}
/* -----------------------------22.06.01 11:53--------------------------------

 ---------------------------------------------------------------------------*/
const Sequence<OUString> OfaMailProfilesCfg_Impl::GetPropertyNames()
{
    Sequence<OUString> aRet(3);
    OUString* pRet = aRet.getArray();
    pRet[0] = C2U("CommandProfile");
    pRet[1] = C2U("Program");
    pRet[2] = C2U("UseDefaultMailer");
    return aRet;
}
/* -----------------------------22.06.01 11:52--------------------------------

 ---------------------------------------------------------------------------*/
void OfaMailProfilesCfg_Impl::Commit()
{
    const Sequence<OUString> aNames = GetPropertyNames();
    const OUString* pNames = aNames.getConstArray();
	Sequence<Any> aValues(aNames.getLength());
	Any* pValues = aValues.getArray();
	for(int nProp = 0; nProp < aNames.getLength(); nProp++)
	{
		switch(nProp)
		{
            case  0: pValues[nProp] <<= sCommandProfile; break;//
            case  1: pValues[nProp] <<= sProgram;        break;//
            case  2: pValues[nProp] = comphelper::makeBoolAny(bUseDefaultMailer); break;
        }
	}
	PutProperties(aNames, aValues);
}
/* -----------------------------21.06.01 09:33--------------------------------

 ---------------------------------------------------------------------------*/
struct OfaHelperProgramsTabPage_Impl
{
#ifdef HELPER_PAGE_COMPLETE
    OfaHelperProgramsCfg_Impl aAppConfig;
#endif
    OfaMailProfilesCfg_Impl aMailConfig;
};

OfaHelperProgramsTabPage::OfaHelperProgramsTabPage(Window* pParent, const SfxItemSet& rSet) :
    SfxTabPage(pParent, OffResId( OFA_TP_HELPERPROG ), rSet),
    aHelpFI(this,           ResId(FI_HELP           )),
    aMailFL(this,           ResId(FL_MAIL           )),
    aStandardMailCB(this,   ResId(CB_MAILSTANDARD   )),
    aProfileFT(this,        ResId(FT_PROFILE        )),
    aProgramFT(this,        ResId(FT_PROGRAM        )),
    aAdditionalMailFT(this, ResId(FT_ADD_MAIL       )),
    aProfilesLB(this,       ResId(LB_PROFILES       )),
    aMailerURLED(this,      ResId(ED_MAILERURL      )),
    aMailerURLPB(this,      ResId(PB_MAILERURL      )),
#ifdef HELPER_PAGE_COMPLETE
    aLinkFL(this,           ResId(FL_LINK           )),
    aHTTPFT(this,           ResId(FT_HTTP           )),
    aHTTPED(this,           ResId(ED_HTTP           )),
    aHTTPPB(this,           ResId(PB_HTTP           )),
    aHTTPSFT(this,          ResId(FT_HTTPS          )),
    aHTTPSED(this,          ResId(ED_HTTPS          )),
    aHTTPSPB(this,          ResId(PB_HTTPS          )),
    aFTPFT(this,            ResId(FT_FTP            )),
    aFTPED(this,            ResId(ED_FTP            )),
    aFTPPB(this,            ResId(PB_FTP            )),
    aMailerFT(this,         ResId(FT_MAILER         )),
    aMailerED(this,         ResId(ED_MAILER         )),
    aMailerPB(this,         ResId(PB_MAILER         )),
    aDocManagerFL(this,     ResId(FL_DOCMANAGER     )),
    aDocManagerFT(this,     ResId(FT_DOCMANAGER     )),
    aDocManagerED(this,     ResId(ED_DOCMANAGER     )),
    aDocManagerPB(this,     ResId(PB_DOCMANAGER     )),
#endif // HELPER_PAGE_COMPLETE
    pImpl(new OfaHelperProgramsTabPage_Impl)
{
    FreeResource();

    Link aLink(LINK(this, OfaHelperProgramsTabPage, FileDialogHdl_Impl));
    aMailerURLPB.SetClickHdl(aLink);
#ifdef HELPER_PAGE_COMPLETE
    aStandardMailCB.Hide();
    aHTTPPB.SetClickHdl(aLink);
    aHTTPSPB.SetClickHdl(aLink);
    aFTPPB.SetClickHdl(aLink);
    aMailerPB.SetClickHdl(aLink);
    aDocManagerPB.SetClickHdl(aLink);

        long nDiff = aProfileFT.GetPosPixel().Y() - aStandardMailCB.GetPosPixel().Y();

        Window* aCntrlArr[] = {
            &aProfileFT,              &aProgramFT,
            &aAdditionalMailFT,       &aProfilesLB,
            &aMailerURLED,            &aMailerURLPB,
            &aLinkFL,
            &aHTTPFT,                 &aHTTPED,
            &aHTTPPB,                 &aHTTPSFT,
            &aHTTPSED,                &aHTTPSPB,
            &aFTPFT,                  &aFTPED,
            &aFTPPB,                  &aMailerFT,
            &aMailerED,               &aMailerPB,
            &aDocManagerFL,            &aDocManagerFT,
            &aDocManagerED,            &aDocManagerPB,
            0};

        for( Window** ppW = aCntrlArr; *ppW; ++ppW )
		{
			Point aPnt( (*ppW)->GetPosPixel() );
			aPnt.Y() -= nDiff;
			(*ppW)->SetPosPixel( aPnt );
		}
        Point aTmp(aAdditionalMailFT.GetPosPixel());
        aTmp.X() = aHTTPFT.GetPosPixel().X();
        aAdditionalMailFT.SetPosPixel(aTmp);
#endif

    aProfilesLB.SetSelectHdl(LINK(this, OfaHelperProgramsTabPage, ProfileHdl_Impl));
#ifndef HELPER_PAGE_COMPLETE
    aStandardMailCB.SetClickHdl(LINK(this, OfaHelperProgramsTabPage, DefaultMailHdl_Impl));
#endif
}
/* -----------------------------21.06.01 07:46--------------------------------

 ---------------------------------------------------------------------------*/
OfaHelperProgramsTabPage::~OfaHelperProgramsTabPage()
{
    delete pImpl;
}
/* -----------------------------21.06.01 07:46--------------------------------

 ---------------------------------------------------------------------------*/
SfxTabPage*  OfaHelperProgramsTabPage::Create( Window* pParent, const SfxItemSet& rAttrSet )
{
    return new OfaHelperProgramsTabPage(pParent, rAttrSet);
}
/* -----------------------------21.06.01 07:46--------------------------------

 ---------------------------------------------------------------------------*/
BOOL OfaHelperProgramsTabPage::FillItemSet( SfxItemSet& rSet )
{
    BOOL bMailModified = FALSE;
    if(aMailerURLED.GetSavedValue() != aMailerURLED.GetText())
    {
        pImpl->aMailConfig.sProgram = aMailerURLED.GetText();
        bMailModified = TRUE;
    }
    if(aProfilesLB.GetSelectEntryPos() != aProfilesLB.GetSavedValue())
    {
        pImpl->aMailConfig.sCommandProfile = aProfilesLB.GetSelectEntry();
        bMailModified = TRUE;
    }
#ifndef HELPER_PAGE_COMPLETE
    if(aStandardMailCB.IsChecked() != aStandardMailCB.GetSavedValue())
    {
        pImpl->aMailConfig.bUseDefaultMailer = aStandardMailCB.IsChecked();
        bMailModified = TRUE;
    }
#endif
    if(bMailModified)
        pImpl->aMailConfig.Commit();

#ifdef HELPER_PAGE_COMPLETE
    BOOL bAppModified = FALSE;
    if(aHTTPED.GetSavedValue() != aHTTPED.GetText())
    {
        pImpl->aAppConfig.sHttp = aHTTPED.GetText();
        bAppModified = TRUE;
    }
    if(aHTTPSED.GetSavedValue() != aHTTPSED.GetText())
    {
        pImpl->aAppConfig.sHttps = aHTTPSED.GetText();
        bAppModified = TRUE;
    }
    if(aFTPED.GetSavedValue() != aFTPED.GetText())
    {
        pImpl->aAppConfig.sFtp = aFTPED.GetText();
        bAppModified = TRUE;
    }
    if(aMailerED.GetSavedValue() != aMailerED.GetText())
    {
        pImpl->aAppConfig.sMailto = aMailerED.GetText();
        bAppModified = TRUE;
    }
    if(aDocManagerED.GetSavedValue() != aDocManagerED.GetText())
    {
        pImpl->aAppConfig.sFile = aDocManagerED.GetText();
        bAppModified = TRUE;
    }
    if(bAppModified)
    {
        pImpl->aAppConfig.Commit();
    }
#endif
    return FALSE;
}
/* -----------------------------21.06.01 07:46--------------------------------

 ---------------------------------------------------------------------------*/
void OfaHelperProgramsTabPage::Reset( const SfxItemSet& rSet )
{
    const OUString* pProfiles = pImpl->aMailConfig.aProfiles.getConstArray();
    for(sal_Int32 nProfile = 0; nProfile < pImpl->aMailConfig.aProfiles.getLength(); nProfile++)
        aProfilesLB.InsertEntry(pProfiles[nProfile]);
    aProfilesLB.SelectEntry(pImpl->aMailConfig.sCommandProfile);
    if(LISTBOX_ENTRY_NOTFOUND == aProfilesLB.GetSelectEntryPos())
    {
        aMailerURLED.Enable(FALSE);
        aMailerURLPB.Enable(FALSE);
    }

    aMailerURLED.SetText(pImpl->aMailConfig.sProgram);
    aMailerURLED.SaveValue();
    aProfilesLB.SaveValue();
#ifndef HELPER_PAGE_COMPLETE
    aStandardMailCB.Check(pImpl->aMailConfig.bUseDefaultMailer);
    DefaultMailHdl_Impl(&aStandardMailCB);
    aStandardMailCB.SaveValue();
#endif

#ifdef HELPER_PAGE_COMPLETE
    aHTTPED.SetText(pImpl->aAppConfig.sHttp);
    aHTTPSED.SetText(pImpl->aAppConfig.sHttps);
    aFTPED.SetText(pImpl->aAppConfig.sFtp);
    aMailerED.SetText(pImpl->aAppConfig.sMailto);
    aDocManagerED.SetText(pImpl->aAppConfig.sFile);
    aHTTPED.SaveValue();
    aHTTPSED.SaveValue();
    aFTPED.SaveValue();
    aMailerED.SaveValue();
    aDocManagerED.SaveValue();
#endif
}
/* -----------------------------21.06.01 07:46--------------------------------

 ---------------------------------------------------------------------------*/
IMPL_LINK(  OfaHelperProgramsTabPage, FileDialogHdl_Impl, PushButton*, pButton )
{
    Edit* pEdit = 0;
    if(&aMailerURLPB == pButton)
        pEdit = &aMailerURLED;
#ifdef HELPER_PAGE_COMPLETE
    else if(&aHTTPPB == pButton)
        pEdit = &aHTTPED;
    else if(&aHTTPSPB == pButton)
        pEdit = &aHTTPSED;
    else if(&aFTPPB == pButton)
        pEdit = &aFTPED;
    else if(&aMailerPB == pButton)
        pEdit = &aMailerED;
    else if(&aDocManagerPB == pButton)
        pEdit = &aDocManagerED;
#endif

    FileDialogHelper aHelper( FILEOPEN_SIMPLE, WB_OPEN );
    aHelper.SetDisplayDirectory(pEdit->GetText());
    if(ERRCODE_NONE == aHelper.Execute())
    {
        pEdit->SetText(aHelper.GetPath());
    }
    return 0;
}
/* -----------------------------21.06.01 07:46--------------------------------

 ---------------------------------------------------------------------------*/
IMPL_LINK(  OfaHelperProgramsTabPage, ProfileHdl_Impl, ListBox*, pLB )
{
    aMailerURLED.Enable(TRUE);
    aMailerURLPB.Enable(TRUE);
    return 0;
}
/* -----------------------------21.06.01 07:46--------------------------------

 ---------------------------------------------------------------------------*/
#ifndef HELPER_PAGE_COMPLETE
IMPL_LINK(  OfaHelperProgramsTabPage, DefaultMailHdl_Impl, CheckBox*, pCheckBox )
{
    BOOL bEnable = !pCheckBox->IsChecked();
    aProfileFT.Enable(bEnable);
    aProgramFT.Enable(bEnable);
    aAdditionalMailFT.Enable(bEnable);
    aProfilesLB.Enable(bEnable);
    if(LISTBOX_ENTRY_NOTFOUND == aProfilesLB.GetSelectEntryPos())
        bEnable = FALSE;

    aMailerURLED.Enable(bEnable);
    aMailerURLPB.Enable(bEnable);
    return 0;
}
#endif

