<?xml version="1.0" encoding="utf-8"?>

<!-- ****************************************************************************************** -->
<!-- * Transformation of schema description into configuration schema format (XMLSchema)	*** -->
<!-- ****************************************************************************************** -->
<xsl:transform  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:schema="http://openoffice.org/2000/registry/schema/description"
				xmlns:default="http://openoffice.org/2000/registry/schema/default"
				xmlns:cfg="http://openoffice.org/2000/registry/instance"
				xmlns:xsd="http://www.w3.org/1999/XMLSchema">

<!-- Get the correct format -->
<xsl:output method="xml" indent-result="yes" indent="yes"/>

<!-- Transformation into data and template files -->
<!-- ****************************** -->
<!-- * schema:package			*** -->
<!-- ****************************** -->
	<xsl:template match="/schema:package">
		<xsl:element name="xsd:schema">
			<xsl:attribute name="xsd:targetNamespace" namespace="">http://openoffice.org/2000/registry/components/<xsl:value-of select="@package-id"/></xsl:attribute>
			<xsl:attribute name="xsd:elementFromDefault" namespace="">unqualified</xsl:attribute>
			<xsl:attribute name="xsd:attributeFromDefault" namespace="">unqualified</xsl:attribute>
			<xsl:attribute name="xmlns:cfg" namespace="">http://openoffice.org/2000/registry/instance</xsl:attribute>			
			<xsl:element name="import">
				<xsl:attribute name="namespace" namespace="">http://openoffice.org/2000/registry/instance</xsl:attribute>
				<xsl:attribute name="schemaLocation" namespace="">cfgbase.xsd</xsl:attribute>				
			</xsl:element>
			<xsl:apply-templates select="schema:templates"/>
			<xsl:apply-templates select="schema:component"/>

			<!-- insert the documentation if there is any -->
			<xsl:call-template name="insertDocumentation"/>			            					
		</xsl:element>		
	</xsl:template>

<!-- ****************************** -->
<!-- * schema:templates			*** -->
<!-- ****************************** -->
    <xsl:template match="schema:templates">
        <xsl:apply-templates>
			<xsl:with-param name="isTemplate">true</xsl:with-param>
		</xsl:apply-templates>

	</xsl:template>

<!-- ****************************** -->
<!-- * schema:component				*** -->
<!-- ****************************** -->
	<xsl:template match="schema:component">
        <xsl:element name="xsd:element"> 
			<xsl:attribute name= "name">
				<xsl:value-of select="@component-id"/>
			</xsl:attribute>
			<xsl:element name="xsd:complexType">
				<xsl:apply-templates select="schema:set"/>
				<xsl:apply-templates select="schema:group"/>
				<xsl:apply-templates select="schema:instance"/>				
			</xsl:element>
			
			<!-- insert the documentation if there is any -->
			<xsl:call-template name="insertDocumentation"/>			            					
		</xsl:element>
	</xsl:template>

<!-- ****************************** -->
<!-- * schema:instance			*** -->
<!-- ****************************** -->
	<xsl:template match="schema:instance">					
		<xsl:param name="isTemplate">false</xsl:param>
		<xsl:choose>
			<xsl:when test="$isTemplate='true'">
				<xsl:element name="xsd:complexType">						
					<xsl:attribute name="name"><xsl:value-of select="@cfg:name"/></xsl:attribute>
					<xsl:attribute name="base"><xsl:value-of select="@cfg:instance-of"/></xsl:attribute>
				</xsl:element>
			</xsl:when>
			<xsl:when test="$isTemplate='false'">
				<xsl:element name="xsd:element">					
					<xsl:attribute name="name"><xsl:value-of select="@cfg:name"/></xsl:attribute>					
					<xsl:attribute name="type"><xsl:value-of select="@cfg:instance-of"/></xsl:attribute>					
				</xsl:element>
			</xsl:when>
		</xsl:choose>
		<!-- insert the documentation if there is any -->
		<xsl:call-template name="insertDocumentation"/>			            					
	</xsl:template>


<!-- ****************************** -->
<!-- * schema:set				*** -->
<!-- ****************************** -->
    <xsl:template match="schema:set">		
		<xsl:param name="isTemplate">false</xsl:param>
		<xsl:choose>
			<xsl:when test="$isTemplate='true'">
				<xsl:element name="xsd:complexType">						
					<xsl:attribute name="name" ><xsl:value-of select="@cfg:name"/></xsl:attribute>
					<xsl:attribute name="cfg:type" namespace="">set</xsl:attribute>
					<xsl:attribute name="cfg:element-type" namespace=""><xsl:value-of select="@cfg:element-type"/></xsl:attribute>
					<xsl:call-template name="setContent"/>            
				</xsl:element>
			</xsl:when>
			<xsl:when test="$isTemplate='false'">
				<xsl:element name="xsd:element">					
					<xsl:attribute name="name" ><xsl:value-of select="@cfg:name"/></xsl:attribute>
					<xsl:attribute name="cfg:type" namespace="">set</xsl:attribute>
					<xsl:attribute name="cfg:element-type" namespace=""><xsl:value-of select="@cfg:element-type"/></xsl:attribute>
					<xsl:element name="xsd:complexType">
						<xsl:call-template name="setContent"/>            	
					</xsl:element>
				</xsl:element>
			</xsl:when>
		</xsl:choose>
		
		<!-- insert the documentation if there is any -->
		<xsl:call-template name="insertDocumentation"/>			            					
	</xsl:template>

<!-- ****************************** -->
<!-- * setContent				*** -->
<!-- ****************************** -->
	<xsl:template name="setContent">				
		<xsl:element name="xsd:element">
			<xsl:attribute name ="name" namespace=""><xsl:value-of select="@cfg:element-type"/></xsl:attribute>						
			<xsl:attribute name = "minOccurs">0</xsl:attribute>
			<xsl:attribute name = "maxOccurs">unbounded</xsl:attribute>
			<xsl:element name="xsd:attribute">
				<xsl:attribute name ="ref">cfg:name</xsl:attribute>						
			</xsl:element>							
		</xsl:element>		
	</xsl:template>

<!-- ****************************** -->
<!-- * schema:group				*** -->
<!-- ****************************** -->
	<xsl:template match="schema:group">		
		<xsl:param name="isTemplate">false</xsl:param>
		<xsl:choose>
			<xsl:when test="$isTemplate='true'">
				<xsl:element name="xsd:complexType">						
					<xsl:attribute name="name"><xsl:value-of select="@cfg:name"/></xsl:attribute>
					<xsl:call-template name="groupContent"/>            
				</xsl:element>
			</xsl:when>
			<xsl:when test="$isTemplate='false'">
				<xsl:element name="xsd:element">					
					<xsl:attribute name="name"><xsl:value-of select="@cfg:name"/></xsl:attribute>
					<xsl:element name="xsd:complexType">
						<xsl:call-template name="groupContent"/>            	
					</xsl:element>
				</xsl:element>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

<!-- ****************************** -->
<!-- * groupContent				*** -->
<!-- ****************************** -->
	<xsl:template name="groupContent">						
		<xsl:element name="xsd:all">
			<xsl:apply-templates select="schema:group"/>
			<xsl:apply-templates select="schema:set"/>
			<xsl:apply-templates select="schema:value"/>
			<xsl:apply-templates select="schema:instance"/>			
		</xsl:element>			            
		<xsl:element name="xsd:attributeGroup">
			<xsl:attribute name ="ref">cfg:node-attributes</xsl:attribute>						
		</xsl:element>
		
		<!-- insert the documentation if there is any -->
		<xsl:call-template name="insertDocumentation"/>			            					
	</xsl:template>

<!-- ****************************** -->
<!-- * schema:value				*** -->
<!-- ****************************** -->
	<xsl:template match="schema:value">
		<xsl:param name="isTemplate">false</xsl:param>				
		<xsl:choose>
			<xsl:when test="$isTemplate='true'">
				<xsl:element name="xsd:complexType">						
					<xsl:call-template name="valueContent"/>
				</xsl:element>
			</xsl:when>
			<xsl:when test="$isTemplate='false'">
				<xsl:element name="xsd:element">					
					<xsl:call-template name="valueContent"/>
				</xsl:element>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

<!-- ****************************** -->
<!-- * valueContent				*** -->
<!-- ****************************** -->
	<xsl:template name="valueContent">
		<xsl:attribute name="name"><xsl:value-of select="@cfg:name"/></xsl:attribute>
		<xsl:choose>
			<xsl:when test="@cfg:derivedBy='list'">			
				<xsl:attribute name="xsd:type" namespace="">cfg:<xsl:value-of select="@cfg:type"/>List</xsl:attribute>			
				<xsl:attribute name="cfg:type" namespace=""><xsl:value-of select="@cfg:type"/></xsl:attribute>
				<xsl:attribute name="cfg:derivedBy" namespace="">list</xsl:attribute>							
			</xsl:when>
			<xsl:otherwise>			
				<xsl:attribute name="xsd:type" >cfg:<xsl:value-of select="@cfg:type"/></xsl:attribute>				
				<xsl:attribute name="cfg:type" ><xsl:value-of select="@cfg:type"/></xsl:attribute>
			</xsl:otherwise>			
		</xsl:choose>		
		<!-- insert the documentation if there is any -->
		<xsl:call-template name="insertDocumentation"/>
	</xsl:template>	

<!-- ****************************** -->
<!-- * schema:type-info			*** -->
<!-- ****************************** -->
	<xsl:template match="schema:type-info">
		<xsl:element name="xsd:appInfo">
			<xsl:apply-templates select="schema:description"/>
			<xsl:apply-templates select="schema:unit"/>
			<xsl:apply-templates select="schema:value-names"/>
		</xsl:element>			
	</xsl:template>

<!-- ****************************** -->
<!-- * schema:unit				*** -->
<!-- ****************************** -->
	<xsl:template match="schema:unit">
		<xsl:element name="unit">
			<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>			
			<xsl:apply-templates select="schema:description"/>			
		</xsl:element>			
	</xsl:template>

<!-- ****************************** -->
<!-- * schema:value-names		*** -->
<!-- ****************************** -->
	<xsl:template match="schema:value-names">
		<xsl:element name="value-names">			
			<xsl:apply-templates select="schema:named-value"/>			
		</xsl:element>			
	</xsl:template>

<!-- ****************************** -->
<!-- * schema:named-value		*** -->
<!-- ****************************** -->
	<xsl:template match="schema:named-value">
		<xsl:element name="named-value">
			<xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
			<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
			<xsl:apply-templates select="schema:description"/>			
		</xsl:element>			
	</xsl:template>

<!-- ****************************** -->
<!-- * insertDocumentation		*** -->
<!-- ****************************** -->
	<xsl:template name="insertDocumentation">
		<xsl:if test="child::schema:documentation or child::schema:type-info">			
			<xsl:element name="xsd:annotation">
				<xsl:apply-templates select="schema:documentation"/>
				<xsl:apply-templates select="schema:type-info"/>
			</xsl:element>
		</xsl:if>		
	</xsl:template>		

<!-- ****************************** -->
<!-- * schema:documentation		*** -->
<!-- ****************************** -->
	<xsl:template match="schema:documentation">
		<xsl:apply-templates select="schema:description"/>					
	</xsl:template>

<!-- ****************************** -->
<!-- * schema:description		*** -->
<!-- ****************************** -->
	<xsl:template match="schema:description">
		<xsl:element name="xsd:documentation"><xsl:value-of select="."/></xsl:element>		
	</xsl:template>
</xsl:transform>

