/*************************************************************************
 *
 *  $RCSfile: SWriterDemo.java,v $
 *
 *  $Revision: 1.2.18.1 $
 *
 *  last change: $Author: jsc $ $Date: 2003/02/17 10:18:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.comp.demo;


import com.sun.star.bridge.XUnoUrlResolver;

// base interface
import com.sun.star.uno.XInterface;

// access the implementations via names
import com.sun.star.comp.servicemanager.ServiceManager;


import com.sun.star.lang.XMultiServiceFactory;

import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.uno.XNamingService;
import com.sun.star.lib.uno.helper.WeakBase;

// staroffice interfaces to provide desktop and componentloader
// and components i.e. spreadsheets, writerdocs etc.
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XComponentLoader;

// additional classes required for testcase
import com.sun.star.awt.Size;

import com.sun.star.lang.XComponent;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XTypeProvider;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;

import com.sun.star.container.XIndexAccess;

import com.sun.star.drawing.XShape;

import com.sun.star.text.ControlCharacter;
import com.sun.star.text.TextContentAnchorType;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextFrame;
import com.sun.star.text.XTextTable;

public class SWriterDemo extends WeakBase implements XTypeProvider, XServiceInfo, XInitialization {
	static private final boolean DEBUG = true;

	static final String __serviceName = "com.sun.star.demo.SWriterDemo";

	public static void blabla(XMultiServiceFactory xMSF) throws Exception {
		XTextDocument myDoc = openWriter(xMSF);
    
		//getting the text object
		XText oText = myDoc.getText();
    
		//create a cursor object
		XTextCursor oCursor = oText.createTextCursor();
    
		//inserting some Text
		oText.insertString( oCursor, "The first line in the newly created text document.\n", false );
  
		//inserting a second line
		oText.insertString( oCursor, "Now we're in the second line\n", false );
    
		//inserting a text table
		//getting MSF of the document
		XMultiServiceFactory oDocMSF = (XMultiServiceFactory) UnoRuntime.queryInterface(
            XMultiServiceFactory.class, myDoc );

		//create instance of a text table
    
		Object oInt = oDocMSF.createInstance("com.sun.star.text.TextTable");
		XTextTable TT = (XTextTable) UnoRuntime.queryInterface(XTextTable.class,oInt);
		//initialize the text table with 4 columns an 4 rows
		TT.initialize(4,4);
    
        
		//insert the table
		oText.insertTextContent(oCursor, TT, false); 
		// get first Row
		XIndexAccess theRows = TT.getRows();
		XPropertySet aRow = (XPropertySet) UnoRuntime.queryInterface(
            XPropertySet.class, theRows.getByIndex(0)); 
     
		// get the property set of the text table
		XPropertySet oTPS = (XPropertySet)UnoRuntime.queryInterface( XPropertySet.class, TT );
    
		// Change the BackColor
		oTPS.setPropertyValue("BackTransparent", new Boolean(false));
		oTPS.setPropertyValue("BackColor",new Integer(13421823));
		aRow.setPropertyValue("BackTransparent", new Boolean(false));
		aRow.setPropertyValue("BackColor",new Integer(6710932));
     
		insertIntoCell("A1","FirstColumn", TT); 
		insertIntoCell("B1","SecondColumn", TT) ;
		insertIntoCell("C1","ThirdColumn", TT) ;
		insertIntoCell("D1","SUM", TT) ;
    
		(TT.getCellByName("A2")).setValue(22.5);
		(TT.getCellByName("B2")).setValue(5615.3);
		(TT.getCellByName("C2")).setValue(-2315.7);
		(TT.getCellByName("D2")).setFormula("sum <A2:C2>"); 
    
		(TT.getCellByName("A3")).setValue(21.5);
		(TT.getCellByName("B3")).setValue(615.3);
		(TT.getCellByName("C3")).setValue(-315.7);
		(TT.getCellByName("D3")).setFormula("sum <A3:C3>"); 
           
		(TT.getCellByName("A4")).setValue(121.5);
		(TT.getCellByName("B4")).setValue(-615.3);
		(TT.getCellByName("C4")).setValue(415.7);
		(TT.getCellByName("D4")).setFormula("sum <A4:C4>");     
    
		// get the property set of the cursor
		XPropertySet oCPS = (XPropertySet)UnoRuntime.queryInterface( XPropertySet.class, oCursor );
		Object oldValue = null;
    
		// Change the CharColor and add a Shadow
		try {
			oCPS.setPropertyValue("CharColor",new Integer(255));
			oCPS.setPropertyValue("CharShadowed", new Boolean(true));
		} catch (Exception e) {
			System.out.println("Couldn't change the color " + e);
		}
     
		//create a paragraph break
		try {
    
			oText.insertControlCharacter( oCursor, ControlCharacter.PARAGRAPH_BREAK, false );
      
		} catch (Exception e) {
			System.out.println("Couldn't insert break "+ e);
		} 

    
		//inserting colored Text
		System.out.println("inserting colored Text");
    
		oText.insertString( oCursor, " This is a colored Text - blue with shadow\n", false );     
         
		//create a paragraph break
		try {
    
			oText.insertControlCharacter( oCursor, ControlCharacter.PARAGRAPH_BREAK, false );
      
		} catch (Exception e) {
			System.out.println("Couldn't insert break "+ e);
		} 
      


 
		// Create a TextFrame
    
		XTextFrame TF = null;
		XShape TFS = null;
    
		try {
			oInt = oDocMSF.createInstance("com.sun.star.text.TextFrame");
			TF = (XTextFrame) UnoRuntime.queryInterface(XTextFrame.class,oInt);
			TFS = (XShape) UnoRuntime.queryInterface(XShape.class,oInt);
      
			Size aSize = new Size();
			aSize.Height = 400;
			aSize.Width = 15000;
    
			TFS.setSize(aSize);

		} catch (Exception e) {
			System.out.println("Couldn't create instance "+ e);
		} 
         
         
		// get the property set of the text frame
    
		XPropertySet oTFPS = (XPropertySet)UnoRuntime.queryInterface( XPropertySet.class, TF );
    
		// Change the AnchorType
		try {
    
			oTFPS.setPropertyValue("AnchorType", TextContentAnchorType.AS_CHARACTER);
      
		} catch (Exception e) {
			System.out.println("Couldn't change the color " + e);
		}
              
    
		//insert the frame
		System.out.println("insert the text frame");
    
		try {
			oText.insertTextContent(oCursor, TF, false); 
		} catch (Exception e) {
			System.out.println("Couldn't insert the frame " + e);
		}
 
		//getting the text object of Frame
		XText oTex = TF.getText();
    
		//create a cursor object
		XTextCursor oCurso = oTex.createTextCursor();
    
		//inserting some Text
		oTex.insertString( oCurso, "The first line in the newly created text frame.", false );
    
		oTex.insertString( oCurso, "\nWith this second line the height of the frame raises.", false );
         
		//insert a paragraph break
		try {
    
			oText.insertControlCharacter( oCursor, ControlCharacter.PARAGRAPH_BREAK, false );
      
		} catch (Exception e) {
			System.out.println("Couldn't insert break "+ e);
		} 
     
		// Change the CharColor and add a Shadow
		try {
			oCPS.setPropertyValue("CharColor",new Integer(65536));
			oCPS.setPropertyValue("CharShadowed", new Boolean(false));
		} catch (Exception e) {
			System.out.println("Couldn't change the color " + e);
		}
   

		oText.insertString( oCursor, " That's all for now !!", false );     

    
		//if the document should be disposed remove the slashes in front of the next line
		//myDoc.dispose();
    
       
		//System.out.println("done");	    

	} // finish method main


	public static XTextDocument openWriter(XMultiServiceFactory oMSF) {
    

		//define variables
		XInterface oInterface;
		XDesktop oDesktop;
		XComponentLoader oCLoader;
		XTextDocument oDoc = null;
		XComponent aDoc = null;

		try {

			oInterface = (XInterface) oMSF.createInstance( "com.sun.star.frame.Desktop" );
			oDesktop = ( XDesktop ) UnoRuntime.queryInterface( XDesktop.class, oInterface );
			oCLoader = ( XComponentLoader ) UnoRuntime.queryInterface( XComponentLoader.class, oDesktop );
			PropertyValue [] szEmptyArgs = new PropertyValue [0];
			String doc = "private:factory/swriter";
			aDoc = oCLoader.loadComponentFromURL(doc, "_blank", 0, szEmptyArgs );
			oDoc = (XTextDocument) UnoRuntime.queryInterface(XTextDocument.class, aDoc);

		} // end of try 

		catch(Exception e){

			System.out.println(" Exception " + e);

		} // end of catch


		return oDoc;
	}//end of openWriter
  
	public static void insertIntoCell(String CellName, String theText, XTextTable TT1) {
 
		XText oTableText = (XText) UnoRuntime.queryInterface(XText.class, TT1.getCellByName(CellName));
    
		//create a cursor object
		XTextCursor oC = oTableText.createTextCursor();
    
		XPropertySet oTPS = (XPropertySet)UnoRuntime.queryInterface( XPropertySet.class, oC );

		try {    
			oTPS.setPropertyValue("CharColor",new Integer(16777215));
		} catch (Exception e) {
		}

    
		//inserting some Text
		oTableText.insertString( oC, theText, false );
  
	} // end of insertIntoCell
 
  

	private XMultiServiceFactory _xMultiServiceFactory;
		
	public SWriterDemo(XMultiServiceFactory xMultiServiceFactory) {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".<init>:" + xMultiServiceFactory);
		
		_xMultiServiceFactory = xMultiServiceFactory;


		try {
			blabla(_xMultiServiceFactory);
		}
		catch(Exception exception) {
			System.err.println(getClass().getName() + ".<init(XMultiServiceFactory) - exception:" + exception);
		}
	}
	
	
	// XInitialization
	public void initialize(Object[] aArguments) throws com.sun.star.uno.Exception, com.sun.star.uno.RuntimeException {
		if(DEBUG) {
			System.err.println("##### " + getClass().getName() + ".initialize;");
			
			for(int i = 0; i < aArguments.length; ++ i)
				System.err.println("##### " + aArguments[i]);
		}
		
		_xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(
            XMultiServiceFactory.class, aArguments[0]);
		
		if(_xMultiServiceFactory == null) {
			XNamingService xNamingService = (XNamingService)UnoRuntime.queryInterface(
                XNamingService.class, aArguments[0]);
			Object smgr = xNamingService.getRegisteredObject("StarOffice.ServiceManager");
			_xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(
                XMultiServiceFactory.class, smgr);
		}
	}
	
	// XServiceInfo
	public String getImplementationName() throws com.sun.star.uno.RuntimeException {
		return getClass().getName();
	}
	
	public boolean supportsService(String serviceName) throws com.sun.star.uno.RuntimeException {
		return __serviceName.equals(serviceName);
	}
	
	public String[] getSupportedServiceNames() throws com.sun.star.uno.RuntimeException {
		return new String[] {__serviceName};
	}
}
