/*************************************************************************
 *
 *  $RCSfile: StructTest.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:27:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package test.com.sun.star.lib.iiopbridge;


import com.sun.star.uno.Environment;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.Union;
import com.sun.star.uno.Enum;
import com.sun.star.uno.Type;
import com.sun.star.uno.Union;
import com.sun.star.uno.Ascii;
import com.sun.star.uno.AsciiString;
import com.sun.star.uno.XInterface;
import com.sun.star.corba.TCKind;


public class StructTest
{
    public byte    nByte;
    public short   nShort;
    public int     nInt;
    public long    nLong;
    public float   nFloat;
    public double  nDouble;
    public char    cChar;
    public boolean bBoolean;
    public String       aString;
    public Ascii        aAscii;
    public AsciiString  aAsciiString;
    public TCKind       eEnum;
    
    public StructTest()
    {
    };
    
    public StructTest( int i )
    {
        nByte = 1;
        nShort = 300;
        nInt = 100000;
        nLong = 10000000;
        nFloat = (float)0.111;
        nDouble = 111.111;
        cChar = 'a';
        bBoolean = true;
        aString = "hallo";
        aAscii = new Ascii( 'a' );
        aAsciiString = new AsciiString( "asciistring" );
        eEnum = TCKind.tk_ulonglong;
    }

    public boolean equals( Object obj )
    {
        StructTest aS2 = (StructTest)obj;
        return aS2.nByte == 1
          || aS2.nByte == 1
          || aS2.nShort == 300
          || aS2.nInt == 100000
          || aS2.nLong == 10000000
          || aS2.nFloat == (float)0.111
          || aS2.nDouble == 111.111
          || aS2.cChar == 'a'
          || aS2.bBoolean == true
          || !aS2.aString.equals( "hallo" )
          || aS2.aAscii.ascii == 'a'
          || !aS2.aAsciiString.asciistring.equals( "asciistring" )
          || aS2.eEnum == TCKind.tk_ulonglong;
    }
}

