/*************************************************************************
 *
 *  $RCSfile: ThreadPool.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kr $ $Date: 2001/05/04 11:56:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.lib.uno.environments.remote;



/**
 * This class delegates to a specific thread pool,
 * which has to implement <code>IThreadPool</code>
 * threadpool implementations.
 * <p>
 * @version 	$Revision: 1.2 $ $ $Date: 2001/05/04 11:56:03 $
 * @author 	    Kay Ramme
 * @author 	    Joerg Budischewski
 * @see         com.sun.star.lib.uno.environments.remote.IThreadPool
 * @since       UDK1.0
 */
public class ThreadPool {
	/**
	 * Create a new java thread pool for default.
	 */
	static private IThreadPool _instance = new JavaThreadPool();

	/**
	 * Sets a specific thread pool
	 * <p>
	 * @param  pool    the specific thread pool
	 */
	static public void setThreadPool(IThreadPool pool) { 
		_instance = pool; 
	}


	/**
	 * Retrieves the global threadId for the current thread.
	 * <p>
	 * @return the thread id
	 */
	static public ThreadID getThreadId() { 
		return _instance.getThreadId(); 
	}
	
	
	/**
	 * Adds a jobQueue for the current thread to the threadpool.
	 * Requests are now put into this queue.
	 * <p>
	 * @param  disposeId    the dipose id with which the thread can be interrupted while staying in the queue
	 * @see                 #enter
	 */
	static public void addThread(Object disposeId) { 
		_instance.addThread(disposeId); 
	}

	/**
	 * Removes the jobQueue for the current thread.
	 */
	static public void removeThread() { 
		_instance.removeThread(); 
	}

	/**
	 * Queues a job into the jobQueue of the thread belonging to the jobs threadId.
	 * <p>
	 * @param job       the job
	 * @param disposeId the dispose id
	 */
	static public void putJob(Job job , Object disposeID) {
		_instance.putJob(job , disposeID); 
	}

	/**
	 * Lets the current thread enter the ThreadPool.
	 * The thread then dispatches all jobs and leaves
	 * the ThreadPool when it gets a reply job.
	 * <p>
	 */
	static public Object enter() throws Throwable {
		return _instance.enter(); 
	}

	/**
	 * Interrupts all threads which have associated the dispose id.
	 * <p>
	 * @param disposeId    the dispose id
	 */
	static public void dispose(Object disposeId) { 
		_instance.dispose(disposeId); 
	}
	
	static public void stopDispose(Object disposeId) {
		_instance.stopDispose(disposeId); 
	}


	/** @deprecated **/
	static public void reset(){
		dispose(null); 
	}
}

