/*************************************************************************
 *
 *  $RCSfile: Perl5StreamInput.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.tool.starjar.regex;

import java.io.Reader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.IOException;

public final class Perl5StreamInput {
    private static final int _fld01AC = 4096;
    private int _fld01AB;
    private Reader _fld01AA;
    boolean _fld01A9;
    boolean _fld01A8;
    int _fld01A7;
    int _fld01A6;
    int _fld01A5;
    int _fld01A4;
    char _fld01A3[];
    char _fld01A2[];

    public Perl5StreamInput(Reader reader, int i) {
        _fld01AA = reader;
        _fld01AB = i;
        _fld01A9 = false;
        _fld01A8 = false;
        _fld01A7 = _fld01A5 = _fld01A6 = 0;
        _fld01A2 = _fld01A3 = new char[i];
        _fld01A4 = -1;
    }

    public Perl5StreamInput(Reader reader) {
        this(reader, 4096);
    }

    public Perl5StreamInput(InputStream inputstream, int i) {
        this(new InputStreamReader(inputstream), i);
    }

    public Perl5StreamInput(InputStream inputstream) {
        this(new InputStreamReader(inputstream), 4096);
    }

    private void _mth01B1(int i, int j) {
        for (j += i; i < j; i++) {
            char c = _fld01A2[i];
            _fld01A3[i] = Character.isUpperCase(c) ? Character.toLowerCase(c) : c;
        }

    }

    void _mth01B0(int i) {
        _fld01A4 = i;
    }

    int _mth01AF() {
        return _fld01A4;
    }

    void _mth01AE(int i, boolean flag) throws IOException {
        if(_fld01A9)
            return;
        if(_fld01A8) {
            _fld01A8 = false;
            _fld01A9 = true;
            return;
        }
        int j = _fld01A7 - i;
        
        if(j < 0)
            throw new IOException("Non-negative offset assertion violation.\nPlease report this error to bugs@oroinc.com\n");
        char ac[] = new char[j + _fld01AB];
        int k = _fld01AA.read(ac, j, _fld01AB);
        
        if (k <= 0) {
            _fld01A9 = true;
            if(k == 0)
                throw new IOException("read from input Reader returned 0 chars.");
        } else {
            _fld01A6 += i;
            for (_fld01A7 = j + k; _fld01A7 < ac.length;) {
                int l = _fld01AA.read(ac, _fld01A7, ac.length - _fld01A7);
                
                if (l == 0)
                    throw new IOException("read from input Reader returned 0 chars.");
                    
                if (l < 0) {
                    _fld01A8 = true;
                    break;
                }
                _fld01A7 += l;
                k += l;
            }

            System.arraycopy(_fld01A2, i, ac, 0, j);
            _fld01A2 = ac;
            
            if (flag) {
                char ac1[] = new char[j + _fld01AB];
                System.arraycopy(_fld01A3, i, ac1, 0, j);
                _fld01A3 = ac1;
                _mth01B1(j, k);
                return;
            }
            _fld01A3 = _fld01A2;
        }
    }

    boolean _mth01AD(boolean flag) throws IOException {
        _fld01A6 += _fld01A7;
        int i = _fld01A7 = _fld01AA.read(_fld01A2);
        
        if(_fld01A7 > 0) {
            int j;
            for (; _fld01A7 < _fld01A2.length; _fld01A7 += j) {
                j = _fld01AA.read(_fld01A2, _fld01A7, _fld01A2.length - _fld01A7);
                
                if (j == 0)
                    throw new IOException("read from input Reader returned 0 chars.");
                    
                if(j < 0)
                    break;
            }
        } else {
            _fld01A9 = true;
        } 
        
        if (!_fld01A9 && flag) {
            _fld01A3 = new char[_fld01A2.length];
            _mth01B1(0, _fld01A7);
        }
        return !_fld01A9;
    }

    public boolean endOfStream() {
        return _fld01A9;
    }
}

