#*************************************************************************
#
#   $RCSfile: makefile.mk,v $
#
#   $Revision: 1.8.10.3 $
#
#   last change: $Author: armin $ $Date: 2002/05/15 11:06:44 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc.
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************
PRJ=..
PRJNAME=OpenOffice
TARGET=util

.INCLUDE:  settings.mk

.IF "$(strip)"!=""
LZIPFLAGS=-S
.ENDIF

.IF "$(OS)"=="WNT"
EXTRARMFLAG=/S
.ELSE
EXTRARMFLAG=-r
.ENDIF

.INCLUDE: target.mk

#ALLTAR : pack
ALLTAR : pack

.IF "$(alllangext)"!=""

pack: $(foreach,i,$(alllangext) pack_$i)

pack_%:
	+-$(RM) $(EXTRARMFLAG) $(OUT)$/$(@:s/pack_//)$/*
	+-lzip $(LZIPFLAGS) -l $(@:s/pack_//) -f openoffice.lst -d $(OUT)$/$(@:s/pack_//) -n OfficeOSL 

pplayer_%:
	+-$(RM) $(EXTRARMFLAG) $(OUT)$/player$/$(@:s/pplayer_//)$/*
	+-lzip $(LZIPFLAGS) -l $(@:s/pplayer_//) -f player.lst -d $(OUT)$/player$/$(@:s/pplayer_//) -n OpenOfficePlayer

test:
	+-lzip $(LZIPFLAGS) -l 01 -f openoffice.lst -o -n OfficeOSL 

test_player:
	+-lzip $(LZIPFLAGS) -l 01 -f player.lst -o -n OpenOfficePlayer 

.ELSE			# "$(alllangext)"!=""
pack:
	@+echo cannot pack nothing...

.ENDIF			# "$(alllangext)"!=""

