/*************************************************************************
 *
 *  $RCSfile: imapscb2.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2001/10/12 16:43:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <string> // needed on Solaris when including <algorithm>...

#include <algorithm>

#ifndef _INETCOREMSG_HXX
#include <inetmsg.hxx>
#endif
#ifndef _INETCORESTRM_HXX
#include <inetstrm.hxx>
#endif
#ifndef _INETTCP_HXX
#include <inettcp.hxx>
#endif

#ifndef INET_IMAPCHAR_HXX
#include <imapchar.hxx>
#endif
#ifndef INET_IMAPCIMP_HXX
#include <imapcimp.hxx>
#endif
#ifndef INET_IMAPCMDS_HXX
#include <imapcmds.hxx>
#endif

//============================================================================
//
//  class INetIMAPClient_Impl
//
//============================================================================

// static
INetIMAPScanner::Mode
INetIMAPClient_Impl::scannerCallback(const INetIMAPScannerToken & rToken,
									 void * pData)
{
	DBG_ASSERT(pData, "INetIMAPClient_Impl::scannerCallback(): Null data");
	INetIMAPClient_Impl & rThis
		= *static_cast< INetIMAPClient_Impl * >(pData);

	DBG_ASSERT(rThis.m_eState > STATE_INITIAL
			   && rThis.m_eState < STATE_CLOSED,
			   "INetIMAPClient_Impl::scannerCallback(): Invalid state");

	if (rThis.m_eScanState == SCAN_STATE_INITIAL)
		rThis.m_aLine.Erase();
	switch (rToken.getType())
	{
		case INetIMAPScannerToken::TYPE_SPACE:
			if (rThis.m_aLine.Len() < STRING_MAXLEN)
				rThis.m_aLine += ' ';
			break;

		case INetIMAPScannerToken::TYPE_NEWLINE:
			break;

		default:
			rThis.m_aLine.
				Append(rToken.getText().GetBuffer(),
					   std::min< xub_StrLen >(
						   rToken.getText().Len(),
						   xub_StrLen(STRING_MAXLEN - rThis.m_aLine.Len())));
			break;
	}

	switch (rThis.m_eScanState)
	{
		case SCAN_STATE_INITIAL:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == '*')
					{
						rThis.m_bTaggedResponse = false;
						rThis.m_eScanState = SCAN_STATE_RESPONSE;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_ATOM:
					if (rToken.getText().Len() == 1
						&& rToken.getText().GetChar(0) == '+')
						if (static_cast< INetIMAPCommandStream * >(
							        &rThis.m_xCommandStream)->
							    isWaitingForContinue())
						{
							rThis.m_nLineOffset = rThis.m_aLine.Len();
							rThis.m_eScanState = SCAN_STATE_CONTINUE;
							return INetIMAPScanner::MODE_TEXT;
						}
						else
							goto invalid;
					else if (rThis.m_eState > STATE_IDLE
							 && rToken.getText() == rThis.m_aTag)
					{
						rThis.m_bTaggedResponse = true;
						rThis.m_eScanState = SCAN_STATE_RESPONSE;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_CONTINUE:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_NEWLINE:
				{
					DBG_ASSERT(
						static_cast< INetIMAPCommandStream * >(
							    &rThis.m_xCommandStream)->
						    isWaitingForContinue(),
						"INetIMAPClient_Impl::scannerCallback(): Invariant");

					INetIMAPFlags ePermanentFlags;
					INetIMAPFlagKeywordList aPermanentFlagKeywords;
					bool bPermanentNewFlagKeywords = false;
					sal_uInt32 nNumber = 0;
					UniString aText;
					INetIMAPCodeResponse::Code eCode
						= rThis.parseResponseText(ePermanentFlags,
												  aPermanentFlagKeywords,
												  bPermanentNewFlagKeywords,
												  nNumber, aText);
					if (eCode != INetIMAPCodeResponse::CODE_NONE)
					{
						INetIMAPContinueCodeResponse
							aResponse(eCode, ePermanentFlags,
									  aPermanentFlagKeywords,
									  bPermanentNewFlagKeywords, nNumber,
									  aText);
						if (!rThis.callBack(aResponse))
							return INetIMAPScanner::MODE_ABORTED;
					}

					static_cast< INetIMAPCommandStream * >(
						    &rThis.m_xCommandStream)->
						continueWithLiteral();
					if (!rThis.m_xConnection->Send(*rThis.m_xCommandStream,
												   connectionSendCallback,
												   &rThis))
					{
						{
							vos::OGuard aGuard = rThis.m_aMutex;
							rThis.m_xCommandStream = 0;
							rThis.m_eState = STATE_IDLE;
						}

						INetIMAPErrorResponse aResponse(ERRCODE_IO_CANTWRITE);
						if (!rThis.callBack(aResponse, CALLBACK_COMMAND))
							return INetIMAPScanner::MODE_ABORTED;
					}

					rThis.m_aLine.Erase();
					rThis.m_eScanState = SCAN_STATE_INITIAL;
					return INetIMAPScanner::MODE_ATOM;
				}

				default:
					DBG_ASSERT
					 (rToken.getType() == INetIMAPScannerToken::TYPE_ATOM
					  || rToken.getType()
					      == INetIMAPScannerToken::TYPE_ATOM_TOO_LONG,
					  "INetIMAPClient_Impl::scannerCallback():"
					   " Invalid token");

					return INetIMAPScanner::MODE_TEXT;
			}

		case SCAN_STATE_RESPONSE:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(), "OK"))
						rThis.m_eResponseID = RESPONSE_OK;
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "NO"))
						rThis.m_eResponseID = RESPONSE_NO;
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "BAD"))
						rThis.m_eResponseID = RESPONSE_BAD;
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "PREAUTH"))
						rThis.m_eResponseID = RESPONSE_PREAUTH;
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "BYE"))
						rThis.m_eResponseID = RESPONSE_BYE;
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "FLAGS"))
						rThis.m_eResponseID = RESPONSE_FLAGS;
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "LIST"))
						rThis.m_eResponseID = RESPONSE_LIST;
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "LSUB"))
						rThis.m_eResponseID = RESPONSE_LSUB;
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "MAILBOX"))
						rThis.m_eResponseID = RESPONSE_MAILBOX;
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "SEARCH"))
						rThis.m_eResponseID = RESPONSE_SEARCH;
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "STATUS"))
						rThis.m_eResponseID = RESPONSE_STATUS;
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "CAPABILITY"))
						rThis.m_eResponseID = RESPONSE_CAPABILITY;
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "NAMESPACE"))
						rThis.m_eResponseID = RESPONSE_NAMESPACE;
					else
					{
						sal_Char const * p = rToken.getText().GetBuffer();
						sal_Char const * pEnd = p + rToken.getText().Len();
						if (INetMIME::scanUnsigned(p, pEnd, true,
												   rThis.m_nResponseNumber)
							&& p == pEnd)
							rThis.m_eResponseID = RESPONSE_NUMBER;
						else
							rThis.m_eResponseID = RESPONSE_INVALID;
					}

					{
						vos::OGuard aGuard = rThis.m_aMutex;
						if (rThis.m_eState == STATE_OPENING)
						{
							if (rThis.m_eResponseID != RESPONSE_OK
								&& rThis.m_eResponseID != RESPONSE_PREAUTH
								&& rThis.m_eResponseID != RESPONSE_BYE)
								rThis.m_eResponseID = RESPONSE_INVALID;
						}
						else if (rThis.m_eResponseID == RESPONSE_PREAUTH
								 || rThis.m_bTaggedResponse
								 && rThis.m_eResponseID > RESPONSE_BAD)
							rThis.m_eResponseID = RESPONSE_INVALID;
					}

					switch (rThis.m_eResponseID)
					{
						case RESPONSE_INVALID:
							goto invalid;

						case RESPONSE_OK:
						case RESPONSE_NO:
						case RESPONSE_BAD:
						case RESPONSE_PREAUTH:
						case RESPONSE_BYE:
							rThis.m_nLineOffset = rThis.m_aLine.Len();
							rThis.m_eScanState = SCAN_STATE_RESPONSE_STATE;
							return INetIMAPScanner::MODE_TEXT;

						case RESPONSE_FLAGS:
							rThis.m_pResponse = new INetIMAPFlagsResponse;
							rThis.m_eScanState = SCAN_STATE_RESPONSE_FLAGS;
							return INetIMAPScanner::MODE_ATOM;

						case RESPONSE_LIST:
						case RESPONSE_LSUB:
							rThis.m_pResponse = new INetIMAPListResponse;
							rThis.m_pListResponseMailbox
							 = new INetIMAPListResponseMailbox;
							rThis.m_eScanState = SCAN_STATE_RESPONSE_LIST;
							return INetIMAPScanner::MODE_ATOM;

						case RESPONSE_MAILBOX:
							rThis.m_nLineOffset = rThis.m_aLine.Len();
							rThis.m_eScanState = SCAN_STATE_RESPONSE_MAILBOX;
							return INetIMAPScanner::MODE_TEXT;

						case RESPONSE_SEARCH:
							rThis.m_pResponse = new INetIMAPSearchResponse;
							rThis.m_eScanState = SCAN_STATE_RESPONSE_SEARCH;
							return INetIMAPScanner::MODE_ATOM;

						case RESPONSE_STATUS:
							rThis.m_pResponse = new INetIMAPStatusResponse;
							rThis.m_eScanState = SCAN_STATE_RESPONSE_STATUS;
							return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;

						case RESPONSE_CAPABILITY:
							rThis.m_pResponse
							 = new INetIMAPCapabilityResponse;
							rThis.m_eScanState
							 = SCAN_STATE_RESPONSE_CAPABILITY;
							return INetIMAPScanner::MODE_ATOM;

						case RESPONSE_NAMESPACE:
							rThis.m_pResponse = new INetIMAPNamespaceResponse;
							rThis.m_nNamespaceResponseKind
							 = INetIMAPNamespaceResponse::NAMESPACE_PERSONAL;
							rThis.m_eScanState
							 = SCAN_STATE_RESPONSE_NAMESPACE;
							return INetIMAPScanner::MODE_ATOM;

						default: // RESPONSE_NUMBER
							rThis.m_eScanState = SCAN_STATE_RESPONSE_NUMBER;
							return INetIMAPScanner::MODE_ATOM;
					}

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_STATE:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_NEWLINE:
				{
					INetIMAPFlags ePermanentFlags = INetIMAPFlags(0);
					INetIMAPFlagKeywordList aPermanentFlagKeywords;
					bool bPermanentNewFlagKeywords = false;
					sal_uInt32 nNumber = 0;
					UniString aText;
					INetIMAPCodeResponse::Code eCode
						= rThis.parseResponseText(ePermanentFlags,
												  aPermanentFlagKeywords,
												  bPermanentNewFlagKeywords,
												  nNumber, aText);

					CallbackType eCallbackType;
					{
						vos::OGuard aGuard = rThis.m_aMutex;

						eCallbackType = rThis.m_eState == STATE_IDLE ?
							                CALLBACK_UNILATERAL :
							                CALLBACK_COMMAND;

						switch (rThis.m_eState)
						{
							case STATE_OPENING:
								if (!rThis.m_bTaggedResponse
									&& rThis.m_eResponseID
									       == RESPONSE_PREAUTH)
									rThis.m_bAuthenticated = true;
								rThis.m_eState = STATE_IDLE;
								break;

							case STATE_COMMAND_LOGOUT:
								if (rThis.m_bTaggedResponse
									&& rThis.m_eResponseID == RESPONSE_OK)
								{
									rThis.m_eState = STATE_CLOSED;
									rThis.m_xConnection->Abort();
									rThis.m_xConnection = 0;
								}
								break;

							case STATE_COMMAND_LOGIN:
								if (rThis.m_bTaggedResponse
									&& rThis.m_eResponseID == RESPONSE_OK)
									rThis.m_bAuthenticated = true;
								break;

							case STATE_COMMAND_SELECT:
								if (rThis.m_bTaggedResponse
									&& rThis.m_eResponseID != RESPONSE_OK)
									rThis.m_aSelectedMailbox.Erase();
								break;

							case STATE_COMMAND_CLOSE:
								if (rThis.m_bTaggedResponse
									&& rThis.m_eResponseID == RESPONSE_OK)
									rThis.m_aSelectedMailbox.Erase();
								break;

							case STATE_COMMAND_FETCH:
							case STATE_COMMAND_UID_FETCH:
								if (rThis.m_bTaggedResponse)
									rThis.m_aStreamCallback = Link();
								break;
						}

						if (rThis.m_bTaggedResponse
							&& rThis.m_eState != STATE_CLOSED)
							rThis.m_eState = STATE_IDLE;
					}

					if (rThis.m_bTaggedResponse)
					{
						DBG_ASSERT(rThis.m_xCommandStream.Is()
								   && !static_cast< INetIMAPCommandStream * >(
									           &rThis.m_xCommandStream)->
								           isWaitingForContinue(),
								   "INetIMAPClient_Impl::scannerCallback():"
								       " Invalid command stream");

						rThis.m_xCommandStream = 0;
					}

					INetIMAPStateResponse
						aResponse(rThis.m_bTaggedResponse,
								  rThis.m_eResponseID == RESPONSE_OK ?
								      INetIMAPStateResponse::STATE_OK :
								  rThis.m_eResponseID == RESPONSE_NO ?
								      INetIMAPStateResponse::STATE_NO :
								  rThis.m_eResponseID == RESPONSE_BAD ?
								      INetIMAPStateResponse::STATE_BAD :
								  rThis.m_eResponseID == RESPONSE_PREAUTH ?
								      INetIMAPStateResponse::STATE_PREAUTH :
								      INetIMAPStateResponse::STATE_BYE,
								  eCode, ePermanentFlags,
								  aPermanentFlagKeywords,
								  bPermanentNewFlagKeywords, nNumber, aText);
					if (!rThis.callBack(aResponse, eCallbackType))
						return INetIMAPScanner::MODE_ABORTED;

					rThis.m_aLine.Erase();
					rThis.m_eScanState = SCAN_STATE_INITIAL;
					return INetIMAPScanner::MODE_ATOM;
				}

				default:
					DBG_ASSERT
					 (rToken.getType() == INetIMAPScannerToken::TYPE_ATOM
					  || rToken.getType()
				          == INetIMAPScannerToken::TYPE_ATOM_TOO_LONG,
					  "INetIMAPClient_Impl::scannerCallback():"
					   " Invalid token");

					return INetIMAPScanner::MODE_TEXT;
			}

		case SCAN_STATE_RESPONSE_FLAGS:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == '(')
					{
						rThis.m_eScanState = SCAN_STATE_RESPONSE_FLAGS_FLAG;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FLAGS_FLAG:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == ')')
					{
						rThis.m_eScanState = SCAN_STATE_RESPONSE_NEWLINE;
						return INetIMAPScanner::MODE_ATOM;
					}
					else if (rToken.getChar() == '\\')
					{
						rThis.m_eScanState
						 = SCAN_STATE_RESPONSE_FLAGS_FLAG_SLASH;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_ATOM:
					static_cast< INetIMAPFlagsResponse * >(rThis.
														       m_pResponse)->
						getFlagKeywords().append(rToken.getText());

					return INetIMAPScanner::MODE_ATOM;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FLAGS_FLAG_SLASH:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(),
												  "ANSWERED"))
						static_cast< INetIMAPFlagsResponse * >(
							    rThis.m_pResponse)->
							addFlags(INET_IMAP_FLAG_ANSWERED);
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "FLAGGED"))
						static_cast< INetIMAPFlagsResponse * >(
							    rThis.m_pResponse)->
							addFlags(INET_IMAP_FLAG_FLAGGED);
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "DELETED"))
						static_cast< INetIMAPFlagsResponse * >(
							    rThis.m_pResponse)->
							addFlags(INET_IMAP_FLAG_DELETED);
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "SEEN"))
						static_cast< INetIMAPFlagsResponse * >(
							    rThis.m_pResponse)->
							addFlags(INET_IMAP_FLAG_SEEN);
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "DRAFT"))
						static_cast< INetIMAPFlagsResponse * >(
							    rThis.m_pResponse)->
							addFlags(INET_IMAP_FLAG_DRAFT);

					rThis.m_eScanState = SCAN_STATE_RESPONSE_FLAGS_FLAG;
					return INetIMAPScanner::MODE_ATOM;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_NEWLINE:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_NEWLINE:
					if (!rThis.callBack(*rThis.m_pResponse))
						return INetIMAPScanner::MODE_ABORTED;

					delete rThis.m_pResponse;
					rThis.m_pResponse = 0;
					rThis.m_aLine.Erase();
					rThis.m_eScanState = SCAN_STATE_INITIAL;
					return INetIMAPScanner::MODE_ATOM;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_LIST:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == '(')
					{
						rThis.m_eScanState = SCAN_STATE_RESPONSE_LIST_FLAG;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_LIST_FLAG:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == ')')
					{
						rThis.m_eScanState = SCAN_STATE_RESPONSE_LIST_HSEP;
						return INetIMAPScanner::MODE_ATOM_QUOTED;
					}
					else if (rToken.getChar() == '\\')
					{
						rThis.m_eScanState
						 = SCAN_STATE_RESPONSE_LIST_FLAG_SLASH;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_LIST_FLAG_SLASH:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(), "MARKED"))
						rThis.m_pListResponseMailbox->
						 addFlags(INetIMAPListResponseMailbox::FLAG_MARKED);
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "NOINFERIORS"))
						rThis.m_pListResponseMailbox->
						 addFlags
						  (INetIMAPListResponseMailbox::FLAG_NOINFERIORS);
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "NOSELECT"))
						rThis.m_pListResponseMailbox->
						 addFlags(INetIMAPListResponseMailbox::FLAG_NOSELECT);
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "UNMARKED"))
						rThis.m_pListResponseMailbox->
						 addFlags(INetIMAPListResponseMailbox::FLAG_UNMARKED);

					rThis.m_eScanState = SCAN_STATE_RESPONSE_LIST_FLAG;
					return INetIMAPScanner::MODE_ATOM;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_LIST_HSEP:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM_QUOTED;

				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(),
												  INET_IMAP_CANONIC_NIL))
					{
						rThis.m_eScanState = SCAN_STATE_RESPONSE_LIST_NAME;
						return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_QUOTED:
					if (rToken.getText().Len() == 1)
					{
						rThis.m_pListResponseMailbox->
							setHierarchySeparator(rToken.getText().
												             GetChar(0));

						rThis.m_eScanState = SCAN_STATE_RESPONSE_LIST_NAME;
						return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_LIST_NAME:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					// At least the "Solstice (tm) Internet Mail Server (tm)
					// IMAP4 service @ 2.0" and "Solstice (tm) Internet Mail
					// Server (tm) 2.0p9 IMAP4 service" send a <mailbox>
					// containing '%', '*', or '\x7F' unquoted:
					if (rToken.getChar() == '%' || rToken.getChar() == '*'
						|| rToken.getChar() == '\x7F')
					{
						rThis.m_pListResponseMailbox->
							setMailboxName(rToken.getChar(), false);
						rThis.m_bResponseMailboxAppendable = true;

						rThis.m_eScanState = SCAN_STATE_RESPONSE_LIST_NEWLINE;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_ATOM:
					rThis.m_pListResponseMailbox->
					 setMailboxName(rToken.getText(),
									INetMIME::equalIgnoreCase
									 (rToken.getText(),
									  INET_IMAP_CANONIC_NIL));
					rThis.m_bResponseMailboxAppendable = true;

					rThis.m_eScanState = SCAN_STATE_RESPONSE_LIST_NEWLINE;
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_QUOTED:
				case INetIMAPScannerToken::TYPE_LITERAL:
					rThis.m_pListResponseMailbox->
					 setMailboxName(rToken.getText(), false);
					rThis.m_bResponseMailboxAppendable = false;

					rThis.m_eScanState = SCAN_STATE_RESPONSE_LIST_NEWLINE;
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_NEWLINE:
					// At least the "Solstice (tm) Internet Mail Server (tm)
					// 2.0p9 IMAP4 service" sometimes sends LSUB response
					// lines that lack the final <mailbox> (and are thus
					// ignored):
					if (rThis.m_eResponseID == RESPONSE_LSUB)
					{
						delete rThis.m_pListResponseMailbox;
						rThis.m_pListResponseMailbox = 0;
						delete rThis.m_pResponse;
						rThis.m_pResponse = 0;
						rThis.m_aLine.Erase();
						rThis.m_eScanState = SCAN_STATE_INITIAL;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_LIST_NEWLINE:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					rThis.m_bResponseMailboxAppendable = false;
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					// At least the "Solstice (tm) Internet Mail Server (tm)
					// IMAP4 service @ 2.0" and "Solstice (tm) Internet Mail
					// Server (tm) 2.0p9 IMAP4 service" send a <mailbox>
					// containing '%', '*', or '\x7F' unquoted:
					if (rThis.m_bResponseMailboxAppendable
						&& (rToken.getChar() == '%' || rToken.getChar() == '*'
							|| rToken.getChar() == '\x7F')
						&& rThis.m_pListResponseMailbox->
						       appendMailboxName(rToken.getChar()))
						return INetIMAPScanner::MODE_ATOM;
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_ATOM:
					// At least the "Solstice (tm) Internet Mail Server (tm)
					// IMAP4 service @ 2.0" and "Solstice (tm) Internet Mail
					// Server (tm) 2.0p9 IMAP4 service" send a <mailbox>
					// containing '%', '*', or '\x7F' unquoted:
					if (rThis.m_bResponseMailboxAppendable
						&& rThis.m_pListResponseMailbox->
						    appendMailboxName(rToken.getText()))
						return INetIMAPScanner::MODE_ATOM;
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_NEWLINE:
					static_cast< INetIMAPListResponse * >(rThis.m_pResponse)->
						appendMailbox(rThis.m_pListResponseMailbox);
					rThis.m_pListResponseMailbox = 0;
					if (!rThis.callBack(*rThis.m_pResponse))
						return INetIMAPScanner::MODE_ABORTED;

					delete rThis.m_pResponse;
					rThis.m_pResponse = 0;
					rThis.m_aLine.Erase();
					rThis.m_eScanState = SCAN_STATE_INITIAL;
					return INetIMAPScanner::MODE_ATOM;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_MAILBOX:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_NEWLINE:
				{
					INetIMAPMailboxResponse aResponse = INetIMAPASCII::stripTrailingSpace(rThis.m_aLine, INetIMAPASCII::skipLeadingSpace(rThis.m_aLine, rThis.m_nLineOffset));
					if (!rThis.callBack(aResponse))
						return INetIMAPScanner::MODE_ABORTED;

					rThis.m_aLine.Erase();
					rThis.m_eScanState = SCAN_STATE_INITIAL;
					return INetIMAPScanner::MODE_ATOM;
				}

				default:
					DBG_ASSERT
					 (rToken.getType() == INetIMAPScannerToken::TYPE_ATOM
					  || rToken.getType()
				          == INetIMAPScannerToken::TYPE_ATOM_TOO_LONG,
					  "INetIMAPClient_Impl::scannerCallback():"
					   " Invalid token");

					return INetIMAPScanner::MODE_TEXT;
			}

		case SCAN_STATE_RESPONSE_SEARCH:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_ATOM:
				{
					sal_Char const * p = rToken.getText().GetBuffer();
					sal_Char const * pEnd = p + rToken.getText().Len();
					sal_uInt32 nNumber;
					if (INetMIME::scanUnsigned(p, pEnd, true, nNumber)
						&& p == pEnd && nNumber != 0)
					{
						static_cast< INetIMAPSearchResponse * >(
							    rThis.m_pResponse)->
							add(nNumber);
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;
				}

				case INetIMAPScannerToken::TYPE_NEWLINE:
					if (!rThis.callBack(*rThis.m_pResponse))
						return INetIMAPScanner::MODE_ABORTED;

					delete rThis.m_pResponse;
					rThis.m_pResponse = 0;
					rThis.m_aLine.Erase();
					rThis.m_eScanState = SCAN_STATE_INITIAL;
					return INetIMAPScanner::MODE_ATOM;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_STATUS:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					// At least the "Solstice (tm) Internet Mail Server (tm)
					// IMAP4 service @ 2.0" and "Solstice (tm) Internet Mail
					// Server (tm) 2.0p9 IMAP4 service" send a <mailbox>
					// containing '%', '*', or '\x7F' unquoted:
					if (rToken.getChar() == '%' || rToken.getChar() == '*'
						|| rToken.getChar() == '\x7F')
					{
						static_cast< INetIMAPStatusResponse * >(
							    rThis.m_pResponse)->
							setMailboxName(rToken.getChar());
						rThis.m_bResponseMailboxAppendable = true;

						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_STATUS_ATTRIB_LIST;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_ATOM:
				case INetIMAPScannerToken::TYPE_QUOTED:
				case INetIMAPScannerToken::TYPE_LITERAL:
					static_cast< INetIMAPStatusResponse * >(rThis.
															    m_pResponse)->
						setMailboxName(rToken.getText());
					rThis.m_bResponseMailboxAppendable
						= rToken.getType() == INetIMAPScannerToken::TYPE_ATOM;

					rThis.m_eScanState
						= SCAN_STATE_RESPONSE_STATUS_ATTRIB_LIST;
					return INetIMAPScanner::MODE_ATOM;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_STATUS_ATTRIB_LIST:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					rThis.m_bResponseMailboxAppendable = false;
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					// At least the "Solstice (tm) Internet Mail Server (tm)
					// IMAP4 service @ 2.0" and "Solstice (tm) Internet Mail
					// Server (tm) 2.0p9 IMAP4 service" send a <mailbox>
					// containing '%', '*', or '\x7F' unquoted:
					if (rToken.getChar() == '(')
					{
						rThis.m_eScanState
						 = SCAN_STATE_RESPONSE_STATUS_ATTRIB;
						return INetIMAPScanner::MODE_ATOM;
					}
					else if (rThis.m_bResponseMailboxAppendable
							 && (rToken.getChar() == '%'
								 || rToken.getChar() == '*'
								 || rToken.getChar() == '\x7F')
							 && static_cast< INetIMAPStatusResponse * >(
								        rThis.m_pResponse)->
							        appendMailboxName(rToken.getChar()))
						return INetIMAPScanner::MODE_ATOM;
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_ATOM:
					// At least the "Solstice (tm) Internet Mail Server (tm)
					// IMAP4 service @ 2.0" and "Solstice (tm) Internet Mail
					// Server (tm) 2.0p9 IMAP4 service" send a <mailbox>
					// containing '%', '*', or '\x7F' unquoted:
					if (rThis.m_bResponseMailboxAppendable
						&& static_cast< INetIMAPStatusResponse * >(
							       rThis.m_pResponse)->
						       appendMailboxName(rToken.getText()))
						return INetIMAPScanner::MODE_ATOM;
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_STATUS_ATTRIB:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == ')')
					{
						rThis.m_eScanState
						 = SCAN_STATE_RESPONSE_NEWLINE;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(),
												  "MESSAGES"))
					{
						rThis.m_eStatusResponseAttribute
						 = INET_IMAP_STATUS_ATTRIBUTE_MESSAGES;
						rThis.m_eScanState
						 = SCAN_STATE_RESPONSE_STATUS_ATTRIB_VALUE;
						return INetIMAPScanner::MODE_ATOM;
					}
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "RECENT"))
					{
						rThis.m_eStatusResponseAttribute
						 = INET_IMAP_STATUS_ATTRIBUTE_RECENT;
						rThis.m_eScanState
						 = SCAN_STATE_RESPONSE_STATUS_ATTRIB_VALUE;
						return INetIMAPScanner::MODE_ATOM;
					}
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "UIDNEXT"))
					{
						rThis.m_eStatusResponseAttribute
						 = INET_IMAP_STATUS_ATTRIBUTE_UIDNEXT;
						rThis.m_eScanState
						 = SCAN_STATE_RESPONSE_STATUS_ATTRIB_VALUE;
						return INetIMAPScanner::MODE_ATOM;
					}
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "UIDVALIDITY"))
					{
						rThis.m_eStatusResponseAttribute
						 = INET_IMAP_STATUS_ATTRIBUTE_UIDVALIDITY;
						rThis.m_eScanState
						 = SCAN_STATE_RESPONSE_STATUS_ATTRIB_VALUE;
						return INetIMAPScanner::MODE_ATOM;
					}
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "UNSEEN"))
					{
						rThis.m_eStatusResponseAttribute
						 = INET_IMAP_STATUS_ATTRIBUTE_UNSEEN;
						rThis.m_eScanState
						 = SCAN_STATE_RESPONSE_STATUS_ATTRIB_VALUE;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_STATUS_ATTRIB_VALUE:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_ATOM:
				{
					sal_Char const * p = rToken.getText().GetBuffer();
					sal_Char const * pEnd = p + rToken.getText().Len();
					sal_uInt32 nNumber;
					if (INetMIME::scanUnsigned(p, pEnd, true, nNumber)
						&& p == pEnd)
					{
						switch (rThis.m_eStatusResponseAttribute)
						{
							case INET_IMAP_STATUS_ATTRIBUTE_MESSAGES:
								static_cast< INetIMAPStatusResponse * >(
									    rThis.m_pResponse)->
									setMessagesAttribute(nNumber);
								break;

							case INET_IMAP_STATUS_ATTRIBUTE_RECENT:
								static_cast< INetIMAPStatusResponse * >(
									    rThis.m_pResponse)->
									setRecentAttribute(nNumber);
								break;

							case INET_IMAP_STATUS_ATTRIBUTE_UIDNEXT:
								static_cast< INetIMAPStatusResponse * >(
									    rThis.m_pResponse)->
									setUIDNextAttribute(nNumber);
								break;

							case INET_IMAP_STATUS_ATTRIBUTE_UIDVALIDITY:
								static_cast< INetIMAPStatusResponse * >(
									    rThis.m_pResponse)->
									setUIDValidityAttribute(nNumber);
								break;

							case INET_IMAP_STATUS_ATTRIBUTE_UNSEEN:
								static_cast< INetIMAPStatusResponse * >(
									    rThis.m_pResponse)->
									setUnseenAttribute(nNumber);
								break;
						}

						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_STATUS_ATTRIB;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;
				}

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_CAPABILITY:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(), "IMAP4"))
						static_cast< INetIMAPCapabilityResponse * >(
							    rThis.m_pResponse)->
							addCapabilities(CAPABILITY_IMAP4);
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "IMAP4REV1"))
						static_cast< INetIMAPCapabilityResponse * >(
							    rThis.m_pResponse)->
							addCapabilities(CAPABILITY_IMAP4REV1);
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "ACL"))
						static_cast< INetIMAPCapabilityResponse * >(
							    rThis.m_pResponse)->
							addCapabilities(CAPABILITY_ACL);
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "QUOTA"))
						static_cast< INetIMAPCapabilityResponse * >(
							    rThis.m_pResponse)->
							addCapabilities(CAPABILITY_QUOTA);
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "LITERAL+"))
						static_cast< INetIMAPCapabilityResponse * >(
							    rThis.m_pResponse)->
							addCapabilities(CAPABILITY_LITERAL_PLUS);
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "IDLE"))
						static_cast< INetIMAPCapabilityResponse * >(
							    rThis.m_pResponse)->
							addCapabilities(CAPABILITY_IDLE);
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "MAILBOX-REFERRALS"))
						static_cast< INetIMAPCapabilityResponse * >(
							    rThis.m_pResponse)->
							addCapabilities(CAPABILITY_MAILBOX_REFERRALS);
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "LOGIN-REFERRALS"))
						static_cast< INetIMAPCapabilityResponse * >(
							    rThis.m_pResponse)->
							addCapabilities(CAPABILITY_LOGIN_REFERRALS);
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "NAMESPACE"))
						static_cast< INetIMAPCapabilityResponse * >(
							    rThis.m_pResponse)->
							addCapabilities(CAPABILITY_NAMESPACE);
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "UIDPLUS"))
						static_cast< INetIMAPCapabilityResponse * >(
							    rThis.m_pResponse)->
							addCapabilities(CAPABILITY_UIDPLUS);
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_ATOM_TOO_LONG:
					rThis.m_eScanState
						= SCAN_STATE_RESPONSE_CAPABILITY_TOO_LONG;
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_NEWLINE:
					rThis.m_bCapabilitiesDetermined = true;
					rThis.m_eCapabilities
						= static_cast< INetIMAPCapabilityResponse * >(
							      rThis.m_pResponse)->
					          getCapabilities();

					if (!rThis.callBack(*rThis.m_pResponse))
						return INetIMAPScanner::MODE_ABORTED;

					delete rThis.m_pResponse;
					rThis.m_pResponse = 0;
					rThis.m_aLine.Erase();
					rThis.m_eScanState = SCAN_STATE_INITIAL;
					return INetIMAPScanner::MODE_ATOM;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_CAPABILITY_TOO_LONG:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_ATOM:
					rThis.m_eScanState = SCAN_STATE_RESPONSE_CAPABILITY;
					return INetIMAPScanner::MODE_ATOM;

				default:
					DBG_ASSERT(
						rToken.getType()
						    == INetIMAPScannerToken::TYPE_ATOM_TOO_LONG,
						"INetIMAPClient_Impl::scannerCallback():"
						    " Invalid token");
					return INetIMAPScanner::MODE_ATOM;
			}

		case SCAN_STATE_RESPONSE_NAMESPACE:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == '(')
					{
						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_NAMESPACE_LIST;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(),
												  INET_IMAP_CANONIC_NIL))
						if (rThis.m_nNamespaceResponseKind
							   == INetIMAPNamespaceResponse::NAMESPACE_SHARED)
						{
							rThis.m_eScanState = SCAN_STATE_RESPONSE_NEWLINE;
							return INetIMAPScanner::MODE_ATOM;
						}
						else
						{
							++rThis.m_nNamespaceResponseKind;
							return INetIMAPScanner::MODE_ATOM;
						}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_NAMESPACE_LIST:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == '(')
					{
						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_NAMESPACE_PREFIX;
						return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
					}
					else if (rToken.getChar() == ')')
						if (rThis.m_nNamespaceResponseKind
							   == INetIMAPNamespaceResponse::NAMESPACE_SHARED)
						{
							rThis.m_eScanState = SCAN_STATE_RESPONSE_NEWLINE;
							return INetIMAPScanner::MODE_ATOM;
						}
						else
						{
							++rThis.m_nNamespaceResponseKind;

							rThis.m_eScanState
								= SCAN_STATE_RESPONSE_NAMESPACE;
							return INetIMAPScanner::MODE_ATOM;
						}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_NAMESPACE_PREFIX:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;

				case INetIMAPScannerToken::TYPE_QUOTED:
				case INetIMAPScannerToken::TYPE_LITERAL:
					rThis.m_aNamespaceResponsePrefix = rToken.getText();

					rThis.m_eScanState = SCAN_STATE_RESPONSE_NAMESPACE_HSEP;
					return INetIMAPScanner::MODE_ATOM_QUOTED;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_NAMESPACE_HSEP:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM_QUOTED;

				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(),
												  INET_IMAP_CANONIC_NIL))
					{
						rThis.m_cNamespaceResponseHierarchySeparator = 0;

						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_NAMESPACE_EXT;
						return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_QUOTED:
					if (rToken.getText().Len() == 1)
					{
						rThis.m_cNamespaceResponseHierarchySeparator
							= rToken.getText().GetChar(0);

						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_NAMESPACE_EXT;
						return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_NAMESPACE_EXT:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == ')')
					{
						static_cast< INetIMAPNamespaceResponse * >(
							    rThis.m_pResponse)->
							addNamespace(
								INetIMAPNamespaceResponse::NamespaceKind(
									rThis.m_nNamespaceResponseKind),
								new INetIMAPNamespace(
									    rThis.m_aNamespaceResponsePrefix,
										rThis.
									 m_cNamespaceResponseHierarchySeparator));

						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_NAMESPACE_LIST;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_QUOTED:
				case INetIMAPScannerToken::TYPE_LITERAL:
					rThis.m_eScanState
						= SCAN_STATE_RESPONSE_NAMESPACE_EXT_LIST;
					return INetIMAPScanner::MODE_ATOM;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_NAMESPACE_EXT_LIST:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == '(')
					{
						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_NAMESPACE_EXT_ARG;
						return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_NAMESPACE_EXT_ARG:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
				case INetIMAPScannerToken::TYPE_QUOTED:
				case INetIMAPScannerToken::TYPE_LITERAL:
					return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == ')')
					{
						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_NAMESPACE_EXT;
						return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_NUMBER:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(), "EXISTS"))
					{
						rThis.m_pResponse
						 = new
						    INetIMAPExistsResponse(rThis.m_nResponseNumber);

						rThis.m_eScanState = SCAN_STATE_RESPONSE_NEWLINE;
						return INetIMAPScanner::MODE_ATOM;
					}
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "RECENT"))
					{
						rThis.m_pResponse
						 = new
						    INetIMAPRecentResponse(rThis.m_nResponseNumber);

						rThis.m_eScanState = SCAN_STATE_RESPONSE_NEWLINE;
						return INetIMAPScanner::MODE_ATOM;
					}
					else if (rThis.m_nResponseNumber
							 && INetMIME::equalIgnoreCase(rToken.getText(),
														  "EXPUNGE"))
					{
						rThis.m_pResponse
						 = new
						    INetIMAPExpungeResponse(rThis.m_nResponseNumber);

						rThis.m_eScanState = SCAN_STATE_RESPONSE_NEWLINE;
						return INetIMAPScanner::MODE_ATOM;
					}
					else if (rThis.m_nResponseNumber
							 && INetMIME::equalIgnoreCase(rToken.getText(),
														  "FETCH"))
					{
						rThis.m_pResponse
						 = new INetIMAPFetchResponse(rThis.m_nResponseNumber);

						rThis.m_eScanState = SCAN_STATE_RESPONSE_FETCH;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == '(')
					{
						rThis.m_eScanState = SCAN_STATE_RESPONSE_FETCH_ATTRIB;
						return INetIMAPScanner::MODE_RESTRICTED;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_ATTRIB:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_RESTRICTED;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == ')')
					{
						rThis.m_eScanState = SCAN_STATE_RESPONSE_NEWLINE;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(),
												  "ENVELOPE"))
					{
						rThis.m_eScanState
						 = SCAN_STATE_RESPONSE_FETCH_ENVELOPE;
						return INetIMAPScanner::MODE_ATOM;
					}
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "FLAGS"))
					{
						rThis.m_eScanState = SCAN_STATE_RESPONSE_FETCH_FLAGS;
						return INetIMAPScanner::MODE_ATOM;
					}
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "INTERNALDATE"))
					{
						rThis.m_eScanState
						 = SCAN_STATE_RESPONSE_FETCH_INTERNALDATE;
						return INetIMAPScanner::MODE_ATOM_QUOTED;
					}
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "RFC822"))
					{
						rThis.m_eScanState = SCAN_STATE_RESPONSE_FETCH_RFC822;
						return
						 INetIMAPScanner::MODE_RESTRICTED_QUOTED_LITERAL;
					}
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "BODY"))
					{
						rThis.m_eScanState = SCAN_STATE_RESPONSE_FETCH_BODY;
						return INetIMAPScanner::MODE_RESTRICTED;
					}
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "BODYSTRUCTURE"))
					{
						rThis.m_eScanState
						 = SCAN_STATE_RESPONSE_FETCH_BODYSTRUCTURE;
						return INetIMAPScanner::MODE_ATOM;
					}
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "UID"))
					{
						rThis.m_eScanState = SCAN_STATE_RESPONSE_FETCH_UID;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_ENVELOPE:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == '(')
					{
						static_cast< INetIMAPFetchResponse * >(
							    rThis.m_pResponse)->
							setEnvelope();

						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_ENVELOPE_DATE;
						return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_ENVELOPE_DATE:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;

				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(),
												  INET_IMAP_CANONIC_NIL))
					{
						rThis.m_eScanState
						 = SCAN_STATE_RESPONSE_FETCH_ENVELOPE_SUBJECT;
						return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_QUOTED:
				case INetIMAPScannerToken::TYPE_LITERAL:
				{
					DateTime aEnvelopeDate(0, 0);
					if (INetCoreRFC822Message().ParseDateField(
						UniString(rToken.getText(), RTL_TEXTENCODING_ASCII_US),
						aEnvelopeDate, aEnvelopeDate))
						static_cast< INetIMAPFetchResponse * >(
							    rThis.m_pResponse)->
							setEnvelopeDate(aEnvelopeDate);

					rThis.m_eScanState
						= SCAN_STATE_RESPONSE_FETCH_ENVELOPE_SUBJECT;
					return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
				}

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_ENVELOPE_SUBJECT:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;

				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(),
												  INET_IMAP_CANONIC_NIL))
					{
						rThis.m_eScanState
						 = SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADR;
						rThis.m_eFetchResponseEnvelopeAdrPart
						 = ENVELOPE_ADR_FROM;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_QUOTED:
				case INetIMAPScannerToken::TYPE_LITERAL:
					static_cast< INetIMAPFetchResponse * >(rThis.
														       m_pResponse)->
						setEnvelopeSubject(rToken.getText());

					rThis.m_eScanState
						= SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADR;
					rThis.m_eFetchResponseEnvelopeAdrPart = ENVELOPE_ADR_FROM;
					return INetIMAPScanner::MODE_ATOM;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADR:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == '(')
					{
						rThis.m_aFetchResponseEnvelopeAdr.Erase();
						rThis.m_eFetchResponseEnvelopeAdrPrefix = PREFIX_NONE;

						rThis.m_eScanState
						 = SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADDRESS_LIST;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(),
												  INET_IMAP_CANONIC_NIL))
						return rThis.doneFetchResponseEnvelopeAdr(false);
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADDRESS_LIST:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == '(')
					{
						rThis.m_eScanState
						 = SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADDRESS_NAME;
						return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
					}
					else if (rToken.getChar() == ')')
						return rThis.doneFetchResponseEnvelopeAdr(true);
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADDRESS_NAME:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;

				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(),
												  INET_IMAP_CANONIC_NIL))
					{
						rThis.m_aFetchResponseEnvelopeAdrName.Erase();

						rThis.m_eScanState
						 = SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADDRESS_ADL;
						return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_QUOTED:
				case INetIMAPScannerToken::TYPE_LITERAL:
					rThis.m_aFetchResponseEnvelopeAdrName = rToken.getText();

					rThis.m_eScanState
					 = SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADDRESS_ADL;
					return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADDRESS_ADL:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;

				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(),
												  INET_IMAP_CANONIC_NIL))
					{
						rThis.m_aFetchResponseEnvelopeAdrADL.Erase();

						rThis.m_eScanState
						 = SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADDRESS_MAILBOX;
						return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_QUOTED:
				case INetIMAPScannerToken::TYPE_LITERAL:
					rThis.m_aFetchResponseEnvelopeAdrADL = rToken.getText();

					rThis.m_eScanState
					 = SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADDRESS_MAILBOX;
					return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADDRESS_MAILBOX:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;

				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(),
												  INET_IMAP_CANONIC_NIL))
					{
						rThis.m_bFetchResponseEnvelopeAdrMailboxNIL = true;

						rThis.m_eScanState
						 = SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADDRESS_HOST;
						return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_QUOTED:
				case INetIMAPScannerToken::TYPE_LITERAL:
					rThis.m_bFetchResponseEnvelopeAdrMailboxNIL = false;
					rThis.m_aFetchResponseEnvelopeAdrMailbox
					 = rToken.getText();

					rThis.m_eScanState
					 = SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADDRESS_HOST;
					return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADDRESS_HOST:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;

				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(),
												  INET_IMAP_CANONIC_NIL))
					{
						if (rThis.m_bFetchResponseEnvelopeAdrMailboxNIL)
						{
							rThis.m_aFetchResponseEnvelopeAdr
							 += ';';
							rThis.m_eFetchResponseEnvelopeAdrPrefix
							 = PREFIX_COMMA;
						}
						else
						{
							switch (rThis.m_eFetchResponseEnvelopeAdrPrefix)
							{
								case PREFIX_SPACE:
									rThis.m_aFetchResponseEnvelopeAdr
									 += ' ';
									break;

								case PREFIX_COMMA:
									rThis.m_aFetchResponseEnvelopeAdr
									 += ", ";
									break;
							}
							rThis.m_aFetchResponseEnvelopeAdr
							 += makeRFC822Phrase
							     (rThis.m_aFetchResponseEnvelopeAdrMailbox);
							rThis.m_aFetchResponseEnvelopeAdr
							 += ':';
							rThis.m_eFetchResponseEnvelopeAdrPrefix
							 = PREFIX_SPACE;
						}

						rThis.m_eScanState
						 = SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADDRESS_CLOSE;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_QUOTED:
				case INetIMAPScannerToken::TYPE_LITERAL:
					switch (rThis.m_eFetchResponseEnvelopeAdrPrefix)
					{
						case PREFIX_SPACE:
							rThis.m_aFetchResponseEnvelopeAdr
							 += ' ';
							break;

						case PREFIX_COMMA:
							rThis.m_aFetchResponseEnvelopeAdr
							 += ", ";
							break;
					}
					if (rThis.m_aFetchResponseEnvelopeAdrName.Len())
					{
						rThis.m_aFetchResponseEnvelopeAdr
						 += makeRFC822Phrase
						     (rThis.m_aFetchResponseEnvelopeAdrName);
						rThis.m_aFetchResponseEnvelopeAdr += ' ';
					}
					rThis.m_aFetchResponseEnvelopeAdr += '<';
					if (rThis.m_aFetchResponseEnvelopeAdrADL.Len())
					{
						rThis.m_aFetchResponseEnvelopeAdr
						 += rThis.m_aFetchResponseEnvelopeAdrADL;
						rThis.m_aFetchResponseEnvelopeAdr += ':';
					}
					rThis.m_aFetchResponseEnvelopeAdr
					 += rThis.m_aFetchResponseEnvelopeAdrMailbox;
					rThis.m_aFetchResponseEnvelopeAdr += '@';
					rThis.m_aFetchResponseEnvelopeAdr += rToken.getText();
					rThis.m_aFetchResponseEnvelopeAdr += '>';
					rThis.m_eFetchResponseEnvelopeAdrPrefix = PREFIX_COMMA;

					rThis.m_eScanState
					 = SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADDRESS_CLOSE;
					return INetIMAPScanner::MODE_ATOM;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADDRESS_CLOSE:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == ')')
					{
						rThis.m_eScanState
						 = SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADDRESS_LIST;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}


		case SCAN_STATE_RESPONSE_FETCH_ENVELOPE_IN_REPLY_TO:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;

				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(),
												  INET_IMAP_CANONIC_NIL))
					{
						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_ENVELOPE_MESSAGE_ID;
						return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_QUOTED:
				case INetIMAPScannerToken::TYPE_LITERAL:
					static_cast< INetIMAPFetchResponse * >(rThis.
														       m_pResponse)->
						setEnvelopeInReplyTo(rToken.getText());

					rThis.m_eScanState
						= SCAN_STATE_RESPONSE_FETCH_ENVELOPE_MESSAGE_ID;
					return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_ENVELOPE_MESSAGE_ID:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;

				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(),
												  INET_IMAP_CANONIC_NIL))
					{
						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_ENVELOPE_CLOSE;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_QUOTED:
				case INetIMAPScannerToken::TYPE_LITERAL:
					static_cast< INetIMAPFetchResponse * >(rThis.
														       m_pResponse)->
						setEnvelopeMessageID(rToken.getText());

					rThis.m_eScanState
						= SCAN_STATE_RESPONSE_FETCH_ENVELOPE_CLOSE;
					return INetIMAPScanner::MODE_ATOM;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_ENVELOPE_CLOSE:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == ')')
					{
						rThis.m_eScanState = SCAN_STATE_RESPONSE_FETCH_ATTRIB;
						return INetIMAPScanner::MODE_RESTRICTED;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_FLAGS:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == '(')
					{
						static_cast< INetIMAPFetchResponse * >(
							    rThis.m_pResponse)->
							setFlags();

						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_FLAGS_FLAG;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_FLAGS_FLAG:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == ')')
					{
						rThis.m_eScanState = SCAN_STATE_RESPONSE_FETCH_ATTRIB;
						return INetIMAPScanner::MODE_RESTRICTED;
					}
					else if (rToken.getChar() == '\\')
					{
						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_FLAGS_FLAG_SLASH;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_ATOM:
					static_cast< INetIMAPFetchResponse * >(rThis.
														       m_pResponse)->
						getFlagKeywords().append(rToken.getText());

					return INetIMAPScanner::MODE_ATOM;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_FLAGS_FLAG_SLASH:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(),
												  "ANSWERED"))
						static_cast< INetIMAPFetchResponse * >(
							    rThis.m_pResponse)->
							addFlags(INetIMAPFetchResponse::FLAG_ANSWERED);
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "FLAGGED"))
						static_cast< INetIMAPFetchResponse * >(
							    rThis.m_pResponse)->
							addFlags(INetIMAPFetchResponse::FLAG_FLAGGED);
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "DELETED"))
						static_cast< INetIMAPFetchResponse * >(
							    rThis.m_pResponse)->
							addFlags(INetIMAPFetchResponse::FLAG_DELETED);
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "SEEN"))
						static_cast< INetIMAPFetchResponse * >(
							    rThis.m_pResponse)->
							addFlags(INetIMAPFetchResponse::FLAG_SEEN);
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "DRAFT"))
						static_cast< INetIMAPFetchResponse * >(
							    rThis.m_pResponse)->
							addFlags(INetIMAPFetchResponse::FLAG_DRAFT);
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "RECENT"))
						static_cast< INetIMAPFetchResponse * >(
							    rThis.m_pResponse)->
							addFlags(INetIMAPFetchResponse::FLAG_RECENT);

					rThis.m_eScanState = SCAN_STATE_RESPONSE_FETCH_FLAGS_FLAG;
					return INetIMAPScanner::MODE_ATOM;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_INTERNALDATE:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM_QUOTED;

				case INetIMAPScannerToken::TYPE_QUOTED:
				{
					DateTime aInternalDate(0, 0);
					if (INetCoreRFC822Message().ParseDateField(
						UniString(rToken.getText(), RTL_TEXTENCODING_ASCII_US),
						aInternalDate, aInternalDate))
						static_cast< INetIMAPFetchResponse * >(
							    rThis.m_pResponse)->
							setInternalDate(aInternalDate);

					rThis.m_eScanState = SCAN_STATE_RESPONSE_FETCH_ATTRIB;
					return INetIMAPScanner::MODE_RESTRICTED;
				}

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_RFC822:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_RESTRICTED_QUOTED_LITERAL;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == '.')
					{
						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_RFC822_DOT;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(),
												  INET_IMAP_CANONIC_NIL))
					{
						rThis.m_pFetchResponseBodySection
							= new INetIMAPFetchResponseBodySection;
						rThis.m_pFetchResponseBodySection->
							appendSectionText(
								INetIMAPBodySectionDescriptor::RFC822);
						static_cast< INetIMAPFetchResponse * >(
							    rThis.m_pResponse)->
							appendBodySection(
								rThis.m_pFetchResponseBodySection);
						rThis.m_pFetchResponseBodySection = 0;

						rThis.m_eScanState = SCAN_STATE_RESPONSE_FETCH_ATTRIB;
						return INetIMAPScanner::MODE_RESTRICTED;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_QUOTED:
				case INetIMAPScannerToken::TYPE_LITERAL:
					rThis.m_pFetchResponseBodySection
						= new INetIMAPFetchResponseBodySection;
					rThis.m_pFetchResponseBodySection->
						appendSectionText(
							INetIMAPBodySectionDescriptor::RFC822);
					rThis.createFetchResponseBodySectionParser();
					rThis.m_pFetchResponseBodySectionParser->
						Write(rToken.getText().GetBuffer(),
							  rToken.getText().Len());
					delete rThis.m_pFetchResponseBodySectionParser->
						       GetTargetMessage()->GetDocumentStream();
					rThis.m_pFetchResponseBodySection->
						setData(rThis.m_pFetchResponseBodySectionParser->
								    GetTargetMessage());
					static_cast< INetIMAPFetchResponse * >(rThis.
														       m_pResponse)->
						appendBodySection(rThis.m_pFetchResponseBodySection);
					rThis.m_pFetchResponseBodySection = 0;
					delete rThis.m_pFetchResponseBodySectionParser;
					rThis.m_pFetchResponseBodySectionParser = 0;

					rThis.m_eScanState = SCAN_STATE_RESPONSE_FETCH_ATTRIB;
					return INetIMAPScanner::MODE_RESTRICTED;

				case INetIMAPScannerToken::TYPE_QUOTED_TOO_LONG:
				case INetIMAPScannerToken::TYPE_LITERAL_TOO_LONG:
					rThis.m_pFetchResponseBodySection
						= new INetIMAPFetchResponseBodySection;
					rThis.m_pFetchResponseBodySection->
						appendSectionText(
							INetIMAPBodySectionDescriptor::RFC822);
					rThis.createFetchResponseBodySectionParser();
					rThis.m_pFetchResponseBodySectionParser->
						Write(rToken.getText().GetBuffer(),
							  rToken.getText().Len());

					rThis.m_eScanState = SCAN_STATE_RESPONSE_FETCH_BODY_LONG;
					return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_RFC822_DOT:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(), "HEADER"))
					{
						rThis.m_pFetchResponseBodySection
							= new INetIMAPFetchResponseBodySection;
						rThis.m_pFetchResponseBodySection->
							appendSectionText(
								INetIMAPBodySectionDescriptor::RFC822_HEADER);

						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_BODY_DATA;
						return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
					}
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "TEXT"))
					{
						rThis.m_pFetchResponseBodySection
							= new INetIMAPFetchResponseBodySection;
						rThis.m_pFetchResponseBodySection->
							appendSectionText(
								INetIMAPBodySectionDescriptor::RFC822_TEXT);

						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_BODY_DATA;
						return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
					}
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "SIZE"))
					{
						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_RFC822_SIZE;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_RFC822_SIZE:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_ATOM:
				{
					sal_Char const * p = rToken.getText().GetBuffer();
					sal_Char const * pEnd = p + rToken.getText().Len();
					sal_uInt32 nNumber;
					if (INetMIME::scanUnsigned(p, pEnd, true, nNumber)
						&& p == pEnd)
					{
						static_cast< INetIMAPFetchResponse * >(
							    rThis.m_pResponse)->
							setRFC822Size(nNumber);

						rThis.m_eScanState = SCAN_STATE_RESPONSE_FETCH_ATTRIB;
						return INetIMAPScanner::MODE_RESTRICTED;
					}
					else
						goto invalid;
				}

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_BODY:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_RESTRICTED;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == '(')
					{
						rThis.m_nFetchResponseBodyLevel = 0;

						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_BODY_LIST;
						return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
					}
					else if (rToken.getChar() == '[')
					{
						rThis.m_pFetchResponseBodySection
							= new INetIMAPFetchResponseBodySection;

						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_BODY_SECTION;
						return INetIMAPScanner::MODE_RESTRICTED;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_BODY_LIST:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
				case INetIMAPScannerToken::TYPE_ATOM:
				case INetIMAPScannerToken::TYPE_ATOM_TOO_LONG:
				case INetIMAPScannerToken::TYPE_QUOTED:
				case INetIMAPScannerToken::TYPE_QUOTED_TOO_LONG:
				case INetIMAPScannerToken::TYPE_LITERAL:
				case INetIMAPScannerToken::TYPE_LITERAL_TOO_LONG:
					return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == '(')
					{
						++rThis.m_nFetchResponseBodyLevel;
						return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
					}
					else if (rToken.getChar() == ')')
					{
						if (rThis.m_nFetchResponseBodyLevel--)
							return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
						else
						{
							rThis.m_eScanState
								= SCAN_STATE_RESPONSE_FETCH_ATTRIB;
							return INetIMAPScanner::MODE_RESTRICTED;
						}
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_BODYSTRUCTURE:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == '(')
					{
						rThis.m_nFetchResponseBodyLevel = 0;

						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_BODY_LIST;
						return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_BODY_SECTION:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_RESTRICTED;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == ']')
					{
						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_BODY_PARTIAL;
						return
							INetIMAPScanner::MODE_RESTRICTED_QUOTED_LITERAL;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(), "HEADER"))
					{
						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_HEADER;
						return INetIMAPScanner::MODE_RESTRICTED;
					}
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "TEXT"))
					{
						rThis.m_pFetchResponseBodySection->
							appendSectionText(
							INetIMAPBodySectionDescriptor::SECTION_TEXT_TEXT);

						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_CLOSE;
						return INetIMAPScanner::MODE_RESTRICTED;
					}
					else
					{
						sal_Char const * p = rToken.getText().GetBuffer();
						sal_Char const * pEnd = p + rToken.getText().Len();
						sal_uInt32 nNumber;
						if (INetMIME::scanUnsigned(p, pEnd, true, nNumber)
							&& p == pEnd)
						{
							rThis.m_pFetchResponseBodySection->
								appendSectionNumber(nNumber);
							rThis.m_eScanState
							  = SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_NUMBER;
							return INetIMAPScanner::MODE_RESTRICTED;
						}
						else
							goto invalid;
					}

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_NUMBER:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_RESTRICTED;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == '.')
					{
						rThis.m_eScanState
						  = SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_NUMBER_DOT;
						return INetIMAPScanner::MODE_RESTRICTED;
					}
					else if (rToken.getChar() == ']')
					{
						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_BODY_PARTIAL;
						return
							INetIMAPScanner::MODE_RESTRICTED_QUOTED_LITERAL;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_NUMBER_DOT:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_RESTRICTED;

				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(), "HEADER"))
					{
						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_HEADER;
						return INetIMAPScanner::MODE_RESTRICTED;
					}
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "TEXT"))
					{
						rThis.m_pFetchResponseBodySection->
							appendSectionText(
							INetIMAPBodySectionDescriptor::SECTION_TEXT_TEXT);

						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_CLOSE;
						return INetIMAPScanner::MODE_RESTRICTED;
					}
					else if (INetMIME::equalIgnoreCase(rToken.getText(),
													   "MIME"))
					{
						rThis.m_pFetchResponseBodySection->
							appendSectionText(
							INetIMAPBodySectionDescriptor::SECTION_TEXT_MIME);

						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_CLOSE;
						return INetIMAPScanner::MODE_RESTRICTED;
					}
					else
					{
						sal_Char const * p = rToken.getText().GetBuffer();
						sal_Char const * pEnd = p + rToken.getText().Len();
						sal_uInt32 nNumber;
						if (INetMIME::scanUnsigned(p, pEnd, true, nNumber)
							&& p == pEnd)
						{
							rThis.m_pFetchResponseBodySection->
								appendSectionNumber(nNumber);
							rThis.m_eScanState
							  = SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_NUMBER;
							return INetIMAPScanner::MODE_RESTRICTED;
						}
						else
							goto invalid;
					}

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_HEADER:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_RESTRICTED;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == '.')
					{
						rThis.m_eScanState
						  = SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_HEADER_DOT;
						return INetIMAPScanner::MODE_RESTRICTED;
					}
					else if (rToken.getChar() == ']')
					{
						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_BODY_PARTIAL;
						return
							INetIMAPScanner::MODE_RESTRICTED_QUOTED_LITERAL;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_HEADER_DOT:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_RESTRICTED;

				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(), "FIELDS"))
					{
						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_FIELDS;
						return INetIMAPScanner::MODE_RESTRICTED;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_FIELDS:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_RESTRICTED;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == '(')
					{
						rThis.m_pFetchResponseBodySection->
							appendSectionText(
				   INetIMAPBodySectionDescriptor::SECTION_TEXT_HEADER_FIELDS);

						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_FNAME;
						return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
					}
					else if (rToken.getChar() == '.')
					{
						rThis.m_eScanState
						  = SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_FIELDS_DOT;
						return INetIMAPScanner::MODE_RESTRICTED;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_FIELDS_DOT:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_RESTRICTED;

				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(), "NOT"))
					{
						rThis.m_pFetchResponseBodySection->
							appendSectionText(
			   INetIMAPBodySectionDescriptor::SECTION_TEXT_HEADER_FIELDS_NOT);

						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_FOPEN;
						return INetIMAPScanner::MODE_ATOM;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_FOPEN:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == '(')
					{
						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_FNAME;
						return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_FNAME:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == ')'
						&& rThis.m_pFetchResponseBodySection->
						       getHeaderFields().getCount() != 0)
					{
						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_CLOSE;
						return INetIMAPScanner::MODE_RESTRICTED;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_ATOM:
				case INetIMAPScannerToken::TYPE_QUOTED:
				case INetIMAPScannerToken::TYPE_LITERAL:
					rThis.m_pFetchResponseBodySection->
						appendHeaderField(rToken.getText());

					return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_CLOSE:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_RESTRICTED;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == ']')
					{
						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_BODY_PARTIAL;
						return
							INetIMAPScanner::MODE_RESTRICTED_QUOTED_LITERAL;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_BODY_PARTIAL:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_RESTRICTED_QUOTED_LITERAL;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == '<')
					{
						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_BODY_PARTIAL_NUMBER;
						return INetIMAPScanner::MODE_RESTRICTED;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(),
												  INET_IMAP_CANONIC_NIL))
					{
						static_cast< INetIMAPFetchResponse * >(
							    rThis.m_pResponse)->
							appendBodySection(
								rThis.m_pFetchResponseBodySection);
						rThis.m_pFetchResponseBodySection = 0;

						rThis.m_eScanState = SCAN_STATE_RESPONSE_FETCH_ATTRIB;
						return INetIMAPScanner::MODE_RESTRICTED;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_QUOTED:
				case INetIMAPScannerToken::TYPE_LITERAL:
				{
					rThis.createFetchResponseBodySectionParser();
					rThis.m_pFetchResponseBodySectionParser->
						Write(rToken.getText().GetBuffer(),
							  rToken.getText().Len());
					delete rThis.m_pFetchResponseBodySectionParser->
						       GetTargetMessage()->GetDocumentStream();
					rThis.m_pFetchResponseBodySection->
						setData(rThis.m_pFetchResponseBodySectionParser->
								    GetTargetMessage());
					static_cast< INetIMAPFetchResponse * >(rThis.
														       m_pResponse)->
						appendBodySection(rThis.m_pFetchResponseBodySection);
					rThis.m_pFetchResponseBodySection = 0;
					delete rThis.m_pFetchResponseBodySectionParser;
					rThis.m_pFetchResponseBodySectionParser = 0;

					rThis.m_eScanState = SCAN_STATE_RESPONSE_FETCH_ATTRIB;
					return INetIMAPScanner::MODE_RESTRICTED;
				}

				case INetIMAPScannerToken::TYPE_QUOTED_TOO_LONG:
				case INetIMAPScannerToken::TYPE_LITERAL_TOO_LONG:
				{
					rThis.createFetchResponseBodySectionParser();
					rThis.m_pFetchResponseBodySectionParser->
						Write(rToken.getText().GetBuffer(),
							  rToken.getText().Len());

					rThis.m_eScanState = SCAN_STATE_RESPONSE_FETCH_BODY_LONG;
					return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
				}

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_BODY_PARTIAL_NUMBER:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_RESTRICTED;

				case INetIMAPScannerToken::TYPE_ATOM:
				{
					sal_Char const * p = rToken.getText().GetBuffer();
					sal_Char const * pEnd = p + rToken.getText().Len();
					sal_uInt32 nNumber;
					if (INetMIME::scanUnsigned(p, pEnd, true, nNumber)
						&& p == pEnd)
					{
						rThis.m_pFetchResponseBodySection->
							setPartial(nNumber);

						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_BODY_PARTIAL_CLOSE;
						return INetIMAPScanner::MODE_RESTRICTED;
					}
					else
						goto invalid;
				}

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_BODY_PARTIAL_CLOSE:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_RESTRICTED_QUOTED_LITERAL;

				case INetIMAPScannerToken::TYPE_SPECIAL:
					if (rToken.getChar() == '>')
					{
						rThis.m_eScanState
							= SCAN_STATE_RESPONSE_FETCH_BODY_DATA;
						return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
					}
					else
						goto invalid;

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_BODY_DATA:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;

				case INetIMAPScannerToken::TYPE_ATOM:
					if (INetMIME::equalIgnoreCase(rToken.getText(),
												  INET_IMAP_CANONIC_NIL))
					{
						static_cast< INetIMAPFetchResponse * >(
							    rThis.m_pResponse)->
							appendBodySection(
								rThis.m_pFetchResponseBodySection);
						rThis.m_pFetchResponseBodySection = 0;

						rThis.m_eScanState = SCAN_STATE_RESPONSE_FETCH_ATTRIB;
						return INetIMAPScanner::MODE_RESTRICTED;
					}
					else
						goto invalid;

				case INetIMAPScannerToken::TYPE_QUOTED:
				case INetIMAPScannerToken::TYPE_LITERAL:
				{
					rThis.createFetchResponseBodySectionParser();
					rThis.m_pFetchResponseBodySectionParser->
						Write(rToken.getText().GetBuffer(),
							  rToken.getText().Len());
					delete rThis.m_pFetchResponseBodySectionParser->
					        GetTargetMessage()->GetDocumentStream();
					rThis.m_pFetchResponseBodySection->
						setData(rThis.m_pFetchResponseBodySectionParser->
								    GetTargetMessage());
					static_cast< INetIMAPFetchResponse * >(rThis.
														       m_pResponse)->
						appendBodySection(rThis.m_pFetchResponseBodySection);
					rThis.m_pFetchResponseBodySection = 0;
					delete rThis.m_pFetchResponseBodySectionParser;
					rThis.m_pFetchResponseBodySectionParser = 0;

					rThis.m_eScanState = SCAN_STATE_RESPONSE_FETCH_ATTRIB;
					return INetIMAPScanner::MODE_RESTRICTED;
				}

				case INetIMAPScannerToken::TYPE_QUOTED_TOO_LONG:
				case INetIMAPScannerToken::TYPE_LITERAL_TOO_LONG:
				{
					rThis.createFetchResponseBodySectionParser();
					rThis.m_pFetchResponseBodySectionParser->
						Write(rToken.getText().GetBuffer(),
							  rToken.getText().Len());

					rThis.m_eScanState = SCAN_STATE_RESPONSE_FETCH_BODY_LONG;
					return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
				}

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_BODY_LONG:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_QUOTED:
				case INetIMAPScannerToken::TYPE_LITERAL:
				{
					rThis.m_pFetchResponseBodySectionParser->
						Write(rToken.getText().GetBuffer(),
							  rToken.getText().Len());
					delete rThis.m_pFetchResponseBodySectionParser->
						       GetTargetMessage()->GetDocumentStream();
					rThis.m_pFetchResponseBodySection->
						setData(rThis.m_pFetchResponseBodySectionParser->
								    GetTargetMessage());
					static_cast< INetIMAPFetchResponse * >(rThis.
														       m_pResponse)->
						appendBodySection(rThis.m_pFetchResponseBodySection);
					rThis.m_pFetchResponseBodySection = 0;
					delete rThis.m_pFetchResponseBodySectionParser;
					rThis.m_pFetchResponseBodySectionParser = 0;

					rThis.m_eScanState = SCAN_STATE_RESPONSE_FETCH_ATTRIB;
					return INetIMAPScanner::MODE_RESTRICTED;
				}

				case INetIMAPScannerToken::TYPE_QUOTED_TOO_LONG:
				case INetIMAPScannerToken::TYPE_LITERAL_TOO_LONG:
				{
					rThis.m_pFetchResponseBodySectionParser->
						Write(rToken.getText().GetBuffer(),
							  rToken.getText().Len());

					return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
				}

				default:
					goto invalid;
			}

		case SCAN_STATE_RESPONSE_FETCH_UID:
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_SPACE:
					return INetIMAPScanner::MODE_ATOM;

				case INetIMAPScannerToken::TYPE_ATOM:
				{
					sal_Char const * p = rToken.getText().GetBuffer();
					sal_Char const * pEnd = p + rToken.getText().Len();
					sal_uInt32 nNumber;
					if (INetMIME::scanUnsigned(p, pEnd, true, nNumber)
						&& p == pEnd && nNumber != 0)
					{
						static_cast< INetIMAPFetchResponse * >(
							    rThis.m_pResponse)->
							setUID(nNumber);
						rThis.m_eScanState = SCAN_STATE_RESPONSE_FETCH_ATTRIB;
						return INetIMAPScanner::MODE_RESTRICTED;
					}
					else
						goto invalid;
				}

				default:
					goto invalid;
			}

	invalid:
			delete rThis.m_pListResponseMailbox;
			rThis.m_pListResponseMailbox = 0;
			delete rThis.m_pFetchResponseBodySection;
			rThis.m_pFetchResponseBodySection = 0;
			if (rThis.m_pFetchResponseBodySectionParser)
			{
				if (rThis.m_pFetchResponseBodySectionParser->
					 GetTargetMessage())
				{
					delete rThis.m_pFetchResponseBodySectionParser->
						       GetTargetMessage()->GetDocumentStream();
					delete rThis.m_pFetchResponseBodySectionParser->
						       GetTargetMessage();
				}
				delete rThis.m_pFetchResponseBodySectionParser;
				rThis.m_pFetchResponseBodySectionParser = 0;
			}
			delete rThis.m_pResponse;
			rThis.m_pResponse = 0;
			rThis.m_eScanState = SCAN_STATE_INVALID;
		default: // SCAN_STATE_INVALID
			switch (rToken.getType())
			{
				case INetIMAPScannerToken::TYPE_NEWLINE:
				{
					INetIMAPInvalidResponse aResponse
						= INetIMAPASCII::convertToUnicode(
							  rThis.m_aLine.GetBuffer(),
							  rThis.m_aLine.GetBuffer()
							      + rThis.m_aLine.Len());
					if (!rThis.callBack(aResponse))
						return INetIMAPScanner::MODE_ABORTED;

					rThis.m_aLine.Erase();
					rThis.m_eScanState = SCAN_STATE_INITIAL;
					return INetIMAPScanner::MODE_ATOM;
				}

				default:
					return INetIMAPScanner::MODE_TEXT;
			}
	}
}

