/*************************************************************************
 *
 *  $RCSfile: ftpdata.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/03/19 12:38:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Matthias Huetsch <matthias.huetsch@sun.com>
 *
 *
 ************************************************************************/

#ifndef _INET_FTPDATA_HXX
#define _INET_FTPDATA_HXX "$Revision: 1.2 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _VOS_OBJECT_HXX_
#include <vos/object.hxx>
#endif

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _INET_SOCKET_HXX
#include <inet/socket.hxx>
#endif

#ifndef _INETFTP_HXX
#include <inetftp.hxx>
#endif

#ifdef _USE_NAMESPACE
namespace inet {
#endif

/*======================================================================
 *
 * INetFTPData internals.
 *
 *====================================================================*/
struct INetFTPDataContext;
class  INetFTPInputStream;
class  INetFTPOutputStream;

#ifndef COPYCTOR_API
#define COPYCTOR_API(C) C (const C&); C& operator= (const C&)
#endif

#ifndef INETFTP_SOCKET_INVALID
#define INETFTP_SOCKET_INVALID (-osl_Socket_E_NotSocket)
#endif

#ifndef INETFTP_SOCKET_WOULDBLOCK
#define INETFTP_SOCKET_WOULDBLOCK (-osl_Socket_E_WouldBlock)
#endif

/*========================================================================
 *
 * INetFTPDataContext interface.
 *
 *======================================================================*/
struct INetFTPDataContext : public NAMESPACE_VOS(OMutex)
{
	/** State.
	 */
	enum State
	{
		STATE_ABORT = -2,
		STATE_ERROR = -1,
		STATE_NONE  =  0,

		STATE_PORT,
		STATE_OPEN,
		STATE_XFER,
		STATE_DONE
	};

	/** StateBlock.
	 */
	struct StateBlock
	{
		State     m_ePrev;
		State     m_eState;
		sal_Int32 m_nState;

		StateBlock (void)
			: m_ePrev (STATE_NONE), m_eState (STATE_NONE), m_nState (0)
		{}

		/** State.
		 */
		State getState (void) const { return m_eState; }
		void  setState (State eState)
		{
			m_ePrev  = m_eState;
			m_eState = eState;
		}

		/** State code.
		 */
		sal_Int32 getStateCode (void) const { return m_nState; }
		void setStateCode (sal_Int32 nState)
		{
			m_nState = nState;
		}
	};

	/** ParamBlock.
	 */
	struct ParamBlock
	{
		INetFTPConnection::DataType m_eDataType;
		INetFTPConnection::ListType m_eListType;

		sal_uInt32                  m_nOffset;

		sal_uInt32                  m_nRecvCount;
		sal_uInt32                  m_nSendCount;

		ParamBlock (void)
			: m_eDataType  (INetFTPConnection::DATA_TYPE_UNKNOWN),
			  m_eListType  (INetFTPConnection::LIST_TYPE_UNDETERMINED),
			  m_nRecvCount (0),
			  m_nSendCount (0)
		{}

		/** Data type.
		 */
		INetFTPConnection::DataType getDataType (void) const
		{
			return m_eDataType;
		}
		void setDataType (INetFTPConnection::DataType eType)
		{
			m_eDataType = eType;
		}

		/** List type.
		 */
		INetFTPConnection::ListType getListType (void) const
		{
			return m_eListType;
		}
		void setListType (INetFTPConnection::ListType eType)
		{
			m_eListType = eType;
		}

		/** Restart offset.
		 */
		sal_uInt32 getOffset (void) const
		{
			return m_nOffset;
		}
		void setOffset (sal_uInt32 nOffset)
		{
			m_nOffset = nOffset;
		}

		/** Recv count.
		 */
		sal_uInt32 getRecvCount (void) const
		{
			return m_nRecvCount;
		}
		void setRecvCount (sal_uInt32 nBytes)
		{
			m_nRecvCount = nBytes;
		}
		void incRecvCount (sal_uInt32 nBytes)
		{
			m_nRecvCount += nBytes;
		}

		/** Send count.
		 */
		sal_uInt32 getSendCount (void) const
		{
			return m_nSendCount;
		}
		void setSendCount (sal_uInt32 nBytes)
		{
			m_nSendCount = nBytes;
		}
		void incSendCount (sal_uInt32 nBytes)
		{
			m_nSendCount += nBytes;
		}
	};

	/** Representation.
	 */
	StateBlock                m_aStateBlk;
	ParamBlock                m_aParamBlk;

	NAMESPACE_VOS(ORef)<INetPassiveTCPSocket> m_xPasvSocket;
	NAMESPACE_VOS(ORef)<INetTCPSocket>        m_xDataSocket;

	sal_uInt32                m_nBufSiz;
	sal_Char                 *m_pBuffer;
	sal_Char                 *m_pRead;
	sal_Char                 *m_pWrite;

	INetFTPCallback          *m_pfnCB;
	void                     *m_pDataCB;

	/** Construction, destruction.
	 */
	INetFTPDataContext (sal_uInt32 nBufSiz = 16384);
	~INetFTPDataContext (void);

	/** State.
	 */
	State getState (void) const
	{
		return m_aStateBlk.getState();
	}
	void setState (State eState)
	{
		NAMESPACE_VOS(OGuard) aGuard (*this);
		m_aStateBlk.setState (eState);
	}

	/** StateCode.
	 */
	sal_Int32 getStateCode (void) const
	{
		return m_aStateBlk.getStateCode();
	}
	void setStateCode (sal_Int32 nState)
	{
		NAMESPACE_VOS(OGuard) aGuard (*this);
		m_aStateBlk.setStateCode (nState);
	}

	/** DataType.
	 */
	INetFTPConnection::DataType getDataType (void) const
	{
		return m_aParamBlk.getDataType();
	}
	void setDataType (INetFTPConnection::DataType eType)
	{
		NAMESPACE_VOS(OGuard) aGuard (*this);
		m_aParamBlk.setDataType (eType);
	}

	/** ListType.
	 */
	INetFTPConnection::ListType getListType (void) const
	{
		return m_aParamBlk.getListType();
	}
	void setListType (INetFTPConnection::ListType eType)
	{
		NAMESPACE_VOS(OGuard) aGuard (*this);
		m_aParamBlk.setListType (eType);
	}
	void setListType (const rtl::OUString &rPath);

	/** Restart offset.
	 */
	sal_uInt32 getOffset (void) const
	{
		return m_aParamBlk.getOffset();
	}
	void setOffset (sal_uInt32 nOffset)
	{
		NAMESPACE_VOS(OGuard) aGuard (*this);
		m_aParamBlk.setOffset (nOffset);
	}

	/** RecvCount.
	 */
	sal_uInt32 getRecvCount (void) const
	{
		return m_aParamBlk.getRecvCount();
	}
	void setRecvCount (sal_uInt32 nBytes)
	{
		NAMESPACE_VOS(OGuard) aGuard (*this);
		m_aParamBlk.setRecvCount (nBytes);
	}

	/** SendCount.
	 */
	sal_uInt32 getSendCount (void) const
	{
		return m_aParamBlk.getSendCount();
	}
	void setSendCount (sal_uInt32 nBytes)
	{
		NAMESPACE_VOS(OGuard) aGuard (*this);
		m_aParamBlk.setSendCount (nBytes);
	}

	/** Transfer callback.
	 */
	void setCallback (INetFTPCallback *pfnCB, void *pDataCB)
	{
		NAMESPACE_VOS(OGuard) aGuard (*this);
		m_pfnCB   = pfnCB;
		m_pDataCB = pDataCB;
	}

	/** Operation.
	 */
	sal_Int32 send (INetFTPInputStream  *pStrm);
	sal_Int32 recv (INetFTPOutputStream *pStrm);
};

/*========================================================================
 *
 * INetFTPInputStream interface.
 *
 *======================================================================*/
class INetFTPInputStream : public NAMESPACE_VOS(OObject)
{
	VOS_DECLARE_CLASSINFO (VOS_NAMESPACE (INetFTPInputStream, inet));

public:
	INetFTPInputStream (void);
	virtual ~INetFTPInputStream (void);

	/** getOffset.
	 */
	virtual sal_uInt32 getOffset (void) const = 0;

	/** read.
	 */
	inline sal_Int32 read (
		sal_Char *pData, sal_uInt32 nSize, void *pCtx);

protected:
	/** getData.
	 */
	virtual sal_Int32 getData (
		sal_Char *pData, sal_uInt32 nSize, void *pCtx) = 0;

private:
	/** Not implemented.
	 */
	COPYCTOR_API (INetFTPInputStream);
};

inline sal_Int32 INetFTPInputStream::read (
	sal_Char *pData, sal_uInt32 nSize, void *pCtx)
{
	return getData (pData, nSize, pCtx);
}

/*========================================================================
 *
 * INetFTPOutputStream interface.
 *
 *======================================================================*/
class INetFTPOutputStream : public NAMESPACE_VOS(OObject)
{
	VOS_DECLARE_CLASSINFO (VOS_NAMESPACE (INetFTPOutputStream, inet));

public:
	INetFTPOutputStream (void);
	virtual ~INetFTPOutputStream (void);

	/** getOffset.
	 */
	virtual sal_uInt32 getOffset (void) const = 0;

	/** write.
	 */
	inline sal_Int32 write (
		const sal_Char *pData, sal_uInt32 nSize, void *pCtx);

protected:
	/** putData.
	 */
	virtual sal_Int32 putData (
		const sal_Char *pData, sal_uInt32 nSize, void *pCtx) = 0;

private:
	/** Not implemented.
	 */
	COPYCTOR_API (INetFTPOutputStream);
};

inline sal_Int32 INetFTPOutputStream::write (
	const sal_Char *pData, sal_uInt32 nSize, void *pCtx)
{
	return putData (pData, nSize, pCtx);
}

/*========================================================================
 *
 * INetFTPStoreStream interface.
 *
 *======================================================================*/
class INetFTPStoreStream : public INetFTPInputStream
{
	VOS_DECLARE_CLASSINFO (VOS_NAMESPACE (INetFTPStoreStream, inet));

public:
	INetFTPStoreStream (
		SvLockBytes *pLockBytes, sal_uInt32 nOffset = 0);
	virtual ~INetFTPStoreStream (void);

	/** getOffset.
	 */
	virtual sal_uInt32 getOffset (void) const;

private:
	/** Representation.
	 */
	SvStream   m_aStrm;
	sal_uInt32 m_nOffset;

	/** getData.
	 */
	virtual sal_Int32 getData (
		sal_Char *pData, sal_uInt32 nSize, void *pCtx);

	/** Not implemented.
	 */
	COPYCTOR_API (INetFTPStoreStream);
};

/*========================================================================
 *
 * INetFTPRetrieveStream interface.
 *
 *======================================================================*/
class INetFTPRetrieveStream : public INetFTPOutputStream
{
	VOS_DECLARE_CLASSINFO (VOS_NAMESPACE (INetFTPRetrieveStream, inet));

public:
	INetFTPRetrieveStream (
		SvOpenLockBytes *pLockBytes, sal_uInt32 nOffset = 0);
	virtual ~INetFTPRetrieveStream (void);

	/** getOffset.
	 */
	virtual sal_uInt32 getOffset (void) const;

private:
	/** Representation.
	 */
	SvOpenLockBytesRef m_xLockBytes;
	sal_uInt32         m_nOffset;

	/** putData.
	 */
	virtual sal_Int32 putData (
		const sal_Char *pData, sal_uInt32 nSize, void *pCtx);

	/** Not implemented.
	 */
	COPYCTOR_API (INetFTPRetrieveStream);
};

/*========================================================================
 *
 * INetFTPDirectoryStream interface.
 *
 *======================================================================*/
class INetFTPDirectoryStream : public INetFTPOutputStream
{
	VOS_DECLARE_CLASSINFO (VOS_NAMESPACE (INetFTPDirectoryStream, inet));

public:
	INetFTPDirectoryStream (
		List &rList,
		INetFTPConnection::ListType eType =
		INetFTPConnection::LIST_TYPE_UNKNOWN);
	virtual ~INetFTPDirectoryStream (void);

	/** getOffset.
	 */
	virtual sal_uInt32 getOffset (void) const;

private:
	/** Representation.
	 */
	SvMemoryStream               m_aBuffer;
	List                        &m_rList;
	INetFTPConnection::ListType  m_eType;

	/** putData.
	 */
	virtual sal_Int32 putData (
		const sal_Char *pData, sal_uInt32 nSize, void *pCtx);

	/** putLine.
	 */
	sal_Int32 putLine (
		const sal_Char *pBuffer, sal_uInt32 nLength);

	/** Not implemented.
	 */
	COPYCTOR_API (INetFTPDirectoryStream);
};

/*========================================================================
 *
 * The End.
 *
 *======================================================================*/
#ifdef _USE_NAMESPACE
}
#endif

#endif /* !_INET_FTPDATA_HXX */

