/*************************************************************************
 *
 *  $RCSfile: inetstrm.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: th $ $Date: 2001/05/11 12:11:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _INETCORESTRM_CXX "$Revision: 1.2 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _RTL_ALLOC_H_
#include <rtl/alloc.h>
#endif
#ifndef _RTL_MEMORY_H_
#include <rtl/memory.h>
#endif
#ifndef _RTL_STRING_H_
#include <rtl/string.h>
#endif

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _INETCOREMSG_HXX
#include "inetmsg.hxx"
#endif
#ifndef _INETCORESTRM_HXX
#include "inetstrm.hxx"
#endif

//=======================================================================

inline sal_Bool ascii_isWhitespace( sal_Unicode ch )
{
    return ((ch <= 0x20) && ch);
}

inline sal_Unicode ascii_toLowerCase( sal_Unicode ch )
{
    if ( (ch >= 0x0041) && (ch <= 0x005A) )
        return ch + 0x20;
    else
        return ch;
}

sal_Unicode ascii_toUpperCase( sal_Unicode ch )
{
    if ( (ch >= 0x0061) && (ch <= 0x007A) )
        return ch - 0x20;
    else
        return ch;
}

/*========================================================================
 *
 * Debug trace environment.
 *
 *=======================================================================*/
#ifdef DBG_UTIL_PRIVATE
#include <stdio.h>

#define _TRACELOGNAME "c:\\inetstrm.log"

#ifdef WIN
#define _TRACELOGFORMAT "%ls\n"
#else
#define _TRACELOGFORMAT "%s\n"
#endif

#define _TRACE(a) \
{ \
    FILE *fp = fopen (_TRACELOGNAME, "a+"); \
    if (fp) \
    { \
        fprintf (fp, _TRACELOGFORMAT, (const char *)((a))); \
        fclose (fp); \
    } \
}

#else
#define _TRACE(a)
#endif /* DBG_UTIL_PRIVATE */

/*=======================================================================
 *
 * INetCoreRFC822Message Implementation.
 *
 *=====================================================================*/
inline const ByteString&
INetCoreRFC822Message::GetBCC_Impl (void) const
{
    return m_aBCC;
}

inline const ByteString&
INetCoreRFC822Message::GetCC_Impl (void) const
{
    return m_aCC;
}

inline const ByteString&
INetCoreRFC822Message::GetComments_Impl (void) const
{
    return m_aComments;
}

inline const ByteString&
INetCoreRFC822Message::GetDate_Impl (void) const
{
    return m_aDate;
}

inline const ByteString&
INetCoreRFC822Message::GetEncoding_Impl (void) const
{
    return m_aEncoding;
}

inline const ByteString&
INetCoreRFC822Message::GetFrom_Impl (void) const
{
    return m_aFrom;
}

inline const ByteString&
INetCoreRFC822Message::GetInReplyTo_Impl (void) const
{
    return m_aInReplyTo;
}

inline const ByteString&
INetCoreRFC822Message::GetKeywords_Impl (void) const
{
    return m_aKeywords;
}

inline const ByteString&
INetCoreRFC822Message::GetMessageID_Impl (void) const
{
    return m_aMessageID;
}

inline const ByteString&
INetCoreRFC822Message::GetReceived_Impl (void) const
{
    return m_aReceived;
}

inline const ByteString&
INetCoreRFC822Message::GetReferences_Impl (void) const
{
    return m_aReferences;
}

inline const ByteString&
INetCoreRFC822Message::GetReplyTo_Impl (void) const
{
    return m_aReplyTo;
}

inline const ByteString&
INetCoreRFC822Message::GetReturnPath_Impl (void) const
{
    return m_aReturnPath;
}

inline const ByteString&
INetCoreRFC822Message::GetSubject_Impl (void) const
{
    return m_aSubject;
}

inline const ByteString&
INetCoreRFC822Message::GetSender_Impl (void) const
{
    return m_aSender;
}

inline const ByteString&
INetCoreRFC822Message::GetTo_Impl (void) const
{
    return m_aTo;
}

inline const ByteString&
INetCoreRFC822Message::GetXMailer_Impl (void) const
{
    return m_aXMailer;
}

inline const ByteString&
INetCoreRFC822Message::GetXPriority_Impl (void) const
{
    return m_aXPriority;
}

inline const ByteString&
INetCoreRFC822Message::GetReturnReceiptTo_Impl (void) const
{
    return m_aReturnReceiptTo;
}

inline void
INetCoreRFC822Message::SetBCC_Impl (const ByteString& rValue)
{
    m_aBCC = rValue;
}

inline void
INetCoreRFC822Message::SetCC_Impl (const ByteString& rValue)
{
    m_aCC = rValue;
}

inline void
INetCoreRFC822Message::SetComments_Impl (const ByteString& rValue)
{
    m_aComments = rValue;
}

inline void
INetCoreRFC822Message::SetDate_Impl (const ByteString& rValue)
{
    m_aDate = rValue;
}

inline void
INetCoreRFC822Message::SetEncoding_Impl (const ByteString& rValue)
{
    m_aEncoding = rValue;
}

inline void
INetCoreRFC822Message::SetFrom_Impl (const ByteString& rValue)
{
    m_aFrom = rValue;
}

inline void
INetCoreRFC822Message::SetInReplyTo_Impl (const ByteString& rValue)
{
    m_aInReplyTo = rValue;
}

inline void
INetCoreRFC822Message::SetKeywords_Impl (const ByteString& rValue)
{
    m_aKeywords = rValue;
}

inline void
INetCoreRFC822Message::SetMessageID_Impl (const ByteString& rValue)
{
    m_aMessageID = rValue;
}

inline void
INetCoreRFC822Message::SetReceived_Impl (const ByteString& rValue)
{
    m_aReceived = rValue;
}

inline void
INetCoreRFC822Message::SetReferences_Impl (const ByteString& rValue)
{
    m_aReferences = rValue;
}

inline void
INetCoreRFC822Message::SetReplyTo_Impl (const ByteString& rValue)
{
    m_aReplyTo = rValue;
}

inline void
INetCoreRFC822Message::SetSubject_Impl (const ByteString& rValue)
{
    m_aSubject = rValue;
}

inline void
INetCoreRFC822Message::SetReturnPath_Impl (const ByteString& rValue)
{
    m_aReturnPath = rValue;
}

inline void
INetCoreRFC822Message::SetSender_Impl (const ByteString& rValue)
{
    m_aSender = rValue;
}

inline void
INetCoreRFC822Message::SetTo_Impl (const ByteString& rValue)
{
    m_aTo = rValue;
}

inline void
INetCoreRFC822Message::SetXMailer_Impl (const ByteString& rValue)
{
    m_aXMailer = rValue;
}

inline void
INetCoreRFC822Message::SetXPriority_Impl (const ByteString& rValue)
{
    m_aXPriority = rValue;
}

inline void
INetCoreRFC822Message::SetReturnReceiptTo_Impl (const ByteString& rValue)
{
    m_aReturnReceiptTo = rValue;
}

/*=======================================================================
 *
 * INetCoreMIMEMessage Implementation.
 *
 *=====================================================================*/
inline void
INetCoreMIMEMessage::SetChildCount_Impl (ULONG nCount)
{
    m_nChildren = nCount;
}

inline const ByteString&
INetCoreMIMEMessage::GetMultipartBoundary_Impl (void) const
{
    return m_aBoundary;
}

inline void
INetCoreMIMEMessage::SetMultipartBoundary_Impl (const ByteString& rValue)
{
    m_aBoundary = rValue;
}

inline const ByteString&
INetCoreMIMEMessage::GetMIMEVersion_Impl (void) const
{
    return m_aMIMEVersion;
}

inline const ByteString&
INetCoreMIMEMessage::GetContentBase_Impl (void) const
{
    return m_aContentBase;
}

inline const ByteString&
INetCoreMIMEMessage::GetContentDescription_Impl (void) const
{
    return m_aContentDescription;
}

inline const ByteString&
INetCoreMIMEMessage::GetContentDisposition_Impl (void) const
{
    return m_aContentDisposition;
}

inline const ByteString&
INetCoreMIMEMessage::GetContentID_Impl (void) const
{
    return m_aContentID;
}

inline const ByteString&
INetCoreMIMEMessage::GetContentLocation_Impl (void) const
{
    return m_aContentLocation;
}

inline const ByteString&
INetCoreMIMEMessage::GetContentType_Impl (void) const
{
    return m_aContentType;
}

inline const ByteString&
INetCoreMIMEMessage::GetContentTransferEncoding_Impl (void) const
{
    return m_aContentTransferEncoding;
}

inline void
INetCoreMIMEMessage::SetMIMEVersion_Impl (const ByteString& rValue)
{
    m_aMIMEVersion = rValue;
}

inline void
INetCoreMIMEMessage::SetContentBase_Impl (const ByteString& rValue)
{
    m_aContentBase = rValue;
}

inline void
INetCoreMIMEMessage::SetContentDescription_Impl (const ByteString& rValue)
{
    m_aContentDescription = rValue;
}

inline void
INetCoreMIMEMessage::SetContentDisposition_Impl (const ByteString& rValue)
{
    m_aContentDisposition = rValue;
}

inline void
INetCoreMIMEMessage::SetContentID_Impl (const ByteString& rValue)
{
    m_aContentID = rValue;
}

inline void
INetCoreMIMEMessage::SetContentLocation_Impl (const ByteString& rValue)
{
    m_aContentLocation = rValue;
}

inline void
INetCoreMIMEMessage::SetContentType_Impl (const ByteString& rValue)
{
    m_aContentType = rValue;
}

inline void
INetCoreMIMEMessage::SetContentTransferEncoding_Impl (
    const ByteString& rValue)
{
    m_aContentTransferEncoding = rValue;
}

/*=======================================================================
 *
 * INetCoreNewsMessage Implementation.
 *
 *=====================================================================*/
inline const ByteString&
INetCoreNewsMessage::GetNewsgroups_Impl (void) const
{
    return m_aNewsgroups;
}

inline const ByteString&
INetCoreNewsMessage::GetPath_Impl (void) const
{
    return m_aPath;
}

inline const ByteString&
INetCoreNewsMessage::GetApproved_Impl (void) const
{
    return m_aApproved;
}

inline const ByteString&
INetCoreNewsMessage::GetBytes_Impl (void) const
{
    return m_aBytes;
}

inline const ByteString&
INetCoreNewsMessage::GetControl_Impl (void) const
{
    return m_aControl;
}

inline const ByteString&
INetCoreNewsMessage::GetDistribution_Impl (void) const
{
    return m_aDistribution;
}

inline const ByteString&
INetCoreNewsMessage::GetExpires_Impl (void) const
{
    return m_aExpires;
}

inline const ByteString&
INetCoreNewsMessage::GetFollowupTo_Impl (void) const
{
    return m_aFollowupTo;
}

inline const ByteString&
INetCoreNewsMessage::GetLines_Impl (void) const
{
    return m_aLines;
}

inline const ByteString&
INetCoreNewsMessage::GetOrganization_Impl (void) const
{
    return m_aOrganization;
}

inline const ByteString&
INetCoreNewsMessage::GetSummary_Impl (void) const
{
    return m_aSummary;
}

inline const ByteString&
INetCoreNewsMessage::GetXref_Impl (void) const
{
    return m_aXref;
}

inline const ByteString&
INetCoreNewsMessage::GetXNewsreader_Impl (void) const
{
    return m_aXNewsreader;
}

inline void
INetCoreNewsMessage::SetNewsgroups_Impl (const ByteString& rValue)
{
    m_aNewsgroups = rValue;
}

inline void
INetCoreNewsMessage::SetPath_Impl (const ByteString& rValue)
{
    m_aPath = rValue;
}

inline void
INetCoreNewsMessage::SetApproved_Impl (const ByteString& rValue)
{
    m_aApproved = rValue;
}

inline void
INetCoreNewsMessage::SetBytes_Impl (const ByteString& rValue)
{
    m_aBytes = rValue;
}

inline void
INetCoreNewsMessage::SetControl_Impl (const ByteString& rValue)
{
    m_aControl = rValue;
}

inline void
INetCoreNewsMessage::SetDistribution_Impl (const ByteString& rValue)
{
    m_aDistribution = rValue;
}

inline void
INetCoreNewsMessage::SetExpires_Impl (const ByteString& rValue)
{
    m_aExpires = rValue;
}

inline void
INetCoreNewsMessage::SetFollowupTo_Impl (const ByteString& rValue)
{
    m_aFollowupTo = rValue;
}

inline void
INetCoreNewsMessage::SetLines_Impl (const ByteString& rValue)
{
    m_aLines = rValue;
}

inline void
INetCoreNewsMessage::SetOrganization_Impl (const ByteString& rValue)
{
    m_aOrganization = rValue;
}

inline void
INetCoreNewsMessage::SetSummary_Impl (const ByteString& rValue)
{
    m_aSummary = rValue;
}

inline void
INetCoreNewsMessage::SetXref_Impl (const ByteString& rValue)
{
    m_aXref = rValue;
}

inline void
INetCoreNewsMessage::SetXNewsreader_Impl (const ByteString& rValue)
{
    m_aXNewsreader = rValue;
}

/*========================================================================
 *
 * INetCoreIStream Implementation.
 *
 *=======================================================================*/
/*
 * INetCoreIStream.
 */
INetCoreIStream::INetCoreIStream (sal_uInt32 nIBufferSize)
    : pIBuffer (NULL),
      nIBufSiz (nIBufferSize),
      nIBufLen (0)
{
    pIBuffer = (sal_Char*)(rtl_allocateMemory (nIBufSiz));
}

/*
 * ~INetCoreIStream.
 */
INetCoreIStream::~INetCoreIStream (void)
{
    rtl_freeMemory (pIBuffer);
}

/*
 * Read.
 */
int INetCoreIStream::Read (
    sal_Char *pData, sal_uInt32 nSize, void *pCtx)
{
    return GetData (pData, nSize, pCtx);
}

/*========================================================================
 *
 * INetCoreOStream Implementation.
 *
 *======================================================================*/
/*
 * INetCoreOStream.
 */
INetCoreOStream::INetCoreOStream (sal_uInt32 nOBufferSize)
    : pOBuffer (NULL),
      nOBufSiz (nOBufferSize),
      nOBufLen (0)
{
    pOBuffer = (sal_Char*)(rtl_allocateMemory (nOBufSiz));
}

/*
 * ~INetCoreOStream.
 */
INetCoreOStream::~INetCoreOStream (void)
{
    rtl_freeMemory (pOBuffer);
}

/*
 * Write.
 */
int INetCoreOStream::Write (
    const sal_Char *pData, sal_uInt32 nSize, void *pCtx)
{
    return PutData (pData, nSize, pCtx);
}

/*=========================================================================
 *
 * INetCoreIOStream Implementation.
 *
 *=======================================================================*/
/*
 * INetCoreIOStream.
 */
INetCoreIOStream::INetCoreIOStream (
    sal_uInt32 nIBufferSize, sal_uInt32 nOBufferSize)
    : INetCoreIStream (nIBufferSize), INetCoreOStream (nOBufferSize)
{
}

/*
 * ~INetCoreIOStream.
 */
INetCoreIOStream::~INetCoreIOStream (void)
{
}

/*========================================================================
 *
 * INetCoreMessageIStream Implementation.
 *
 *======================================================================*/
/*
 * INetCoreMessageIStream.
 */
INetCoreMessageIStream::INetCoreMessageIStream (sal_uInt32 nIBufferSize)
    : INetCoreIStream (),
      nIBufSiz         (nIBufferSize),
      pSourceMsg       (NULL),
      bHeaderGenerated (sal_False),
      eIState          (INETCOREMSG_EOL_BEGIN)
{
    pIBuffer = (sal_Char*)(rtl_allocateMemory (nIBufSiz));
    pIRead = pIWrite = pIBuffer;

    rtl_zeroMemory (pIBuffer, nIBufSiz);
}

/*
 * ~INetCoreMessageIStream.
 */
INetCoreMessageIStream::~INetCoreMessageIStream (void)
{
    rtl_freeMemory (pIBuffer);
}

/*
 * GetData.
 */
int INetCoreMessageIStream::GetData (
    sal_Char *pData, sal_uInt32 nSize, void *pCtx)
{
    if (pSourceMsg == NULL)
        return INETCORESTREAM_STATUS_ERROR;

    sal_Char *pWBuf = pData;
    while (pWBuf < (pData + nSize))
    {
        // Caller's buffer not yet filled.
        if ((pIRead - pIWrite) > 0)
        {
            // Bytes still in buffer.
            if (!bHeaderGenerated)
            {
                // @@@ Here we MUST fold long header lines (NYI) @@@
            }
            *pWBuf++ = *pIWrite++;
        }
        else
        {
            // Buffer empty. Reset to <Begin-of-Buffer>.
            pIRead = pIWrite = pIBuffer;

            // Read next message line.
            int nRead = GetMsgLine (pIBuffer, nIBufSiz, pCtx);
            if (nRead > 0)
            {
                // Set read pointer.
                pIRead = pIBuffer + nRead;
            }
            else
            {
                if (!bHeaderGenerated)
                {
                    // Header generated. Insert empty line.
                    bHeaderGenerated = sal_True;
                    *pIRead++ = '\r';
                    *pIRead++ = '\n';
                }
                else
                {
                    // Body generated.
                    return (pWBuf - pData);
                }
            }
        }
    }
    return (pWBuf - pData);
}

/*======================================================================
 *
 * INetCoreMessageOStream Implemetation.
 *
 *====================================================================*/
/*
 * INetCoreMessageOStream.
 */
INetCoreMessageOStream::INetCoreMessageOStream (sal_uInt32 nOBufSiz)
    : INetCoreOStream (nOBufSiz),
      pTargetMsg      (NULL),
      bHeaderParsed   (sal_False)
{
    rtl_zeroMemory (pOBuffer, nOBufSiz);
    eOState = INETCOREMSG_EOL_BEGIN;
}

/*
 * ~INetCoreMessageOStream.
 */
INetCoreMessageOStream::~INetCoreMessageOStream (void)
{
}

/*
 * PutData.
 * (Simple Field Parsing (RFC822, Appendix B))
 */
int INetCoreMessageOStream::PutData (
    const sal_Char *pData, sal_uInt32 nSize, void *pCtx)
{
    if (pTargetMsg == NULL)
        return INETCORESTREAM_STATUS_ERROR;

    const sal_Char *pStop = (pData + nSize);
    while (!bHeaderParsed && (pData < pStop))
    {
        if ((eOState == INETCOREMSG_EOL_FLF) ||
            (eOState == INETCOREMSG_EOL_BEGIN))
        {
            if ((*pData == '\r') || (*pData == '\n'))
            {
                /*
                 * Empty Line. Separates header fields from message body.
                 * Skip this and any 2nd line break character (if any).
                 */
                pData++;
                if ((pData < pStop) &&
                    ((*pData == '\r') || (*pData == '\n'))) pData++;

                // Emit any buffered last header field.
                if (nOBufLen > 0)
                {
                    *(pOBuffer + nOBufLen) = '\0';
                    int status = PutMsgLine (pOBuffer, nOBufLen, pCtx);
                    if (status != INETCORESTREAM_STATUS_OK) return status;
                }

                // Reset to begin.
                eOState  = INETCOREMSG_EOL_BEGIN;
                nOBufLen = 0;

                // Mark header parsed.
                bHeaderParsed = sal_True;
            }
            else if ((*pData == ' ') || (*pData == '\t'))
            {
                // Continuation line. Unfold multi-line field-body.
                *(pOBuffer + nOBufLen++) = ' ';
                pData++;
            }
            else
            {
                // Begin of new header field.
                if ((eOState == INETCOREMSG_EOL_BEGIN) && (nOBufLen > 0))
                {
                    // Emit buffered header field now.
                    *(pOBuffer + nOBufLen) = '\0';
                    int status = PutMsgLine (pOBuffer, nOBufLen, pCtx);
                    if (status != INETCORESTREAM_STATUS_OK) return status;
                }

                // Reset to begin of buffer.
                nOBufLen = 0;

                // Inserted current character into buffer.
                *(pOBuffer + nOBufLen++) = *pData++;
            }

            // Search for next line break character.
            if (!bHeaderParsed) eOState = INETCOREMSG_EOL_SCR;
        }
        else if (eOState == INETCOREMSG_EOL_FCR)
        {
            // Skip line break character.
            pData++;

            if (pData == pStop)
            {
                // No more lookahead. Must emit buffered header field.
                *(pOBuffer + nOBufLen) = '\0';
                int status = PutMsgLine (pOBuffer, nOBufLen, pCtx);
                if (status != INETCORESTREAM_STATUS_OK) return status;

                // Mark end of line.
                eOState = INETCOREMSG_EOL_FLF;
            }
            else
            {
                // Mark begin of line.
                eOState = INETCOREMSG_EOL_BEGIN;
            }
        }
        else if ((*pData == '\r') || (*pData == '\n'))
        {
            if (*pData == '\r') pData++;
            eOState = INETCOREMSG_EOL_FCR;
        }
        else if (ascii_isWhitespace (*pData & 0x7f))
        {
            // Any <LWS> is folded into a single <SP> character.
            if (nOBufLen == 0)
            {
                *(pOBuffer + nOBufLen++) = ' ';
            }
            else
            {
                sal_Char c = *(pOBuffer + nOBufLen - 1);
                if (!ascii_isWhitespace (c & 0x7f))
                    *(pOBuffer + nOBufLen++) = ' ';
            }

            // Skip over this <LWS> character.
            pData++;
        }
        else
        {
            // Any other character is inserted into line buffer.
            *(pOBuffer + nOBufLen++) = *pData++;
        }

        if ((nOBufLen + 1) == nOBufSiz)
        {
            // Line buffer full. Must emit buffered header field.
            *(pOBuffer + nOBufLen) = '\0';
            int status = PutMsgLine (pOBuffer, nOBufLen, pCtx);
            if (status != INETCORESTREAM_STATUS_OK) return status;

            // Reset to begin of buffer.
            nOBufLen = 0;

            // Search for next line break.
            eOState = INETCOREMSG_EOL_SCR;
        }
    }

    if (bHeaderParsed && (pData < pStop))
    {
        // Put message body down-stream.
        return PutMsgLine (pData, (pStop - pData), pCtx);
    }

    return INETCORESTREAM_STATUS_OK;
}

/*=======================================================================
 *
 * InetCoreMessageIOStream Implementation.
 *
 *=====================================================================*/
/*
 * INetCoreMessageIOStream.
 */
INetCoreMessageIOStream::INetCoreMessageIOStream (
    sal_uInt32 nIBufSiz, sal_uInt32 nOBufSiz)
    : INetCoreMessageIStream (nIBufSiz),
      INetCoreMessageOStream (nOBufSiz)
{
}

/*
 * ~INetCoreMessageIOStream.
 */
INetCoreMessageIOStream::~INetCoreMessageIOStream (void)
{
}

/*=======================================================================
 *
 * INetCoreRFC822MessageStream Implementation.
 *
 *=====================================================================*/
/*
 * INetCoreRFC822MessageStream.
 */
INetCoreRFC822MessageStream::INetCoreRFC822MessageStream (
    sal_uInt32 nMsgBufferSize)
    : INetCoreMessageIOStream (),
      eState     (INETCOREMSG_RFC822_BEGIN),
      eOkState   (INETCOREMSG_RFC822_END),
      nMsgBufSiz (nMsgBufferSize)
{
    pMsgBuffer = (sal_Char*)(rtl_allocateMemory (nMsgBufSiz));
    pMsgRead = pMsgWrite = pMsgBuffer;
}

/*
 * ~INetCoreRFC822MessageStream.
 */
INetCoreRFC822MessageStream::~INetCoreRFC822MessageStream (void)
{
    rtl_freeMemory (pMsgBuffer);
}

/*
 * ConvertFrom7Bit.
 * (Support for non-ASCII header fields (RFC1522))
 */
ByteString INetCoreRFC822MessageStream::ConvertFrom7Bit (
    const ByteString &rFieldBody)
{
#if 0  /* OBSOLETE */
    UniString aFieldBody (
        INetMIME::decodeHeaderFieldBody (
            INetMIME::HEADER_FIELD_TEXT, rFieldBody));
    return ByteString (aFieldBody, gsl_getSystemTextEncoding());
#endif /* OBSOLETE */
    return rFieldBody;
}

/*
 * GenerateHeaderField.
 */
int INetCoreRFC822MessageStream::GenerateHeaderField (
    const sal_Char            *pFieldName,
    const ByteString          &rFieldBody,
    INetMIME::HeaderFieldType  eType,
    sal_Char                  *pData,
    sal_uInt32                 nSize,
    sal_uInt32                 nLimit)
{
    if (rFieldBody.Len() == 0)
        return 0;

    INetMIMEStringOutputSink aSink (0, nLimit);
    aSink << pFieldName << 0x3A; // ':'
    INetMIME::writeHeaderFieldBody (
        aSink, eType, rFieldBody, gsl_getSystemTextEncoding());
    aSink << INetMIMEOutputSink::endl;

    ByteString aField (aSink.takeBuffer());
    DBG_ASSERT(
        aField.Len() <= nSize,
        "INetCoreRFC822MessageStream::GenerateHeaderField(): Too long");
    rtl_copyMemory (pData, aField.GetBuffer(), aField.Len());
    return aField.Len();
}

/*
 * GetMsgLine.
 * (Header Field Generator)
 */
int INetCoreRFC822MessageStream::GetMsgLine (
    sal_Char *pData, sal_uInt32 nSize, void *pCtx)
{
    INetCoreRFC822Message *pMsg = GetSourceMessage();
    if (pMsg == NULL)
        return INETCORESTREAM_STATUS_ERROR;

    // Check whether to generate header or body.
    while (!IsHeaderGenerated())
    {
        /*
         * Generate a message header field line.
         */
        int nRead;
        switch (eState)
        {
            case INETCOREMSG_RFC822_BEGIN:
                eState = INETCOREMSG_RFC822_FROM;
                break;

            case INETCOREMSG_RFC822_FROM:
                eState = INETCOREMSG_RFC822_DATE;
                if ((nRead = GenerateHeaderField (
                    "From", pMsg->GetFrom_Impl(),
                    INetMIME::HEADER_FIELD_ADDRESS,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_RFC822_DATE:
                eState = INETCOREMSG_RFC822_MESSAGE_ID;
                if ((nRead = GenerateHeaderField (
                    "Date", pMsg->GetDate_Impl(),
                    INetMIME::HEADER_FIELD_STRUCTURED,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_RFC822_MESSAGE_ID:
                eState = INETCOREMSG_RFC822_SUBJECT;
                if ((nRead = GenerateHeaderField (
                    "Message-ID", pMsg->GetMessageID_Impl(),
                    INetMIME::HEADER_FIELD_MESSAGE_ID,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_RFC822_SUBJECT:
                eState = INETCOREMSG_RFC822_SENDER;
                if ((nRead = GenerateHeaderField (
                    "Subject", pMsg->GetSubject_Impl(),
                    INetMIME::HEADER_FIELD_TEXT,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_RFC822_SENDER:
                eState = INETCOREMSG_RFC822_TO;
                if ((nRead = GenerateHeaderField (
                    "Sender", pMsg->GetSender_Impl(),
                    INetMIME::HEADER_FIELD_ADDRESS,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_RFC822_TO:
                eState = INETCOREMSG_RFC822_CC;
                if ((nRead = GenerateHeaderField (
                    "To", pMsg->GetTo_Impl(),
                    INetMIME::HEADER_FIELD_ADDRESS,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_RFC822_CC:
                eState = INETCOREMSG_RFC822_BCC;
                if ((nRead = GenerateHeaderField (
                    "CC", pMsg->GetCC_Impl(),
                    INetMIME::HEADER_FIELD_ADDRESS,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_RFC822_BCC:
                eState = INETCOREMSG_RFC822_REPLY_TO;
                if ((nRead = GenerateHeaderField (
                    "BCC", pMsg->GetBCC_Impl(),
                    INetMIME::HEADER_FIELD_ADDRESS,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_RFC822_REPLY_TO:
                eState = INETCOREMSG_RFC822_RETURN_RECEIPT_TO;
                if ((nRead = GenerateHeaderField (
                    "Reply-To", pMsg->GetReplyTo_Impl(),
                    INetMIME::HEADER_FIELD_ADDRESS,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_RFC822_RETURN_RECEIPT_TO:
                eState = INETCOREMSG_RFC822_COMMENTS;
                if ((nRead = GenerateHeaderField (
                    "Return-Receipt-To", pMsg->GetReturnReceiptTo_Impl(),
                    INetMIME::HEADER_FIELD_ADDRESS,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_RFC822_COMMENTS:
                eState = INETCOREMSG_RFC822_IN_REPLY_TO;
                if ((nRead = GenerateHeaderField (
                    "Comments", pMsg->GetComments_Impl(),
                    INetMIME::HEADER_FIELD_TEXT,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_RFC822_IN_REPLY_TO:
                eState = INETCOREMSG_RFC822_KEYWORDS;
                if ((nRead = GenerateHeaderField (
                    "In-Reply-To", pMsg->GetInReplyTo_Impl(),
                    INetMIME::HEADER_FIELD_ADDRESS,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_RFC822_KEYWORDS:
                eState = INETCOREMSG_RFC822_REFERENCES;
                if ((nRead = GenerateHeaderField (
                    "Keywords", pMsg->GetKeywords_Impl(),
                    INetMIME::HEADER_FIELD_PHRASE,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_RFC822_REFERENCES:
                eState = INETCOREMSG_RFC822_X_MAILER;
                // At least the 'Netscape-Collabra/3.5 03715 NNRP' NNTP
                // server, when sending XOVER information, only includes the
                // first line of References, but our message threading
                // mechanism needs accurate References information to work
                // correctly, so split this into unusually long lines:
                if ((nRead = GenerateHeaderField (
                    "References", pMsg->GetReferences_Impl(),
                    INetMIME::HEADER_FIELD_ADDRESS,
                    pData, nSize,
                    INetMIME::HARD_LINE_LENGTH_LIMIT)) > 0) return nRead;
                break;

            case INETCOREMSG_RFC822_X_MAILER:
                eState = INETCOREMSG_RFC822_X_PRIORITY;
                if ((nRead = GenerateHeaderField (
                    "X-Mailer", pMsg->GetXMailer_Impl(),
                    INetMIME::HEADER_FIELD_TEXT,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_RFC822_X_PRIORITY:
                eState = INETCOREMSG_RFC822_END;
                if ((nRead = GenerateHeaderField (
                    "X-Priority", pMsg->GetXPriority_Impl(),
                    INetMIME::HEADER_FIELD_TEXT,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_RFC822_END:
                eState = INETCOREMSG_RFC822_BEGIN;
                eIState = INETCOREMSG_EOL_BEGIN;
                return 0;
                break;

            default: // Never reached.
                return INETCORESTREAM_STATUS_ERROR;
                break;
        } // switch (eState)
    } // while (!IsHeaderGenerated())

    // Check for message body.
    SvStream *pIS = pMsg->GetDocumentStream();
    if (pIS == NULL)
        return 0;

    // Generate the message body.
    sal_Char *pWBuf = pData;
    while (pWBuf < (pData + nSize))
    {
        // Caller's buffer not yet filled.
        if ((pMsgRead - pMsgWrite) > 0)
        {
            // Bytes still in buffer.
            if (eIState == INETCOREMSG_EOL_FCR)
            {
                eIState = INETCOREMSG_EOL_SCR;
                if (*pMsgWrite != '\n')
                {
                    // Found <CR> only. Insert missing <LF>.
                    *pWBuf++ = '\n';
                }
                else
                {
                    // Found standard <CR><LF> sequence.
                    *pWBuf++ = *pMsgWrite++;
                }
            }
            else if (*pMsgWrite == '\r')
            {
                eIState = INETCOREMSG_EOL_FCR;
                *pWBuf++ = *pMsgWrite++;
            }
            else if (*pMsgWrite == '\n')
            {
                // Found <LF> only. Insert missing <CR>.
                eIState = INETCOREMSG_EOL_FCR;
                *pWBuf++ = '\r';
            }
            else
            {
                *pWBuf++ = *pMsgWrite++; // Shall be 7bit us-ascii.
            }
        }
        else
        {
            // Buffer empty. Reset to <Begin-of-Buffer>.
            pMsgRead = pMsgWrite = pMsgBuffer;

            // Read next message block.
            sal_uInt32 nRead = pIS->Read (pMsgBuffer, nMsgBufSiz);
            if (nRead > 0)
            {
                // Set read pointer.
                pMsgRead = pMsgBuffer + nRead;
            }
            else
            {
                // Document done.
                return (pWBuf - pData);
            }
        }
    }
    return (pWBuf - pData);
}

/*
 * PutMsgLine.
 * (Header Field Parser)
 */
int INetCoreRFC822MessageStream::PutMsgLine (
    const sal_Char *pData, sal_uInt32 nSize, void *pCtx)
{
    // Check for message container.
    INetCoreRFC822Message *pMsg = GetTargetMessage();
    if (pMsg == NULL)
        return INETCORESTREAM_STATUS_ERROR;

    // Check whether to parse header or body.
    if (!IsHeaderParsed ())
    {
        /*
         * Parse a message header field line.
         */
        const sal_Char *pStop = (pData + nSize);
        const sal_Char *check = "";
        ByteString      aField;

        eState   = INETCOREMSG_RFC822_BEGIN;
        eOkState = INETCOREMSG_RFC822_END;

        while (pData < pStop)
        {
            switch (eState)
            {
                case INETCOREMSG_RFC822_BEGIN:
                    switch (ascii_toLowerCase (*pData))
                    {
                        case 'b':
                            check = "cc";
                            eOkState = INETCOREMSG_RFC822_BCC;
                            eState = INETCOREMSG_RFC822_CHECK;
                            break;

                        case 'c':
                            eState = INETCOREMSG_RFC822_LETTER_C;
                            break;

                        case 'd':
                            check = "ate";
                            eOkState = INETCOREMSG_RFC822_DATE;
                            eState = INETCOREMSG_RFC822_CHECK;
                            break;

                        case 'e':
                            check = "ncoding";
                            eOkState = INETCOREMSG_RFC822_ENCODING;
                            eState = INETCOREMSG_RFC822_CHECK;
                            break;

                        case 'f':
                            check = "rom";
                            eOkState = INETCOREMSG_RFC822_FROM;
                            eState = INETCOREMSG_RFC822_CHECK;
                            break;

                        case 'i':
                            check = "n-reply-to";
                            eOkState = INETCOREMSG_RFC822_IN_REPLY_TO;
                            eState = INETCOREMSG_RFC822_CHECK;
                            break;

                        case 'k':
                            check = "eywords";
                            eOkState = INETCOREMSG_RFC822_KEYWORDS;
                            eState = INETCOREMSG_RFC822_CHECK;
                            break;

                        case 'm':
                            check = "essage-id";
                            eOkState = INETCOREMSG_RFC822_MESSAGE_ID;
                            eState = INETCOREMSG_RFC822_CHECK;
                            break;

                        case 'r':
                            check = "e";
                            eOkState = INETCOREMSG_RFC822_TOKEN_RE;
                            eState = INETCOREMSG_RFC822_CHECK;
                            break;

                        case 's':
                            eState = INETCOREMSG_RFC822_LETTER_S;
                            break;

                        case 't':
                            check = "o";
                            eOkState = INETCOREMSG_RFC822_TO;
                            eState = INETCOREMSG_RFC822_CHECK;
                            break;

                        case 'x':
                            check = "-";
                            eOkState = INETCOREMSG_RFC822_TOKEN_XMINUS;
                            eState = INETCOREMSG_RFC822_CHECK;
                            break;

                        default:
                            eState = INETCOREMSG_RFC822_JUNK;
                            break;
                    }
                    pData++;
                    break;

                case INETCOREMSG_RFC822_TOKEN_RE:
                    switch (ascii_toLowerCase (*pData))
                    {
                        case 'c':
                            check = "eived";
                            eOkState = INETCOREMSG_RFC822_RECEIVED;
                            eState = INETCOREMSG_RFC822_CHECK;
                            break;

                        case 'f':
                            check = "erences";
                            eOkState = INETCOREMSG_RFC822_REFERENCES;
                            eState = INETCOREMSG_RFC822_CHECK;
                            break;

                        case 'p':
                            check = "ly-to";
                            eOkState = INETCOREMSG_RFC822_REPLY_TO;
                            eState = INETCOREMSG_RFC822_CHECK;
                            break;

                        case 't':
                            check = "urn-";
                            eOkState = INETCOREMSG_RFC822_TOKEN_RETURNMINUS;
                            eState = INETCOREMSG_RFC822_CHECK;
                            break;

                        default:
                            eState = INETCOREMSG_RFC822_JUNK;
                            break;
                    }
                    pData++;
                    break;

                case INETCOREMSG_RFC822_TOKEN_RETURNMINUS:
                    switch (ascii_toLowerCase (*pData))
                    {
                        case 'p':
                            check = "ath";
                            eOkState = INETCOREMSG_RFC822_RETURN_PATH;
                            eState = INETCOREMSG_RFC822_CHECK;
                            break;

                        case 'r':
                            check = "eceipt-to";
                            eOkState = INETCOREMSG_RFC822_RETURN_RECEIPT_TO;
                            eState = INETCOREMSG_RFC822_CHECK;
                            break;

                        default:
                            eState = INETCOREMSG_RFC822_JUNK;
                            break;
                    }
                    pData++;
                    break;

                case INETCOREMSG_RFC822_TOKEN_XMINUS:
                    switch (ascii_toLowerCase (*pData))
                    {
                        case 'm':
                            check = "ailer";
                            eOkState = INETCOREMSG_RFC822_X_MAILER;
                            eState = INETCOREMSG_RFC822_CHECK;
                            break;

                        case 'p':
                            check = "riority";
                            eOkState = INETCOREMSG_RFC822_X_PRIORITY;
                            eState = INETCOREMSG_RFC822_CHECK;
                            break;

                        default:
                            eState = INETCOREMSG_RFC822_JUNK;
                            break;
                    }
                    pData++;
                    break;

                case INETCOREMSG_RFC822_LETTER_C:
                    switch (ascii_toLowerCase (*pData))
                    {
                        case 'c':
                            check = "";
                            eOkState = INETCOREMSG_RFC822_CC;
                            eState = INETCOREMSG_RFC822_CHECK;
                            break;

                        case 'o':
                            check = "mments";
                            eOkState = INETCOREMSG_RFC822_COMMENTS;
                            eState = INETCOREMSG_RFC822_CHECK;
                            break;

                        default:
                            eState = INETCOREMSG_RFC822_JUNK;
                            break;
                    }
                    pData++;
                    break;

                case INETCOREMSG_RFC822_LETTER_S:
                    switch (ascii_toLowerCase (*pData))
                    {
                        case 'e':
                            check = "nder";
                            eOkState = INETCOREMSG_RFC822_SENDER;
                            eState = INETCOREMSG_RFC822_CHECK;
                            break;

                        case 'u':
                            check = "bject";
                            eOkState = INETCOREMSG_RFC822_SUBJECT;
                            eState = INETCOREMSG_RFC822_CHECK;
                            break;

                        default:
                            eState = INETCOREMSG_RFC822_JUNK;
                            break;
                    }
                    pData++;
                    break;

                case INETCOREMSG_RFC822_CHECK:
                    while (ascii_toLowerCase (*pData) == *check)
                    {
                        pData++;
                        check++;
                    }
                    if (*check == '\0')
                    {
                        eState = eOkState;
                        while (*pData)
                        {
                            if (ascii_isWhitespace (*pData))
                                pData++;
                            else if (*pData == ':')
                                pData++;
                            else
                                break;
                        }

                        /* @@@ OBSOLETE @@@ */
                        aField = ConvertFrom7Bit (pData);
                    }
                    else
                    {
                        eState = INETCOREMSG_RFC822_JUNK;
                    }
                    break;

                case INETCOREMSG_RFC822_BCC:
                    pMsg->SetBCC_Impl (aField);
                    eState = INETCOREMSG_RFC822_JUNK;
                    break;

                case INETCOREMSG_RFC822_CC:
                    pMsg->SetCC_Impl (aField);
                    eState = INETCOREMSG_RFC822_JUNK;
                    break;

                case INETCOREMSG_RFC822_COMMENTS:
                    pMsg->SetComments_Impl (aField);
                    eState = INETCOREMSG_RFC822_JUNK;
                    break;

                case INETCOREMSG_RFC822_DATE:
                    pMsg->SetDate_Impl (aField);
                    eState = INETCOREMSG_RFC822_JUNK;
                    break;

                case INETCOREMSG_RFC822_ENCODING:
                    pMsg->SetEncoding_Impl (aField);
                    eState = INETCOREMSG_RFC822_JUNK;
                    break;

                case INETCOREMSG_RFC822_FROM:
                    pMsg->SetFrom_Impl (aField);
                    eState = INETCOREMSG_RFC822_JUNK;
                    break;

                case INETCOREMSG_RFC822_IN_REPLY_TO:
                    pMsg->SetInReplyTo_Impl (aField);
                    eState = INETCOREMSG_RFC822_JUNK;
                    break;

                case INETCOREMSG_RFC822_KEYWORDS:
                    pMsg->SetKeywords_Impl (aField);
                    eState = INETCOREMSG_RFC822_JUNK;
                    break;

                case INETCOREMSG_RFC822_MESSAGE_ID:
                    pMsg->SetMessageID_Impl (aField);
                    eState = INETCOREMSG_RFC822_JUNK;
                    break;

                case INETCOREMSG_RFC822_RECEIVED:
                    pMsg->SetReceived_Impl (aField);
                    eState = INETCOREMSG_RFC822_JUNK;
                    break;

                case INETCOREMSG_RFC822_REFERENCES:
                    pMsg->SetReferences_Impl (aField);
                    eState = INETCOREMSG_RFC822_JUNK;
                    break;

                case INETCOREMSG_RFC822_REPLY_TO:
                    pMsg->SetReplyTo_Impl (aField);
                    eState = INETCOREMSG_RFC822_JUNK;
                    break;

                case INETCOREMSG_RFC822_RETURN_PATH:
                    pMsg->SetReturnPath_Impl (aField);
                    eState = INETCOREMSG_RFC822_JUNK;
                    break;

                case INETCOREMSG_RFC822_RETURN_RECEIPT_TO:
                    pMsg->SetReturnReceiptTo_Impl (aField);
                    eState = INETCOREMSG_RFC822_JUNK;
                    break;

                case INETCOREMSG_RFC822_SENDER:
                    pMsg->SetSender_Impl (aField);
                    eState = INETCOREMSG_RFC822_JUNK;
                    break;

                case INETCOREMSG_RFC822_SUBJECT:
                    pMsg->SetSubject_Impl (aField);
                    eState = INETCOREMSG_RFC822_JUNK;
                    break;

                case INETCOREMSG_RFC822_TO:
                    pMsg->SetTo_Impl (aField);
                    eState = INETCOREMSG_RFC822_JUNK;
                    break;

                case INETCOREMSG_RFC822_X_MAILER:
                    pMsg->SetXMailer_Impl (aField);
                    eState = INETCOREMSG_RFC822_JUNK;
                    break;

                case INETCOREMSG_RFC822_X_PRIORITY:
                    pMsg->SetXPriority_Impl (aField);
                    eState = INETCOREMSG_RFC822_JUNK;
                    break;

                default: // _JUNK
                    while (pData < pStop) pData++;
                    eState = INETCOREMSG_RFC822_BEGIN;
                    break;
            } // switch (eState)
        } // while (pData < pStop)
        return INETCORESTREAM_STATUS_OK;
    }
    else
    {
        /*
         * Put the message body down-stream.
         */
        SvStream *pOS = pMsg->GetDocumentStream();
        if (pOS == NULL)
            return INETCORESTREAM_STATUS_WOULDBLOCK;

        sal_uInt32 nWrite = pMsg->GetDocumentSize();
        nWrite += pOS->Write (pData, nSize);
        pMsg->SetDocumentSize (nWrite);

        return INETCORESTREAM_STATUS_OK;
    }
}

/*=======================================================================
 *
 * INetCoreMessageEncodeQPStream Implementation.
 * (Quoted-Printable Encoding)
 *
 *=====================================================================*/
class INetCoreMessageEncodeQPStream : public INetCoreMessageIStream
{
    static const sal_Char hex2pr[16];
    static const sal_Char ebcdic[14];

    sal_uInt32 nMsgBufSiz;
    sal_Char  *pMsgBuffer;
    sal_Char  *pMsgRead;
    sal_Char  *pMsgWrite;

    sal_uInt32 nTokBufSiz;
    sal_Char  *pTokBuffer;
    sal_Char  *pTokRead;
    sal_Char  *pTokWrite;

    sal_Bool   bDone;

    virtual int GetMsgLine (
        sal_Char *pData, sal_uInt32 nSize, void *pCtx = NULL);

public:
    INetCoreMessageEncodeQPStream (sal_uInt32 nMsgBufferSize = 1024);
    virtual ~INetCoreMessageEncodeQPStream (void);
};

/*
 * hex2pr.
 */
const sal_Char INetCoreMessageEncodeQPStream::hex2pr[16] =
{
    '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
    'A', 'B', 'C', 'D', 'E', 'F'
};

/*
 * ebcdic.
 */
const sal_Char INetCoreMessageEncodeQPStream::ebcdic[14] =
{
    '!', '"', '#', '$', '@', '[', '\\', ']', '^', '`',
    '{', '|', '}', '~'
};

/*
 * INetCoreMessageEncodeQPStream.
 */
INetCoreMessageEncodeQPStream::INetCoreMessageEncodeQPStream (
    sal_uInt32 nMsgBufferSize)
    : INetCoreMessageIStream(),
      nMsgBufSiz (nMsgBufferSize),
      nTokBufSiz (80),
      bDone      (sal_False)
{
    GenerateHeader (sal_False);

    pMsgBuffer = (sal_Char*)(rtl_allocateMemory (nMsgBufSiz));
    pMsgRead = pMsgWrite = pMsgBuffer;

    pTokBuffer = (sal_Char*)(rtl_allocateMemory (nTokBufSiz));
    pTokRead = pTokWrite = pTokBuffer;

    eIState = INETCOREMSG_EOL_SCR;
}

/*
 * ~INetCoreMessageEncodeQPStream.
 */
INetCoreMessageEncodeQPStream::~INetCoreMessageEncodeQPStream (void)
{
    rtl_freeMemory (pMsgBuffer);
    rtl_freeMemory (pTokBuffer);
}

/*
 * GetMsgLine.
 */
int INetCoreMessageEncodeQPStream::GetMsgLine (
    sal_Char *pData, sal_uInt32 nSize, void *pCtx)
{
    INetCoreMessage *pMsg = GetSourceMessage();
    if (pMsg == NULL)
        return INETCORESTREAM_STATUS_ERROR;

    SvStream *pIS = pMsg->GetDocumentStream();
    if (pIS == NULL)
        return 0;

    sal_Char *pWBuf = pData;
    while (pWBuf < (pData + nSize))
    {
        // Caller's buffer not yet filled.
        if ((pMsgRead - pMsgWrite) > 0)
        {
            // Bytes still in message buffer.
            if ((eIState != INETCOREMSG_EOL_BEGIN) &&
                ((pTokRead - pTokBuffer) < 72))
            {
                // Token buffer not yet filled.
                if (eIState == INETCOREMSG_EOL_FCR)
                {
                    eIState = INETCOREMSG_EOL_BEGIN;
                    if (*pMsgWrite != '\n')
                    {
                        // Convert orphant <CR> into <CR><LF> sequence.
                        *pTokRead++ = '\n';
                    }
                    *pTokRead++ = *pMsgWrite++;
                }
                else if ((*pMsgWrite == ' ') || (*pMsgWrite == '\t'))
                {
                    eIState = INETCOREMSG_EOL_FSP;
                    *pTokRead++ = *pMsgWrite++;
                }
                else if (*pMsgWrite == '\r')
                {
                    // Found <CR>.
                    if (eIState == INETCOREMSG_EOL_FSP)
                    {
                        // Encode last (trailing space) character.
                        sal_uInt8 c = (sal_uInt8)(*(--pTokRead));
                        *pTokRead++ = '=';
                        *pTokRead++ = hex2pr[((c & 0xf0) >> 4)];
                        *pTokRead++ = hex2pr[((c & 0x0f)     )];
                    }
                    eIState = INETCOREMSG_EOL_FCR;
                    *pTokRead++ = *pMsgWrite++;
                }
                else if (*pMsgWrite == '\n')
                {
                    // Found <LF> only.
                    if (eIState == INETCOREMSG_EOL_FSP)
                    {
                        // Encode last (trailing space) character.
                        sal_uInt8 c = (sal_uInt8)(*(--pTokRead));
                        *pTokRead++ = '=';
                        *pTokRead++ = hex2pr[((c & 0xf0) >> 4)];
                        *pTokRead++ = hex2pr[((c & 0x0f)     )];
                    }
                    eIState = INETCOREMSG_EOL_BEGIN;

                    // Convert orphant <LF> into <CR><LF> sequence.
                    *pTokRead++ = '\r';
                    *pTokRead++ = *pMsgWrite++;
                }
                else if (*pMsgWrite == '=')
                {
                    // Escape character itself MUST be encoded, of course.
                    sal_uInt8 c = (sal_uInt8)(*pMsgWrite++);
                    *pTokRead++ = '=';
                    *pTokRead++ = hex2pr[((c & 0xf0) >> 4)];
                    *pTokRead++ = hex2pr[((c & 0x0f)     )];

                    eIState = INETCOREMSG_EOL_SCR;
                }
                else if (((sal_uInt8)(*pMsgWrite) > 0x20) &&
                         ((sal_uInt8)(*pMsgWrite) < 0x7f)    )
                {
                    /*
                     * Some printable ASCII character.
                     * (Encode EBCDIC special characters (NYI)).
                     */
                    *pTokRead++ = *pMsgWrite++;
                    eIState = INETCOREMSG_EOL_SCR;
                }
                else
                {
                    // Encode any other character.
                    sal_uInt8 c = (sal_uInt8)(*pMsgWrite++);
                    *pTokRead++ = '=';
                    *pTokRead++ = hex2pr[((c & 0xf0) >> 4)];
                    *pTokRead++ = hex2pr[((c & 0x0f)     )];

                    eIState = INETCOREMSG_EOL_SCR;
                }
            }
            else
            {
                // Check for maximum line length.
                if (eIState != INETCOREMSG_EOL_BEGIN)
                {
                    // Check for <Within-Line-Break> state.
                    if (eIState == INETCOREMSG_EOL_FCR)
                    {
                        // Process <CR> again next round.
                        pMsgWrite--;
                        pTokRead--;
                    }

                    // Insert soft line break.
                    *pTokRead++ = '=';
                    *pTokRead++ = '\r';
                    *pTokRead++ = '\n';

                    eIState = INETCOREMSG_EOL_BEGIN;
                }

                // Copy to caller's buffer.
                if ((pTokRead - pTokWrite) > 0)
                {
                    // Bytes still in token buffer.
                    *pWBuf++ = *pTokWrite++;
                }
                else
                {
                    // Token buffer empty. Reset to <Begin-of-Buffer>.
                    pTokRead = pTokWrite = pTokBuffer;
                    eIState = INETCOREMSG_EOL_SCR;
                }
            }
        }
        else
        {
            // Message buffer empty. Reset to <Begin-of-Buffer>.
            pMsgRead = pMsgWrite = pMsgBuffer;

            // Read next message block.
            sal_uInt32 nRead = pIS->Read (pMsgBuffer, nMsgBufSiz);
            if (nRead > 0)
            {
                // Set read pointer.
                pMsgRead = (pMsgBuffer + nRead);
            }
            else
            {
                // Nothing more ro read.
                if (!bDone)
                {
                    // Append final <CR><LF>.
                    if (!(eIState == INETCOREMSG_EOL_BEGIN))
                    {
                        *pTokRead++ = '\r';
                        *pTokRead++ = '\n';
                    }

                    // Mark we're done.
                    bDone = sal_True;
                }
                else
                {
                    // Already done all encoding.
                    if ((pTokRead - pTokWrite) > 0)
                    {
                        // Bytes still in token buffer.
                        *pWBuf++ = *pTokWrite++;
                    }
                    else
                    {
                        // Token buffer empty. Reset to <Begin-of-Buffer>.
                        pTokRead = pTokWrite = pTokBuffer;

                        // Return.
                        return (pWBuf - pData);
                    }
                }
            }
        }
    }
    return (pWBuf - pData);
}

/*=====================================================================
 *
 * INetCoreMessageDecodeQPStream Implementation.
 * (Quoted-Printable Decoding)
 *
 *====================================================================*/
class INetCoreMessageDecodeQPStream : public INetCoreMessageOStream
{
    static const sal_uInt8 pr2hex[128];

    sal_uInt32 nMsgBufSiz;
    sal_uInt32 nMsgBufLen;
    sal_Char  *pMsgBuffer;
    sal_Char  *pMsgRead;
    sal_Char  *pMsgWrite;

    sal_uInt32 nTokBufLen;
    sal_Char  pTokBuffer[4];

    virtual int PutMsgLine (
        const sal_Char *pData, sal_uInt32 nSize, void *pCtx = NULL);

public:
    INetCoreMessageDecodeQPStream (sal_uInt32 nMsgBufferSize = 1024);
    virtual ~INetCoreMessageDecodeQPStream (void);
};

/*
 * pr2hex.
 */
const sal_uInt8 INetCoreMessageDecodeQPStream::pr2hex[128] =
{
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,

    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
    0x08, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,

    0x10, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,

    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
};

/*
 * INetCoreMessageDecodeQPStream.
 */
INetCoreMessageDecodeQPStream::INetCoreMessageDecodeQPStream (
    sal_uInt32 nMsgBufferSize) :
    INetCoreMessageOStream(),
    nMsgBufSiz (nMsgBufferSize),
    nMsgBufLen (0),
    nTokBufLen (0)
{
    ParseHeader (sal_False);

    pMsgBuffer = (sal_Char*)(rtl_allocateMemory (nMsgBufSiz));
    pMsgRead = pMsgWrite = pMsgBuffer;

    eOState = INETCOREMSG_EOL_SCR;
}

/*
 * ~INetCoreMessageDecodeQPStream.
 */
INetCoreMessageDecodeQPStream::~INetCoreMessageDecodeQPStream (void)
{
    rtl_freeMemory (pMsgBuffer);
}

/*
 * PutMsgLine.
 */
int INetCoreMessageDecodeQPStream::PutMsgLine (
    const sal_Char *pData, sal_uInt32 nSize, void *pCtx)
{
    INetCoreMessage *pMsg = GetTargetMessage();
    if (pMsg == NULL)
        return INETCORESTREAM_STATUS_ERROR;

    SvStream *pOS   = pMsg->GetDocumentStream();
    sal_uInt32    nWrite = pMsg->GetDocumentSize();

    while (nSize--)
    {
        if (eOState == INETCOREMSG_EOL_FESC)
        {
            *(pTokBuffer + nTokBufLen++) =
                (sal_Char)(ascii_toUpperCase(*pData++) & 0x7f);
            if (nTokBufLen == 2)
            {
                if ((*pTokBuffer == '\r') || (*pTokBuffer == '\n'))
                {
                    // Soft line break (=<CR><LF>).
                    if (pOS == NULL)
                        return INETCORESTREAM_STATUS_WOULDBLOCK;
                    else
                        nWrite += pOS->Write (pMsgBuffer, nMsgBufLen);
                    nMsgBufLen = 0;
                }
                else
                {
                    // Decode token.
                    *(pMsgBuffer + nMsgBufLen++) =
                        ((pr2hex[(int)(pTokBuffer[0] & 0x7f)] << 4) |
                         (pr2hex[(int)(pTokBuffer[1] & 0x7f)] & 15)   );
                }
                nTokBufLen = 0;
                eOState = INETCOREMSG_EOL_SCR;
            }
        }
        else if (*pData == '=')
        {
            // Found escape character.
            pData++;
            eOState = INETCOREMSG_EOL_FESC;
        }
        else if (eOState == INETCOREMSG_EOL_FCR)
        {
            *(pMsgBuffer + nMsgBufLen++) = *pData++;
            eOState = INETCOREMSG_EOL_BEGIN;
        }
        else if (*pData == '\r')
        {
            *(pMsgBuffer + nMsgBufLen++) = *pData++;
            eOState = INETCOREMSG_EOL_FCR;
        }
        else
        {
            *(pMsgBuffer + nMsgBufLen++) = *pData++;
        }

        if (eOState == INETCOREMSG_EOL_BEGIN)
        {
            if (pOS == NULL)
                return INETCORESTREAM_STATUS_WOULDBLOCK;
            else
                nWrite += pOS->Write (pMsgBuffer, nMsgBufLen);

            nMsgBufLen = 0;
            eOState = INETCOREMSG_EOL_SCR;
        }
    }
    pMsg->SetDocumentSize (nWrite);
    return INETCORESTREAM_STATUS_OK;
}

/*======================================================================
 *
 * INetCoreMessageEncode64Stream Implementation.
 * (Base64 Encoding)
 *
 *====================================================================*/
class INetCoreMessageEncode64Stream : public INetCoreMessageIStream
{
    static const sal_Char six2pr[64];

    sal_uInt32  nMsgBufSiz;
    sal_uInt8  *pMsgBuffer;
    sal_uInt8  *pMsgRead;
    sal_uInt8  *pMsgWrite;

    sal_uInt32  nTokBufSiz;
    sal_Char   *pTokBuffer;
    sal_Char   *pTokRead;
    sal_Char   *pTokWrite;

    sal_Bool    bDone;

    virtual int GetMsgLine (
        sal_Char *pData, sal_uInt32 nSize, void *pCtx = NULL);

public:
    INetCoreMessageEncode64Stream (sal_uInt32 nMsgBufferSize = 1536);
    virtual ~INetCoreMessageEncode64Stream (void);
};

/*
 * six2pr.
 */
const sal_Char INetCoreMessageEncode64Stream::six2pr[64] =
{
    'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
    'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
    'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm',
    'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
    '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'
};

/*
 * INetCoreMessageEncode64Stream.
 */
INetCoreMessageEncode64Stream::INetCoreMessageEncode64Stream (
    sal_uInt32 nMsgBufferSize)
    : INetCoreMessageIStream(),
      nMsgBufSiz (nMsgBufferSize),
      nTokBufSiz (80),
      bDone      (sal_False)
{
    GenerateHeader (sal_False);

    pMsgBuffer = (sal_uInt8*)(rtl_allocateMemory (nMsgBufSiz));
    pMsgRead = pMsgWrite = pMsgBuffer;

    pTokBuffer = (sal_Char*)(rtl_allocateMemory (nTokBufSiz));
    pTokRead = pTokWrite = pTokBuffer;
}

/*
 * ~INetCoreMessageEncode64Stream.
 */
INetCoreMessageEncode64Stream::~INetCoreMessageEncode64Stream (void)
{
    rtl_freeMemory (pMsgBuffer);
    rtl_freeMemory (pTokBuffer);
}

/*
 * GetMsgLine.
 */
int INetCoreMessageEncode64Stream::GetMsgLine (
    sal_Char *pData, sal_uInt32 nSize, void *pCtx)
{
    INetCoreMessage *pMsg = GetSourceMessage();
    if (pMsg == NULL)
        return INETCORESTREAM_STATUS_ERROR;

    SvStream *pIS = pMsg->GetDocumentStream();
    if (pIS == NULL)
        return 0;

    sal_Char *pWBuf = pData;
    while (pWBuf < (pData + nSize))
    {
        // Caller's buffer not yet filled.
        if ((pMsgRead - pMsgWrite) > 0)
        {
            // Bytes still in message buffer.
            if ((pTokRead - pTokBuffer) < 72)
            {
                // Token buffer not yet filled.
                switch ((pTokRead - pTokBuffer) % 4)
                {
                    case 0:
                        *pTokRead++ = six2pr[(int)(*pMsgWrite >> 2)];
                        break;

                    case 1:
                        *pTokRead++ = six2pr[
                            (int)(((*pMsgWrite << 4) & 060) |
                                  (((*(pMsgWrite + 1)) >> 4) & 017))];
                        pMsgWrite++;
                        break;

                    case 2:
                        *pTokRead++ = six2pr[
                            (int)(((*pMsgWrite << 2) & 074) |
                                  (((*(pMsgWrite + 1)) >> 6) & 003))];
                        pMsgWrite++;
                        break;

                    default: // == case 3
                        *pTokRead++ = six2pr[(int)(*pMsgWrite & 077)];
                        pMsgWrite++;
                        break;
                }
            }
            else if ((pTokRead - pTokBuffer) == 72)
            {
                // Maximum line length. Append <CR><LF>.
                *pTokRead++ = '\r';
                *pTokRead++ = '\n';
            }
            else
            {
                if ((pTokRead - pTokWrite) > 0)
                {
                    // Bytes still in token buffer.
                    *pWBuf++ = *pTokWrite++;
                }
                else
                {
                    // Token buffer empty. Reset to <Begin-of-Buffer>.
                    pTokRead = pTokWrite = pTokBuffer;
                }
            }
        }
        else
        {
            // Message buffer empty. Reset to <Begin-of-Buffer>.
            pMsgRead = pMsgWrite = pMsgBuffer;

            // Read next message block.
            sal_uInt32 nRead = pIS->Read (pMsgBuffer, nMsgBufSiz);
            if (nRead > 0)
            {
                // Set read pointer.
                pMsgRead = (pMsgBuffer + nRead);
            }
            else
            {
                // Nothing more to read.
                if (!bDone)
                {
                    // Append pad character(s).
                    switch ((pTokRead - pTokBuffer) % 4)
                    {
                        case 2:
                            *pTokRead++ = '=';
                            // Fall through for 2nd pad character.

                        case 3:
                            *pTokRead++ = '=';
                            break;

                        default:
                            break;
                    }

                    // Append final <CR><LF>.
                    *pTokRead++ = '\r';
                    *pTokRead++ = '\n';

                    // Mark we're done.
                    bDone = sal_True;
                }
                else
                {
                    // Already done all encoding.
                    if ((pTokRead - pTokWrite) > 0)
                    {
                        // Bytes still in token buffer.
                        *pWBuf++ = *pTokWrite++;
                    }
                    else
                    {
                        // Token buffer empty. Reset to <Begin-of-Buffer>.
                        pTokRead = pTokWrite = pTokBuffer;

                        // Reset done flag, if everything has been done.
                        // if (pWBuf == pData) bDone = sal_False;

                        // Return.
                        return (pWBuf - pData);
                    }
                }
            }
        }
    } // while (pWBuf < (pData + nSize))
    return (pWBuf - pData);
}

/*======================================================================
 *
 * INetCoreMessageDecode64Stream Implementation.
 * (Base64 Decoding)
 *
 *====================================================================*/
class INetCoreMessageDecode64Stream : public INetCoreMessageOStream
{
    static const sal_uInt8 pr2six[256];

    sal_uInt32 nMsgBufSiz;
    sal_Char  *pMsgBuffer;
    sal_Char  *pMsgRead;
    sal_Char  *pMsgWrite;

    virtual int PutMsgLine (
        const sal_Char *pData, sal_uInt32 nSize, void *pCtx = NULL);

public:
    INetCoreMessageDecode64Stream (sal_uInt32 nMsgBufferSize = 128);
    virtual ~INetCoreMessageDecode64Stream (void);
};

/*
 * pr2six.
 */
const sal_uInt8 INetCoreMessageDecode64Stream::pr2six[256] =
{
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,

    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x3E, 0x40, 0x40, 0x40, 0x3F,
    0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B,
    0x3C, 0x3D, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,

    0x40, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06,
    0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E,
    0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16,
    0x17, 0x18, 0x19, 0x40, 0x40, 0x40, 0x40, 0x40,

    0x40, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x20,
    0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,
    0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x30,
    0x31, 0x32, 0x33, 0x40, 0x40, 0x40, 0x40, 0x40,

    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,

    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,

    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,

    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40
};

/*
 * INetCoreMessageDecode64Stream.
 */
INetCoreMessageDecode64Stream::INetCoreMessageDecode64Stream (
    sal_uInt32 nMsgBufferSize)
    : INetCoreMessageOStream(),
      nMsgBufSiz (nMsgBufferSize)
{
    ParseHeader (sal_False);

    pMsgBuffer = (sal_Char*)(rtl_allocateMemory (nMsgBufSiz));
    pMsgRead = pMsgWrite = pMsgBuffer;

    eOState = INETCOREMSG_EOL_SCR;
}

/*
 * ~INetCoreMessageDecode64Stream.
 */
INetCoreMessageDecode64Stream::~INetCoreMessageDecode64Stream (void)
{
    rtl_freeMemory (pMsgBuffer);
}

/*
 * PutMsgLine.
 */
int INetCoreMessageDecode64Stream::PutMsgLine (
    const sal_Char *pData, sal_uInt32 nSize, void *pCtx)
{
    INetCoreMessage *pMsg = GetTargetMessage();
    if (pMsg == NULL)
        return INETCORESTREAM_STATUS_ERROR;

    SvStream *pOS = pMsg->GetDocumentStream();
    if (pOS == NULL)
        return INETCORESTREAM_STATUS_WOULDBLOCK;

    sal_uInt32 nWrite = pMsg->GetDocumentSize();

    const sal_Char *pStop = (pData + nSize);
    while (pData < pStop)
    {
        if (pr2six[(int)(*pData)] > 63)
        {
            /*
             * Character not in base64 alphabet.
             * Check for <End-of-Stream> or Junk.
             */
            if (*pData == '=')
            {
                // Final pad character -> Done.
                nWrite += pOS->Write (pMsgBuffer, (pMsgWrite - pMsgBuffer));

                pMsg->SetDocumentSize (nWrite);
                return INETCORESTREAM_STATUS_LOADED;
            }
            else if (eOState == INETCOREMSG_EOL_FCR)
            {
                // Skip any line break character.
                if ((*pData == '\r') || (*pData == '\n')) pData++;

                // Store decoded message buffer contents.
                nWrite += pOS->Write (pMsgBuffer, (pMsgWrite - pMsgBuffer));

                // Reset to <Begin-of-Buffer>.
                pMsgWrite = pMsgBuffer;
                eOState = INETCOREMSG_EOL_SCR;
            }
            else if ((*pData == '\r') || (*pData == '\n'))
            {
                // Skip any line break character.
                pData++;
                eOState = INETCOREMSG_EOL_FCR;
            }
            else
            {
                // Skip any junk character (may be transmission error).
                pData++;
            }
        }
        else
        {
            // Decode any other character into message buffer.
            switch ((pMsgRead - pMsgBuffer) % 4)
            {
                case 0:
                    *pMsgWrite    = (pr2six[(int)(*pData++)] << 2);
                    pMsgRead++;
                    break;

                case 1:
                    *pMsgWrite++ |= (pr2six[(int)(*pData  )] >> 4);
                    *pMsgWrite    = (pr2six[(int)(*pData++)] << 4);
                    pMsgRead++;
                    break;

                case 2:
                    *pMsgWrite++ |= (pr2six[(int)(*pData  )] >> 2);
                    *pMsgWrite    = (pr2six[(int)(*pData++)] << 6);
                    pMsgRead++;
                    break;

                default: // == case 3
                    *pMsgWrite++ |= (pr2six[(int)(*pData++)]);
                    pMsgRead = pMsgBuffer;
                    break;
            } // switch ((pMsgRead - pMsgBuffer) % 4)
        }
    } // while (pData < pStop)

    pMsg->SetDocumentSize (nWrite);
    return INETCORESTREAM_STATUS_OK;
}

/*=========================================================================
 *
 * INetCoreMIMEMessageStream Implementation.
 *
 *=======================================================================*/
/*
 * INetCoreMIMEMessageStream.
 */
INetCoreMIMEMessageStream::INetCoreMIMEMessageStream (
    sal_uInt32 nMsgBufferSize)
    : INetCoreRFC822MessageStream (),
      nMsgBufSiz    (nMsgBufferSize),
      eState        (INETCOREMSG_MIME_BEGIN),
      eOkState      (INETCOREMSG_MIME_JUNK),
      nChildIndex   (0),
      pChildStream  (NULL),
      pEncodeStream (NULL),
      pDecodeStream (NULL),
      eEncoding     (INETCOREMSG_ENCODING_7BIT)
{
    pMsgBuffer = (sal_Char*)(rtl_allocateMemory (nMsgBufSiz));
    pMsgRead = pMsgWrite = pMsgBuffer;
}

/*
 * ~INetCoreMIMEMessageStream.
 */
INetCoreMIMEMessageStream::~INetCoreMIMEMessageStream (void)
{
    delete pChildStream;
    delete pEncodeStream;
    delete pDecodeStream;
    rtl_freeMemory (pMsgBuffer);
}

/*
 * IsPartDelimiter_Impl.
 */
static sal_Bool IsPartDelimiter_Impl (
    const ByteString &rDelim, const sal_Char *p, xub_StrLen n)
{
    if (n >= rDelim.Len())
    {
        // Check for part delimiter.
        if (rDelim.CompareTo (p, rDelim.Len()) == COMPARE_EQUAL)
        {
            // Check for close delimiter.
            p += rDelim.Len();
            n -= rDelim.Len();
            if ((n >= 2) && (p[0] == '-') && (p[1] == '-'))
                return sal_False;
            else
                return sal_True;
        }
    }
    return sal_False;
}

/*
 * GetMsgEncoding.
 */
INetCoreMIMEMessageStreamEncoding
INetCoreMIMEMessageStream::GetMsgEncoding (const ByteString& rContentType)
{
    if ((rContentType.CompareIgnoreCaseToAscii ("message"  , 7) == 0) ||
        (rContentType.CompareIgnoreCaseToAscii ("multipart", 9) == 0)    )
        return INETCOREMSG_ENCODING_7BIT;

    if (rContentType.CompareIgnoreCaseToAscii ("text", 4) == 0)
    {
        if (rContentType.CompareIgnoreCaseToAscii ("text/plain", 10) == 0)
        {
            if (rContentType.GetTokenCount ('=') > 1)
            {
                ByteString aCharset (rContentType.GetToken (1, '='));
                aCharset.EraseLeadingChars (' ');
                aCharset.EraseLeadingChars ('"');

                if (aCharset.CompareIgnoreCaseToAscii ("us-ascii", 8) == 0)
                    return INETCOREMSG_ENCODING_7BIT;
                else
                    return INETCOREMSG_ENCODING_QUOTED;
            }
            else
                return INETCOREMSG_ENCODING_7BIT;
        }
        else
            return INETCOREMSG_ENCODING_QUOTED;
    }

    return INETCOREMSG_ENCODING_BASE64;
}

/*
 * GetMsgLine.
 * (Header Field Generator)
 */
int INetCoreMIMEMessageStream::GetMsgLine (
    sal_Char *pData, sal_uInt32 nSize, void *pCtx)
{
    // Check for message container.
    INetCoreMIMEMessage *pMsg = GetSourceMessage();
    if (pMsg == NULL)
        return INETCORESTREAM_STATUS_ERROR;

    // Check whether to generate header or body.
    while (!IsHeaderGenerated ())
    {
        /*
         * Generate a message header field line.
         */
        int nRead;
        switch (eState)
        {
            case INETCOREMSG_MIME_BEGIN:
                if ((nRead = INetCoreRFC822MessageStream::GetMsgLine (
                    pData, nSize, pCtx)) > 0)
                    return nRead;
                else
                    eState = INETCOREMSG_MIME_VERSION;
                break;

            case INETCOREMSG_MIME_VERSION:
                eState = INETCOREMSG_MIME_CONTENT_BASE;
                if (pMsg->GetParent() == NULL)
                {
                    pMsg->SetMIMEVersion_Impl ("1.0");
                    return GenerateHeaderField (
                        "MIME-Version", pMsg->GetMIMEVersion_Impl(),
                        INetMIME::HEADER_FIELD_STRUCTURED,
                        pData, nSize);
                }
                else
                {
                    pMsg->SetMIMEVersion_Impl (ByteString());
                }
                break;

            case INETCOREMSG_MIME_CONTENT_BASE:
                eState = INETCOREMSG_MIME_CONTENT_DESCRIPTION;
                if ((nRead = GenerateHeaderField (
                    "Content-Base", pMsg->GetContentBase_Impl(),
                    INetMIME::HEADER_FIELD_TEXT,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_MIME_CONTENT_DESCRIPTION:
                eState = INETCOREMSG_MIME_CONTENT_DISPOSITION;
                if ((nRead = GenerateHeaderField (
                    "Content-Description", pMsg->GetContentDescription_Impl(),
                    INetMIME::HEADER_FIELD_TEXT,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_MIME_CONTENT_DISPOSITION:
                eState = INETCOREMSG_MIME_CONTENT_ID;
                if ((nRead = GenerateHeaderField (
                    "Content-Disposition", pMsg->GetContentDisposition_Impl(),
                    INetMIME::HEADER_FIELD_STRUCTURED,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_MIME_CONTENT_ID:
                eState = INETCOREMSG_MIME_CONTENT_LOCATION;
                if ((nRead = GenerateHeaderField (
                    "Content-ID", pMsg->GetContentID_Impl(),
                    INetMIME::HEADER_FIELD_MESSAGE_ID,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_MIME_CONTENT_LOCATION:
                eState = INETCOREMSG_MIME_CONTENT_TYPE;
                if ((nRead = GenerateHeaderField (
                    "Content-Location", pMsg->GetContentLocation_Impl(),
                    INetMIME::HEADER_FIELD_TEXT,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_MIME_CONTENT_TYPE:
                eState = INETCOREMSG_MIME_CONTENT_TRANSFER_ENCODING;
                if (pMsg->GetContentType_Impl().Len() == 0)
                    pMsg->SetContentType_Impl ("text/plain; charset=us-ascii");
                return GenerateHeaderField (
                    "Content-Type", pMsg->GetContentType_Impl(),
                    INetMIME::HEADER_FIELD_STRUCTURED,
                    pData, nSize);
                break;

            case INETCOREMSG_MIME_CONTENT_TRANSFER_ENCODING:
                eState = INETCOREMSG_MIME_END;
                eEncoding = GetMsgEncoding (pMsg->GetContentType_Impl());
                switch (eEncoding)
                {
                    case INETCOREMSG_ENCODING_BASE64:
                        pMsg->SetContentTransferEncoding_Impl ("base64");
                        break;

                    case INETCOREMSG_ENCODING_QUOTED:
                        pMsg->SetContentTransferEncoding_Impl ("quoted-printable");
                        break;

                    default:
                        pMsg->SetContentTransferEncoding_Impl ("7bit");
                        break;
                }
                return GenerateHeaderField (
                    "Content-Transfer-Encoding",
                    pMsg->GetContentTransferEncoding_Impl(),
                    INetMIME::HEADER_FIELD_STRUCTURED,
                    pData, nSize);
                break;

            case INETCOREMSG_MIME_END:
                eState = INETCOREMSG_MIME_BEGIN;
                eIState = INETCOREMSG_EOL_BEGIN;
                return 0;
                break;

            default: // Never reached.
                return INETCORESTREAM_STATUS_ERROR;
                break;
        } // switch (eState)
    } // while (!bHeaderGenerated)

    /*
     * Generate the message body.
     */
    if (pMsg->IsContainer())
    {
        /*
         * Encapsulated message body.
         */
        while (eState == INETCOREMSG_MIME_BEGIN)
        {
            if (pChildStream == NULL)
            {
                INetCoreMIMEMessage *pNextMsg = pMsg->GetChild (nChildIndex);
                if (pNextMsg)
                {
                    // Increment child index.
                    nChildIndex++;

                    // Create child stream.
                    pChildStream = pNextMsg->CreateMessageStream();
                    pChildStream->SetSourceMessage (pNextMsg);

                    SvStream *pDocStrm = pNextMsg->GetDocumentStream();
                    if (pDocStrm)
                        pDocStrm->Seek (STREAM_SEEK_TO_BEGIN);

                    if (pMsg->IsMultipart())
                    {
                        // Insert multipart delimiter.
                        ByteString aDelim ("--");
                        aDelim += pMsg->GetMultipartBoundary_Impl();
                        aDelim += "\015\012";

                        rtl_copyMemory (
                            pData, aDelim.GetBuffer(), aDelim.Len());
                        return aDelim.Len();
                    }
                }
                else
                {
                    // No more parts. Mark we're done.
                    eState = INETCOREMSG_MIME_END;
                    nChildIndex = 0;

                    if (pMsg->IsMultipart())
                    {
                        // Insert close delimiter.
                        ByteString aDelim ("--");
                        aDelim += pMsg->GetMultipartBoundary_Impl();
                        aDelim += "--\015\012";

                        rtl_copyMemory (
                            pData, aDelim.GetBuffer(), aDelim.Len());
                        return aDelim.Len();
                    }
                }
            }
            else
            {
                // Read current child stream.
                int nRead = pChildStream->Read (pData, nSize, pCtx);
                if (nRead > 0)
                {
                    return nRead;
                }
                else
                {
                    // Cleanup exhausted child stream.
                    DELETEZ (pChildStream);
                }
            }
        } // while (eState == INETCOREMSG_MIME_BEGIN)
        return 0;
    }
    else
    {
        /*
         * Single part message body.
         */
        if (pMsg->GetDocumentStream () == NULL)
        {
            // Empty message body.
            return 0;
        }
        else
        {
            // Check whether message body needs to be encoded.
            if (eEncoding == INETCOREMSG_ENCODING_7BIT)
            {
                // No Encoding.
                return INetCoreRFC822MessageStream::GetMsgLine (
                    pData, nSize, pCtx);
            }
            else
            {
                // Apply appropriate Encoding.
                while (eState == INETCOREMSG_MIME_BEGIN)
                {
                    if (pEncodeStream == NULL)
                    {
                        // Create encoder stream.
                        if (eEncoding == INETCOREMSG_ENCODING_QUOTED)
                        {
                            // Quoted-Printable Encoding.
                            pEncodeStream = new INetCoreMessageEncodeQPStream;
                        }
                        else
                        {
                            // Base64 Encoding.
                            pEncodeStream = new INetCoreMessageEncode64Stream;
                        }
                        pEncodeStream->SetSourceMessage (pMsg);

                        SvStream *pDocStrm = pMsg->GetDocumentStream();
                        if (pDocStrm)
                            pDocStrm->Seek (STREAM_SEEK_TO_BEGIN);
                    }
                    else
                    {
                        // Read encoded message.
                        int nRead = pEncodeStream->Read (pData, nSize, pCtx);
                        if (nRead > 0)
                        {
                            return nRead;
                        }
                        else
                        {
                            // Cleanup exhausted encoder stream.
                            DELETEZ (pEncodeStream);

                            // Mark we're done.
                            eState = INETCOREMSG_MIME_END;
                        }
                    }
                } // while (eState == INETCOREMSG_MIME_BEGIN)
                return 0;
            }
        }
    }
    return INETCORESTREAM_STATUS_ERROR; // Never reached.
}

/*
 * PutMsgLine.
 * (Header Field Parser)
 */
int INetCoreMIMEMessageStream::PutMsgLine (
    const sal_Char *pData, sal_uInt32 nSize, void *pCtx)
{
    // Check for message container.
    INetCoreMIMEMessage *pMsg = GetTargetMessage();
    if (pMsg == NULL)
        return INETCORESTREAM_STATUS_ERROR;

    // Check whether to parse header or body.
    if (!IsHeaderParsed ())
    {
        /*
         * Parse a message header field line.
         */
        const sal_Char *pSave = pData;
        const sal_Char *pStop = (pData + nSize);
        const sal_Char *check = "";
        ByteString     aField;

        eState   = INETCOREMSG_MIME_BEGIN;
        eOkState = INETCOREMSG_MIME_JUNK;

        while (pData < pStop)
        {
            switch (eState)
            {
                case INETCOREMSG_MIME_BEGIN:
                    switch (ascii_toLowerCase (*pData))
                    {
                        case 'c':
                            check = "ontent-";
                            eOkState = INETCOREMSG_MIME_TOKEN_CONTENT;
                            eState = INETCOREMSG_MIME_CHECK;
                            break;

                        case 'm':
                            check = "ime-version";
                            eOkState = INETCOREMSG_MIME_VERSION;
                            eState = INETCOREMSG_MIME_CHECK;
                            break;

                        default:
                            eState = INETCOREMSG_MIME_RFC822;
                            break;
                    }
                    pData++;
                    break;

                case INETCOREMSG_MIME_TOKEN_CONTENT:
                    switch (ascii_toLowerCase (*pData))
                    {
                        case 'b':
                            check = "ase";
                            eOkState = INETCOREMSG_MIME_CONTENT_BASE;
                            eState = INETCOREMSG_MIME_CHECK;
                            break;

                        case 'd':
                            eState = INETCOREMSG_MIME_TOKEN_CONTENT_D;
                            break;

                        case 'i':
                            check = "d";
                            eOkState = INETCOREMSG_MIME_CONTENT_ID;
                            eState = INETCOREMSG_MIME_CHECK;
                            break;

                        case 'l':
                            check = "ocation";
                            eOkState = INETCOREMSG_MIME_CONTENT_LOCATION;
                            eState = INETCOREMSG_MIME_CHECK;
                            break;

                        case 't':
                            eState = INETCOREMSG_MIME_TOKEN_CONTENT_T;
                            break;

                        default:
                            eState = INETCOREMSG_MIME_RFC822;
                            break;
                    }
                    pData++;
                    break;

                case INETCOREMSG_MIME_TOKEN_CONTENT_D:
                    switch (ascii_toLowerCase (*pData))
                    {
                        case 'e':
                            check = "scription";
                            eOkState = INETCOREMSG_MIME_CONTENT_DESCRIPTION;
                            eState = INETCOREMSG_MIME_CHECK;
                            break;

                        case 'i':
                            check = "sposition";
                            eOkState = INETCOREMSG_MIME_CONTENT_DISPOSITION;
                            eState = INETCOREMSG_MIME_CHECK;
                            break;

                        default:
                            eState = INETCOREMSG_MIME_RFC822;
                            break;
                    }
                    pData++;
                    break;

                case INETCOREMSG_MIME_TOKEN_CONTENT_T:
                    switch (ascii_toLowerCase (*pData))
                    {
                        case 'r':
                            check = "ansfer-encoding";
                            eOkState =
                                INETCOREMSG_MIME_CONTENT_TRANSFER_ENCODING;
                            eState = INETCOREMSG_MIME_CHECK;
                            break;

                        case 'y':
                            check = "pe";
                            eOkState = INETCOREMSG_MIME_CONTENT_TYPE;
                            eState = INETCOREMSG_MIME_CHECK;
                            break;

                        default:
                            eState = INETCOREMSG_MIME_RFC822;
                            break;
                    }
                    pData++;
                    break;

                case INETCOREMSG_MIME_CHECK:
                    while (ascii_toLowerCase (*pData) == *check)
                    {
                        pData++;
                        check++;
                    }
                    if (*check == '\0')
                    {
                        eState = eOkState;
                        while (*pData)
                        {
                            if (ascii_isWhitespace (*pData))
                                pData++;
                            else if (*pData == ':')
                                pData++;
                            else
                                break;
                        }

                        /* @@@ OBSOLETE @@@ */
                        aField = ConvertFrom7Bit (pData);
                    }
                    else
                    {
                        eState = INETCOREMSG_MIME_RFC822;
                    }
                    break;

                case INETCOREMSG_MIME_VERSION:
                    pMsg->SetMIMEVersion_Impl (aField);
                    eState = INETCOREMSG_MIME_JUNK;
                    break;

                case INETCOREMSG_MIME_CONTENT_BASE:
                    pMsg->SetContentBase_Impl (aField);
                    eState = INETCOREMSG_MIME_JUNK;
                    break;

                case INETCOREMSG_MIME_CONTENT_DESCRIPTION:
                    pMsg->SetContentDescription_Impl (aField);
                    eState = INETCOREMSG_MIME_JUNK;
                    break;

                case INETCOREMSG_MIME_CONTENT_DISPOSITION:
                    pMsg->SetContentDisposition_Impl (aField);
                    eState = INETCOREMSG_MIME_JUNK;
                    break;

                case INETCOREMSG_MIME_CONTENT_ID:
                    pMsg->SetContentID_Impl (aField);
                    eState = INETCOREMSG_MIME_JUNK;
                    break;

                case INETCOREMSG_MIME_CONTENT_LOCATION:
                    pMsg->SetContentLocation_Impl (aField);
                    eState = INETCOREMSG_MIME_JUNK;
                    break;

                case INETCOREMSG_MIME_CONTENT_TYPE:
                    pMsg->SetContentType_Impl (aField);
                    eState = INETCOREMSG_MIME_JUNK;
                    break;

                case INETCOREMSG_MIME_CONTENT_TRANSFER_ENCODING:
                    pMsg->SetContentTransferEncoding_Impl (aField);
                    {
                        ByteString aEncoding (
                            pMsg->GetContentTransferEncoding_Impl());
                        if (aEncoding.CompareIgnoreCaseToAscii (
                            "base64", 6) == COMPARE_EQUAL)
                            eEncoding = INETCOREMSG_ENCODING_BASE64;
                        else if (aEncoding.CompareIgnoreCaseToAscii (
                            "quoted-printable", 16) == COMPARE_EQUAL)
                            eEncoding = INETCOREMSG_ENCODING_QUOTED;
                        else
                            eEncoding = INETCOREMSG_ENCODING_7BIT;
                    }
                    eState = INETCOREMSG_MIME_JUNK;
                    break;

                case INETCOREMSG_MIME_RFC822:
                    while (pData < pStop) pData++;
                    eState = INETCOREMSG_MIME_BEGIN;
                    return INetCoreRFC822MessageStream::PutMsgLine (
                        pSave, nSize, pCtx);
                    break;

                default: // _JUNK
                    while (pData < pStop) pData++;
                    eState = INETCOREMSG_MIME_BEGIN;
                    break;
            } // switch (eState)
        } // while (pData < pStop)
        return INETCORESTREAM_STATUS_OK;
    }
    else
    {
        /*
         * Parse the message body.
         */
        if (pMsg->IsContainer())
        {
            // Content-Transfer-Encoding MUST be "7bit" (RFC1521).
            if (pMsg->IsMessage())
            {
                // Encapsulated message.
                pMsg->SetChildCount_Impl(1);
                return INetCoreRFC822MessageStream::PutMsgLine (
                    pData, nSize, pCtx);
            }
            else
            {
                // Multipart message.
                if (pMsg->GetMultipartBoundary_Impl().Len() == 0)
                {
                    // Determine boundary.
                    ByteString aBoundary;
                    ByteString aType (pMsg->GetContentType_Impl());

                    USHORT n = aType.GetTokenCount (';');
                    for (USHORT i = 0; i < n; i++)
                    {
                        ByteString aParam      (aType.GetToken (i, ';'));
                        ByteString aLowerParam (aParam);
                        aLowerParam.ToLowerAscii();

                        USHORT nPos = aLowerParam.Search ("boundary=");
                        if (nPos != STRING_NOTFOUND)
                        {
                            aBoundary = aParam.Copy (nPos + 9);
                            break;
                        }
                    }

                    aBoundary.EraseLeadingChars  (' ');
                    aBoundary.EraseTrailingChars (' ');

                    aBoundary.EraseLeadingChars  ('"');
                    aBoundary.EraseTrailingChars ('"');

                    // Save boundary.
                    pMsg->SetMultipartBoundary_Impl (aBoundary);
                }

                ByteString aDelim ("--");
                aDelim += pMsg->GetMultipartBoundary_Impl();

                // Count number of parts.
                const sal_Char *pStop = pData + nSize;
                while (pData < pStop)
                {
                    if (eState == INETCOREMSG_MIME_END)
                    {
                        int status;

                        // Check for 2nd line break character.
                        if ((*pData == '\r') || (*pData == '\n'))
                        {
                            // Copy current character.
                            *pMsgWrite++ = *pData++;

                            // Put buffered line down-stream.
                            status = INetCoreRFC822MessageStream::PutMsgLine (
                                pMsgBuffer, (pMsgWrite - pMsgBuffer), pCtx);

                            // Reset to <Begin-of-Buffer>.
                            pMsgWrite = pMsgBuffer;
                        }
                        else
                        {
                            // Put buffered line down-stream.
                            status = INetCoreRFC822MessageStream::PutMsgLine (
                                pMsgBuffer, (pMsgWrite - pMsgBuffer), pCtx);

                            // Reset to <Begin-of-Buffer>.
                            pMsgWrite = pMsgBuffer;

                            // Copy current character.
                            *pMsgWrite++ = *pData++;
                        }

                        if (status != INETCORESTREAM_STATUS_OK) return status;
                        eState = INETCOREMSG_MIME_BEGIN;
                    }
                    else if ((*pData == '\r') || (*pData == '\n'))
                    {
                        /*
                         * Found any line break character.
                         * Compare buffered line with part delimiter.
                         */
                        xub_StrLen n = pMsgWrite - pMsgBuffer;
                        if (IsPartDelimiter_Impl (aDelim, pMsgBuffer, n))
                        {
                            // Increment part count.
                            ULONG nCount = pMsg->GetChildCount();
                            pMsg->SetChildCount_Impl (nCount + 1);
                        }
                        *pMsgWrite++ = *pData++;
                        eState = INETCOREMSG_MIME_END;
                    }
                    else
                    {
                        *pMsgWrite++ = *pData++;
                    }
                }
                return INETCORESTREAM_STATUS_OK;
            }
        }
        else
        {
            /*
             * Single part message.
             * Remove any ContentTransferEncoding.
             */
            if (pMsg->GetContentType_Impl().Len() == 0)
            {
                ByteString aDefault (pMsg->GetDefaultContentType_Impl());
                pMsg->SetContentType_Impl (aDefault);
            }

            if (eEncoding == INETCOREMSG_ENCODING_7BIT)
            {
                // No decoding necessary.
                return INetCoreRFC822MessageStream::PutMsgLine (
                    pData, nSize, pCtx);
            }
            else
            {
                if (pDecodeStream == NULL)
                {
                    if (eEncoding == INETCOREMSG_ENCODING_QUOTED)
                        pDecodeStream = new INetCoreMessageDecodeQPStream;
                    else
                        pDecodeStream = new INetCoreMessageDecode64Stream;

                    pDecodeStream->SetTargetMessage (pMsg);
                }
                return pDecodeStream->Write (pData, nSize, pCtx);
            }
        }
    }
}

/*======================================================================
 *
 * INetCoreNewsMessageStream Implementation.
 *
 *====================================================================*/
/*
 * INetCoreNewsMessageStream.
 */
INetCoreNewsMessageStream::INetCoreNewsMessageStream (void)
    : eState   (INETCOREMSG_NEWS_BEGIN),
      eOkState (INETCOREMSG_NEWS_JUNK)
{
}

/*
 * ~INetCoreNewsMessageStream.
 */
INetCoreNewsMessageStream::~INetCoreNewsMessageStream (void)
{
}

/*
 * GetMsgLine.
 * (Header Field Generator)
 */
int INetCoreNewsMessageStream::GetMsgLine (
    sal_Char *pData, sal_uInt32 nSize, void *pCtx)
{
    // Check for message container.
    INetCoreNewsMessage *pMsg = GetSourceMessage();
    if (pMsg == NULL)
        return INETCORESTREAM_STATUS_ERROR;

    // Check whether to generate header or body.
    while (!IsHeaderGenerated ())
    {
        /*
         * Generate a news message header field line.
         */
        int nRead;
        switch (eState)
        {
            case INETCOREMSG_NEWS_BEGIN:
                if ((nRead = INetCoreMIMEMessageStream::GetMsgLine (
                    pData, nSize, pCtx)) > 0)
                    return nRead;
                else
                    eState = INETCOREMSG_NEWS_NEWSGROUPS;
                break;

            case INETCOREMSG_NEWS_NEWSGROUPS: // Required.
                eState = INETCOREMSG_NEWS_PATH;
                if ((nRead = GenerateHeaderField (
                    "Newsgroups", pMsg->GetNewsgroups_Impl(),
                    INetMIME::HEADER_FIELD_STRUCTURED,
                    pData, nSize,
                    INetMIME::HARD_LINE_LENGTH_LIMIT)) > 0) return nRead;
                break;

            case INETCOREMSG_NEWS_PATH: // Intensionally not sent.
                eState = INETCOREMSG_NEWS_APPROVED;
                break;

            case INETCOREMSG_NEWS_APPROVED:
                eState = INETCOREMSG_NEWS_CONTROL;
                if ((nRead = GenerateHeaderField (
                    "Approved", pMsg->GetApproved_Impl(),
                    INetMIME::HEADER_FIELD_ADDRESS,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_NEWS_CONTROL:
                eState = INETCOREMSG_NEWS_DISTRIBUTION;
                if ((nRead = GenerateHeaderField (
                    "Control", pMsg->GetControl_Impl(),
                    INetMIME::HEADER_FIELD_STRUCTURED,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_NEWS_DISTRIBUTION:
                eState = INETCOREMSG_NEWS_EXPIRES;
                if ((nRead = GenerateHeaderField (
                    "Distribution", pMsg->GetDistribution_Impl(),
                    INetMIME::HEADER_FIELD_STRUCTURED,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_NEWS_EXPIRES:
                eState = INETCOREMSG_NEWS_FOLLOWUP_TO;
                if ((nRead = GenerateHeaderField (
                    "Expires", pMsg->GetExpires_Impl(),
                    INetMIME::HEADER_FIELD_STRUCTURED,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_NEWS_FOLLOWUP_TO:
                eState = INETCOREMSG_NEWS_LINES;
                if ((nRead = GenerateHeaderField (
                    "Followup-To", pMsg->GetFollowupTo_Impl(),
                    INetMIME::HEADER_FIELD_STRUCTURED,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_NEWS_LINES:
                eState = INETCOREMSG_NEWS_ORGANIZATION;
                if ((nRead = GenerateHeaderField (
                    "Lines", pMsg->GetLines_Impl(),
                    INetMIME::HEADER_FIELD_TEXT,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_NEWS_ORGANIZATION:
                eState = INETCOREMSG_NEWS_SUMMARY;
                if ((nRead = GenerateHeaderField (
                    "Organization", pMsg->GetOrganization_Impl(),
                    INetMIME::HEADER_FIELD_TEXT,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_NEWS_SUMMARY:
                eState = INETCOREMSG_NEWS_XREF;
                if ((nRead = GenerateHeaderField (
                    "Summary", pMsg->GetSummary_Impl(),
                    INetMIME::HEADER_FIELD_TEXT,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_NEWS_XREF:
                eState = INETCOREMSG_NEWS_X_NEWSREADER;
                if ((nRead = GenerateHeaderField (
                    "Xref", pMsg->GetXref_Impl(),
                    INetMIME::HEADER_FIELD_STRUCTURED,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_NEWS_X_NEWSREADER:
                eState = INETCOREMSG_NEWS_END;
                if ((nRead = GenerateHeaderField (
                    "X-Newsreader", pMsg->GetXNewsreader_Impl(),
                    INetMIME::HEADER_FIELD_TEXT,
                    pData, nSize)) > 0) return nRead;
                break;

            case INETCOREMSG_NEWS_END:
                eState = INETCOREMSG_NEWS_BEGIN;
                return 0;
                break;

            default: // Never reached.
                return INETCORESTREAM_STATUS_ERROR;
                break;
        } // switch (eState)
    } // while (!IsHeaderGenerated ())

    /*
     * Generate the news message body, which can be any MIME message.
     */
    return INetCoreMIMEMessageStream::GetMsgLine (pData, nSize, pCtx);
}

/*
 * PutMsgLine.
 * (Header Field Parser)
 */
int INetCoreNewsMessageStream::PutMsgLine (
    const sal_Char *pData, sal_uInt32 nSize, void *pCtx)
{
    // Check for message container.
    INetCoreNewsMessage *pMsg = GetTargetMessage();
    if (pMsg == NULL)
        return INETCORESTREAM_STATUS_ERROR;

    // Check whether to parse header or body.
    if (!IsHeaderParsed ())
    {
        /*
         * Parse a news message header field line.
         */
        const sal_Char *pSave = pData;
        const sal_Char *pStop = (pData + nSize);
        const sal_Char *check = "";
        ByteString      aField;

        eState   = INETCOREMSG_NEWS_BEGIN;
        eOkState = INETCOREMSG_NEWS_JUNK;

        while (pData < pStop)
        {
            switch (eState)
            {
                case INETCOREMSG_NEWS_BEGIN:
                    switch (ascii_toLowerCase (*pData))
                    {
                        case 'a':
                            check = "pproved";
                            eOkState = INETCOREMSG_NEWS_APPROVED;
                            eState = INETCOREMSG_NEWS_CHECK;
                            break;

                        case 'b':
                            check = "ytes";
                            eOkState = INETCOREMSG_NEWS_BYTES;
                            eState = INETCOREMSG_NEWS_CHECK;
                            break;

                        case 'c':
                            check = "ontrol";
                            eOkState = INETCOREMSG_NEWS_CONTROL;
                            eState = INETCOREMSG_NEWS_CHECK;
                            break;

                        case 'd':
                            check = "istribution";
                            eOkState = INETCOREMSG_NEWS_DISTRIBUTION;
                            eState = INETCOREMSG_NEWS_CHECK;
                            break;

                        case 'e':
                            check = "xpires";
                            eOkState = INETCOREMSG_NEWS_EXPIRES;
                            eState = INETCOREMSG_NEWS_CHECK;
                            break;

                        case 'f':
                            check = "ollowup-to";
                            eOkState = INETCOREMSG_NEWS_FOLLOWUP_TO;
                            eState = INETCOREMSG_NEWS_CHECK;
                            break;

                        case 'l':
                            check = "ines";
                            eOkState = INETCOREMSG_NEWS_LINES;
                            eState = INETCOREMSG_NEWS_CHECK;
                            break;

                        case 'n':
                            check = "ewsgroups";
                            eOkState = INETCOREMSG_NEWS_NEWSGROUPS;
                            eState = INETCOREMSG_NEWS_CHECK;
                            break;

                        case 'o':
                            check = "rganization";
                            eOkState = INETCOREMSG_NEWS_ORGANIZATION;
                            eState = INETCOREMSG_NEWS_CHECK;
                            break;

                        case 'p':
                            check = "ath";
                            eOkState = INETCOREMSG_NEWS_PATH;
                            eState = INETCOREMSG_NEWS_CHECK;
                            break;

                        case 's':
                            check = "ummary";
                            eOkState = INETCOREMSG_NEWS_SUMMARY;
                            eState = INETCOREMSG_NEWS_CHECK;
                            break;

                        case 'x':
                            eState = INETCOREMSG_NEWS_LETTER_X;
                            break;

                        default:
                            eState = INETCOREMSG_NEWS_MIME;
                            break;
                    }
                    pData++;
                    break;

                case INETCOREMSG_NEWS_LETTER_X:
                    switch (ascii_toLowerCase (*pData))
                    {
                        case 'r':
                            check = "ef";
                            eOkState = INETCOREMSG_NEWS_XREF;
                            eState = INETCOREMSG_NEWS_CHECK;
                            break;

                        case '-':
                            check = "newsreader";
                            eOkState = INETCOREMSG_NEWS_X_NEWSREADER;
                            eState = INETCOREMSG_NEWS_CHECK;
                            break;

                        default:
                            eState = INETCOREMSG_NEWS_MIME;
                            break;
                    }
                    pData++;
                    break;

                case INETCOREMSG_NEWS_CHECK:
                    while (ascii_toLowerCase (*pData) == *check)
                    {
                        pData++;
                        check++;
                    }
                    if (*check == '\0')
                    {
                        eState = eOkState;
                        while (*pData)
                        {
                            if (ascii_isWhitespace (*pData))
                                pData++;
                            else if (*pData == ':')
                                pData++;
                            else
                                break;
                        }

                        /* @@@ OBSOLETE @@@ */
                        aField = ConvertFrom7Bit (pData);
                    }
                    else
                    {
                        eState = INETCOREMSG_NEWS_MIME;
                    }
                    break;

                case INETCOREMSG_NEWS_NEWSGROUPS:
                    pMsg->SetNewsgroups_Impl (aField);
                    eState = INETCOREMSG_NEWS_JUNK;
                    break;

                case INETCOREMSG_NEWS_PATH:
                    pMsg->SetPath_Impl (aField);
                    eState = INETCOREMSG_NEWS_JUNK;
                    break;

                case INETCOREMSG_NEWS_APPROVED:
                    pMsg->SetApproved_Impl (aField);
                    eState = INETCOREMSG_NEWS_JUNK;
                    break;

                case INETCOREMSG_NEWS_BYTES:
                    pMsg->SetBytes_Impl (aField);
                    eState = INETCOREMSG_NEWS_JUNK;
                    break;

                case INETCOREMSG_NEWS_CONTROL:
                    pMsg->SetControl_Impl (aField);
                    eState = INETCOREMSG_NEWS_JUNK;
                    break;

                case INETCOREMSG_NEWS_DISTRIBUTION:
                    pMsg->SetDistribution_Impl (aField);
                    eState = INETCOREMSG_NEWS_JUNK;
                    break;

                case INETCOREMSG_NEWS_EXPIRES:
                    pMsg->SetExpires_Impl (aField);
                    eState = INETCOREMSG_NEWS_JUNK;
                    break;

                case INETCOREMSG_NEWS_FOLLOWUP_TO:
                    pMsg->SetFollowupTo_Impl (aField);
                    eState = INETCOREMSG_NEWS_JUNK;
                    break;

                case INETCOREMSG_NEWS_LINES:
                    pMsg->SetLines_Impl (aField);
                    eState = INETCOREMSG_NEWS_JUNK;
                    break;

                case INETCOREMSG_NEWS_ORGANIZATION:
                    pMsg->SetOrganization_Impl (aField);
                    eState = INETCOREMSG_NEWS_JUNK;
                    break;

                case INETCOREMSG_NEWS_SUMMARY:
                    pMsg->SetSummary_Impl (aField);
                    eState = INETCOREMSG_NEWS_JUNK;
                    break;

                case INETCOREMSG_NEWS_XREF:
                    pMsg->SetXref_Impl (aField);
                    eState = INETCOREMSG_NEWS_JUNK;
                    break;

                case INETCOREMSG_NEWS_X_NEWSREADER:
                    pMsg->SetXNewsreader_Impl (aField);
                    eState = INETCOREMSG_NEWS_JUNK;
                    break;

                case INETCOREMSG_NEWS_MIME:
                    while (pData < pStop) pData++;
                    eState = INETCOREMSG_NEWS_BEGIN;
                    return INetCoreMIMEMessageStream::PutMsgLine (
                        pSave, nSize, pCtx);
                    break;

                default: // _JUNK;
                    while (pData < pStop) pData++;
                    eState = INETCOREMSG_NEWS_BEGIN;
                    break;
            } // switch (eState)
        } // while (pData < pStop)
        return INETCORESTREAM_STATUS_OK;
    }
    else
    {
        /*
         * Parse the news message body, which can be any MIME message.
         */
        return INetCoreMIMEMessageStream::PutMsgLine (pData, nSize, pCtx);
    }
}

