/*************************************************************************
 *
 *  $RCSfile: httpwrap.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _INET_HTTPWRAP_CXX "$Revision: 1.1.1.1 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _INET_MACROS_HXX
#include <inet/macros.hxx>
#endif

#ifndef _INET_HTTPWRAP_HXX
#include "httpwrap.hxx"
#endif
#ifndef _INETHTTP_HXX
#include "inethttp.hxx"
#endif
#ifndef _INETDNS_HXX
#include "inetdns.hxx"
#endif

#ifdef _USE_NAMESPACE
using namespace inet;
#endif

/*=======================================================================
 *
 * INetHTTPWrapper implementation.
 *
 *=====================================================================*/
VOS_IMPLEMENT_CLASSINFO(
	VOS_CLASSNAME (INetHTTPWrapper, inet),
	VOS_NAMESPACE (INetHTTPWrapper, inet),
	VOS_NAMESPACE (OMutex, vos),
	0);

/*
 * INetHTTPWrapper.
 */
INetHTTPWrapper::INetHTTPWrapper (void)
{
	NAMESPACE_VOS(OGuard) aGuard (*this);
	m_pResolver = new INetCoreDNSResolver();
}

/*
 * ~INetHTTPWrapper.
 */
INetHTTPWrapper::~INetHTTPWrapper (void)
{
	NAMESPACE_VOS(OGuard) aGuard (*this);
	delete m_pResolver;
}

/*
 * newHTTPConnection.
 */
sal_Bool INetHTTPWrapper::newHTTPConnection (
	NAMESPACE_VOS(ORef)<INetHTTPConnection> &rxConnection)
{
	NAMESPACE_VOS(OGuard) aGuard (*this);
	INetHTTPConnection::createInstance (rxConnection);
	return (rxConnection.isValid());
}

/*
 * newHTTPGetRequest.
 */
sal_Bool INetHTTPWrapper::newHTTPGetRequest (
	NAMESPACE_VOS(ORef)<INetHTTPGetRequest> &rxRequest)
{
	NAMESPACE_VOS(OGuard) aGuard (*this);
	rxRequest = new INetHTTPGetRequest();
	return (rxRequest.isValid());
}

/*
 * newHTTPHeadRequest.
 */
sal_Bool INetHTTPWrapper::newHTTPHeadRequest (
	NAMESPACE_VOS(ORef)<INetHTTPHeadRequest> &rxRequest)
{
	NAMESPACE_VOS(OGuard) aGuard (*this);
	rxRequest = new INetHTTPHeadRequest();
	return (rxRequest.isValid());
}

/*
 * newHTTPPostRequest.
 */
sal_Bool INetHTTPWrapper::newHTTPPostRequest (
	NAMESPACE_VOS(ORef)<INetHTTPPostRequest> &rxRequest)
{
	NAMESPACE_VOS(OGuard) aGuard (*this);
	rxRequest = new INetHTTPPostRequest();
	return (rxRequest.isValid());
}

/*
 * newHTTPPutRequest.
 */
sal_Bool INetHTTPWrapper::newHTTPPutRequest (
	NAMESPACE_VOS(ORef)<INetHTTPPutRequest> &rxRequest)
{
	NAMESPACE_VOS(OGuard) aGuard (*this);
	rxRequest = new INetHTTPPutRequest();
	return (rxRequest.isValid());
}

/*
 * newHTTPDeleteRequest.
 */
sal_Bool INetHTTPWrapper::newHTTPDeleteRequest (
	NAMESPACE_VOS(ORef)<INetHTTPDeleteRequest> &rxRequest)
{
	NAMESPACE_VOS(OGuard) aGuard (*this);
	rxRequest = new INetHTTPDeleteRequest();
	return (rxRequest.isValid());
}

/*
 * NewINetHTTPWrapper.
 * (called from INetWrapper::newINetHTTPWrapper()).
 */
NAMESPACE_INET(INetHTTPWrapper)* SAL_CALL NewINetHTTPWrapper (void)
{
	return new INetHTTPWrapper();
}

