/*************************************************************************
 *
 *  $RCSfile: socket.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _INET_SOCKET_HXX
#define _INET_SOCKET_HXX "$Revision: 1.1.1.1 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif
#ifndef _VOS_OBJECT_HXX_
#include <vos/object.hxx>
#endif
#ifndef _VOS_SOCKET_HXX_
#include <vos/socket.hxx>
#endif

#ifndef _INET_MACROS_HXX
#include <inet/macros.hxx>
#endif

typedef void* oslSocksContext;

#ifdef _USE_NAMESPACE
namespace inet {
#endif

class OSocketMonitor;
class OSocketDispatcher;

/*========================================================================
 *
 * INetSocket interface.
 *
 *======================================================================*/
class INetSocket : public NAMESPACE_VOS(OSocket)
{
	VOS_DECLARE_CLASSINFO (VOS_NAMESPACE (INetSocket, inet));

public:
	/** Event.
	 */
	enum Event
	{
		EVENT_READ    = 0x01,
		EVENT_WRITE   = 0x02,
		EVENT_OOB     = 0x04,

		EVENT_ACCEPT  = 0x08,
		EVENT_CONNECT = 0x10,
		EVENT_CLOSE   = 0x20,
		EVENT_LISTEN  = 0x40
	};

	/** EventHandler.
	 */
	typedef sal_Bool EventHandler (
		const NAMESPACE_VOS(ORef)<INetSocket> &rxSocket,
		sal_Int32                              nEvent,
		void                                  *pData);

	virtual sal_Bool registerEventHandler (
		EventHandler *pfnHandler, void *pData);

	virtual sal_Bool deregisterEventHandler (
		EventHandler *pfnHandler);


	/** Handle event (call registered handlers).
	 */
	virtual sal_Bool handleEvent (sal_Int32 nEvent);

	/** Post event.
	 */
	virtual sal_Bool postEvent (sal_Int32 nEvent);


	/** Local address of bound socket.
	 */
	virtual sal_Bool getMyAddr (
		NAMESPACE_VOS(OSocketAddr) &rMyAddr) const;

	/** Peer address of connected socket.
	 */
	virtual sal_Bool getToAddr (
		NAMESPACE_VOS(OSocketAddr) &rToAddr) const;


	/** Last socket error.
	 */
	virtual oslSocketError getLastError (void) const;


	/** recv.
	 */
	virtual sal_Int32 recv (
		void           *pData,
		sal_uInt32      nData,
		TSocketMsgFlag  eFlag = TMsg_Normal);

	/** send.
	 */
	virtual sal_Int32 send (
		const void     *pData,
		sal_uInt32      nData,
		TSocketMsgFlag  eFlag = TMsg_Normal);

	/** close.
	 */
	virtual void SAL_CALL close (void);

protected:
	/** Construction, destruction.
	 */
	INetSocket (TSocketType eType);
	INetSocket (oslSocket hSocket);
	virtual ~INetSocket (void);

	/** enableEvent.
	 */
	virtual void enableEvent (sal_Int32 nEvent);

private:
	/** Representation.
	 */
	NAMESPACE_VOS(ORef)<OSocketMonitor>    m_xMonitor;
	NAMESPACE_VOS(ORef)<OSocketDispatcher> m_xDispatcher;

	/** Not implemented.
	 */
	INetSocket (const INetSocket&);
	INetSocket& operator= (const INetSocket&);
};

/*========================================================================
 *
 * INetUDPSocket interface.
 *
 *======================================================================*/
class INetUDPSocket : public NAMESPACE_INET(INetSocket)
{
	VOS_DECLARE_CLASSINFO (VOS_NAMESPACE (INetUDPSocket, inet));

public:
	/** Construction.
	 */
	INetUDPSocket (void);

	/** recvFrom.
	 */
	virtual sal_Int32 recvFrom (
		NAMESPACE_VOS(OSocketAddr)       &rFromAddr,
		void                             *pData,
		sal_uInt32                        nData,
		TSocketMsgFlag                    eFlag = TMsg_Normal);

	/** sendTo.
	 */
	virtual sal_Int32 sendTo (
		const NAMESPACE_VOS(OSocketAddr) &rToAddr,
		const void                       *pData,
		sal_uInt32                        nData,
		TSocketMsgFlag                    eFlag = TMsg_Normal);

protected:
	/** Destruction.
	 */
	virtual ~INetUDPSocket (void);

private:
	/** Not implemented.
	 */
	INetUDPSocket (const INetUDPSocket&);
	INetUDPSocket& operator= (const INetUDPSocket&);
};

/*========================================================================
 *
 * INetTCPSocket interface.
 *
 *======================================================================*/
class INetTCPSocket : public NAMESPACE_INET(INetSocket)
{
	VOS_DECLARE_CLASSINFO (VOS_NAMESPACE (INetTCPSocket, inet));

public:
	/** Socks gateway address.
	 */
	virtual sal_Bool setSocksGateway (
		const NAMESPACE_VOS(OSocketAddr) &rGwAddr);

	/** Local address of bound socket.
	 */
	virtual sal_Bool getMyAddr (
		NAMESPACE_VOS(OSocketAddr) &rMyAddr) const;

	/** Peer address of connected socket.
	 */
	virtual sal_Bool getToAddr (
		NAMESPACE_VOS(OSocketAddr) &rToAddr) const;

protected:
	/** Construction, destruction.
	 */
	INetTCPSocket (void);
	INetTCPSocket (oslSocket hSocket);
	virtual ~INetTCPSocket (void);

	/** Socks gateway context.
	 */
	inline oslSocksContext getSocksContext (void) const;

	/** Peer address.
	 */
	sal_Bool setToAddr (
		const NAMESPACE_VOS(OSocketAddr) &rToAddr);

private:
	/** Representation.
	 */
	oslSocksContext            m_hContext;
	NAMESPACE_VOS(OSocketAddr) m_aToAddr;

	/** Not implemented.
	 */
	INetTCPSocket (const INetTCPSocket&);
	INetTCPSocket& operator= (const INetTCPSocket&);
};

inline oslSocksContext INetTCPSocket::getSocksContext (void) const
{
	return m_hContext;
}

/*========================================================================
 *
 * INetActiveTCPSocket interface.
 * (Active/Connecting peer (Client)).
 *
 *======================================================================*/
class INetActiveTCPSocket : public NAMESPACE_INET(INetTCPSocket)
{
	VOS_DECLARE_CLASSINFO (VOS_NAMESPACE (INetActiveTCPSocket, inet));

public:
	/** Construction.
	 */
	INetActiveTCPSocket (void);

	/** connect.
	 */
	virtual sal_Bool connect (
		const NAMESPACE_VOS(OSocketAddr) &rToAddr);

	/** close.
	 */
	virtual void SAL_CALL close (void);

protected:
	/** Destruction.
	 */
	virtual ~INetActiveTCPSocket (void);

	/** Handle event.
	 */
	virtual sal_Bool handleEvent (sal_Int32 nEvent);

private:
	/** Representation.
	 */
	sal_Bool m_bConnected;

	/** Not implemented.
	 */
	INetActiveTCPSocket (const INetActiveTCPSocket&);
	INetActiveTCPSocket& operator= (const INetActiveTCPSocket&);
};

/*========================================================================
 *
 * INetPassiveTCPSocket interface.
 * (Passive/Listening peer (Server)).
 *
 *======================================================================*/
class INetPassiveTCPSocket : public NAMESPACE_INET(INetTCPSocket)
{
	VOS_DECLARE_CLASSINFO (VOS_NAMESPACE (INetPassiveTCPSocket, inet));

public:
	/** Construction.
	 */
	INetPassiveTCPSocket (void);

	/** accept.
	 */
	virtual sal_Bool accept (
		NAMESPACE_VOS(ORef)<INetTCPSocket> &rxSocket,
		NAMESPACE_VOS(OSocketAddr)         &rFromAddr);

	/** listen.
	 */
	virtual sal_Bool listen (
		const NAMESPACE_VOS(OSocketAddr) &rLocalAddr,
		const NAMESPACE_VOS(OSocketAddr) *pToAddr = NULL);

protected:
	/** Destruction.
	 */
	virtual ~INetPassiveTCPSocket (void);

	/** Handle event.
	 */
	virtual sal_Bool handleEvent (sal_Int32 nEvent);

private:
	/** Representation.
	 */
	sal_Bool m_bListening;

	/** Not implemented.
	 */
	INetPassiveTCPSocket (const INetPassiveTCPSocket&);
	INetPassiveTCPSocket& operator= (const INetPassiveTCPSocket&);
};

/*========================================================================
 *
 * The end.
 *
 *======================================================================*/
#ifdef _USE_NAMESPACE
}
#endif

#endif /* !_INET_SOCKET_HXX */

