/*************************************************************************
 *
 *  $RCSfile: localedata_nf.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: er $ $Date: 2000/12/12 15:27:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef I18N_SIMPLE_LOCALEDATA_NF_HXX
#define I18N_SIMPLE_LOCALEDATA_NF_HXX

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _LANG_HXX
#include <tools/lang.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _COM_SUN_STAR_I18N_FORMATELEMENT_HPP_
#include <com/sun/star/i18n/FormatElement.hpp>
#endif

class International;


/** @Descr
	Implementation of format code generating methods similar to the
	old Numberformatter methods. The enum tables are copied (!) from the
	NumberFormatter because we can't include it here for sake of
	crossdependencies.
 */


//! enum table copied from svtools/zformat.hxx
enum NfKeywordIndex
{
	NF_KEY_NONE = 0,
	NF_KEY_E,			// exponential symbol
	NF_KEY_AMPM,		// AM/PM
	NF_KEY_AP,			// a/p
	NF_KEY_MI,			// minute		(!)
	NF_KEY_MMI,			// minute 02	(!)
	NF_KEY_M,			// month		(!)
	NF_KEY_MM,			// month 02		(!)
	NF_KEY_MMM,			// month short name
	NF_KEY_MMMM,		// month long name
	NF_KEY_H,			// hour
	NF_KEY_HH,			// hour 02
	NF_KEY_S,			// second
	NF_KEY_SS,			// second 02
	NF_KEY_Q,			// quarter
	NF_KEY_QQ,			// quarter 02
	NF_KEY_D,			// day of month
	NF_KEY_DD,			// day of month 02
	NF_KEY_DDD,			// day of week short
	NF_KEY_DDDD,		// day of week long
	NF_KEY_YY,			// year two digits
	NF_KEY_YYYY,		// year four digits
	NF_KEY_NN,			// day of week short
	NF_KEY_NNNN,		// day of week long with separator
	NF_KEY_CCC,			// currency bank symbol (old version)
	NF_KEY_GENERAL,		// General / Standard
	NF_KEY_LASTOLDKEYWORD = NF_KEY_GENERAL,
	NF_KEY_NNN,			// day of week long without separator, as of version 6, 10.10.97
	NF_KEY_WW,			// week of year, as of version 8, 19.06.98
	NF_KEY_MMMMM,		// first letter of month name
	NF_KEY_LASTKEYWORD = NF_KEY_MMMMM,
	NF_KEY_UNUSED4,
	NF_KEY_QUARTER,		// quarter long
	NF_KEY_TRUE,		// boolean true
	NF_KEY_FALSE,		// boolean false
	NF_KEY_BOOLEAN,		// boolean
	NF_KEY_COLOR,		// color
	NF_KEY_FIRSTCOLOR,
	NF_KEY_BLACK = NF_KEY_FIRSTCOLOR,	// you do know colors, don't you?
	NF_KEY_BLUE,
	NF_KEY_GREEN,
	NF_KEY_CYAN,
	NF_KEY_RED,
	NF_KEY_MAGENTA,
	NF_KEY_BROWN,
	NF_KEY_GREY,
	NF_KEY_YELLOW,
	NF_KEY_WHITE,
	NF_KEY_LASTCOLOR = NF_KEY_WHITE,
	NF_KEY_LASTKEYWORD_SO5 = NF_KEY_LASTCOLOR,
	//! Keys from here on can't be saved in SO5 file format and MUST be
	//! converted to string which means losing any information.
	NF_KEY_AAA,			// abbreviated day name from Japanese Xcl, same as DDD or NN English
	NF_KEY_AAAA,		// full day name from Japanese Xcl, same as DDDD or NNN English
	NF_KEY_EC,			// E non-gregorian calendar year without preceding 0
	NF_KEY_EEC,			// EE non-gregorian calendar year with preceding 0 (two digit)
	NF_KEY_G,			// abbreviated era name, latin characters M T S or H for Gengou calendar
	NF_KEY_GG,			// abbreviated era name
	NF_KEY_GGG,			// full era name
	NF_KEY_R,			// acts as EE (Xcl) => GR==GEE, GGR==GGEE, GGGR==GGGEE
	NF_KEY_RR,			// acts as GGGEE (Xcl)
	NF_KEYWORD_ENTRIES_COUNT
};

typedef String NfKeywordTable [NF_KEYWORD_ENTRIES_COUNT];


//! enum table copied from svtools/zforlist.hxx
enum NfIndexTableOffset
{
	NF_NUMERIC_START = 0,

	NF_NUMBER_START = NF_NUMERIC_START,
	NF_NUMBER_STANDARD = NF_NUMBER_START,	// General/Standard/...
	NF_NUMBER_INT,							// 0
	NF_NUMBER_DEC2,							// 0.00
	NF_NUMBER_1000INT,						// #,##0
	NF_NUMBER_1000DEC2,						// #,##0.00
	NF_NUMBER_SYSTEM,						// #,##0.00 or whatever is set as system default
	NF_NUMBER_END = NF_NUMBER_SYSTEM,

	NF_SCIENTIFIC_START,
	NF_SCIENTIFIC_000E000 = NF_SCIENTIFIC_START,	// 0.00E+000
	NF_SCIENTIFIC_000E00,							// 0.00E+00
	NF_SCIENTIFIC_END = NF_SCIENTIFIC_000E00,

	NF_PERCENT_START,
	NF_PERCENT_INT = NF_PERCENT_START,		// 0%
	NF_PERCENT_DEC2,						// 0.00%
	NF_PERCENT_END = NF_PERCENT_DEC2,

	NF_FRACTION_START,
	NF_FRACTION_1 = NF_FRACTION_START,		// # ?/?
	NF_FRACTION_2,							// # ??/??
	NF_FRACTION_END = NF_FRACTION_2,

	NF_NUMERIC_END = NF_FRACTION_END,

	NF_CURRENCY_START,
	NF_CURRENCY_1000INT = NF_CURRENCY_START,// #,##0 DM
	NF_CURRENCY_1000DEC2,					// #,##0.00 DM
	NF_CURRENCY_1000INT_RED,                // #,##0 DM			negative in red
	NF_CURRENCY_1000DEC2_RED,				// #,##0.00 DM		negative in red
	NF_CURRENCY_1000DEC2_CCC,				// #,##0.00 DEM		banking currency abbreviation
	NF_CURRENCY_1000DEC2_DASHED,			// #,##0.-- DM
	NF_CURRENCY_END = NF_CURRENCY_1000DEC2_DASHED,

	NF_DATE_START,
	NF_DATE_SYSTEM_SHORT = NF_DATE_START,	// 08.10.97
	NF_DATE_SYSTEM_LONG,					// Mittwoch, 8. Oktober 1997
	NF_DATE_SYS_DDMMYY,		   				// 08.10.97
	NF_DATE_SYS_DDMMYYYY,	   				// 08.10.1997
	NF_DATE_SYS_DMMMYY,	   					// 8. Okt 97
	NF_DATE_SYS_DMMMYYYY,	   				// 8. Okt 1997
	NF_DATE_DIN_DMMMYYYY,					// 8. Okt. 1997					DIN
	NF_DATE_SYS_DMMMMYYYY,					// 8. Oktober 1997
	NF_DATE_DIN_DMMMMYYYY,					// 8. Oktober 1997				DIN
	NF_DATE_SYS_NNDMMMYY,		 			// Mi, 8. Okt 97
	NF_DATE_DEF_NNDDMMMYY,		 			// Mi 08.Okt 97
	NF_DATE_SYS_NNDMMMMYYYY,	   			// Mi, 8. Oktober 1997
	NF_DATE_SYS_NNNNDMMMMYYYY,	   			// Mittwoch, 8. Oktober 1997
	NF_DATE_DIN_MMDD,		 				// 10-08						DIN
	NF_DATE_DIN_YYMMDD,		 				// 97-10-08						DIN
	NF_DATE_DIN_YYYYMMDD,	 				// 1997-10-08					DIN
	NF_DATE_SYS_MMYY,		   				// 10.97
	NF_DATE_SYS_DDMMM,						// 08.Okt
	NF_DATE_MMMM,							// Oktober
	NF_DATE_QQJJ,							// 4. Quartal 97
	NF_DATE_WW,								// week of year
	NF_DATE_END = NF_DATE_WW,

	NF_TIME_START,
	NF_TIME_HHMM = NF_TIME_START,			// HH:MM
	NF_TIME_HHMMSS,							// HH:MM:SS
	NF_TIME_HHMMAMPM,						// HH:MM AM/PM
	NF_TIME_HHMMSSAMPM,						// HH:MM:SS AM/PM
	NF_TIME_HH_MMSS,						// [HH]:MM:SS
	NF_TIME_MMSS00,							// MM:SS,00
	NF_TIME_HH_MMSS00,	  					// [HH]:MM:SS,00
	NF_TIME_END = NF_TIME_HH_MMSS00,

	NF_DATETIME_START,
	NF_DATETIME_SYSTEM_SHORT_HHMM = NF_DATETIME_START,	// 08.10.97 01:23
	NF_DATETIME_SYS_DDMMYYYY_HHMMSS,		// 08.10.1997 01:23:45
	NF_DATETIME_END = NF_DATETIME_SYS_DDMMYYYY_HHMMSS,

	NF_BOOLEAN,								// BOOLEAN
	NF_TEXT,								// @
	NF_INDEX_TABLE_ENTRIES
};


// Similar to SvNumberFormatter and ImpSvNumberformatScan
class LocaleDataFormats
{
	NfKeywordTable				sKeyword;
	String						sNameGeneral;
	International*				pIntl;
	BOOL						bChangeIntl;

			void				setupKeywords();
			String				mapElementUsageShortToString( sal_Int16 nFormatUsage );
			String				mapElementKeyShortToString( sal_Int16 nFormatUsage );

	// Methods taken from SvNumberFormatter
			void				SetDependentKeywords();
			void				ImpGenerateFormats(
									::com::sun::star::uno::Sequence< ::com::sun::star::i18n::FormatElement > & rSeq
									);
								// build negative currency format
			void				ImpGetNegCurrFormat( XubString& sNegStr );

								// build positive currency format
			void				ImpGetPosCurrFormat( XubString& sPosStr );

								// build date format
			void				ImpGetDateFormat( XubString& sDateStr );

								// build long date format
								// -1: none, 0: system, 1: short, 2: long
			void				ImpGetLongDateFormat(
									XubString& sDateStr,
									short nShortLongDayOfWeek = 0,
									short nShortLongDay = 0,
									short nShortLongMonth = 0,
									short nShortLongYear = 0
									);

public:
	static	void				GetLogicalKeywords(
									LanguageType eLnge,
									const sal_Unicode*& pTrue,
									const sal_Unicode*& pFalse
									);

	static	String				GetQuarterWord( LanguageType eLang );

								LocaleDataFormats( International* pIntl );

			void				scheduleIntlChange( International* p )
									{
										pIntl = p;
										bChangeIntl = TRUE;
									}
			void				getFormats(
									::com::sun::star::uno::Sequence< ::com::sun::star::i18n::FormatElement > & rSeq
									);
};


// Similar to NfCurrencyEntry
class LocaleDataCurrencyEntry
{
public:
								/** [$DM-407] (bBank==FALSE) or [$DEM] (bBank==TRUE)
									is assigned to rStr, if bBank==FALSE and
									bWithoutExtension==TRUE only [$DM] */
	static	void				BuildSymbolString(
									String& rStr,
									const International* pIntl,
									BOOL bBank,
									BOOL bWithoutExtension = FALSE
									);

								// rSymStr gets appended/prepended
	static	void				CompletePositiveFormatString(
									XubString&,
									const XubString& rSymStr,
									USHORT nPosiFormat
									);
								// same, negative sign is applied also
	static	void				CompleteNegativeFormatString(
									XubString&,
									const XubString& rSymStr,
									USHORT nNegaFormat
									);
};


#endif // I18N_SIMPLE_LOCALEDATA_NF_HXX
