/*************************************************************************
 *
 *  $RCSfile: breakiterator.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: jp $ $Date: 2000/11/20 16:46:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _I18N_BREAKITERATOR_HXX_
#define _I18N_BREAKITERATOR_HXX_


#ifndef _COM_SUN_STAR_I18N_XBREAKITERATOR_HPP_
#include <com/sun/star/i18n/XBreakIterator.hpp>
#endif

#include <com/sun/star/i18n/WordType.hpp>
#include <com/sun/star/i18n/BreakType.hpp>
#include <com/sun/star/i18n/ScriptType.hpp>
#include <com/sun/star/i18n/CharacterIteratorMode.hpp>
#include <com/sun/star/i18n/CharType.hpp>

#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx> // helper for implementations
#endif

class International;

//	----------------------------------------------------
//	class BreakIterator
//	----------------------------------------------------
class BreakIterator : public cppu::WeakImplHelper1
<
	::com::sun::star::i18n::XBreakIterator
>
{
	/// used for upper/lower et al.
	International* pIntl;

	void setupInternational( const ::com::sun::star::lang::Locale& rLocale );

public:
	BreakIterator();
	virtual ~BreakIterator();

	virtual sal_Int32 SAL_CALL nextCharacters( const ::rtl::OUString& Text,
		sal_Int32 nStartPos, const ::com::sun::star::lang::Locale& rLocale,
		sal_Int16 nCharacterIteratorMode, sal_Int32 nCount, sal_Int32& nDone )
						throw( ::com::sun::star::uno::RuntimeException );
    virtual sal_Int32 SAL_CALL previousCharacters( const ::rtl::OUString& Text,
		sal_Int32 nStartPos, const ::com::sun::star::lang::Locale& nLocale,
		sal_Int16 nCharacterIteratorMode, sal_Int32 nCount, sal_Int32& nDone )
						throw( ::com::sun::star::uno::RuntimeException );

    virtual ::com::sun::star::i18n::Boundary SAL_CALL nextWord(
		const ::rtl::OUString& Text, sal_Int32 nStartPos,
		const ::com::sun::star::lang::Locale& nLocale, sal_Int16 WordType )
						throw( ::com::sun::star::uno::RuntimeException );
    virtual ::com::sun::star::i18n::Boundary SAL_CALL previousWord(
		const ::rtl::OUString& Text, sal_Int32 nStartPos,
		const ::com::sun::star::lang::Locale& nLocale, sal_Int16 WordType )
							throw( ::com::sun::star::uno::RuntimeException );
    virtual ::com::sun::star::i18n::Boundary SAL_CALL getWordBoundary(
		const ::rtl::OUString& Text, sal_Int32 nPos,
		const ::com::sun::star::lang::Locale& nLocale, sal_Int16 WordType,
		sal_Bool bForward )
							throw( ::com::sun::star::uno::RuntimeException );
    virtual sal_Int16 SAL_CALL getWordType( const ::rtl::OUString& Text,
		sal_Int32 nPos, const ::com::sun::star::lang::Locale& nLocale )
							throw( ::com::sun::star::uno::RuntimeException );

    virtual sal_Bool SAL_CALL isBeginWord( const ::rtl::OUString& Text,
		sal_Int32 nPos, const ::com::sun::star::lang::Locale& nLocale,
		sal_Int16 WordType )
							throw( ::com::sun::star::uno::RuntimeException );
    virtual sal_Bool SAL_CALL isEndWord( const ::rtl::OUString& Text,
		sal_Int32 nPos, const ::com::sun::star::lang::Locale& nLocale,
		sal_Int16 WordType )
							throw( ::com::sun::star::uno::RuntimeException );

    virtual sal_Int32 SAL_CALL beginOfSentence( const ::rtl::OUString& Text,
		sal_Int32 nStartPos, const ::com::sun::star::lang::Locale& nLocale )
							throw( ::com::sun::star::uno::RuntimeException );
    virtual sal_Int32 SAL_CALL endOfSentence( const ::rtl::OUString& Text,
		sal_Int32 nStartPos, const ::com::sun::star::lang::Locale& nLocale )
							throw( ::com::sun::star::uno::RuntimeException );

    virtual ::com::sun::star::i18n::LineBreakResults SAL_CALL getLineBreak(
		const ::rtl::OUString& Text, sal_Int32 nStartPos,
		const ::com::sun::star::lang::Locale& nLocale, sal_Int32 nMinBreakPos,
		const ::com::sun::star::i18n::LineBreakHyphenationOptions& hOptions,
		const ::com::sun::star::i18n::LineBreakUserOptions& bOptions )
							throw( ::com::sun::star::uno::RuntimeException );

    virtual sal_Int32 SAL_CALL beginOfScript( const ::rtl::OUString& Text,
		sal_Int32 nStartPos, sal_Int16 ScriptType )
							throw( ::com::sun::star::uno::RuntimeException );
    virtual sal_Int32 SAL_CALL endOfScript( const ::rtl::OUString& Text,
		sal_Int32 nStartPos, sal_Int16 ScriptType )
							throw( ::com::sun::star::uno::RuntimeException );
    virtual sal_Int32 SAL_CALL nextScript( const ::rtl::OUString& Text,
		sal_Int32 nStartPos, sal_Int16 ScriptType )
							throw( ::com::sun::star::uno::RuntimeException );
    virtual sal_Int32 SAL_CALL previousScript( const ::rtl::OUString& Text,
		sal_Int32 nStartPos, sal_Int16 ScriptType )
							throw( ::com::sun::star::uno::RuntimeException );
    virtual sal_Int16 SAL_CALL getScriptType( const ::rtl::OUString& Text,
		sal_Int32 nPos )
							throw( ::com::sun::star::uno::RuntimeException );

    virtual sal_Int32 SAL_CALL beginOfCharBlock( const ::rtl::OUString& Text,
		sal_Int32 nStartPos, const ::com::sun::star::lang::Locale& nLocale,
		sal_Int16 CharType )
							throw( ::com::sun::star::uno::RuntimeException );
    virtual sal_Int32 SAL_CALL endOfCharBlock( const ::rtl::OUString& Text,
		sal_Int32 nStartPos, const ::com::sun::star::lang::Locale& nLocale,
		sal_Int16 CharType )
							throw( ::com::sun::star::uno::RuntimeException );
    virtual sal_Int32 SAL_CALL nextCharBlock( const ::rtl::OUString& Text,
		sal_Int32 nStartPos, const ::com::sun::star::lang::Locale& nLocale,
		sal_Int16 CharType )
							throw( ::com::sun::star::uno::RuntimeException );
    virtual sal_Int32 SAL_CALL previousCharBlock( const ::rtl::OUString& Text,
		sal_Int32 nStartPos, const ::com::sun::star::lang::Locale& nLocale,
		sal_Int16 CharType )
							throw( ::com::sun::star::uno::RuntimeException );
};





#endif // _I18N_BREAKITERATOR_HXX_
