/*************************************************************************
 *
 *  $RCSfile: typedetection.cxx,v $
 *
 *  $Revision: 1.17 $
 *
 *  last change: $Author: as $ $Date: 2001/08/14 12:54:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_SERVICES_TYPEDETECTION_HXX_
#include <services/typedetection.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_ARGUMENTANALYZER_HXX_
#include <classes/argumentanalyzer.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_RESETABLEGUARD_HXX_
#include <threadhelp/resetableguard.hxx>
#endif

#ifndef __FRAMEWORK_SERVICES_H_
#include <services.h>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif

#ifndef _COM_SUN_STAR_DOCUMENT_XEXTENDEDFILTERDETECTION_HPP_
#include <com/sun/star/document/XExtendedFilterDetection.hpp>
#endif

//_________________________________________________________________________________________________________________
//	includes of other projects
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

using namespace ::com::sun::star::document				;
using namespace ::com::sun::star::beans					;
using namespace ::com::sun::star::container				;
using namespace ::com::sun::star::lang					;
using namespace ::com::sun::star::uno					;
using namespace ::cppu									;
using namespace ::osl									;
using namespace ::rtl									;
using namespace ::com::sun::star::io					;

//_________________________________________________________________________________________________________________
//	non exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	non exported definitions
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	declarations
//_________________________________________________________________________________________________________________

//*****************************************************************************************************************
//	constructor
//*****************************************************************************************************************
TypeDetection::TypeDetection( const Reference< XMultiServiceFactory >& xFactory )
		//	Init baseclasses first
		//	Attention:
		//		Don't change order of initialization!
		//      ThreadHelpBase is a struct with a mutex as member. We can't use a mutex as member directly, while
		//		we must garant right initialization and a valid value of this! First initialize
		//		baseclasses and then members. And we need the mutex for other baseclasses !!!
		:	ThreadHelpBase	(			)
		,	OWeakObject		(			)
		// Init member
		,	m_xFactory		( xFactory	)
		,	m_aCache		(			)
{
	// Safe impossible cases
	// We can't work without valid initialization.
	LOG_ASSERT( impldbg_checkParameter_TypeDetection( xFactory ), "TypeDetection::TypeDetection()\nInvalid parameter detected!\n" )
	// Safe impossible cases
	// We need our cache for working.
	LOG_ASSERT( !(m_aCache.isValid()==sal_False), "TypeDetection::TypeDetection()\nInitializing of cache failed. Factory can't work so!\n" )
}

//*****************************************************************************************************************
//	destructor
//*****************************************************************************************************************
TypeDetection::~TypeDetection()
{
	// Our cache is cleared automaticly!
}

//*****************************************************************************************************************
//	XInterface, XTypeProvider, XServiceInfo
//*****************************************************************************************************************
DEFINE_XINTERFACE_5						(	TypeDetection							,
											OWeakObject								,
											DIRECT_INTERFACE(XTypeProvider			),
											DIRECT_INTERFACE(XServiceInfo			),
											DIRECT_INTERFACE(XTypeDetection			),
											DIRECT_INTERFACE(XNameAccess			),
											DIRECT_INTERFACE(XElementAccess			)
										)

DEFINE_XTYPEPROVIDER_5					(	TypeDetection		,
											XTypeProvider		,
											XServiceInfo		,
											XTypeDetection		,
											XNameAccess			,
											XElementAccess
										)

DEFINE_XSERVICEINFO_ONEINSTANCESERVICE	(	TypeDetection						,
                                            OWeakObject                         ,
                                            SERVICENAME_TYPEDETECTION           ,
											IMPLEMENTATIONNAME_TYPEDETECTION
										)

DEFINE_INIT_SERVICE                     (   TypeDetection,
                                            {
                                            }
                                        )

//*****************************************************************************************************************
//	XTypeDetection
//*****************************************************************************************************************
OUString SAL_CALL TypeDetection::queryTypeByURL( const OUString& sURL ) throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	// Safe impossible cases.
	// Method not defined for all incoming parameter!
	LOG_ASSERT( impldbg_checkParameter_queryTypeByURL( sURL ), "TypeDetection::queryTypeByURL()\nInvalid parameter detected!\n" )

	// Search first suitable type for given URL in cache.
	// We return first matching one at everytime ... these method has no chance to search follow ones!
	CheckedTypeIterator	pIterator	;
	OUString			sTypeName	;

	m_aCache.searchType( sURL, NULL, NULL, pIterator, sTypeName );
	return sTypeName;
}

//*****************************************************************************************************************
//	XTypeDetection
//*****************************************************************************************************************
OUString SAL_CALL TypeDetection::queryTypeByDescriptor( Sequence< PropertyValue >& seqDescriptor, sal_Bool bDeep ) throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	// Safe impossible cases.
	// Method not defined for all incoming parameter!
	LOG_ASSERT( impldbg_checkParameter_queryTypeByDescriptor( seqDescriptor, bDeep ), "TypeDetection::queryTypeByDescriptor()\nInvalid parameter detected!\n" )

    RTL_LOGFILE_CONTEXT( aLog, "framework (as96863) ::TypeDetection::queryTypeByDescriptor" );

	// Set default return value if search failed.
	OUString sTypeName;

	// Which detect method whish user?
	//		a) We support a flat detection by using file description parameter like extension, mime type ...
	//		b) We support a deep detection by using an input stream.
	// A flat detection can we make everytime - a deep detection is an additional feature!

	//-------------------------------------------------------------------------------------------------------------
	// I)	Analyze given descriptor arguments first.
	//		Search for mime type and clipboardformat.
    ArgumentAnalyzer    aAnalyzer( seqDescriptor )  ;
	OUString			sURL						;
	OUString			sMediaType					;
	OUString			sClipboardFormat			;
	OUString*			pMediaType			= NULL	;
	OUString*			pClipboardFormat	= NULL	;
	FileType			aType						;

	if( aAnalyzer.getArgument( E_MEDIATYPE	, sMediaType		) == sal_True ) { pMediaType		= &sMediaType;			}
	if( aAnalyzer.getArgument( E_FORMAT		, sClipboardFormat	) == sal_True )	{ pClipboardFormat	= &sClipboardFormat;	}

	//-------------------------------------------------------------------------------------------------------------
	// II)	Make a flat detection by using given URL, mime type or format.
	//		Attention: A URL is min. required to do that!
	if	(
			( aAnalyzer.getArgument( E_URL, sURL )	==	sal_True	)	&&
			( sURL.getLength()						>	0			)
		)
	{
		// We need this value to break follow loops erliar!
		sal_Bool bBreakFlatSearch	=	sal_False	;
		sal_Bool bBreakDeepSearch	=	sal_False	;

		//---------------------------------------------------------------------------------------------------------
		// II.I)	Step over our type cache items to find right one.
		//			Break if someone could be found or all elements are checked - but don't pass given parameter.
		CheckedTypeIterator	pTypeIterator	;
		OUString			sMyDecision		;
		while	(
					( m_aCache.searchType( sURL, pMediaType, pClipboardFormat, pTypeIterator, sMyDecision )	==	sal_True	)	&&
					( bBreakFlatSearch																		==	sal_False	)
				)
		{
			//-----------------------------------------------------------------------------------------------------
			// II.II)	We have found a type. Now we must look if optional deep detection is allowed by user!
			//			If not we can set our detected type for return.
			//			Otherwise we must search registered detect service and make a deep detection.
			if( bDeep == sal_False )
			{
				sTypeName			=	sMyDecision	;
				bBreakFlatSearch	=	sal_True	;
			}
			else
			{
				//-------------------------------------------------------------------------------------------------
				// II.III)	Try to find registered detect service for flat detected type.
				//			If you found some one - create it and let him work.
				//			Ignore detector if an error occure - e.g. creation failed, detection failed, an exception was catched ...
				//			In these cases we use next cache item!
				CheckedStringListIterator	pDetectorIterator	;
				OUString					sDetectorName		;
				while	(
							( m_aCache.searchDetectorForType( sMyDecision, pDetectorIterator, sDetectorName )	==	sal_True	)	&&
							( bBreakDeepSearch																	==	sal_False	)
						)
				{
					// Attention: Full namespace is neccessary because it exist another interface with same name in com.sun.star.frame!
					Reference< ::com::sun::star::document::XExtendedFilterDetection > xDetector( m_xFactory->createInstance( sDetectorName ), UNO_QUERY );
					if( xDetector.is() == sal_True )
					{
						// Before created service can work - we must add our collected informations to descriptor!
						// Don't forget to read arguments after detect again!
						// A detect service can add his informations to the descriptor too.
						aType = m_aCache.getType( sMyDecision );
						aAnalyzer.setArgument( E_TYPENAME		, sMyDecision				);
						aAnalyzer.setArgument( E_MEDIATYPE		, aType.sMediaType			);
						aAnalyzer.setArgument( E_FORMAT			, aType.sClipboardFormat	);
						aAnalyzer.setArgument( E_DETECTSERVICE	, sDetectorName				);

						OUString sDetectorDecision = xDetector->detect( seqDescriptor );
                        aAnalyzer.setArguments( seqDescriptor );

						//-----------------------------------------------------------------------------------------
            			// The detect service has the following possibilities:
            			// a)	He agrees with our result.
						//		=> We can return our value and break all loops.
						if( sDetectorDecision == sMyDecision )
						{
							sTypeName			=	sMyDecision	;
							bBreakDeepSearch	=	sal_True	;
							bBreakFlatSearch	=	sal_True	;
						}
						else
						//-----------------------------------------------------------------------------------------
            			// b)	He doesn't know anything and returns an empty string ...
            			//		=> Then we must search for next detector and ask him for his agreement.
						//		Attention: We must correct our media descriptor (delete old wrong detect service)!
            			if( sDetectorDecision.getLength() < 1 )
            			{
							aAnalyzer.deleteArgument( E_DETECTSERVICE );
						}
						else
						//-----------------------------------------------------------------------------------------
						// c)	He disagree with our result. (sDetectorDecision not empty but different from sMyDecision)
						//		=> Then we must return his decision for a type name ...
						//		and break all loops in a right manner!
						//		Attention: Changing of given descriptor comes later!
						{
							sTypeName			=	sDetectorDecision				;
							bBreakDeepSearch	=	sal_True						;
							bBreakFlatSearch	=	sal_True						;
							aType				=	m_aCache.getType( sTypeName )	;
						}
					}
				}
			}
		}
	}

	//-------------------------------------------------------------------------------------------------------------
	// III)	We haven't found any type for given parameter.
	//		What can we do? If user allow a deep search
	//		we can loop over all registered detect services and ask it for his decision.
	//		BUT ... THIS IS A VERY EXPENSIVE WAY ...!!!
	if	(
			( sTypeName.getLength()	<	1			)	&&
			( bDeep					==	sal_True	)
		)
	{
        Sequence< OUString >    lAllDetectors   =   m_aCache.getAllDetectorNamesWithDefault()  ;
        sal_Int32               nCount          =   lAllDetectors.getLength()                  ;
		for( sal_Int32 nDetector=0; nDetector<nCount; ++nDetector )
		{
			Reference< ::com::sun::star::document::XExtendedFilterDetection > xDetector( m_xFactory->createInstance( lAllDetectors[nDetector] ), UNO_QUERY );
			if( xDetector.is() == sal_True )
			{
                OUString sDetectorDecision = xDetector->detect( seqDescriptor );
                aAnalyzer.setArguments( seqDescriptor );
                if( sDetectorDecision.getLength() > 0 )
				{
					sTypeName	=	sDetectorDecision				;
					aType		=	m_aCache.getType( sTypeName )	;
					break;
				}
			}
		}
	}

	//-------------------------------------------------------------------------------------------------------------
	// IV)	Dont forget to actualize te descriptor!
	if( sTypeName.getLength() > 0 )
	{
        aAnalyzer.setArgument( E_TYPENAME       , sTypeName				);
       	aAnalyzer.setArgument( E_MEDIATYPE      , aType.sMediaType      );
        aAnalyzer.setArgument( E_FORMAT         , aType.sClipboardFormat);
	}

	// Return result of detection.
	return sTypeName;
}

//*****************************************************************************************************************
//	XNameAccess
//*****************************************************************************************************************
Any SAL_CALL TypeDetection::getByName( const OUString& sName ) throw(	NoSuchElementException	,
				  														WrappedTargetException	,
				  														RuntimeException		)
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	// Safe impossible cases.
	// Method not defined for all incoming parameter!
	LOG_ASSERT( impldbg_checkParameter_getByName( sName ), "TypeDetection::getByName()\nInvalid parameter detected!\n" )

	// Set default return value if search failed.
	Any aAny;

	if( m_aCache.existsType( sName ) == sal_False )
	{
		throw NoSuchElementException( DECLARE_ASCII("TypeDetection::getByName()\nSpecified type not exist!\n"), static_cast< OWeakObject* >( this ) );
	}

	aAny <<= m_aCache.getTypeProperties( sName );

	// Return result of operation.
	return aAny;
}

//*****************************************************************************************************************
//	XNameAccess
//*****************************************************************************************************************
Sequence< OUString > SAL_CALL TypeDetection::getElementNames() throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	return m_aCache.getAllTypeNames();
}

//*****************************************************************************************************************
//	XNameAccess
//*****************************************************************************************************************
sal_Bool SAL_CALL TypeDetection::hasByName( const OUString& sName ) throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	return m_aCache.existsType( sName );
}

//*****************************************************************************************************************
//	XElementAccess
//*****************************************************************************************************************
Type SAL_CALL TypeDetection::getElementType() throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	return( ::getCppuType( (const Sequence< PropertyValue >*)NULL ) );
}

//*****************************************************************************************************************
//	XElementAccess
//*****************************************************************************************************************
sal_Bool SAL_CALL TypeDetection::hasElements() throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	return m_aCache.hasTypes();
}

//_________________________________________________________________________________________________________________
//	debug methods
//_________________________________________________________________________________________________________________

/*-----------------------------------------------------------------------------------------------------------------
	The follow methods checks the parameter for other functions. If a parameter or his value is non valid,
	we return "sal_False". (else sal_True) This mechanism is used to throw an ASSERT!

	ATTENTION

		If you miss a test for one of this parameters, contact the autor or add it himself !(?)
		But ... look for right testing! See using of this methods!
-----------------------------------------------------------------------------------------------------------------*/

#ifdef ENABLE_ASSERTIONS

//*****************************************************************************************************************
sal_Bool TypeDetection::impldbg_checkParameter_TypeDetection( const Reference< XMultiServiceFactory >& xFactory )
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &xFactory		==	NULL		)	||
			( xFactory.is()	==	sal_False	)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool TypeDetection::impldbg_checkParameter_queryTypeByURL( const OUString& sURL )
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &sURL			==	NULL	)	||
			( sURL.getLength()	<	1		)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool TypeDetection::impldbg_checkParameter_queryTypeByDescriptor(	Sequence< PropertyValue >&	seqDescriptor	,
																		sal_Bool					bDeep			)
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &seqDescriptor			==	NULL	)	||
			( seqDescriptor.getLength()	<	1		)	||
			(
				( bDeep	!=	sal_True	)	&&
				( bDeep	!=	sal_False	)
			)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool TypeDetection::impldbg_checkParameter_getByName( const OUString& sName )
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &sName			==	NULL	)	||
			( sName.getLength()	<	1		)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool TypeDetection::impldbg_checkParameter_hasByName( const OUString& sName )
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &sName			==	NULL	)	||
			( sName.getLength()	<	1		)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

#endif	//	#ifdef ENABLE_ASSERTIONS

}		//	namespace framework
