/*************************************************************************
 *
 *  $RCSfile: synccont.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "synccont.hxx"

static Reference<XInteractionHandler>	globalInteractionHandler;
static Reference<XProgressHandler>		globalProgressHandler;

// -----------------
// - SyncURLParser -
// -----------------

class SyncURLParser
{
private:

	OUString		maURL;
	OUString		maRoot;
	List			maSubURLList;
	List			maSubTitleList;

public:				
					
					SyncURLParser( const OUString& rURL, const OUString& rRoot );
					~SyncURLParser();

	sal_uInt32		GetLevelCount() const { return maSubURLList.Count(); }

	const OUString&	GetURL() const { return maURL; }
	const OUString&	GetRoot() const { return maRoot; }
	
	const OUString&	GetSubURL( sal_uInt32 nLevel ) const 
					{ 
						DBG_ASSERT( nLevel < GetLevelCount(), "Level out of range" );
						return *(OUString*)( maSubURLList.GetObject( nLevel ) ); 
					}

	const OUString&	GetSubTitle( sal_uInt32 nLevel ) const 
					{
						DBG_ASSERT( nLevel < GetLevelCount(), "Level out of range" );
						return *(OUString*)( maSubTitleList.GetObject( nLevel ) );
					}
};

//----------------------------------------------------------------------------

SyncURLParser::SyncURLParser( const OUString& rURL, const OUString& rRoot ) :
	maURL( rURL ), maRoot( rRoot ) 
{
	if( maURL.compareTo( maRoot, maRoot.getLength() ) == 0 )
	{
		sal_uInt32	i = maRoot.getLength();
		sal_uInt32	nLen = maURL.getLength();

		maSubURLList.Insert( new OUString( maRoot ), LIST_APPEND );
		maSubTitleList.Insert( new OUString, LIST_APPEND );

		while( i < nLen )
		{
			sal_uInt32 nTitleBegin = i;

			while( ( i < nLen ) && ( maURL[ i ] != L'/' ) )
				i++;

			OUString* pSubURL = new OUString( maURL.copy( 0, i ) );
			OUString* pSubTitle = new OUString( pSubURL->copy( nTitleBegin, i++ - nTitleBegin ) );

			maSubURLList.Insert( pSubURL, LIST_APPEND );
			maSubTitleList.Insert( pSubTitle, LIST_APPEND );
		}
	}
}

//----------------------------------------------------------------------------

SyncURLParser::~SyncURLParser()
{
	void* p;

	for( p = maSubURLList.First(); p; p = maSubURLList.Next() )
		delete (OUString*) p;

	for( p = maSubTitleList.First(); p; p = maSubTitleList.Next() )
		delete (OUString*) p;
}

// ------------------
 // - SyncContent -
// ------------------

SyncContent::SyncContent()
{
}

//----------------------------------------------------------------------------

SyncContent::~SyncContent()
{
}

//----------------------------------------------------------------------------

OUString SyncContent::TypeIdToType( sal_uInt32 nType )
{
	OUString aType;

	switch( nType )
	{
		case( SyncType::FILE ):			aType = CNT_TYPESTR_FILE; break;
		case( SyncType::FOLDER ):		aType = CNT_TYPESTR_FOLDER; break;
		case( SyncType::VFS_FILE ):		aType = CNT_TYPESTR_VFS_FILE; break;
		case( SyncType::VFS_FOLDER ):	aType = CNT_TYPESTR_VFS_FOLDER; break;

		default:
		break;
	}

	return aType;
}

//----------------------------------------------------------------------------

sal_uInt32 SyncContent::TypeToTypeId( const OUString& rType )
{
	sal_uInt32 nType;

	if( rType.equalsIgnoreCase( CNT_TYPESTR_VFS_FOLDER ) )
		nType = SyncType::VFS_FOLDER;
	else if( rType.equalsIgnoreCase( CNT_TYPESTR_VFS_FILE ) )
		nType = SyncType::VFS_FILE;
	else if( rType.equalsIgnoreCase( CNT_TYPESTR_FOLDER ) )
		nType = SyncType::FOLDER;
	else if( rType.equalsIgnoreCase( CNT_TYPESTR_FILE ) )
		nType = SyncType::FILE;
	else
		nType = SyncType::NONE;

	return nType;
}

// -----------------------------------------------------------------------------

REF( XContent ) SyncContent::CreatePhysicalContent( SyncContent& rParent, const OUString& rTitle, sal_uInt32 nType )
{
	REF( XContent ) xRet;
	sal_Bool		bDone = sal_False;

	if( rParent.IsValid() )
	{
		REF( XContentCreator ) xCreator( REF( XContentCreator )( rParent.GetXContent(), UNO_QUERY ) );

		if( xCreator.is() )
		{
			ContentInfo	aInfo;

			aInfo.Type = SyncContent::TypeIdToType( nType );
			aInfo.Attributes = 0;

			if( aInfo.Type.getLength() && ( xRet = xCreator->createNewContent( aInfo ) ).is() )
			{
				REF( XPropertyTaskProcessor ) xProc( xRet, UNO_QUERY );

				if( xProc.is() )
				{
					SEQ( PropertyValue )	aProps( 1 );
					PropertyValue&			rProp = aProps.getArray()[ 0 ];
					Any						aTitle; aTitle <<= rTitle;

					rProp.Name = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "Title" ) ); rProp.Handle = -1; rProp.Value = aTitle;
					
					REF( XPropertyTask ) xPrpTask( xProc->createPropertyTask( PropertyTaskType_SET, aProps, NULL ) );

					if( xPrpTask.is() )
					{
						xPrpTask->execute();

						REF( XCommandTaskProcessor ) xProc( xRet, UNO_QUERY );
						
						if( xProc.is() )
						{
							Command				aCommand; aCommand.Name = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "insert" ) ); aCommand.Handle = -1;
							REF( XCommandTask ) xCmdTask( xProc->createCommandTask( aCommand, REF( XResultAcceptor )(), NULL ) );

							if( xCmdTask.is() )
							{
								xCmdTask->execute();
								bDone = sal_True;
							}
						}
					}
				}
			}
		}
	}

	if( !bDone )
		xRet = REF( XContent )();

	return xRet;
}

//----------------------------------------------------------------------------

sal_Bool SyncContent::ImplExists( const OUString& rURL, sal_uInt32 nType )
{
	sal_Bool bTryToCreateContent = sal_False;
	sal_Bool bWatchForTitle = sal_False;
	sal_Bool bRet = sal_False;

	if( ( SyncType::FOLDER == nType ) || ( SyncType::FILE == nType ) )
	{
		bTryToCreateContent = sal_True;
		bRet = FALSE;
	}
	else 
	{
		bTryToCreateContent = sal_True;

		if( ( SyncType::VFS_FOLDER != nType ) && ( SyncType::VFS_FILE != nType ) )
			bWatchForTitle = sal_True;
	}

	if( !bRet && bTryToCreateContent )
	{
		REF( XContentIdentifier ) xId( mxIdFact->createContentIdentifier( rURL.getStr() ) );

		if( xId.is() )
		{
			REF( XContent ) xCnt( mxProv->queryContent( xId ) );

			if( xCnt.is() )
			{
				if( bWatchForTitle )
				{
					REF( XPropertyTaskProcessor ) xProc( xCnt, UNO_QUERY );

					if( xProc.is() )
					{
						const OUString			rTitleProp( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "Title" ) ) );
						REF( XPropertySetInfo ) xInfo( xProc->getPropertySetInfo() );
		
						if( xInfo.is() && xInfo->hasPropertyByName( rTitleProp ) )
						{
							SEQ( PropertyValue ) aProps( 1 );
							PropertyValue&		 rProp = aProps.getArray()[ 0 ];

							rProp.Name = rTitleProp; rProp.Handle = -1;
							
							REF( XPropertyTask ) xTask( xProc->createPropertyTask( PropertyTaskType_GET, aProps, NULL ) );

							if( xTask.is() )
							{
								OUString aTitle;

								xTask->execute();
								( xTask->getProperties().getConstArray() )[ 0 ].Value >>= aTitle;
								bRet = aTitle.getLength() > 0;
							}
						}
					}
				}
				else
					bRet = sal_True;
			}
		}
	}

	return bRet;
}

// -----------------------------------------------------------------------------

sal_Bool SyncContent::ImplCreateContent( const OUString& rURL, sal_uInt32 nType )
{
	OUString	aRoot;
	sal_uInt32	nParentType;
	sal_Bool	bRet = sal_False;

	switch( nType )
	{
		case( SyncType::FILE ):
		case( SyncType::FOLDER ):
		{
			aRoot = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "file:///" ) );
			nParentType = SyncType::FOLDER;
		}
		break;

		case( SyncType::VFS_FILE ):
		case( SyncType::VFS_FOLDER ):
		{
			for( sal_uInt32 i = 0, nCount = rURL.getLength(); ( i < nCount ) && !aRoot.getLength(); i++ )
			{
				if( rURL[ i ] == L'?' )
				{
					if( i < ( nCount - 2 ) )
						aRoot = rURL.copy( 0, i + 2 );
					else if ( i < ( nCount - 1 ) )
						( aRoot = rURL.copy( 0, i + 1 ) ) += ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "/" ) );
				}
			}

			nParentType = ( aRoot.getLength() ? SyncType::VFS_FOLDER : SyncType::NONE );
		}
		break;

		default:
			nParentType = SyncType::NONE;
		break;
	}

	if( SyncType::NONE != nType )
	{
		const SyncURLParser aParser( rURL, aRoot );
		const sal_uInt32    nParserCount( aParser.GetLevelCount() );
		
		if( nParserCount > 1 )
		{
			sal_uInt32 i = nParserCount - 1;
			sal_Bool   bFound = sal_False;

			while( !bFound && i-- )
			{
				const OUString& rSubURL = aParser.GetSubURL( i );

				if( ImplExists( rSubURL, nParentType ) )
					bFound = sal_True;
			}

			if( bFound )
			{
				// get lowest available parent
				SyncContent* pParent = SyncContent::Create( mxFact, mxMgr, aParser.GetSubURL( i ), nParentType, sal_False );

				// create all neccessary parents
				for( ++i; i < ( nParserCount - 1 ); i++ )
				{
					REF( XContent )	xParentCnt( CreatePhysicalContent( *pParent, aParser.GetSubTitle( i ), nParentType ) );
					SyncContent*	pNewParent = SyncContent::Create( mxFact, mxMgr, xParentCnt );

					SyncContent::Destroy( pParent );
					pParent = pNewParent;
				}

				// create content
				bRet = CreatePhysicalContent( *pParent, aParser.GetSubTitle( aParser.GetLevelCount() - 1 ), nType ).is();
				SyncContent::Destroy( pParent );
			}
		}
	}

	return bRet;
}

//----------------------------------------------------------------------------

SyncContent* SyncContent::Init( REF( XMultiServiceFactory )& rxFact,
								REF( XContentProviderManager )& rxMgr, 
								const OUString& rURL, sal_uInt32 nType,
								sal_Bool bCreate )
{
	mnCntType = SyncType::NONE;
	mxFact = rxFact;
	mxMgr = rxMgr,
	mxProv = REF( XContentProvider )( mxMgr, UNO_QUERY );
	mxIdFact = REF( XContentIdentifierFactory )( mxMgr, UNO_QUERY );

	if( rURL.len() && mxProv.is() && mxFact.is() && mxIdFact.is() )
	{
		sal_Bool bCont;

		if( !ImplExists( rURL, nType ) && bCreate )
			bCont = ImplCreateContent( rURL, nType );
		else
			bCont = sal_True;

		if( bCont )
		{
			REF( XContentIdentifier ) xId( mxIdFact->createContentIdentifier( rURL.getStr() ) );

			if( xId.is() )
			{
				if( ( mxContent = mxProv->queryContent( xId ) ).is() )
				{
					REF( XPropertyTaskProcessor ) xProc( mxContent, UNO_QUERY );

					if( xProc.is() )
						xProc->addPropertiesChangeListener( SEQ( OUString )(), this );

					mxContent->addContentEventListener( this );
					mnCntType = SyncContent::TypeToTypeId( mxContent->getContentType().getStr() );
				}
			}
		}
	}

	return this;
}

//----------------------------------------------------------------------------

SyncContent* SyncContent::Init( REF( XMultiServiceFactory )& rxFact,
								REF( XContentProviderManager )& rxMgr, 
								REF( XContent )& rxContent )
{
	mnCntType = SyncType::NONE;
	mxFact = rxFact;
	mxMgr = rxMgr,
	mxProv = REF( XContentProvider )( mxMgr, UNO_QUERY );
	mxIdFact = REF( XContentIdentifierFactory )( mxMgr, UNO_QUERY );

	if( rxContent.is() )
	{
		mxContent = rxContent;
		mnCntType = SyncContent::TypeToTypeId( mxContent->getContentType().getStr() );

		REF( XPropertyTaskProcessor ) xProc( mxContent, UNO_QUERY );

		if( xProc.is() )
			xProc->addPropertiesChangeListener( SEQ( OUString )(), this );

		mxContent->addContentEventListener( this );
	}

	return this;
}

//----------------------------------------------------------------------------

void SyncContent::Destroy()
{
	if( mxContent.is() )
	{
		REF( XPropertyTaskProcessor ) xProc( mxContent, UNO_QUERY );

		if( xProc.is() )
			xProc->removePropertiesChangeListener( SEQ( OUString )(), this );

		mxContent->removeContentEventListener( this );
	}
}

// -----------------------------------------------------------------------------

Any SAL_CALL SyncContent::queryInterface( const Type & rType ) throw (RuntimeException)
{
	const Any aRet( ::cppu::queryInterface( rType,
											static_cast< XContentEventListener* >( this ), 
											static_cast< XPropertiesChangeListener* >( this ),
											static_cast< XContentTaskClient* >( this ) ) );

	return( aRet.hasValue() ? aRet : OWeakObject::queryInterface( rType ) );
}

// -----------------------------------------------------------------------------

void SAL_CALL SyncContent::acquire() throw( RuntimeException )
{
	OWeakObject::acquire();
}

// -----------------------------------------------------------------------------

void SAL_CALL SyncContent::release() throw( RuntimeException )
{
	OWeakObject::release();
}

// -----------------------------------------------------------------------------

void SAL_CALL SyncContent::disposing( const EventObject& rSource ) throw( RuntimeException )
{
}

// -----------------------------------------------------------------------------

void SAL_CALL SyncContent::contentEvent( const ContentEvent& rEvt ) throw( RuntimeException )
{
}

// -----------------------------------------------------------------------------

void SAL_CALL SyncContent::propertiesChange( const SEQ( PropertyChangeEvent )& rEvt ) throw( RuntimeException )
{
}

// -----------------------------------------------------------------------------

void SAL_CALL SyncContent::contentTaskEvent( const ContentTaskEvent& Event ) throw( RuntimeException )
{
}

//-------------------------------------------------------------------------

const OUString SyncContent::GetURL() const
{
	REF( XContentIdentifier )  xId( mxContent->getIdentifier() );
	return xId->getContentIdentifier().getStr();
}

//-------------------------------------------------------------------------

const OUString SyncContent::GetType() const
{
	return mxContent->getContentType().getStr();
}

//-------------------------------------------------------------------------

void SyncContent::Dispose()
{
	REF( XComponent ) xComponent( mxContent, UNO_QUERY );
	
	if( xComponent.is() )
		xComponent->dispose();
}

//-------------------------------------------------------------------------
SEQ( CommandInfo ) SyncContent::GetCommands()
{
	REF( XCommandTaskProcessor )	xProc( mxContent, UNO_QUERY );
	SEQ( CommandInfo )				aInfo( 0 );

	if( xProc.is() )
	{
		REF( XCommandInfo ) xInfo( xProc->getCommandsInfo() );
		
		if ( xInfo.is() )
			aInfo = xInfo->getCommands();
	}

	return aInfo;
}

//-------------------------------------------------------------------------
SEQ( Property ) SyncContent::GetProperties()
{
	REF( XPropertyTaskProcessor )	xProc( mxContent, UNO_QUERY );
	SEQ( Property)					aInfo( 0 );
	
	if ( xProc.is() )
	{
		REF( XPropertySetInfo ) xInfo( xProc->getPropertySetInfo() );
		
		if (xInfo.is() )
			aInfo = xInfo->getProperties();
	}

	return aInfo;
}

//----------------------------------------------------------------------------
Any SyncContent::GetPropertyValue( const OUString& rName )
{
	REF( XPropertyTaskProcessor )	xProc( mxContent, UNO_QUERY );
	Any								aAny;
	
	if( xProc.is() )
	{
		REF( XPropertySetInfo ) xInfo( xProc->getPropertySetInfo() );
		
		if( xInfo.is() && xInfo->hasPropertyByName( rName ) )
		{
			SEQ( PropertyValue )			aProps( 1 );
			PropertyValue&					rProp = aProps.getArray()[ 0 ];

			rProp.Name	     = rName;
			rProp.Handle     = -1; /* unknown */
//			rProp.Type       = ;
//			rProp.Attributes = ;
//			rProp.Value	     = ;
//			rProp.State      = ;

			REF( XContentTaskEnvironment )	xEnv( new UCBSyncTaskEnv( this, globalInteractionHandler, globalProgressHandler ) );
			REF( XPropertyTask )			xTask( xProc->createPropertyTask( PropertyTaskType_GET, aProps, xEnv ) );

			if ( xTask.is() )
			{
				xTask->execute();
				aAny = ( xTask->getProperties().getConstArray() )[ 0 ].Value;
			}
		}
	}
	
	return aAny;
}

//----------------------------------------------------------------------------
void SyncContent::SetPropertyValue( const OUString& rName, const Any& rValue )
{
	REF( XPropertyTaskProcessor ) xProc( mxContent, UNO_QUERY );
	
	if( xProc.is() )
	{
		REF( XPropertySetInfo ) xInfo( xProc->getPropertySetInfo() );
		
		if( xInfo.is() && xInfo->hasPropertyByName( rName ) )
		{
			SEQ( PropertyValue )	aProps( 1 );
			PropertyValue&			rProp = aProps.getArray()[ 0 ];

			rProp.Name	     = rName;
			rProp.Handle     = -1; /* unknown */
//			rProp.Type       = ;
//			rProp.Attributes = ;
			rProp.Value	     = rValue;
//			rProp.State      = ;

			REF( XContentTaskEnvironment )	xEnv( new UCBSyncTaskEnv( this, globalInteractionHandler, globalProgressHandler ) );
			REF( XPropertyTask )			xTask( xProc->createPropertyTask( PropertyTaskType_SET, aProps, xEnv ) );

			if( xTask.is() )
				xTask->execute();
		}
	}
}

//----------------------------------------------------------------------------

void SyncContent::ExecuteCommand( const OUString& rName, const Any& rArgument )
{
	REF( XCommandTaskProcessor ) xProc( mxContent, UNO_QUERY );
	
	if( xProc.is() )
	{
		REF( XCommandInfo ) xInfo( xProc->getCommandsInfo() );
		
		if( xInfo.is() && xInfo->hasCommandByName( rName ) )
		{
			Command aCommand;

			aCommand.Name     = rName;
			aCommand.Handle   = -1; /* unknown */
//			aCommand.ArgType  = ;
			aCommand.Argument = rArgument;

			REF( XContentTaskEnvironment )	xEnv( new UCBSyncTaskEnv( this, globalInteractionHandler, globalProgressHandler ) );
			REF( XCommandTask )				xTask( xProc->createCommandTask( aCommand, REF( XResultAcceptor )(), xEnv ) );

			if( xTask.is() )
				xTask->execute();
		}
	}
}
