/*************************************************************************
 *
 *  $RCSfile: synccom.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SYNCCOM_HXX
#define _SYNCCOM_HXX

#ifndef _DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _TOOLS_TIME_HXX
#include <tools/time.hxx>
#endif
#ifndef _VCOMPAT_HXX
#include <tools/vcompat.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif
#ifndef _UCBHELPER_CONTENT_HXX_
#include <ucbhelper/content.hxx>
#endif
#ifndef _UCBHELPER_CONTENTBROKER_HXX_
#include <ucbhelper/contentbroker.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTPROVIDER_HPP_
#include <com/sun/star/ucb/XContentProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTIDENTIFIERFACTORY_HPP_
#include <com/sun/star/ucb/XContentIdentifierFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTPROVIDERMANAGER_HPP_
#include <com/sun/star/ucb/XContentProviderManager.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_CONTENTACTION_HPP_
#include <com/sun/star/ucb/ContentAction.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTPROVIDERSERVICEREGISTRY_HPP_
#include <com/sun/star/ucb/XContentProviderServiceRegistry.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCOMMANDTASKPROCESSOR_HPP_
#include <com/sun/star/ucb/XCommandTaskProcessor.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XPROPERTYTASKPROCESSOR_HPP_
#include <com/sun/star/ucb/XPropertyTaskProcessor.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCOMMANDENVIRONMENT_HPP_
#include <com/sun/star/ucb/XCommandEnvironment.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_COMMANDINFO_HPP_
#include <com/sun/star/ucb/CommandInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XINDEXACCESS_HPP_
#include <com/sun/star/container/XIndexAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTY_HPP_
#include <com/sun/star/beans/Property.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif

#include <com/sun/star/registry/XRegistryKey.hpp>
#include <com/sun/star/ucb/XContentTaskClient.hpp>
#include <com/sun/star/ucb/XProgressHandler.hpp>
#include <com/sun/star/ucb/XCommandInfo.hpp>
#include <com/sun/star/ucb/XPropertyTaskProcessor.hpp>
#include <com/sun/star/ucb/XContentCreator.hpp>
#include <com/sun/star/ucb/XCommandTaskProcessor.hpp>
#include <com/sun/star/ucb/OpenCommandArgument.hpp>
#include <com/sun/star/ucb/XContentCreationListener.hpp>
#include <com/sun/star/ucb/XContentCreationNotifier.hpp>
#include <com/sun/star/ucb/XResultAcceptor.hpp>
#include <com/sun/star/task/XInteractionHandler.hpp>
#include <com/sun/star/beans/XPropertiesChangeListener.hpp>
#include <com/sun/star/beans/Property.hpp>
#include <com/sun/star/lang/XComponent.hpp>
#include <com/sun/star/io/XInputStream.hpp>
#include <com/sun/star/io/XOutputStream.hpp>
#include <com/sun/star/chaos/OpenMode.hpp>
#include <com/sun/star/sync/SyncScheme.hpp>
#include <com/sun/star/sync/SyncElement.hpp>
#include <com/sun/star/sync/SyncInfo.hpp>
#include <com/sun/star/sync/SyncEvent.hpp>
#include <com/sun/star/sync/SyncAction.hpp>
#include <com/sun/star/sync/SyncMode.hpp>
#include <com/sun/star/sync/SyncOptions.hpp>
#include <com/sun/star/sync/SyncType.hpp>
#include <com/sun/star/sync/XSyncCollector.hpp>
#include <com/sun/star/sync/XSynchronizer.hpp>

// -----------------------------------------------------------------------------

#ifndef __RTL_USTRING_
#include <rtl/ustring>
#endif
#ifndef _STORE_STORE_HXX_
#include <store/store.hxx>
#endif

using namespace rtl;
using namespace store;
using namespace cppu;
using namespace com::sun::star::registry;
using namespace com::sun::star::uno;
using namespace com::sun::star::lang;
using namespace com::sun::star::beans;
using namespace com::sun::star::task;
using namespace com::sun::star::ucb;
using namespace com::sun::star::io;
using namespace com::sun::star::sync;

// -----------------------------------------------------------------------------

#define REF( _def_Obj )						Reference< _def_Obj >
#define SEQ( _def_Obj )						Sequence< _def_Obj > 

// -----------------------------------------------------------------------------

// !!!
#define CNT_TYPESTR_NONE		::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "" ) )
#define CNT_TYPESTR_VFS_FOLDER	::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "Folder" ) )
#define CNT_TYPESTR_VFS_FILE	::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "File" ) )
#define CNT_TYPESTR_FOLDER		::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "application/vnd.sun.staroffice.fsys-folder" ) )
#define CNT_TYPESTR_FILE		::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "application/vnd.sun.staroffice.fsys-file" ) )

// ------------------
// - UCBSyncTaskEnv -
// ------------------

class UCBSyncTaskEnv : public OWeakObject, public XContentTaskEnvironment
{
	REF( XContentTaskClient )					mxClient;
	REF( XInteractionHandler )					mxInteractionHandler;
	REF( XProgressHandler )						mxProgressHandler;
												
public:											
												
												UCBSyncTaskEnv( const REF( XContentTaskClient )& rxClient,
																const REF( XInteractionHandler )& rxInteractionHandler,
																const REF( XProgressHandler )& rxProgressHandler ) :
													mxClient( rxClient ),
													mxInteractionHandler( rxInteractionHandler ),
													mxProgressHandler( rxProgressHandler ) {}
												
												~UCBSyncTaskEnv() {}

	// XInterface
    virtual void SAL_CALL						acquire() throw( RuntimeException ) { OWeakObject::acquire(); }
    virtual void SAL_CALL						release() throw( RuntimeException ) { OWeakObject::release(); }
	virtual Any SAL_CALL						queryInterface( const Type & rType ) throw (RuntimeException)
												{
													const Any aRet( ::cppu::queryInterface( rType,
																							static_cast< XContentTaskEnvironment* >( this ) ) ); 

													return( aRet.hasValue() ? aRet : OWeakObject::queryInterface( rType ) );
												}

 	// XContentTaskEnvironemnt
    virtual REF( XContentTaskClient ) SAL_CALL	getClient() throw( RuntimeException ) { return mxClient; }
	virtual REF( XInteractionHandler ) SAL_CALL getInteractionHandler() throw (RuntimeException) { return mxInteractionHandler; }
	virtual REF( XProgressHandler ) SAL_CALL	getProgressHandler() throw (RuntimeException) { return mxProgressHandler; }
};


#endif // _SYNCCOM_HXX
