/*************************************************************************
 *
 *  $RCSfile: synccoll.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SYNCCOLL_HXX
#define _SYNCCOLL_HXX

#include "synccom.hxx"
#include "syncbase.hxx"

// -----------------
// - SyncCollector -
// -----------------

class SyncCollector : public OWeakObject, public XContentEventListener, 
					  public XSyncCollector, public XContentCreationListener
{	
private:

	REF( XMultiServiceFactory )						mxFact;
	REF( XContentProviderManager )					mxProvMgr;
	PSYNCBASE*										mpSyncBases;
	SEQ( SyncScheme )								maSyncSchemes;
	sal_Bool										mbLocked;

													SyncCollector();
													
public:												
													
	static OUString									GetURL( const OUString& rFile ) 
													{ 
														INetURLObject aURL; 
														aURL.SetSmartURL( rFile ); 
														return aURL.GetMainURL(); 
													}

	static OUString									ToRel( const OUString& rAbsIdentifier, const SyncScheme& rScheme )
													{
														return rAbsIdentifier.copy( rScheme.Root.getLength() );
													}
													
public:												
													
													SyncCollector( const REF( XMultiServiceFactory )& rxMgr );
	virtual 										~SyncCollector();
													
	// XInterface									
	virtual Any SAL_CALL							queryInterface( const Type & rType ) throw (RuntimeException);
    virtual void SAL_CALL							acquire() throw( RuntimeException );
    virtual void SAL_CALL							release() throw( RuntimeException );
													
	// XEventListener								
    virtual void SAL_CALL							disposing( const EventObject& Source ) throw( RuntimeException );
													
	// XContentEventListener						
    virtual void SAL_CALL							contentEvent( const ContentEvent& evt ) throw( RuntimeException );

	// XUCBSynchronizer						
	virtual sal_Bool SAL_CALL						initialize( const REF( XContentProviderManager )& rxMgr, 
																const SEQ( SyncScheme )& rSyncSchemes, 
																const OUString& rBaseFileName );
	
	virtual SEQ( SyncScheme ) SAL_CALL				getRegisteredSyncSchemes();

	virtual SEQ( SyncElement ) SAL_CALL				getSyncSequence( const OUString& rSchemeName, const SyncInfo& rSyncInfo );

	virtual void SAL_CALL							beginSynchronize();

	virtual void SAL_CALL							endSynchronize();

	virtual sal_Bool SAL_CALL						getCorrespondingElement( const SyncScheme& rSyncSchemeIn,
																			 const SyncElement& rSyncElementIn, 
																			 SyncElement& rSyncElementOut );

	virtual sal_Bool SAL_CALL						executeElementCommand( const OUString& rSchemeName,
																		   const SyncElement& rElem,
																		   const OUString& rCommand, 
																		   Any& rAny );

	virtual void SAL_CALL							elementSynchronized( const OUString& rSchemeName,
																		 const SyncElement& rElem,
																		 sal_uInt32 nSyncAction );

	virtual void SAL_CALL							notify( const REF( XContent )& rxCnt, sal_uInt32 nEvent );

	// XContentCreationListener
	virtual void SAL_CALL							contentCreationEvent( const ContentCreationEvent& rEvt );

public:
	
	sal_uInt32										GetSyncSchemeCount() const { return maSyncSchemes.getLength(); }
	const SyncScheme&								GetSyncScheme( const OUString& rSchemeName ) const;
	
	sal_Bool										HasSyncBase( const OUString& rSchemeName ) const;
	SyncBase&										GetSyncBase( const OUString& rSchemeName, sal_Bool bDynamic ) const;

	sal_Bool										IsLocked() const { return mbLocked; }
};

#endif
