/*************************************************************************
 *
 *  $RCSfile: stringdefine.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: fs $ $Date: 2001/06/06 08:17:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_FORMSCTRLR_STRINGDEFINE_HXX_
#define _EXTENSIONS_FORMSCTRLR_STRINGDEFINE_HXX_

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

//............................................................................
namespace pcr
{
//............................................................................

	//============================================================
	//= a helper for static ascii pseudo-unicode strings
	//============================================================
	struct ConstAsciiString
	{
		const sal_Char*	ascii;
		sal_Int32		length;

		inline	operator const ::rtl::OUString& () const;
		inline	operator const sal_Char* () const { return ascii; }

		inline ConstAsciiString(const sal_Char* _pAsciiZeroTerminated, const sal_Int32 _nLength);
		inline ~ConstAsciiString();

	private:
		mutable ::rtl::OUString*	ustring;
	};

	//------------------------------------------------------------
	inline ConstAsciiString::ConstAsciiString(const sal_Char* _pAsciiZeroTerminated, const sal_Int32 _nLength)
		:ascii(_pAsciiZeroTerminated)
		,length(_nLength)
		,ustring(NULL)
	{
	}

	//------------------------------------------------------------
	inline ConstAsciiString::~ConstAsciiString()
	{
		delete ustring;
		ustring = NULL;
	}

	//------------------------------------------------------------
	inline ConstAsciiString::operator const ::rtl::OUString& () const
	{
		if (!ustring)
			ustring = new ::rtl::OUString(ascii, length, RTL_TEXTENCODING_ASCII_US);
		return *ustring;
	}

	//============================================================

#define CONST_ASCII_LENGTH(c)	\
	(const sal_Char*)c, c.length()

	//============================================================
	//= concrete strings
	//============================================================
	#ifndef PCR_IMPLEMENT_STRINGS
	#define PCR_CONSTASCII_STRING(ident, string) extern const ConstAsciiString ident
	#else
	#define PCR_CONSTASCII_STRING(ident, string) extern const ConstAsciiString ident(string, sizeof(string)-1)
	#endif

//............................................................................
} // namespace pcr
//............................................................................

#endif // _EXTENSIONS_FORMSCTRLR_STRINGDEFINE_HXX_

/*************************************************************************
 * history:
 *	$Log: stringdefine.hxx,v $
 *	Revision 1.2  2001/06/06 08:17:57  fs
 *	changed the ConstAsciiString implementation so that an OUString is shared and re-used
 *	
 *	Revision 1.1  2001/01/12 11:33:53  fs
 *	initial checkin - outsourced the form property browser
 *	
 *
 *	Revision 1.0 12.01.01 09:37:53  fs
 ************************************************************************/

