/*************************************************************************
 *
 *  $RCSfile: pgpui60.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef WIN32
#define _EXTENSIONS_PGP_PGPUI_CXX "$Revision: 1.1.1.1 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _RTL_MEMORY_H_
#include <rtl/memory.h>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif

#ifndef _EXTENSIONS_PGP_PGPUI_HXX
#include "pgpui.hxx"
#endif

#ifndef Included_pflPrefTypes_h
#include "pflPrefTypes.h"
#endif
#ifndef Included_pgpClientPrefs_h
#include "pgpClientPrefs.h"
#endif
#ifndef Included_pgpPubTypes_h
#include "pgpPubTypes.h"
#endif
#ifndef Included_pgpErrors_h
#include "pgpErrors.h"
#endif
#ifndef Included_pgpKeys_h
#include "pgpKeys.h"
#endif
#ifndef Included_pgpUtilities_h
#include "pgpUtilities.h"
#endif

using namespace com::sun::star::uno;
using namespace rtl;

#define U2S(u) OUStringToOString((u), RTL_TEXTENCODING_MS_1252)

/*========================================================================
 *
 * PGPUIGetPreferences_Impl.
 *
 *======================================================================*/
/*
 * PGPcl.h
 */
extern "C" PGPError PGPAPI PGPclOpenClientPrefs (
	PGPMemoryMgrRef memMgr, PGPPrefRef *pPrefRef);
extern "C" PGPError PGPAPI PGPclCloseClientPrefs (
	PGPPrefRef PrefRef, sal_Bool bSave);

/*
 * PGPUIGetPreferences_Impl.
 */
PGPError PGPUIGetPreferences_Impl (PGPUIPreferences_Impl &rPref)
{
	PGPContextRef context = PGPGetContext_Impl();
	PGPPrefRef    pref = NULL;

	PGPError errcode = PGPclOpenClientPrefs (
		PGPGetContextMemoryMgr (context), &pref);
	if (IsntPGPError(errcode))
	{
		PGPGetPrefBoolean (
			pref,
			kPGPPrefEncryptToSelf,
			&(rPref.m_bEncryptToSelf));
		PGPGetPrefBoolean (
			pref,
			kPGPPrefMailEncryptDefault,
			&(rPref.m_bEncryptByDefault));
		PGPGetPrefBoolean (
			pref,
			kPGPPrefMailSignDefault,
			&(rPref.m_bSignByDefault));
		PGPGetPrefBoolean (
			pref,
			kPGPPrefAutoDecrypt,
			&(rPref.m_bAutoDecrypt));

#if 0  /* NYI */
		PGPGetPrefNumber (
			pref,
			kPGPPrefWordWrapWidth);
		PGPGetPrefString (
			pref,
			kPGPPrefComment);
#endif /* NYI */

		errcode = PGPclCloseClientPrefs (pref, sal_False);
	}
	return errcode;
}

/*========================================================================
 *
 * PGPUIGetRecipientKeySet_Impl.
 *
 *======================================================================*/
/*
 * PGPcl.h
 */
#define CurrentPGPRecipVersion 'DUKE'

typedef struct recipient_dialog_st
{
	sal_uInt32    dwVersion;
	sal_uInt32    hwndParent;
	sal_Char *    pszTitle;
	PGPContextRef Context;
	PGPKeySetRef  OriginalKeySet;
	PGPKeySetRef  SelectedKeySet;
	sal_Char **   pszRecipients;
	sal_uInt32    dwNumRecipients;
	sal_uInt32    dwOptions;
	sal_uInt32    dwFlags;
	sal_uInt32    dwDisableFlags;
	void *        tlsContext;
	PGPKeySetRef  AddedKeys;
} RECIPIENTDIALOGSTRUCT;

extern "C" PGPUInt32 PGPAPI PGPclRecipientDialog (RECIPIENTDIALOGSTRUCT *ctx);

/*
 * PGPUIGetRecipientKeySet_Impl.
 */
void PGPUIGetRecipientKeySet_Impl (
	PGPContextRef             Context,
	const Sequence<OUString> &rRecipients,
	PGPKeySetRef             *pOriginalKeySet,
	PGPKeySetRef             *pSelectedKeySet)
{
	*pSelectedKeySet = NULL;
	if (rRecipients.getLength())
	{
		sal_Int32 i, n = rRecipients.getLength();

		RECIPIENTDIALOGSTRUCT rd;
		rtl_zeroMemory (&rd, sizeof (rd));

		rd.dwVersion       = CurrentPGPRecipVersion;
		rd.hwndParent      = 0;
		rd.pszTitle        = "Recipient Selection Dialog";

		rd.Context         = Context;
		rd.OriginalKeySet  = *pOriginalKeySet;
		rd.SelectedKeySet  = 0;

		rd.pszRecipients   = new sal_Char*[n];
		rd.dwNumRecipients = n;

		rd.dwOptions       = 1;
		rd.dwFlags         = 0;
		rd.dwDisableFlags  = 1 | 2 | 8;

		for (i = 0; i < n; i++)
		{
			OString aRecipient (U2S (rRecipients.getConstArray()[i]));
			sal_uInt32 nSize = aRecipient.getLength() + 1;

			rd.pszRecipients[i] = new sal_Char[nSize];
			rtl_copyMemory (
				rd.pszRecipients[i], (const sal_Char*)aRecipient, nSize);
		}

		if (PGPclRecipientDialog (&rd))
		{
			*pOriginalKeySet = rd.OriginalKeySet;
			*pSelectedKeySet = rd.SelectedKeySet;
		}

		for (i = 0; i < n; i++)
			delete rd.pszRecipients[i], rd.pszRecipients[i] = 0;
		delete [] rd.pszRecipients;
	}
}

#ifndef WIN32 /* Other platform */

/*
 * PGPGetRecipientKeySet_Impl.
 */
void PGPGetRecipientKeySet_Impl (
	PGPContextRef             Context
	const Sequence<OUString> &rRecipients,
	PGPKeySetRef             *pOriginalKeySet,
	PGPKeySetRef             *pSelectedKeySet)
{
	*pSelectedKeySet = NULL;
	if (rRecipients.getLength())
	{
		PGPFilterRef filter = NULL;
		PGPError     err = 0;

		sal_Int32 i, n = rRecipients.getLength();
		for (i = 0; i < n; i++)
		{
			OString aRecipient (U2S (rRecipients.getConstArray()[i]));

			PGPFilterRef f = NULL;
			err = PGPNewUserIDEmailFilter (
				m_context, (const sal_Char*)aRecipient, kPGPMatchSubString, &f);
			if (err == 0)
			{
				if (filter)
					err = PGPUnionFilters (filter, f, &filter);
				else
					filter = f;
			}
		}

		PGPKeySetRef selectedKeySet = NULL;
		err = PGPFilterKeySet (m_keyset, filter, &selectedKeySet);
		if (err == 0)
		{
			PGPUInt32 numKeys = 0;
			err = PGPCountKeys (selectedKeySet, &numKeys);
			if (numKeys)
			{
			}
			PGPFreeKeySet (selectedKeySet);
		}
		PGPFreeFilter (filter);
	}
}

#endif /* Other platform */

/*========================================================================
 *
 * PGPUIGetSigningPhrase_Impl.
 *
 *======================================================================*/
/*
 * PGPcl.h
 */
extern "C" PGPError PGPAPI PGPclGetCachedSigningPhrase (
	PGPContextRef      context,
	void *             tlsContext,
	sal_uInt32         hwndParent,
	sal_Char *         pszPrompt,
	sal_Bool           bForceUserInput,
	sal_Char **        pszPhrase,
	PGPKeySetRef       KeySet,
	PGPKeyRef *        pKey,
	PGPHashAlgorithm * pHashAlg,
	PGPUInt32 *        pOptions,
	PGPUInt32          nFlags,
	PGPByte **         ppPasskeyBuffer,
	PGPUInt32 *        piPasskeyLength,
	PGPKeySetRef *     pKeysetAdded);

/*
 * PGPUIGetSigningPhrase_Impl.
 */
PGPError PGPUIGetSigningPhrase_Impl (
	PGPContextRef  Context,
	PGPKeySetRef   KeySet,
	PGPKeyRef     *pKey,
	sal_Char     **pszPhrase)
{
	sal_Char *pszPrompt = "Please enter your passphrase:";
	return PGPclGetCachedSigningPhrase (
		Context,
		NULL,
		0,
		pszPrompt,
		sal_False,
		pszPhrase,
		KeySet,
		pKey,
		NULL,
		NULL,
		0,
		NULL,
		NULL,
		NULL);
}

/*========================================================================
 *
 * PGPUIGetDecryptPhrase_Impl.
 *
 *======================================================================*/
/*
 * PGPcl.h
 */
extern "C" PGPError PGPAPI PGPclGetCachedDecryptionPhrase (
	PGPContextRef    context,
	void *           tlsContext,
	PGPKeySetRef     keyring,
	sal_uInt32       hwndParent,
	sal_Char *       pszPrompt,
	sal_Bool         bForceUserInput,
	sal_Char **      pszPhrase,
	PGPKeySetRef     KeySet,
	const PGPKeyID   KeyIDList[],
	PGPUInt32        KeyIDCount,
	PGPByte **       ppPasskeyBuffer,
	PGPUInt32 *      piPasskeyLength,
	PGPKeySetRef *   pKeysetAdded);
	
/*
 * PGPUIGetDecryptPhrase_Impl.
 */
PGPError PGPUIGetDecryptPhrase_Impl (
	PGPContextRef  Context,
	PGPKeySetRef   KeyRing,
	PGPKeySetRef   KeySet,
	const PGPKeyID KeyIDList[],
	PGPUInt32      KeyIDCount,
	sal_Char     **pszPhrase)
{
	PGPUInt32 nKeyCount = 0;
	if (KeySet)
		PGPCountKeys (KeySet, &nKeyCount);

	sal_Char *pszPrompt = "Please enter your passphrase:";
	return PGPclGetCachedDecryptionPhrase (
		Context,
		NULL,
		KeyRing,
		0,
		pszPrompt,
		(nKeyCount == 0),
		pszPhrase,
		KeySet,
		KeyIDList,
		KeyIDCount,
		NULL,
		NULL,
		NULL);
}

/*========================================================================
 *
 * PGPUIFreePhrase_Impl.
 *
 *======================================================================*/
/*
 * PGPcl.h
 */
extern "C" void PGPAPI PGPclFreePhrase (sal_Char * pszPhrase);

/*
 * PGPUIFreePhrase_Impl.
 */
void PGPUIFreePhrase_Impl (sal_Char *pszPhrase)
{
	PGPclFreePhrase (pszPhrase);
}

/*========================================================================
 *
 * The End.
 *
 *======================================================================*/

#endif /* WIN32 */

