/*************************************************************************
 *
 *  $RCSfile: SimplePGPMailer.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.star.pgp;

import java.util.*;
import com.sun.star.io.*;
import javax.swing.JOptionPane;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.RuntimeException;
import com.sun.star.pgp.*;
//==================================================================================================

public class SimplePGPMailer implements
	  XPGPEncoder,
      XPGPDecoder,
	  XPGPPreferences
{
	private static final boolean DEBUG = false;

	static ResourceBundle m_aBundle= null;
	
	//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// XPGPEncoder
	//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    public boolean encryptAndSign( String[] Recipients, XInputStream aPlainTextIn, XOutputStream aCipherTextOut )
		throws RuntimeException
	{			  

  		if (_currentPGP.hasPublicUserInfos() && _currentPGP.hasSignatureUserInfos())
     	{
			boolean bRet=true;
			try{
				PGPMainDialog main = PGPMainDialog.invoke( getResourceBundle(),_currentPGP, Recipients );
				if (main != null)
				{
					if (main.useConvEncryption())
					{
						ConfirmedPassPhraseDialog dialog = ConfirmedPassPhraseDialog.invoke(getResourceBundle());
						if (dialog != null)
						{
							SignersPassPhraseDialog pass=  SignersPassPhraseDialog.invoke( getResourceBundle(), _currentPGP );
							if( pass != null)
								_currentPGP.encryptAndSignConv(pass.getSigner(),pass.getPassPhrase(),
											dialog.getPassPhrase(),	aPlainTextIn, aCipherTextOut);
						}
					}
					else{
						SignersPassPhraseDialog pass = SignersPassPhraseDialog.invoke( getResourceBundle(), _currentPGP );
						if (pass != null)
							_currentPGP.encryptAndSign( pass.getSigner(), pass.getPassPhrase(),
												 main.getRecipients(), aPlainTextIn, aCipherTextOut );
					}
				}
				aCipherTextOut.closeOutput();
			}catch (IOException exc)
			{
				JOptionPane.showMessageDialog( null, exc.getMessage(), "IO Error",
											   JOptionPane.ERROR_MESSAGE );
				bRet= false;
			}
			catch (PGPException exc)
			{
				JOptionPane.showMessageDialog( null, exc.getMessage(), "PGP Error",
										   JOptionPane.ERROR_MESSAGE );
				bRet= false;
			}
			return bRet;		
		}
		return false;
	}

  // Currently the encryption is performed synchroniously. Note, that the thread Encrypt is not
  // startet.
	public boolean encrypt( String[] Recipients, XInputStream aPlainTextIn, XOutputStream aCipherTextOut ) throws RuntimeException {
		if (_currentPGP.hasPublicUserInfos())
		{
			boolean bRet=true;
			try{
				PGPMainDialog main = PGPMainDialog.invoke( getResourceBundle(),_currentPGP, Recipients );
				if (main != null)
				{
					if (main.useConvEncryption())
					{
						ConfirmedPassPhraseDialog dialog = ConfirmedPassPhraseDialog.invoke(getResourceBundle());
						if (dialog != null)
							_currentPGP.encryptConv( dialog.getPassPhrase(), aPlainTextIn, aCipherTextOut);
					}
					else
					{
						_currentPGP.encrypt( main.getRecipients(), aPlainTextIn, aCipherTextOut);
					}
				}
				aCipherTextOut.closeOutput();
			}catch (IOException exc)
			{
				JOptionPane.showMessageDialog( null, exc.getMessage(), "IO Error",
											   JOptionPane.ERROR_MESSAGE );
				bRet= false;
			}
			catch (PGPException exc)
			{
				JOptionPane.showMessageDialog( null, exc.getMessage(), "PGP Error",
											   JOptionPane.ERROR_MESSAGE );
				bRet= false;
			}
			return bRet;

		}
		return false;
	}

	
    public boolean sign( boolean bDataIsAscii, XInputStream aPlainTextIn,XOutputStream aCipherTextOut ) throws RuntimeException {
		if (_currentPGP.hasSignatureUserInfos())
		{
			boolean bRet=true;
			try{			
				SignersPassPhraseDialog pass = SignersPassPhraseDialog.invoke( getResourceBundle(), _currentPGP );
				if (pass != null)
					 _currentPGP.sign( pass.getSigner(), pass.getPassPhrase(),
							   bDataIsAscii, aPlainTextIn, aCipherTextOut );
				aCipherTextOut.closeOutput();
			}catch (IOException exc)
			{
				JOptionPane.showMessageDialog( null, exc.getMessage(), "IO Error",
											   JOptionPane.ERROR_MESSAGE );
				bRet= false;
			}
			catch (PGPException exc)
			{
				JOptionPane.showMessageDialog( null, exc.getMessage(), "PGP Error",
										   JOptionPane.ERROR_MESSAGE );
				bRet= false;
			}
			return bRet;
		}
		return false;
	}
	
	//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// XPGPDecoder
	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++false+++++++++++++++++++++++++
   public void addDecoderListener( XPGPDecoderListener Listener) throws RuntimeException {
		// addlement() is synchronized
		_decoderListeners.addElement( Listener );
	}

	
    public void removeDecoderListener( XPGPDecoderListener Listener ) throws RuntimeException {
		// removeElement() is synchronized
		_decoderListeners.removeElement( Listener );
	} 


    public boolean decryptAndVerify( XInputStream aCipherTextIn, XOutputStream aPlainTextOut ) throws RuntimeException {
		if (_currentPGP.hasPublicUserInfos() && _currentPGP.hasSignatureUserInfos())
		{
			boolean bRet= true;
			try{
				SignatureInfo info = _currentPGP.decryptAndVerify( new DecryptPassPhraseDialogImpl(getResourceBundle()),
																   aCipherTextIn, aPlainTextOut);
				// fire listener events
				for ( Enumeration enum = _decoderListeners.elements(); enum.hasMoreElements(); )
				{
					XPGPDecoderListener l = (XPGPDecoderListener)enum.nextElement();
					if( info != null)
						l.verified( new com.sun.star.pgp.SignatureEvent( SimplePGPMailer.this,
																				 info._userId, info._bSignatureChecked, info._bMessageVerified ) );
				}
				aPlainTextOut.closeOutput();
			}catch (IOException exc)
			{
				JOptionPane.showMessageDialog( null, exc.getMessage(), "IO Error",
											   JOptionPane.ERROR_MESSAGE );
				bRet= false;
			}
			catch (PGPException exc)
			{
				JOptionPane.showMessageDialog( null, exc.getMessage(), "PGP Error",
											   JOptionPane.ERROR_MESSAGE );
				bRet= false;
			}
			return bRet;
		}
		return false;
	}

	//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// XPGPPreferences
	//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    public boolean getEncryptToSelf() throws RuntimeException {
		return false;
	}

    public boolean getEncryptByDefault() throws RuntimeException {
		return false;
	}

    public boolean getSignByDefault() throws RuntimeException {
		return false;
	}

    public boolean getAutoDecrypt() throws RuntimeException {
		return false;
	}


	public	SimplePGPMailer( XMultiServiceFactory xSF, IPGP pgp )
	{
		_xServiceFactory= xSF;
		_currentPGP = pgp;
	}

	//----------------------------------------------------------------------------------------------

// RuntimeException MissingResoureException is not caught. That helps with debugging.
	public static ResourceBundle getResourceBundle()
	{
		if( m_aBundle != null )
			return m_aBundle;
		
		boolean bRet= true;
		try{
			// determine language and country
			String sLang= System.getProperty("user.language", "en");
			String sCountry= System.getProperty("user.country", "US");
			
			Locale aLocale= new Locale( sLang, sCountry);
			m_aBundle= ResourceBundle.getBundle("com.sun.star.pgp.resources.pgp", aLocale);
			
		}catch( SecurityException se){
		}catch( MissingResourceException mre){
			System.err.println( mre.getMessage());
		}
		return m_aBundle;
	}
	
//  	static
//  	{
//  		try
//  		{
//  			javax.swing.UIManager.setLookAndFeel(
//  				"com.sun.java.swing.plaf.windows.WindowsLookAndFeel" );
//  		}
//  		catch (javax.swing.UnsupportedLookAndFeelException exc)
//  		{
//  		}
//  		catch (InstantiationException exc)
//  		{
//  		}
//  		catch (IllegalAccessException exc)
//  		{
//  		}
//  		catch (ClassNotFoundException exc)
//  		{
//  		}
//  	}

	//##############################################################################################
	private XMultiServiceFactory _xServiceFactory= null;
	private IPGP					_currentPGP = null;
	private Vector					_decoderListeners = new Vector();
}

