/*************************************************************************
 *
 *  $RCSfile: asyncadmin.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: fs $ $Date: 2001/06/15 09:49:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_DBI_ASYNCADMIN_HXX_
#include "asyncadmin.hxx"
#endif
#ifndef _SV_SVAPP_HXX 
#include <vcl/svapp.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _COM_SUN_STAR_UI_DIALOGS_XEXECUTABLEDIALOG_HPP_
#include <com/sun/star/ui/dialogs/XExecutableDialog.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _VCL_STDTEXT_HXX 
#include <vcl/stdtext.hxx>
#endif


//.........................................................................
namespace dbi
{
//.........................................................................

	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::lang;
	using namespace ::com::sun::star::ui::dialogs;
	using namespace ::com::sun::star::beans;

	//=====================================================================
	//= OAsyncAdminDialog
	//=====================================================================
	//---------------------------------------------------------------------
	OAsyncAdminDialog::OAsyncAdminDialog(const Reference< XMultiServiceFactory >& _rxORB, const ::rtl::OUString& _rInitialSelection)
		:m_xORB(_rxORB)
		,m_bExecuting(sal_False)
		,m_sInitialSelection(_rInitialSelection)
	{
		DBG_ASSERT(m_xORB.is(), "OAsyncAdminDialog::OAsyncAdminDialog: invalid service factory");
	}

	//---------------------------------------------------------------------
	void OAsyncAdminDialog::execute()
	{
		::osl::MutexGuard aGuard(m_aMutex);

		acquire();
		m_bExecuting = sal_True;

		Application::PostUserEvent(LINK(this, OAsyncAdminDialog, OnAsyncExecute));
	}

	//---------------------------------------------------------------------
	IMPL_LINK( OAsyncAdminDialog, OnAsyncExecute, void*, NOTINTERESTEDIN )
	{
		::osl::MutexGuard aGuard(m_aMutex);

		try
		{
			::rtl::OUString sServiceName = ::rtl::OUString::createFromAscii("com.sun.star.sdb.DatasourceAdministrationDialog");

			// build the arguments sequence, if we have an initial selection
			Sequence< Any > aArgs;
			if (m_sInitialSelection.getLength())
			{
				aArgs.realloc(1);
				aArgs[0] <<= PropertyValue(
					::rtl::OUString::createFromAscii("InitialSelection"), 0,
					makeAny(m_sInitialSelection),
					PropertyState_DIRECT_VALUE);
			}

			// create
			Reference< XInterface > xAdminDialog;
			if (aArgs.getLength())
				xAdminDialog = m_xORB->createInstanceWithArguments(sServiceName, aArgs);
			else
				xAdminDialog = m_xORB->createInstance(sServiceName);

			// available?
			if (!xAdminDialog.is())
			{
				ShowServiceNotAvailableError(NULL, sServiceName, sal_True);
				return 0L;
			}

			// execute
			Reference< XExecutableDialog > xExecutable(xAdminDialog, UNO_QUERY);
			if (xExecutable.is())
			{
				xExecutable->execute();
			}
			else
			{
				DBG_ERROR("OAsyncAdminDialog, OnAsyncExecute: missing the XExecutableDialog interface of the component!!");
			}
		}
		catch(Exception&)
		{
			DBG_ERROR("OAsyncAdminDialog, OnAsyncExecute: could not create/execute the dialog component!");
		}

		return 0L;
	}

//.........................................................................
}	// namespace dbi
//.........................................................................

/*************************************************************************
 * history:
 *	$Log: asyncadmin.cxx,v $
 *	Revision 1.2  2001/06/15 09:49:46  fs
 *	#86986# moved css/ui/* to css/ui/dialogs/*
 *	
 *	Revision 1.1  2001/02/12 07:10:17  fs
 *	initial checkin - importing StarOffice 5.2 database files
 *	
 *
 *	Revision 1.0 08.02.01 11:05:28  fs
 ************************************************************************/

