/*************************************************************************
 *
 *  $RCSfile: pkgchk_misc.h,v $
 *
 *  $Revision: 1.2.4.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/11/01 14:39:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <rtl/string.hxx>
#include <rtl/ustrbuf.hxx>
#include <rtl/bootstrap.hxx>
#include <osl/file.hxx>

#include <com/sun/star/uno/RuntimeException.hpp>

#define CSTR_LEN(x) x, sizeof (x) -1
#define OUSTR(x) ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM(x) )


namespace pkgchk
{

class pkgchk_env;

//
// path name handling
//
//==================================================================================================
inline bool ends_with_ignore_ascii_case(
    ::rtl::OUString const & str, char const * end, sal_Int32 end_len )
    SAL_THROW( () )
{
    sal_Int32 len = str.getLength();
    return (end_len <= len &&
            0 == rtl_ustr_ascii_compareIgnoreAsciiCase( str.pData->buffer + len - end_len, end ));
}
#ifdef SAL_W32
#define LF "\r\n"
//==================================================================================================
inline bool path_equals(
    ::rtl::OUString const & path1, ::rtl::OUString const & path2 )
    SAL_THROW( () )
{
    return (sal_False != path1.equalsIgnoreAsciiCase( path2 ));
}
#else
#define LF "\n"
//==================================================================================================
inline bool path_equals(
    ::rtl::OUString const & path1, ::rtl::OUString const & path2 )
    SAL_THROW( () )
{
    return (sal_False != path1.equals( path2 ));
}
#endif
//==================================================================================================
inline ::rtl::OUString path_concat(
    ::rtl::OUString const & dir, ::rtl::OUString const & file )
    SAL_THROW( () )
{
    ::rtl::OUStringBuffer buf( dir.getLength() + 1 + file.getLength() );
    buf.append( dir );
    buf.append( (sal_Unicode)'/' );
    buf.append( file );
    return buf.makeStringAndClear();
}
//==================================================================================================
inline ::rtl::OUString path_concat(
    ::rtl::OUString const & dir, char const * file, sal_Int32 file_len )
    SAL_THROW( () )
{
    ::rtl::OUStringBuffer buf( dir.getLength() + 1 + file_len );
    buf.append( dir );
    buf.append( (sal_Unicode)'/' );
    buf.appendAscii( file, file_len );
    return buf.makeStringAndClear();
}
//==================================================================================================
::rtl::OUString const & path_get_executable()
    SAL_THROW( (::com::sun::star::uno::RuntimeException) );
//==================================================================================================
::rtl::OUString path_make_absolute( ::rtl::OUString const & path )
    SAL_THROW( (::com::sun::star::uno::RuntimeException) );
//==================================================================================================
inline bool path_exists( ::rtl::OUString const & path ) SAL_THROW( () )
{
    ::osl::DirectoryItem dirItem;
    return (::osl::DirectoryItem::E_None == ::osl::DirectoryItem::get( path, dirItem ));
}

//
// file, path handling
//
sal_uInt32 const c_file_status_mask =
    FileStatusMask_Type |
    FileStatusMask_FileName | FileStatusMask_FileURL |
    FileStatusMask_ModifyTime;

//==================================================================================================
void file_write( oslFileHandle file, ::rtl::OString const & text, ::rtl::OUString const & fileName )
    SAL_THROW( (::com::sun::star::uno::RuntimeException) );
//==================================================================================================
inline void file_write(
    ::osl::File const & file, ::rtl::OString const & text, ::rtl::OUString const & fileName )
    SAL_THROW( (::com::sun::star::uno::RuntimeException) )
{
    file_write( *reinterpret_cast< oslFileHandle const * >( &file ), text, fileName );
}
//==================================================================================================
void path_get_status( ::osl::FileStatus * status, ::rtl::OUString const & path )
    SAL_THROW( (::com::sun::star::uno::RuntimeException) );
//==================================================================================================
void diritem_get_status( ::osl::FileStatus * status, ::osl::DirectoryItem & dirItem )
    SAL_THROW( (::com::sun::star::uno::RuntimeException) );
//==================================================================================================
::rtl::OUString file_status_get_encoded_name( ::osl::FileStatus const & status )
    SAL_THROW( (::com::sun::star::uno::RuntimeException) );
//==================================================================================================
void dir_create(
    ::rtl::OUString const & path )
    SAL_THROW( (::com::sun::star::uno::RuntimeException) );
//==================================================================================================
inline void dir_ensure(
    ::rtl::OUString const & path )
    SAL_THROW( (::com::sun::star::uno::RuntimeException) )
{
    if (! path_exists( path ))
        dir_create( path );
}
//==================================================================================================
void dir_open(
    ::osl::Directory & dir, ::rtl::OUString const & path, bool create = false )
    SAL_THROW( (::com::sun::star::uno::RuntimeException) );

//==================================================================================================
void path_copy(
    ::rtl::OUString const & dest_path_, ::rtl::OUString const & src_path,
    pkgchk_env const & env )
    SAL_THROW( (::com::sun::star::uno::RuntimeException) );
//==================================================================================================
void path_erase(
    ::rtl::OUString const & path,
    pkgchk_env const & env )
    SAL_THROW( (::com::sun::star::uno::RuntimeException) );
//==================================================================================================
void zip_inflate(
    ::rtl::OUString const & dest_path, ::rtl::OUString const & src_path,
    pkgchk_env const & env )
    SAL_THROW( (::com::sun::star::uno::RuntimeException) );

//
// bootstrap variables
//
//==================================================================================================
::rtl::OUString getFromBstrap(
    ::rtl::OUString const & key, ::rtl::Bootstrap const & bstrap )
    SAL_THROW( (::com::sun::star::uno::RuntimeException) );

//
// checks whether concurrent office process is running
//
//==================================================================================================
bool office_is_running( ::rtl::Bootstrap const & unorc )
    SAL_THROW( (::com::sun::star::uno::RuntimeException) );

}
