/*************************************************************************
 *
 *  $RCSfile: singledoccontroller.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: fs $ $Date: 2001/08/15 13:36:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef DBAUI_SINGLEDOCCONTROLLER_HXX
#define DBAUI_SINGLEDOCCONTROLLER_HXX

#ifndef DBAUI_GENERICCONTROLLER_HXX
#include "genericcontroller.hxx"
#endif
#ifndef _COMPHELPER_PROPERTYCONTAINER_HXX_ 
#include <comphelper/propertycontainer.hxx>
#endif
#ifndef _COMPHELPER_PROPERTY_ARRAY_HELPER_HXX_ 
#include <comphelper/proparrhlp.hxx>
#endif
#ifndef _COMPHELPER_BROADCASTHELPER_HXX_
#include <comphelper/broadcasthelper.hxx>
#endif
#ifndef _COM_SUN_STAR_SDBC_XCONNECTION_HPP_
#include <com/sun/star/sdbc/XConnection.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XDATABASEMETADATA_HPP_ 
#include <com/sun/star/sdbc/XDatabaseMetaData.hpp>
#endif

//........................................................................
namespace dbaui
{
//........................................................................

	//====================================================================
	//= OSingleDocumentController
	//====================================================================
	class OSingleDocumentController;
	typedef OGenericUnoController					OSingleDocumentController_CBASE;
	typedef ::comphelper::OPropertyContainer		OSingleDocumentController_PBASE;
	typedef ::comphelper::OPropertyArrayUsageHelper	<	OSingleDocumentController
													>	OSingleDocumentController_PABASE;

	class OSingleDocumentController
			:public OSingleDocumentController_CBASE
			,public OSingleDocumentController_PBASE
			,public OSingleDocumentController_PABASE
	{
		friend class OConnectionChangeBroadcaster;
	private:
		// <properties>
		::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >
						m_xConnection;
		// </properties>
		::rtl::OUString	m_sDataSourceName;		// the data source we're working for
		::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >
						m_xDataSource;
		sal_Bool		m_bOwnConnection : 1;	// is true when we created our own connection


	protected:
		// ----------------------------------------------------------------
		// initalizing members
		/** forces usage of a connection which we do not own
			<p>To be used from within XInitialization::initialize only.</p>
		*/
		void		initializeConnection( const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >& _rxForeignConn );

		/** initializes the data source name
			<p>To be used from within XInitialization::initializec.</p>
		*/
		void		initializeDataSourceName( const ::rtl::OUString& _rName );

	public:
		// ----------------------------------------------------------------
		// asking for connection-related stuff
		const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >&
					getConnection() const { return m_xConnection; }
		sal_Bool	isConnected() const { return m_xConnection.is(); }

		::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XDatabaseMetaData >
					getMetaData( ) const { return isConnected() ? m_xConnection->getMetaData() : ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XDatabaseMetaData >(); }
		// ----------------------------------------------------------------
		// access to the data source
		const ::rtl::OUString&
					getDataSourceName() const { return m_sDataSourceName; }
		const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >&
					getDataSource() const { return m_xDataSource; }
		sal_Bool	haveDataSource() const { return m_xDataSource.is(); }

	protected:
		OSingleDocumentController(const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB);

		virtual void		disconnect();
		virtual void		reconnect( sal_Bool _bUI );
				sal_Bool	ensureConnected( sal_Bool _bUI )	{ if ( !isConnected() ) reconnect( _bUI ); return isConnected(); }

		/** called when our connection is beeing disposed
			<p>The default implementation does a reconnect</p>
		*/
		virtual void losingConnection( );

		// late construction
		virtual sal_Bool Construct(Window* pParent);

	protected:
		// XInterface
		virtual ::com::sun::star::uno::Any SAL_CALL queryInterface( const ::com::sun::star::uno::Type& aType ) throw (::com::sun::star::uno::RuntimeException);
		virtual void SAL_CALL acquire(  ) throw ();
		virtual void SAL_CALL release(  ) throw ();

		// XTypeProvider
		virtual ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Type > SAL_CALL getTypes(  ) throw (::com::sun::star::uno::RuntimeException);
		virtual ::com::sun::star::uno::Sequence<sal_Int8> SAL_CALL getImplementationId(  ) throw(::com::sun::star::uno::RuntimeException);

		// OPropertyArrayUsageHelper
		virtual ::cppu::IPropertyArrayHelper* createArrayHelper( ) const;

		// XPropertySet
		virtual com::sun::star::uno::Reference<com::sun::star::beans::XPropertySetInfo>  SAL_CALL getPropertySetInfo() throw(com::sun::star::uno::RuntimeException);
		virtual ::cppu::IPropertyArrayHelper& SAL_CALL getInfoHelper();

		// XEventListener
		virtual void SAL_CALL disposing(const ::com::sun::star::lang::EventObject& Source) throw( ::com::sun::star::uno::RuntimeException );

		// OComponentHelper
		virtual void SAL_CALL disposing();
	};

//........................................................................
}	// namespace dbaui
//........................................................................

#endif // DBAUI_SINGLEDOCCONTROLLER_HXX

/*************************************************************************
 * history:
 *	$Log: singledoccontroller.hxx,v $
 *	Revision 1.3  2001/08/15 13:36:27  fs
 *	#88637# add a separator above the toolbox
 *	
 *	Revision 1.2  2001/08/15 13:13:05  oj
 *	#88644# insert some DBG's and fix getFocus calls
 *	
 *	Revision 1.1  2001/08/14 11:58:05  fs
 *	initial checkin - base class for controller which work on one single object belonging to a data source connection
 *	
 *
 *	Revision 1.0 14.08.01 09:37:38  fs
 ************************************************************************/

