/*************************************************************************
 *
 *  $RCSfile: MABQuery.cxx,v $
 *
 *  $Revision: 1.28 $
 *
 *  last change: $Author: mmaher $ $Date: 2001/10/04 13:39:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Willem van Dorp, Darren Kenny
 *
 *
 ************************************************************************/

#include <mozaddressbook/MABQueryHelper.hxx>
#include <mozaddressbook/MABNameMapper.hxx>
 
#ifndef _CONNECTIVITY_MAB_QUERY_HXX_
#include "mozaddressbook/MABQuery.hxx"
#endif
#ifndef _CONNECTIVITY_MAB_CONVERSIONS_HXX_
#include "mozaddressbook/MABTypeConverter.hxx"
#endif

#include <../MABDebug.hxx>

static NS_DEFINE_CID(kRDFServiceCID, NS_RDFSERVICE_CID);
static NS_DEFINE_CID(kAbDirectoryQueryArgumentsCID, NS_ABDIRECTORYQUERYARGUMENTS_CID);
static NS_DEFINE_CID(kBooleanConditionStringCID, NS_BOOLEANCONDITIONSTRING_CID);
static NS_DEFINE_CID(kBooleanExpressionCID, NS_BOOLEANEXPRESSION_CID);
static NS_DEFINE_CID(kAbDirectoryQueryProxyCID, NS_ABDIRECTORYQUERYPROXY_CID);

using namespace connectivity::mozaddressbook;
using namespace connectivity;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::sdbc;
using namespace connectivity;

// -------------------------------------------------------------------------
OMozabQuery::OMozabQuery()
{
    OSL_TRACE( "IN OMozabQuery::OMozabQuery()\n" );

    // Set default values. (For now just as a reminder).
    m_bQuerySubDirs   = sal_True;       // LDAP Queryies require this to be set!
    m_nMaxNrOfReturns = -1; // Unlimited number of returns.

    // OMozabQueryHelper is reference counted, so we need to add to the 
    // count here to prevent accidental deletion else where...
    // 
    m_aQueryHelper = new OMozabQueryHelper();
    NS_IF_ADDREF( m_aQueryHelper);

    OSL_TRACE( "\tOUT OMozabQuery::OMozabQuery()\n" );
}
// -------------------------------------------------------------------------
OMozabQuery::OMozabQuery(const ::std::map< ::rtl::OUString, ::rtl::OUString>  & ca)
{
    OSL_TRACE( "IN OMozabQuery::OMozabQuery()\n" );

    // Set default values. (For now just as a reminder).
    m_bQuerySubDirs   = sal_True;       // LDAP Queryies require this to be set!
    m_nMaxNrOfReturns = -1; // Unlimited number of returns.

        // OMozabQueryHelper is reference counted, so we need to add to the 
        // count here to prevent accidental deletion else where...
        // 
        m_aQueryHelper = new OMozabQueryHelper();
        NS_IF_ADDREF( m_aQueryHelper);
        m_aColumnAliasMap = ca;

    OSL_TRACE( "\tOUT OMozabQuery::OMozabQuery()\n" );
}
// -------------------------------------------------------------------------
OMozabQuery::~OMozabQuery()
{
    OSL_TRACE("IN OMozabQuery::~OMozabQuery()\n");
    
    // OMozabQueryHelper is reference counted, so we need to decrement the
    // count here.
    // 
    NS_IF_RELEASE( m_aQueryHelper);

    OSL_TRACE("\tOUT OMozabQuery::~OMozabQuery()\n");
}
// -------------------------------------------------------------------------
void OMozabQuery::setAttributes(::std::vector< ::rtl::OUString> &attrs)
{
    OSL_TRACE("IN OMozabQuery::setAttributes()\n");
    ::osl::MutexGuard aGuard( m_aMutex );

    m_aAttributes.clear();
    ::std::vector< ::rtl::OUString>::iterator aIterAttr = attrs.begin();
        ::std::map< ::rtl::OUString, ::rtl::OUString>::iterator aIterMap;
    for(aIterAttr; aIterAttr != attrs.end();++aIterAttr) {
                aIterMap = m_aColumnAliasMap.find(*aIterAttr);
                if (aIterMap == m_aColumnAliasMap.end()) {
                	// Not found.
                	m_aAttributes.push_back(*aIterAttr);
                } else {
                	m_aAttributes.push_back(aIterMap->second);
            }
    }

    OSL_TRACE("\tOUT OMozabQuery::setAttributes()\n");

    return;
}
// -------------------------------------------------------------------------
const ::std::vector< ::rtl::OUString> &OMozabQuery::getAttributes() const
{
    OSL_TRACE("IN OMozabQuery::getAttributes()\n");
    
    OSL_TRACE("\tOUT OMozabQuery::getAttributes()\n");

    return(m_aAttributes);
}
// -------------------------------------------------------------------------
void OMozabQuery::setAddressbook(::rtl::OUString &ab)
{
    OSL_TRACE("IN OMozabQuery::setAddressbook()\n");
    ::osl::MutexGuard aGuard(m_aMutex);
    
    m_aAddressbook = ab;

    OSL_TRACE("\tOUT OMozabQuery::setAddressbook()\n");

    return;
}
// -------------------------------------------------------------------------
::rtl::OUString OMozabQuery::getAddressbook() const
{
    OSL_TRACE("IN OMozabQuery::getAddressbook()\n");
    
    OSL_TRACE("\tOUT OMozabQuery::getAddressbook()\n");

    return(m_aAddressbook);
}
// -------------------------------------------------------------------------
void OMozabQuery::setMatchItems(::std::vector< ::rtl::OUString> &mi)
{
    OSL_TRACE("IN OMozabQuery::setMatchItems()\n");
    ::osl::MutexGuard aGuard(m_aMutex);

    ::std::vector< ::rtl::OUString>::iterator aIter = mi.begin();
    ::std::map< ::rtl::OUString, ::rtl::OUString>::const_iterator aIterMap;

    m_aMatchItems.clear();
    for(aIter; aIter != mi.end();++aIter) {
        aIterMap = m_aColumnAliasMap.find(*aIter);
        if (aIterMap == m_aColumnAliasMap.end()) {
            // Not found.
            m_aMatchItems.push_back(*aIter);
        } 
        else {
            m_aMatchItems.push_back(aIterMap->second);
        }
    }
    OSL_TRACE("\tOUT OMozabQuery::setMatchItems()\n");

    return;
}
// -------------------------------------------------------------------------
const ::std::vector< ::rtl::OUString> &OMozabQuery::getMatchItems() const
{
    OSL_TRACE("IN OMozabQuery::getMatchItems()\n");

    OSL_TRACE("\tOUT OMozabQuery::getMatchItems()\n");

    return(m_aMatchItems);
}
// -------------------------------------------------------------------------
void OMozabQuery::setMatchValues(::std::vector< ::rtl::OUString>& mv)
{
    OSL_TRACE("IN OMozabQuery::setMatchValues()\n");
    ::osl::MutexGuard aGuard(m_aMutex);

    ::std::vector< ::rtl::OUString>::iterator aIter = mv.begin();
    m_aMatchValues.clear();
    for(aIter; aIter != mv.end();++aIter) {
        m_aMatchValues.push_back(*aIter);
    }
    OSL_TRACE("\tOUT OMozabQuery::setMatchValues()\n");

    return;
}
// -------------------------------------------------------------------------
const ::std::vector< ::rtl::OUString>& OMozabQuery::getMatchValues( void ) const
{
    OSL_TRACE("IN OMozabQuery::getMatchValues()\n");

    OSL_TRACE("\tOUT OMozabQuery::getMatchValue()\n");

    return(m_aMatchValues);
}
// -------------------------------------------------------------------------
void OMozabQuery::setMaxNrOfReturns(const sal_Int32 mnr)
{
    OSL_TRACE( "IN OMozabQuery::setMaxNrOfReturns()\n" );
    ::osl::MutexGuard aGuard(m_aMutex);

    m_nMaxNrOfReturns = mnr;
    OSL_TRACE("\tOUT OMozabQuery::setMaxNrOfReturns()\n" );

    return;
}
// -------------------------------------------------------------------------
sal_Int32 OMozabQuery::getMaxNrOfReturns() const
{
    OSL_TRACE("IN OMozabQuery::getMaxNrOfReturns()\n");

    OSL_TRACE("\tOUT OMozabQuery::getMaxNrOfReturns()\n");

    return(m_nMaxNrOfReturns);
}
// -------------------------------------------------------------------------
void OMozabQuery::setQuerySubDirs(sal_Bool &qsd)
{
    OSL_TRACE("IN OMozabQuery::setQuerySubDirs()\n");
    ::osl::MutexGuard aGuard(m_aMutex);

    m_bQuerySubDirs = qsd;
    OSL_TRACE("\tOUT OMozabQuery::setQuerySubDirs()\n");

    return;
}
// -------------------------------------------------------------------------
sal_Bool OMozabQuery::getQuerySubDirs() const
{
    OSL_TRACE("IN OMozabQuery::getQuerySubDirs()\n");

    OSL_TRACE("\tOUT OMozabQuery::getQuerySubDirs()\n");

    return(m_bQuerySubDirs);
}
// -------------------------------------------------------------------------
void OMozabQuery::setSqlOppr(::std::vector< OMozabQuery::eSqlOppr > &so)
{
    OSL_TRACE("IN OMozabQuery::setSqlOppr()\n");
    ::osl::MutexGuard aGuard(m_aMutex);

    m_aSqlOppr.clear();
    m_aSqlOppr = so;

    OSL_TRACE("\tOUT OMozabQuery::setSqlOppr()\n");

    return;
}
// -------------------------------------------------------------------------
const ::std::vector< OMozabQuery::eSqlOppr > &OMozabQuery::getSqlOppr() const
{
    OSL_TRACE("IN OMozabQuery::getSqlOppr()\n");
    
    OSL_TRACE("\tOUT OMozabQuery::getSqlOppr()\n");

    return(m_aSqlOppr);
}
// -------------------------------------------------------------------------
sal_Int32 OMozabQuery::executeQuery(sal_Bool _bIsOutlookExpress)
{
    OSL_TRACE("IN OMozabQuery::executeQuery()\n");
    ::osl::MutexGuard aGuard(m_aMutex);


    nsresult rv;        // Store return values.
    //	OMozabTypeConverter aTypeConverter;
    // Create a nsIAbDirectory object to initialise the nsIAbDirectoryQuery object.
	nsCOMPtr<nsIRDFService> rdfService(do_GetService(kRDFServiceCID, &rv)) ;   
    if (NS_FAILED(rv)) 
        return(-1);

    nsCOMPtr<nsIAbDirectory> directory;
    OMozabNameMapper *nmap = OMozabNameMapper::getInstance();

    if ( nmap->getDir( m_aAddressbook, getter_AddRefs( directory ) ) == sal_False )
        return( -1 );

    // Create a nsIAbDirectoryQuery object which eventually will execute 
    // the query by calling DoQuery().
    nsCOMPtr< nsIAbDirectoryQueryProxy > directoryQueryProxy = do_CreateInstance( kAbDirectoryQueryProxyCID, &rv);

    nsCOMPtr<nsIAbDirectoryQuery> directoryQuery(do_QueryInterface(directory, &rv));

    if ( NS_FAILED(rv) || _bIsOutlookExpress) 
    {
        rv = directoryQueryProxy->Initiate (directory);
        NS_ENSURE_SUCCESS(rv, rv);

        directoryQuery = do_QueryInterface (directoryQueryProxy, &rv);
        NS_ENSURE_SUCCESS(rv, rv);
        OSL_TRACE("Using the directoryQueryProxy\n");
    }
#ifdef DEBUG
    else
        OSL_TRACE("Not using a Query Proxy, Query i/f supported by directory\n");
#endif /* DEBUG */

    // Array that holds all matchItems, to be passed to DoQuery().
    nsCOMPtr<nsISupportsArray> matchItems;
    NS_NewISupportsArray(getter_AddRefs(matchItems));

    // Add every individual boolString to matchItems array.
    ::std::vector< ::rtl::OUString>::iterator aIterMi = m_aMatchItems.begin();
    ::std::vector< eSqlOppr >::iterator aIterOp = m_aSqlOppr.begin();
    ::std::vector< ::rtl::OUString>::iterator aIterVal = m_aMatchValues.begin();
    nsString matchValue;
    // Initialise the matchItems container.
    for(aIterMi; aIterMi != m_aMatchItems.end();++aIterMi, ++aIterOp, ++aIterVal) 
    {
        nsCOMPtr<nsIAbBooleanConditionString> boolString = do_CreateInstance (kBooleanConditionStringCID, &rv);
        OSL_TRACE("0x%08X\n", (void*)boolString );
        NS_ENSURE_SUCCESS( rv, rv );
        // Set the 'name' property of the boolString. 
        string aMiName = OMozabTypeConverter::ouStringToStlString(*aIterMi); 
        boolString->SetName(strdup(aMiName.c_str()));
        OSL_TRACE("Name = %s ;", aMiName.c_str() );
        // Set the 'matchType' property of the boolString. Check for equal length.
        if (aIterOp == m_aSqlOppr.end() && aIterMi != m_aMatchItems.end()) {
            m_aSqlOppr.push_back(matchIs); // Add matchIs for non-set value.
        }
        switch(*aIterOp) {
            case matchExists:
                boolString->SetCondition(nsIAbBooleanConditionTypes::Exists);
                break;
            case matchDoesNotExist:
                boolString->SetCondition(nsIAbBooleanConditionTypes::DoesNotExist);
                break;
            case matchContains:
                boolString->SetCondition(nsIAbBooleanConditionTypes::Contains);
                break;
            case matchDoesNotContain:
                boolString->SetCondition(nsIAbBooleanConditionTypes::DoesNotContain);
                break;
            case matchIs:
                boolString->SetCondition(nsIAbBooleanConditionTypes::Is);
                break;
            case matchIsNot:
                boolString->SetCondition(nsIAbBooleanConditionTypes::IsNot);
                break;
            case matchBeginsWith:
                boolString->SetCondition(nsIAbBooleanConditionTypes::BeginsWith);
                break;
            case matchEndsWith:
                boolString->SetCondition(nsIAbBooleanConditionTypes::EndsWith);
                break;
            case matchSoundsLike:
                boolString->SetCondition(nsIAbBooleanConditionTypes::SoundsLike);
                break;
            case matchRegExp:
                boolString->SetCondition(nsIAbBooleanConditionTypes::RegExp);
                break;
            default:
                boolString->SetCondition(nsIAbBooleanConditionTypes::Is);
                break;
        }
        // Set the 'matchValue' property of the boolString. Value returned in unicode.
        if ( (*aIterVal) )
        {
            OSL_TRACE("Value = %s \n", OUtoCStr( (*aIterVal) ) );
            OMozabTypeConverter::ouStringToNsString( (*aIterVal), matchValue);
            boolString->SetValue(matchValue.ToNewUnicode ());
        }
        // Add the individual boolString to the container of matchItems.
        matchItems->AppendElement(boolString);
    }
    nsCOMPtr< nsIAbBooleanExpression > queryExpression = do_CreateInstance( kBooleanExpressionCID , &rv);
    NS_ENSURE_SUCCESS( rv, rv );
    queryExpression->SetExpressions(matchItems);
    queryExpression->SetOperation(nsIAbBooleanOperationTypes::OR);

    // Add every atribute we're interested in to the return properties array.
    ::std::vector< ::rtl::OUString>::iterator aIterAttr = m_aAttributes.begin();
    char    **returnProperties = new char* [ m_aAttributes.size() + 2 ];

    PRInt32   count=0;
    returnProperties[count] = strdup( "card:nsIAbCard");
    for(aIterAttr, count=1; aIterAttr != m_aAttributes.end();++aIterAttr,++count) 
    {
        ::std::string aAttrName = OMozabTypeConverter::ouStringToStlString(*aIterAttr);
        returnProperties[count] = strdup( aAttrName.c_str() );
        OSL_TRACE("returnProperties[%d] = %s\n", count, returnProperties[count] );
    }
    returnProperties[count] = NULL;

    nsCOMPtr< nsIAbDirectoryQueryArguments > arguments = do_CreateInstance( kAbDirectoryQueryArgumentsCID, &rv);

    NS_ENSURE_SUCCESS( rv, rv );
    rv = arguments->SetExpression(queryExpression);
    NS_ENSURE_SUCCESS( rv, rv );

    rv = arguments->SetReturnProperties(count, (const char **)returnProperties);
    NS_ENSURE_SUCCESS( rv, rv );

    rv = arguments->SetQuerySubDirectories(m_bQuerySubDirs);
    NS_ENSURE_SUCCESS( rv, rv );

    PRInt32 context;
    // Execute the query.
    OSL_TRACE( "****** calling DoQuery\n");

    m_aQueryHelper->reset();

    rv = directoryQuery->DoQuery(arguments, m_aQueryHelper, m_nMaxNrOfReturns, -1, &context);

    if (NS_FAILED(rv))  {
        OSL_TRACE( "****** DoQuery failed\n");
        OSL_TRACE("\tOUT OMozabQuery::executeQuery()\n");
        m_aQueryHelper->notifyQueryError() ;
        return(-1);
    } else {
        OSL_TRACE( "****** DoQuery succeeded \n");
    }

    OSL_TRACE("\tOUT OMozabQuery::executeQuery()\n");

    return(0);
}

// -------------------------------------------------------------------------
//
//
//  If the query executed is being done asynchronously then this may return
//  -1 as the count, ie. it's undetermined.
//
sal_Int32
OMozabQuery::getRowCount() 
{
    return( m_aQueryHelper->getResultCount() );
}

// -------------------------------------------------------------------------
//
//
// As opposed to getRowCount() this returns the actual number of rows fetched
// so far (if is an async query)
//
sal_Int32
OMozabQuery::getRealRowCount() 
{
    return( m_aQueryHelper->getRealCount() );
}

//
//  If the query executed is being done asynchronously then this may be
//  false
//
sal_Bool
OMozabQuery::queryComplete( void )
{
    return( m_aQueryHelper->queryComplete() );
}

// -------------------------------------------------------------------------

sal_Bool
OMozabQuery::checkRowAvailable( sal_Int32 nDBRow )
{
    while( !queryComplete() && m_aQueryHelper->getRealCount() <= nDBRow )
        m_aQueryHelper->waitForRow( nDBRow );

    return( getRowCount() > nDBRow );
}

// -------------------------------------------------------------------------
void
OMozabQuery::getRowValue( ORowSetValue& rValue, 
                          sal_Int32 nDBRow, rtl::OUString& aDBColumnName, sal_Int32 nType )
{
    rtl::OUString   sValue;

    OSL_TRACE( "IN OMozabQuery::getRowValue()\n");

    OMozabQueryHelperResultEntry*   xResEntry = m_aQueryHelper->getByIndex( nDBRow );

    if (xResEntry == NULL )
    { 
        rValue.setNull();
        OSL_TRACE( "xResEntry = null\n");
    }
    ::std::map< ::rtl::OUString, ::rtl::OUString>::const_iterator aIterMap;
    switch ( nType ) {
        case DataType::VARCHAR:
            aIterMap = m_aColumnAliasMap.find(aDBColumnName);
            if (aIterMap != m_aColumnAliasMap.end()) {
                sValue = xResEntry->getValue(aIterMap->second);
            } else {
                sValue = xResEntry->getValue( aDBColumnName );
            }
            rValue = sValue;
            break;
        default:
            OSL_TRACE("Unknown DataType : %d\n", nType );
            rValue.setNull();
            break;
    }

    OSL_TRACE( "\tOUT OMozabQuery::getRowValue()\n");
}
