/*************************************************************************
 *
 *  $RCSfile: Statement.cxx,v $
 *
 *  $Revision: 1.15 $
 *
 *  last change: $Author: oj $ $Date: 2001/10/26 14:01:12 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _CONNECTIVITY_JAVA_SQL_STATEMENT_HXX_
#include "java/sql/Statement.hxx"
#endif

#ifndef _CONNECTIVITY_JAVA_SQL_RESULTSET_HXX_
#include "java/sql/ResultSet.hxx"
#endif
#ifndef _CONNECTIVITY_JAVA_SQL_CONNECTION_HXX_
#include "java/sql/Connection.hxx"
#endif
#ifndef _CONNECTIVITY_JAVA_SQL_SQLWARNING_HXX_
#include "java/sql/SQLWarning.hxx"
#endif
#ifndef _CONNECTIVITY_JAVA_TOOLS_HXX_
#include "java/tools.hxx"
#endif
#ifndef _COMPHELPER_PROPERTY_HXX_
#include <comphelper/property.hxx>
#endif
#ifndef _COM_SUN_STAR_LANG_DISPOSEDEXCEPTION_HPP_
#include <com/sun/star/lang/DisposedException.hpp>
#endif
#ifndef _CPPUHELPER_TYPEPROVIDER_HXX_
#include <cppuhelper/typeprovider.hxx>
#endif
#ifndef _COMPHELPER_SEQUENCE_HXX_
#include <comphelper/sequence.hxx>
#endif
#ifndef CONNECTIVITY_CONNECTION_HXX
#include "TConnection.hxx"
#endif
#ifndef _COMPHELPER_TYPES_HXX_
#include <comphelper/types.hxx>
#endif

using namespace ::comphelper;
using namespace connectivity;
using namespace ::cppu;
//------------------------------------------------------------------------------
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
//	using namespace ::com::sun::star::sdbcx;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::lang;

//------------------------------------------------------------------------------
//**************************************************************
//************ Class: java.sql.Statement
//**************************************************************

jclass java_sql_Statement_Base::theClass = 0;

// -------------------------------------------------------------------------
java_sql_Statement_Base::java_sql_Statement_Base( JNIEnv * pEnv, jobject myObj,java_sql_Connection* _pCon )
	:java_sql_Statement_BASE(m_aMutex)
	,java_lang_Object( pEnv, myObj )
	,OPropertySetHelper(java_sql_Statement_BASE::rBHelper)
	,m_pConnection(_pCon)
	,rBHelper(java_sql_Statement_BASE::rBHelper)
{
	OSL_ENSURE(m_pConnection, "java_sql_Statement_Base::java_sql_Statement_Base: invalid connection!");
	if (m_pConnection)
		m_pConnection->acquire();
}

//------------------------------------------------------------------------------
java_sql_Statement_Base::~java_sql_Statement_Base()
{
}

//------------------------------------------------------------------------------
void OStatement_BASE2::disposing()
{
	::osl::MutexGuard aGuard(m_aMutex);

	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
	if( t.pEnv ){

		// temporaere Variable initialisieren
		char * cSignature = "()V";
		char * cMethodName = "close";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID);
			ThrowSQLException(t.pEnv,*(::cppu::OWeakObject*)this);
		} //mID
	} //t.pEnv

	if (m_pConnection)
		m_pConnection->release();
	m_pConnection = NULL;

	dispose_ChildImpl();
}
// -------------------------------------------------------------------------
jclass java_sql_Statement_Base::getMyClass()
{
	// die Klasse muss nur einmal geholt werden, daher statisch
	if( !theClass ){
		SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
		if( !t.pEnv ) return (jclass)0;
		jclass tempClass = t.pEnv->FindClass("java/sql/Statement"); OSL_ENSURE(tempClass,"Java : FindClass nicht erfolgreich!");
		jclass globClass = (jclass)t.pEnv->NewGlobalRef( tempClass );
		t.pEnv->DeleteLocalRef( tempClass );
		saveClassRef( globClass );
	}
	return theClass;
}
// -----------------------------------------------------------------------------
void SAL_CALL java_sql_Statement_Base::disposing(void)
{
	java_sql_Statement_BASE::disposing();
}
// -------------------------------------------------------------------------

void java_sql_Statement_Base::saveClassRef( jclass pClass )
{
	if( SDBThreadAttach::IsJavaErrorOccured() || pClass==0  )
		return;
	// der uebergebe Klassen-Handle ist schon global, daher einfach speichern
	theClass = pClass;
}
//-----------------------------------------------------------------------------
void SAL_CALL OStatement_BASE2::release() throw()
{
	relase_ChildImpl();
}

// -------------------------------------------------------------------------
Any SAL_CALL java_sql_Statement_Base::queryInterface( const Type & rType ) throw(RuntimeException)
{
	Any aRet = java_sql_Statement_BASE::queryInterface(rType);
	return aRet.hasValue() ? aRet : OPropertySetHelper::queryInterface(rType);
}
// -------------------------------------------------------------------------
Sequence< Type > SAL_CALL java_sql_Statement_Base::getTypes(  ) throw(RuntimeException)
{
	::cppu::OTypeCollection aTypes(	::getCppuType( (const Reference< ::com::sun::star::beans::XMultiPropertySet > *)0 ),
												::getCppuType( (const Reference< ::com::sun::star::beans::XFastPropertySet > *)0 ),
												::getCppuType( (const Reference< ::com::sun::star::beans::XPropertySet > *)0 ));

	return ::comphelper::concatSequences(aTypes.getTypes(),java_sql_Statement_BASE::getTypes());
}

// -------------------------------------------------------------------------

void SAL_CALL java_sql_Statement_Base::cancel(  ) throw(RuntimeException)
{
	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
	if( t.pEnv ){

		// temporaere Variable initialisieren
		char * cSignature = "()V";
		char * cMethodName = "cancel";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID);
			ThrowSQLException(t.pEnv,*(::cppu::OWeakObject*)this);
		} //mID
	} //t.pEnv
}
// -------------------------------------------------------------------------

void SAL_CALL java_sql_Statement_Base::close(  ) throw(::com::sun::star::sdbc::SQLException, RuntimeException)
{
	{
		::osl::MutexGuard aGuard( m_aMutex );
		if (java_sql_Statement_BASE::rBHelper.bDisposed)
			throw DisposedException();
	}
	dispose();
}
// -------------------------------------------------------------------------

void SAL_CALL java_sql_Statement::clearBatch(  ) throw(::com::sun::star::sdbc::SQLException, RuntimeException)
{
	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
	if( t.pEnv ){

		// temporaere Variable initialisieren
		char * cSignature = "()V";
		char * cMethodName = "clearBatch";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID);
			ThrowSQLException(t.pEnv,*(::cppu::OWeakObject*)this);
		} //mID
	} //t.pEnv
}
// -------------------------------------------------------------------------

sal_Bool SAL_CALL java_sql_Statement_Base::execute( const ::rtl::OUString& sql ) throw(SQLException, RuntimeException)
{
	jboolean out(sal_False);
	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		char * cSignature = "(Ljava/lang/String;)Z";
		char * cMethodName = "execute";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			jvalue args[1];
			// Parameter konvertieren
			args[0].l = convertwchar_tToJavaString(t.pEnv,sql);
			out = t.pEnv->CallBooleanMethod( object, mID, args[0].l );
			// und aufraeumen
			t.pEnv->DeleteLocalRef((jstring)args[0].l);
			ThrowSQLException(t.pEnv,*(::cppu::OWeakObject*)this);
		} //mID
	} //t.pEnv
	return out;
}
// -------------------------------------------------------------------------

Reference< XResultSet > SAL_CALL java_sql_Statement_Base::executeQuery( const ::rtl::OUString& sql ) throw(SQLException, RuntimeException)
{
	jobject out(0);
	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		char * cSignature = "(Ljava/lang/String;)Ljava/sql/ResultSet;";
		char * cMethodName = "executeQuery";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			jvalue args[1];
			// Parameter konvertieren
			args[0].l = convertwchar_tToJavaString(t.pEnv,sql);
			out = t.pEnv->CallObjectMethod( object, mID, args[0].l);
			// und aufraeumen
			t.pEnv->DeleteLocalRef((jstring)args[0].l);
			ThrowSQLException(t.pEnv,*(::cppu::OWeakObject*)this);			
		} //mID
	} //t.pEnv
	// ACHTUNG: der Aufrufer wird Eigentuemer des zurueckgelieferten Zeigers !!!
	return out==0 ? 0 : new java_sql_ResultSet( t.pEnv, out,this );
}
// -------------------------------------------------------------------------
Reference< XConnection > SAL_CALL java_sql_Statement_Base::getConnection(  ) throw(SQLException, RuntimeException)
{
	return (Reference< XConnection >)m_pConnection;
}
// -------------------------------------------------------------------------

Any SAL_CALL java_sql_Statement::queryInterface( const Type & rType ) throw(RuntimeException)
{
	Any aRet = ::cppu::queryInterface(rType,static_cast< XBatchExecution*> (this));
	return aRet.hasValue() ? aRet : java_sql_Statement_Base::queryInterface(rType);
}
// -------------------------------------------------------------------------

void SAL_CALL java_sql_Statement::addBatch( const ::rtl::OUString& sql ) throw(::com::sun::star::sdbc::SQLException, RuntimeException)
{
	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
	if( t.pEnv ){
		
		// temporaere Variable initialisieren
		char * cSignature = "(Ljava/lang/String;)I";
		char * cMethodName = "addBatch";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			jvalue args[1];
			// Parameter konvertieren
			args[0].l = convertwchar_tToJavaString(t.pEnv,sql);
			t.pEnv->CallVoidMethod( object, mID, args[0].l );
			// und aufraeumen
			t.pEnv->DeleteLocalRef((jstring)args[0].l);
			ThrowSQLException(t.pEnv,*this);			
		} //mID
	} //t.pEnv
}
// -------------------------------------------------------------------------

Sequence< sal_Int32 > SAL_CALL java_sql_Statement::executeBatch(  ) throw(::com::sun::star::sdbc::SQLException, RuntimeException)
{
	Sequence< sal_Int32 > aSeq;
	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		char * cSignature = "()[I";
		char * cMethodName = "executeBatch";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			jintArray out = (jintArray)t.pEnv->CallObjectMethod( object, mID );
			ThrowSQLException(t.pEnv,*this);
			if (out)
			{
				jboolean p = sal_False;
				aSeq.realloc(t.pEnv->GetArrayLength(out));
				memcpy(aSeq.getArray(),t.pEnv->GetIntArrayElements(out,&p),aSeq.getLength());
				t.pEnv->DeleteLocalRef(out);
			}
		} //mID
	} //t.pEnv
	return aSeq;
}
// -------------------------------------------------------------------------


sal_Int32 SAL_CALL java_sql_Statement_Base::executeUpdate( const ::rtl::OUString& sql ) throw(SQLException, RuntimeException)
{
	jint out(0);
	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
	if( t.pEnv ){
		
		// temporaere Variable initialisieren
		char * cSignature = "(Ljava/lang/String;)I";
		char * cMethodName = "executeUpdate";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			jvalue args[1];
			// Parameter konvertieren
			args[0].l = convertwchar_tToJavaString(t.pEnv,sql);
			out = t.pEnv->CallIntMethod( object, mID, args[0].l );
			// und aufraeumen
			t.pEnv->DeleteLocalRef((jstring)args[0].l);
			ThrowSQLException(t.pEnv,*(::cppu::OWeakObject*)this);			
		} //mID
	} //t.pEnv
	return (sal_Int32)out;
}
// -------------------------------------------------------------------------

Reference< ::com::sun::star::sdbc::XResultSet > SAL_CALL java_sql_Statement_Base::getResultSet(  ) throw(::com::sun::star::sdbc::SQLException, RuntimeException)
{
	jobject out(0);
	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
	if( t.pEnv ){

		// temporaere Variable initialisieren
		char * cSignature = "()Ljava/sql/ResultSet;";
		char * cMethodName = "getResultSet";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallObjectMethod( object, mID);
			ThrowSQLException(t.pEnv,*(::cppu::OWeakObject*)this);
		} //mID
	} //t.pEnv
	// ACHTUNG: der Aufrufer wird Eigentuemer des zurueckgelieferten Zeigers !!!
	return out==0 ? 0 : new java_sql_ResultSet( t.pEnv, out,this );
}
// -------------------------------------------------------------------------

sal_Int32 SAL_CALL java_sql_Statement_Base::getUpdateCount(  ) throw(::com::sun::star::sdbc::SQLException, RuntimeException)
{
	jint out(0);
	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
	if( t.pEnv ){

		// temporaere Variable initialisieren
		char * cSignature = "()I";
		char * cMethodName = "getUpdateCount";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallIntMethod( object, mID);
			ThrowSQLException(t.pEnv,*(::cppu::OWeakObject*)this);
		} //mID
	} //t.pEnv
	return (sal_Int32)out;
}
// -------------------------------------------------------------------------

sal_Bool SAL_CALL java_sql_Statement_Base::getMoreResults(  ) throw(::com::sun::star::sdbc::SQLException, RuntimeException)
{
	jboolean out(sal_False);
	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		char * cSignature = "()Z";
		char * cMethodName = "getMoreResults";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallBooleanMethod( object, mID );
			ThrowSQLException(t.pEnv,*(::cppu::OWeakObject*)this);
		} //mID
	} //t.pEnv
	return out;
}
// -------------------------------------------------------------------------

// -------------------------------------------------------------------------
Any SAL_CALL java_sql_Statement_Base::getWarnings(  ) throw(::com::sun::star::sdbc::SQLException, RuntimeException)
{
	jobject out(NULL);
	SDBThreadAttach t;
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		char * cSignature = "()Ljava/sql/SQLWarning;";
		char * cMethodName = "getWarnings";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = 			t.pEnv->CallObjectMethod( object, mID);
			ThrowSQLException(t.pEnv,*(::cppu::OWeakObject*)this);
		} //mID
	} //t.pEnv
	// ACHTUNG: der Aufrufer wird Eigentuemer des zurueckgelieferten Zeigers !!!
	return out ? makeAny(java_sql_SQLWarning(java_sql_SQLWarning_BASE( t.pEnv, out ),*(::cppu::OWeakObject*)this)) : Any();
}
// -------------------------------------------------------------------------
void SAL_CALL java_sql_Statement_Base::clearWarnings(  ) throw(::com::sun::star::sdbc::SQLException, RuntimeException)
{
	SDBThreadAttach t;
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		char * cSignature = "()V";
		char * cMethodName = "clearWarnings";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID);
			ThrowSQLException(t.pEnv,*(::cppu::OWeakObject*)this);
		}
	}
}
//------------------------------------------------------------------------------
sal_Int32 java_sql_Statement_Base::getQueryTimeOut() const  throw(SQLException, RuntimeException)
{
	jint out(0);
	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		char * cSignature = "()I";
		char * cMethodName = "getQueryTimeOut";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallIntMethod( object, mID);
			if(t.pEnv->ExceptionOccurred())
				t.pEnv->ExceptionClear();
		} //mID
	} //t.pEnv
	return (sal_Int32)out;
}
//------------------------------------------------------------------------------
sal_Int32 java_sql_Statement_Base::getMaxRows() const throw(SQLException, RuntimeException)
{
	jint out(0);
	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		char * cSignature = "()I";
		char * cMethodName = "getMaxRows";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallIntMethod( object, mID);
			if(t.pEnv->ExceptionOccurred())
				t.pEnv->ExceptionClear();
		} //mID
	} //t.pEnv
	return (sal_Int32)out;
}
//------------------------------------------------------------------------------
sal_Int32 java_sql_Statement_Base::getResultSetConcurrency() const throw(SQLException, RuntimeException)
{
	jint out(0);
	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		char * cSignature = "()I";
		char * cMethodName = "getResultSetConcurrency";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallIntMethod( object, mID);
			if(t.pEnv->ExceptionOccurred())
				t.pEnv->ExceptionClear();
		} //mID
	} //t.pEnv
	return (sal_Int32)out;
}
//------------------------------------------------------------------------------
sal_Int32 java_sql_Statement_Base::getResultSetType() const throw(SQLException, RuntimeException)
{
	jint out(0);
	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		char * cSignature = "()I";
		char * cMethodName = "getResultSetType";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallIntMethod( object, mID);
			if(t.pEnv->ExceptionOccurred())
				t.pEnv->ExceptionClear();
		} //mID
	} //t.pEnv
	return (sal_Int32)out;
}
//------------------------------------------------------------------------------
sal_Int32 java_sql_Statement_Base::getFetchDirection() const throw(SQLException, RuntimeException)
{
	jint out(0);
	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		char * cSignature = "()I";
		char * cMethodName = "getFetchDirection";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallIntMethod( object, mID);
			if(t.pEnv->ExceptionOccurred())
				t.pEnv->ExceptionClear();
		} //mID
	} //t.pEnv
	return (sal_Int32)out;
}
//------------------------------------------------------------------------------
sal_Int32 java_sql_Statement_Base::getFetchSize() const throw(SQLException, RuntimeException)
{
	jint out(0);
	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		char * cSignature = "()I";
		char * cMethodName = "getFetchSize";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallIntMethod( object, mID);
			if(t.pEnv->ExceptionOccurred())
				t.pEnv->ExceptionClear();
		} //mID
	} //t.pEnv
	return (sal_Int32)out;
}
//------------------------------------------------------------------------------
sal_Int32 java_sql_Statement_Base::getMaxFieldSize() const throw(SQLException, RuntimeException)
{
	jint out(0);
	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		char * cSignature = "()I";
		char * cMethodName = "getMaxFieldSize";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallIntMethod( object, mID);
			if(t.pEnv->ExceptionOccurred())
				t.pEnv->ExceptionClear();
		} //mID
	} //t.pEnv
	return (sal_Int32)out;
}
//------------------------------------------------------------------------------
::rtl::OUString java_sql_Statement_Base::getCursorName() const throw(SQLException, RuntimeException)
{
	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
	::rtl::OUString aStr;
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		char * cSignature = "()Ljava/lang/String;";
		char * cMethodName = "getCursorName";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			jstring out = (jstring)t.pEnv->CallObjectMethod( object, mID);
			if(t.pEnv->ExceptionOccurred())
				t.pEnv->ExceptionClear();
			if(out)
				aStr = JavaString2String(t.pEnv,out);
		} //mID
	} //t.pEnv
	// ACHTUNG: der Aufrufer wird Eigentuemer des zurueckgelieferten Zeigers !!!
	return aStr;
}
//------------------------------------------------------------------------------
void java_sql_Statement_Base::setQueryTimeOut(sal_Int32 _par0) throw(SQLException, RuntimeException)
{
	jint out(0);
	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		char * cSignature = "(I)V";
		char * cMethodName = "setQueryTimeOut";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID )
		{
			t.pEnv->CallVoidMethod( object, mID,_par0);
			if(t.pEnv->ExceptionOccurred())
				t.pEnv->ExceptionClear();
		} //mID
	} //t.pEnv
}

//------------------------------------------------------------------------------
void java_sql_Statement_Base::setMaxRows(sal_Int32 _par0) throw(SQLException, RuntimeException)
{
	jint out(0);
	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		char * cSignature = "(I)V";
		char * cMethodName = "setMaxRows";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID,_par0);
			if(t.pEnv->ExceptionOccurred())
				t.pEnv->ExceptionClear();
		} //mID
	} //t.pEnv
}
//------------------------------------------------------------------------------
void java_sql_Statement_Base::setResultSetConcurrency(sal_Int32 _par0) throw(SQLException, RuntimeException)
{
	// not avaiblable in jdbc
//	jint out(0);
//	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
//	if( t.pEnv ){
//		// temporaere Variable initialisieren
//		char * cSignature = "(I)V";
//		char * cMethodName = "setResultSetConcurrency";
//		// Java-Call absetzen
//		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
//		if( mID ){
//			t.pEnv->CallVoidMethod( object, mID,_par0);
//			// special case here most JDBC 1.x doesn't support this feature so we just clear the exception when they occured
//			if(t.pEnv->ExceptionOccurred())
//				t.pEnv->ExceptionClear();
//		} //mID
//	} //t.pEnv
}
//------------------------------------------------------------------------------
void java_sql_Statement_Base::setResultSetType(sal_Int32 _par0) throw(SQLException, RuntimeException)
{
	// not avaiblable in jdbc
//	jint out(0);
//	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
//	if( t.pEnv ){
//		// temporaere Variable initialisieren
//		char * cSignature = "(I)V";
//		char * cMethodName = "setResultSetType";
//		// Java-Call absetzen
//		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
//		if( mID ){
//			t.pEnv->CallVoidMethod( object, mID,_par0);
//			// special case here most JDBC 1.x doesn't support this feature so we just clear the exception when they occured
//			if(t.pEnv->ExceptionOccurred())
//				t.pEnv->ExceptionClear();
//		} //mID
//		else if(t.pEnv->ExceptionOccurred())
//			t.pEnv->ExceptionClear();
//	} //t.pEnv

}
//------------------------------------------------------------------------------
void java_sql_Statement_Base::setFetchDirection(sal_Int32 _par0) throw(SQLException, RuntimeException)
{
	jint out(0);
	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		char * cSignature = "(I)V";
		char * cMethodName = "setFetchDirection";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID,_par0);
			if(t.pEnv->ExceptionOccurred())
				t.pEnv->ExceptionClear();
		} //mID
	} //t.pEnv

}
//------------------------------------------------------------------------------
void java_sql_Statement_Base::setFetchSize(sal_Int32 _par0) throw(SQLException, RuntimeException)
{
	jint out(0);
	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		char * cSignature = "(I)V";
		char * cMethodName = "setFetchSize";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID,_par0);
			if(t.pEnv->ExceptionOccurred())
				t.pEnv->ExceptionClear();
		} //mID
	} //t.pEnv

}
//------------------------------------------------------------------------------
void java_sql_Statement_Base::setMaxFieldSize(sal_Int32 _par0) throw(SQLException, RuntimeException)
{
	jint out(0);
	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		char * cSignature = "(I)V";
		char * cMethodName = "setMaxFieldSize";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID,_par0);
			if(t.pEnv->ExceptionOccurred())
				t.pEnv->ExceptionClear();
		} //mID
	} //t.pEnv

}
//------------------------------------------------------------------------------
void java_sql_Statement_Base::setCursorName(const ::rtl::OUString &_par0) throw(SQLException, RuntimeException)
{
	jint out(0);
	SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		char * cSignature = "(Ljava/lang/String;)V";
		char * cMethodName = "setCursorName";
		// Java-Call absetzen
		jmethodID mID = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			jvalue args[1];
			// Parameter konvertieren
			args[0].l = convertwchar_tToJavaString(t.pEnv,_par0);
			t.pEnv->CallVoidMethod( object, mID,args[0].l);
			if(t.pEnv->ExceptionOccurred())
				t.pEnv->ExceptionClear();
			t.pEnv->DeleteLocalRef((jstring)args[0].l);
			if(t.pEnv->ExceptionOccurred())
				t.pEnv->ExceptionClear();
		} //mID
	} //t.pEnv

}

// -------------------------------------------------------------------------
::cppu::IPropertyArrayHelper* java_sql_Statement_Base::createArrayHelper( ) const
{
	Sequence< Property > aProps(10);
	Property* pProperties = aProps.getArray();
	sal_Int32 nPos = 0;
	DECL_PROP0(CURSORNAME,	::rtl::OUString);
	DECL_BOOL_PROP0(ESCAPEPROCESSING);
	DECL_PROP0(FETCHDIRECTION,sal_Int32);
	DECL_PROP0(FETCHSIZE,	sal_Int32);
	DECL_PROP0(MAXFIELDSIZE,sal_Int32);
	DECL_PROP0(MAXROWS,		sal_Int32);
	DECL_PROP0(QUERYTIMEOUT,sal_Int32);
	DECL_PROP0(RESULTSETCONCURRENCY,sal_Int32);
	DECL_PROP0(RESULTSETTYPE,sal_Int32);
	DECL_BOOL_PROP0(USEBOOKMARKS);

	return new ::cppu::OPropertyArrayHelper(aProps);
}

// -------------------------------------------------------------------------
::cppu::IPropertyArrayHelper & java_sql_Statement_Base::getInfoHelper()

{
	return *const_cast<java_sql_Statement_Base*>(this)->getArrayHelper();
}
// -------------------------------------------------------------------------
sal_Bool java_sql_Statement_Base::convertFastPropertyValue(
							Any & rConvertedValue,
							Any & rOldValue,
							sal_Int32 nHandle,
							const Any& rValue )
								throw (::com::sun::star::lang::IllegalArgumentException)
{
	switch(nHandle)
	{
		case PROPERTY_ID_QUERYTIMEOUT:
			return ::comphelper::tryPropertyValue(rConvertedValue, rOldValue, rValue, getQueryTimeOut());
		case PROPERTY_ID_MAXFIELDSIZE:
			return ::comphelper::tryPropertyValue(rConvertedValue, rOldValue, rValue, getMaxFieldSize());
		case PROPERTY_ID_MAXROWS:
			return ::comphelper::tryPropertyValue(rConvertedValue, rOldValue, rValue, getMaxRows());
		case PROPERTY_ID_CURSORNAME:
			return ::comphelper::tryPropertyValue(rConvertedValue, rOldValue, rValue, getCursorName());
		case PROPERTY_ID_RESULTSETCONCURRENCY:
			return ::comphelper::tryPropertyValue(rConvertedValue, rOldValue, rValue, getResultSetConcurrency());
		case PROPERTY_ID_RESULTSETTYPE:
			return ::comphelper::tryPropertyValue(rConvertedValue, rOldValue, rValue, getResultSetType());
		case PROPERTY_ID_FETCHDIRECTION:
			return ::comphelper::tryPropertyValue(rConvertedValue, rOldValue, rValue, getFetchDirection());
		case PROPERTY_ID_FETCHSIZE:
			return ::comphelper::tryPropertyValue(rConvertedValue, rOldValue, rValue, getFetchSize());
		case PROPERTY_ID_ESCAPEPROCESSING:
			//	return ::comphelper::tryPropertyValue(rConvertedValue, rOldValue, rValue, m_bAsLink);
		case PROPERTY_ID_USEBOOKMARKS:
			//	return ::comphelper::tryPropertyValue(rConvertedValue, rOldValue, rValue, m_bAsLink);
		default:
			;
	}
	return sal_False;
}
// -------------------------------------------------------------------------
void java_sql_Statement_Base::setFastPropertyValue_NoBroadcast(
								sal_Int32 nHandle,
								const Any& rValue
												 )
												 throw (Exception)
{
	switch(nHandle)
	{
		case PROPERTY_ID_QUERYTIMEOUT:
			setQueryTimeOut(comphelper::getINT32(rValue));
			break;
		case PROPERTY_ID_MAXFIELDSIZE:
			setMaxFieldSize(comphelper::getINT32(rValue));
			break;
		case PROPERTY_ID_MAXROWS:
			setMaxRows(comphelper::getINT32(rValue));
			break;
		case PROPERTY_ID_CURSORNAME:
			setCursorName(comphelper::getString(rValue));
			break;
		case PROPERTY_ID_RESULTSETCONCURRENCY:
			setResultSetConcurrency(comphelper::getINT32(rValue));
			break;
		case PROPERTY_ID_RESULTSETTYPE:
			setResultSetType(comphelper::getINT32(rValue));
			break;
		case PROPERTY_ID_FETCHDIRECTION:
			setFetchDirection(comphelper::getINT32(rValue));
			break;
		case PROPERTY_ID_FETCHSIZE:
			setFetchSize(comphelper::getINT32(rValue));
			break;
		case PROPERTY_ID_ESCAPEPROCESSING:
			//	return ::comphelper::tryPropertyValue(rConvertedValue, rOldValue, rValue, m_bAsLink);
		case PROPERTY_ID_USEBOOKMARKS:
			//	return ::comphelper::tryPropertyValue(rConvertedValue, rOldValue, rValue, m_bAsLink);
		default:
			;
	}
}
// -------------------------------------------------------------------------
void java_sql_Statement_Base::getFastPropertyValue(
								Any& rValue,
								sal_Int32 nHandle
									 ) const
{
	switch(nHandle)
	{
		case PROPERTY_ID_QUERYTIMEOUT:
			rValue <<= getQueryTimeOut();
			break;
		case PROPERTY_ID_MAXFIELDSIZE:
			rValue <<= getMaxFieldSize();
			break;
		case PROPERTY_ID_MAXROWS:
			rValue <<= getMaxRows();
			break;
		case PROPERTY_ID_CURSORNAME:
			rValue <<= getCursorName();
			break;
		case PROPERTY_ID_RESULTSETCONCURRENCY:
			rValue <<= getResultSetConcurrency();
			break;
		case PROPERTY_ID_RESULTSETTYPE:
			rValue <<= getResultSetType();
			break;
		case PROPERTY_ID_FETCHDIRECTION:
			rValue <<= getFetchDirection();
			break;
		case PROPERTY_ID_FETCHSIZE:
			rValue <<= getFetchSize();
			break;
		case PROPERTY_ID_ESCAPEPROCESSING:
		case PROPERTY_ID_USEBOOKMARKS:
		default:
			;
	}
}
// -------------------------------------------------------------------------
jclass java_sql_Statement::theClass = 0;

java_sql_Statement::~java_sql_Statement()
{}

jclass java_sql_Statement::getMyClass()
{
	// die Klasse muss nur einmal geholt werden, daher statisch
	if( !theClass ){
		SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment gelscht worden!");
		if( !t.pEnv ) return (jclass)0;
		jclass tempClass = t.pEnv->FindClass("java/sql/Statement"); OSL_ENSURE(tempClass,"Java : FindClass nicht erfolgreich!");
		jclass globClass = (jclass)t.pEnv->NewGlobalRef( tempClass );
		t.pEnv->DeleteLocalRef( tempClass );
		saveClassRef( globClass );
	}
	return theClass;
}

void java_sql_Statement::saveClassRef( jclass pClass )
{
	if( SDBThreadAttach::IsJavaErrorOccured() || pClass==0  )
		return;
	// der uebergebe Klassen-Handle ist schon global, daher einfach speichern
	theClass = pClass;
}

IMPLEMENT_SERVICE_INFO(java_sql_Statement,"com.sun.star.sdbcx.JStatement","com.sun.star.sdbc.Statement");
// -----------------------------------------------------------------------------
void SAL_CALL java_sql_Statement_Base::acquire() throw()
{
	java_sql_Statement_BASE::acquire();
}
// -----------------------------------------------------------------------------
void SAL_CALL java_sql_Statement_Base::release() throw()
{
	java_sql_Statement_BASE::release();
}
// -----------------------------------------------------------------------------
void SAL_CALL java_sql_Statement::acquire() throw()
{
	OStatement_BASE2::acquire();
}
// -----------------------------------------------------------------------------
void SAL_CALL java_sql_Statement::release() throw()
{
	OStatement_BASE2::release();
}
// -----------------------------------------------------------------------------
::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySetInfo > SAL_CALL java_sql_Statement_Base::getPropertySetInfo(  ) throw(::com::sun::star::uno::RuntimeException)
{
	return ::cppu::OPropertySetHelper::createPropertySetInfo(getInfoHelper());
}
// -----------------------------------------------------------------------------


