/*************************************************************************
 *
 *  $RCSfile: lookupcontext.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: jb $ $Date: 2001/09/28 12:44:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CONFIGMGR_LOOKUPCONTEXT_HXX_
#define CONFIGMGR_LOOKUPCONTEXT_HXX_

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef CONFIGMGR_CONFIGPATH_HXX_
#include <configpath.hxx>
#endif

namespace configmgr
{	
	namespace Lookup
	{
		static const sal_uInt32	DEFAULT			=	0x00000001;	// access the shared path
		static const sal_uInt32	USER			=	0x00000002; // access the user path, necessary if merging is required	
		static const sal_uInt32	CACHE			=	0x00000004; // read binary data instead of xml data if possible
		static const sal_uInt32	TEMPLATE		=	0x00000008; // read template data
		static const sal_uInt32	UPDATE_CACHE	=	0x00000010; // update binary data, if outdated or not available
		
		static const sal_uInt32	ADMIN_MODE		=	(DEFAULT | CACHE | UPDATE_CACHE);
		static const sal_uInt32	SETUP_MODE		=	(DEFAULT);	// read and write only into the default layer
		static const sal_uInt32	USER_MODE		=	(CACHE | DEFAULT | USER | UPDATE_CACHE); // read and merge data of both layers, prefer binary data
		static const sal_uInt32	TEMPLATE_MODE	=	(DEFAULT | TEMPLATE); // read templates from the default layer, only available as XML

        static const sal_uInt32	DEFAULT_MASK	=	(DEFAULT | TEMPLATE | CACHE | UPDATE_CACHE);
	}

	//==========================================================================
	//= OLookupContext
	//==========================================================================		
	class OLookupContext
	{
		rtl::OUString				m_sDefaultURL;				 // base path for data containing default data 
		rtl::OUString				m_sUserURL;					 // base path for data containing updates 
		configuration::AbsolutePath	m_aNodePath;				 // node path to look up 		
		const sal_uInt32			m_nAccessFlags;		

		OLookupContext(OLookupContext const&);
		OLookupContext& operator=(OLookupContext const&);		

	public:		
		/// extension for xml files
		static const rtl::OUString& xmlExt();
		
		/// extension for binary files
		static const rtl::OUString& cacheExt();

		/// category name for cache files
		static const rtl::OUString& cacheCategory();

		/// category name for temporary files
		static const rtl::OUString& templateCategory();

		/// category name for instance files 
		static const rtl::OUString& instanceCategory();

		OLookupContext(rtl::OUString const& _sDefaultURL,
					   rtl::OUString const& _sUserURL, 
					   configuration::AbsolutePath const& _rNodePath,
					   sal_uInt32 _nAccessFlags)
					   :m_sDefaultURL(_sDefaultURL)
					   ,m_sUserURL(_sUserURL)
					   ,m_aNodePath(_rNodePath)
					   ,m_nAccessFlags(_nAccessFlags){}

		/// access to the node path
		configuration::AbsolutePath const& getNodePath() const {return m_aNodePath;}

		/// retrieve the flags for the lookup
		sal_uInt32 getAccessFlags() const {return m_nAccessFlags;}

		/** composes a file URL depending on the accessMode provided.
		    Allowed modes are (DEFAULT, USER, CACHE, TEMPLATE).
		*/
		rtl::OUString composeFileURL(sal_Int32 _nAccessMode) const;		
	}; // OLookupContext

} // configmgr

#endif // CONFIGMGR_LOOKUPCONTEXT_HXX_
