/*************************************************************************
 *
 *  $RCSfile: lookupcontext.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: dg $ $Date: 2001/09/18 19:15:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "lookupcontext.hxx"

#ifndef _CONFIGMGR_FILEHELPER_HXX_
#include "filehelper.hxx"
#endif
#ifndef CONFIGMGR_NAMEHELPER_HXX
#include "namehelper.hxx"
#endif
#ifndef _CONFIGMGR_TRACER_HXX_
#include "tracer.hxx"
#endif
#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#ifndef _COM_SUN_STAR_IO_IOEXCEPTION_HPP_
#include <com/sun/star/io/IOException.hpp>
#endif

#ifndef INCLUDED_SET
#include <set>
#define INCLUDED_SET
#endif

#define ASCII(x) rtl::OUString::createFromAscii(x)

namespace configmgr
{
	namespace css = com::sun::star;
	namespace io = css::io;
    using rtl::OUString;

	//==========================================================================
	//= OLookupContext
	//==========================================================================	
	
	// -----------------------------------------------------------------------------
	const rtl::OUString& OLookupContext::xmlExt()
	{
		static const OUString ssXMLExt(ASCII(".xml"));
		return ssXMLExt;
	}

	// -----------------------------------------------------------------------------
	const rtl::OUString& OLookupContext::cacheExt()
	{
		static const OUString ssCacheExt(ASCII(".dat"));
		return ssCacheExt;
	}

	// -----------------------------------------------------------------------------
	const OUString& OLookupContext::cacheCategory()
	{
		static const OUString ssCacheDirName(ASCII("cache"));
		return ssCacheDirName;
	}

	// -----------------------------------------------------------------------------
	const OUString& OLookupContext::templateCategory()
	{
		static const OUString ssTemplateDirName(ASCII("template"));
		return ssTemplateDirName;
	}

	// -----------------------------------------------------------------------------
	const OUString& OLookupContext::instanceCategory()
	{
		static const OUString ssInstanceDirName(ASCII("instance"));
		return ssInstanceDirName;
	}

	// -----------------------------------------------------------------------------
	rtl::OUString OLookupContext::composeFileURL(sal_Int32 _nAccessMode) const
	{
		rtl::OUString sURL;
		rtl::OUString sModule(m_aNodePath.getModuleName().toString().replace(sal_Unicode('.'), FileHelper::delimiter));
		switch (_nAccessMode)
		{
			case Lookup::DEFAULT:
				{
					sURL = m_sDefaultURL + FileHelper::delimiterAsString() 
						   + instanceCategory() + FileHelper::delimiterAsString() 
						   + sModule + xmlExt();
				} break;
			case Lookup::USER:
				{
					sURL = m_sUserURL + FileHelper::delimiterAsString() 
						   + instanceCategory() + FileHelper::delimiterAsString() 
						   + sModule + xmlExt();
				} break;
			case Lookup::CACHE:
				{
					sURL = m_sDefaultURL + FileHelper::delimiterAsString() + cacheCategory() + FileHelper::delimiterAsString()
						   + instanceCategory() + FileHelper::delimiterAsString() 
						   + sModule + cacheExt();

				} break;
			case Lookup::TEMPLATE:
				{
					sURL = m_sDefaultURL + FileHelper::delimiterAsString() 
						   + templateCategory() + FileHelper::delimiterAsString() 
						   + sModule + xmlExt();

				} break;
			default:
				OSL_ENSURE(0, "Invalid access flag");
		}
		return sURL;
	}
}
