/*************************************************************************
 *
 *  $RCSfile: localizednodebuilder.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: jb $ $Date: 2001/12/07 10:43:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "localizednodebuilder.hxx"

#ifndef CONFIGMGR_ATTRIBUTEPARSER_HXX
#include "attributeparser.hxx"
#endif
#ifndef _CONFIGMGR_STRDECL_HXX_
#include "strdecl.hxx"
#endif
#ifndef CONFIGMGR_TREE_NODEFACTORY_HXX
#include "treenodefactory.hxx"
#endif
#ifndef CONFIGMGR_TYPECONVERTER_HXX
#include "typeconverter.hxx"
#endif

namespace configmgr
{
	namespace uno		= ::com::sun::star::uno;
	namespace sax		= ::com::sun::star::xml::sax;
	namespace lang		= ::com::sun::star::lang;

// -----------------------------------------------------------------------------

AbstractLocalizedNodeBuilder::AbstractLocalizedNodeBuilder(ParserContext& rContext)
: AbstractValueNodeBuilder(rContext)
{
}
// -----------------------------------------------------------------------------

AbstractLocalizedNodeBuilder::AbstractLocalizedNodeBuilder(vos::ORef< AbstractValueNodeBuilder > const& rValueBuilder)
: AbstractValueNodeBuilder(rValueBuilder->getParserContext())
, m_xValueBuilder(rValueBuilder)
{
}
// -----------------------------------------------------------------------------

bool AbstractLocalizedNodeBuilder::isInValue() const
{
	bool bInValue = m_xValueBuilder->isInContent();

	OSL_ASSERT(!m_xActiveHandler.is() == !bInValue);
	OSL_ASSERT(!bInValue || this->isInContent() );

	return bInValue;
}
// -----------------------------------------------------------------------------

void SAL_CALL AbstractLocalizedNodeBuilder::startElement(
		const rtl::OUString& aName,
		const uno::Reference< sax::XAttributeList > &xAttribs
	)
	throw(sax::SAXException, uno::RuntimeException)
{
	if (this->isInValue())
	{
		OSL_ENSURE(false, "Unexpected subelement for value");
	}

	else if (this->isInContent())
	{
		OSL_ENSURE(aName.equals(TAG_VALUE), "LocalizedNodeBuilder: Warning: Unexpected subelement tag");

		OUString aLocale = getAttributeHandler().getLocale(xAttribs);
		OUString sNodeName = this->getNodeName();

		if (acceptLocale( aLocale, sNodeName))
		{
			ValueInfo aInfo = this->getValueInfo();
			getAttributeHandler().getValueInfo(xAttribs, aInfo);
            // The single-locale subelement is not considered localized again
            aInfo.aAttributes.bLocalized = false; 
            // The single-locale subelement is considered replaced for the user (unless we are in defaults)
            if (aInfo.aAttributes.state() == node::isMerged)
                aInfo.aAttributes.setState(node::isReplaced); 

			m_xValueBuilder->prepareNode();
			m_xValueBuilder->startNode(sNodeName, aInfo);

			m_xActiveHandler = m_xValueBuilder->getSaxHandler();
		}
		else
		{
			m_xActiveHandler.clear();
		}
	}

	else
	{
		AbstractValueNodeBuilder::startElement(aName, xAttribs);
	}

}
// -----------------------------------------------------------------------------

void SAL_CALL AbstractLocalizedNodeBuilder::endElement(const rtl::OUString& aName)
	throw(sax::SAXException, uno::RuntimeException)
{
	if (this->isInValue())
	{
		m_xActiveHandler.clear();

		m_xValueBuilder->endNode();

		std::auto_ptr<INode> pValueNode = m_xValueBuilder->buildNode();

		if (pValueNode.get() != NULL)
			this->valueAvailable(pValueNode);
	}

	else 
	{
		AbstractValueNodeBuilder::endElement(aName);
	}

}
// -----------------------------------------------------------------------------

void SAL_CALL AbstractLocalizedNodeBuilder::characters(const rtl::OUString& aChars)
		throw(sax::SAXException, uno::RuntimeException)
{
	if (this->isInValue())
	{
		if (m_xActiveHandler.is()) m_xActiveHandler->characters(aChars);
	}
	else
	{
		OSL_ENSURE(this->isInContent(), "LocalizedNodeBuilder: Error: Got characters while not processing");
	}
}
// -----------------------------------------------------------------------------

void SAL_CALL AbstractLocalizedNodeBuilder::ignorableWhitespace(const rtl::OUString& aWhitespaces)
		throw(sax::SAXException, uno::RuntimeException)
{
	OSL_ENSURE(aWhitespaces.trim().getLength() == 0, "LocalizedNodeBuilder: Warning: Non-whitespace characters in ignorable whitespace");
	if (this->isInValue())
	{
		if (m_xActiveHandler.is()) m_xActiveHandler->ignorableWhitespace(aWhitespaces);
	}
	else
	{
		OSL_ENSURE(this->isInContent(), "LocalizedNodeBuilder: Error: Got whitespace while not processing");
	}
}
// -----------------------------------------------------------------------------

void AbstractLocalizedNodeBuilder::startedNode()
{
	OSL_ENSURE(m_xValueBuilder.isValid(), "LocalizedNodeBuilder: ValueBuilder not initialized");
	OSL_ENSURE(!isInValue(), "LocalizedNodeBuilder: ValueBuilder still active when starting new scope");

	m_xValueBuilder->prepareNode();
	// ValueBuilder's ValueConverter is updated on each subobject
}
// -----------------------------------------------------------------------------

void AbstractLocalizedNodeBuilder::finishNode()
{
	OSL_ENSURE(!isInValue(), "LocalizedNodeBuilder: ValueBuilder still active when scope is finished");
	m_xActiveHandler.clear();
}
// -----------------------------------------------------------------------------

void AbstractLocalizedNodeBuilder::doPrepare()
{
	m_xActiveHandler.clear();

	if (!m_xValueBuilder.isValid())
		m_xValueBuilder = new SimpleValueNodeBuilder(this->getParserContext());

	AbstractValueNodeBuilder::doPrepare();
	m_xValueBuilder->prepareNode();	
}
// -----------------------------------------------------------------------------
/*
// -----------------------------------------------------------------------------
LocalizedValueNodeBuilder::LocalizedValueNodeBuilder(ParserContext& rContext)
: AbstractLocalizedNodeBuilder(rContext)
{
}

// -----------------------------------------------------------------------------
LocalizedValueNodeBuilder::LocalizedValueNodeBuilder(vos::ORef< AbstractValueNodeBuilder > const& rValueBuilder)
: AbstractLocalizedNodeBuilder(rValueBuilder)
{
}

// -----------------------------------------------------------------------------
bool LocalizedValueNodeBuilder::acceptLocale(OUString const& aLocale, OUString& sNodeName)
{
	OSL_ASSERT(sNodeName == this->getNodeName());

	return m_aLocaleFinder.accept(localehelper::makeLocale(aLocale));
}

// -----------------------------------------------------------------------------
void LocalizedValueNodeBuilder::valueAvailable(std::auto_ptr<INode> aValueNode)
{
	m_pCurrentValue = aValueNode;
}

// -----------------------------------------------------------------------------
		
void LocalizedValueNodeBuilder::setAcceptedLocales(rtl::OUString const & _sLocale)
{
	OSL_ENSURE(!isInContent(), "LocalizedNodeBuilder: Changing locale while parsing - losing locale information");
	m_aLocaleFinder.reset( localehelper::makeLocale(_sLocale) );
}
// -----------------------------------------------------------------------------
		
void LocalizedValueNodeBuilder::setAcceptedLocales(lang::Locale  const & _aLocale)
{
	OSL_ENSURE(!isInContent(), "LocalizedNodeBuilder: Changing locale while parsing - losing locale information");
	m_aLocaleFinder.reset( localehelper::makeLocale(_aLocale) );
}
// -----------------------------------------------------------------------------

void LocalizedValueNodeBuilder::setAcceptedLocales(uno::Sequence< rtl::OUString > const & _aLocales)
{
	OSL_ENSURE(!isInContent(), "LocalizedNodeBuilder: Changing locale while parsing - losing locale information");
	m_aLocaleFinder.reset( localehelper::makeLocaleSequence(_aLocales) );
}
// -----------------------------------------------------------------------------
		
void LocalizedValueNodeBuilder::setAcceptedLocales(uno::Sequence< lang::Locale  > const & _aLocales)
{
	OSL_ENSURE(!isInContent(), "LocalizedNodeBuilder: Changing locale while parsing - losing locale information");
	m_aLocaleFinder.reset( localehelper::makeLocaleSequence(_aLocales) );
}

// -----------------------------------------------------------------------------
void LocalizedValueNodeBuilder::doPrepare()
{
	m_pCurrentValue.reset(); 
	m_aLocaleFinder.reset();
	AbstractLocalizedNodeBuilder::doPrepare();
}

// -----------------------------------------------------------------------------
void LocalizedValueNodeBuilder::startedNode()
{
	m_aLocaleFinder.reset();
	AbstractLocalizedNodeBuilder::startedNode();
}

// -----------------------------------------------------------------------------
void LocalizedValueNodeBuilder::finishNode()
{
	if (m_pCurrentValue.get() == NULL)
	{
		if (!getValueInfo().isNull)
		{
		//No Locale found in non-NULL localized value - treating as null - need this for templates;
			this->getValueConverter().setIsNull();
		}
		m_pCurrentValue = implMakeNullNode(); 
	}
	AbstractLocalizedNodeBuilder::finishNode();
}

// -----------------------------------------------------------------------------
std::auto_ptr<INode> LocalizedValueNodeBuilder::doGetNode()
{
	return m_pCurrentValue;
}
// -----------------------------------------------------------------------------
*/

// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------
LocalizedValueSetBuilder::LocalizedValueSetBuilder(ParserContext& rContext)
: AbstractLocalizedNodeBuilder(rContext)
{
}

// -----------------------------------------------------------------------------
LocalizedValueSetBuilder::LocalizedValueSetBuilder(vos::ORef< AbstractValueNodeBuilder > const& rValueBuilder)
: AbstractLocalizedNodeBuilder(rValueBuilder)
{
}

// -----------------------------------------------------------------------------
bool LocalizedValueSetBuilder::acceptLocale(OUString const& aLocale, OUString& sNodeName)
{
	sNodeName = aLocale;

	if (sNodeName.getLength() == 0)
    {
        OSL_ENSURE(false, "Found localized subvalue without locale");
		return false;
    }

	return true; // accept any locale that has a non-empty name
}

// -----------------------------------------------------------------------------
void LocalizedValueSetBuilder::valueAvailable(std::auto_ptr<INode> aValueNode)
{
	OSL_ASSERT(m_aValueSet.get());

	m_aValueSet->addChild(aValueNode);
}

// -----------------------------------------------------------------------------
void LocalizedValueSetBuilder::doPrepare()
{
	m_aValueSet.reset(); 
	AbstractLocalizedNodeBuilder::doPrepare();
}

// -----------------------------------------------------------------------------
void LocalizedValueSetBuilder::startedNode()
{
	AbstractLocalizedNodeBuilder::startedNode();
	m_aValueSet = implMakeSetNode(); 
}

// -----------------------------------------------------------------------------
std::auto_ptr<INode> LocalizedValueSetBuilder::doGetNode()
{
	return std::auto_ptr<INode>(m_aValueSet.release());
}
// -----------------------------------------------------------------------------
/*	
std::auto_ptr<INode> LocalizedValueNodeBuilder::implMakeNullNode()
{
	return base_ptr( getNodeFactory().createNullValueNode( getNodeName(), 
															getUnoType(), 
															getValueInfo().aAttributes ) );
}
*/
// -----------------------------------------------------------------------------
		
std::auto_ptr<ISubtree> LocalizedValueSetBuilder::implMakeSetNode()
{
	ValueInfo aInfo = this->getValueInfo();
	return getNodeFactory().createSetNode( getNodeName(), 
											toTemplateName(aInfo.sType, aInfo.isList), 
											TEMPLATE_MODULE_LOCALIZED_VALUE, 
											aInfo.aAttributes );
}
// -----------------------------------------------------------------------------
	
} // namespace
