/*************************************************************************
 *
 *  $RCSfile: sessionfactory.cxx,v $
 *
 *  $Revision: 1.24 $
 *
 *  last change: $Author: dg $ $Date: 2001/09/21 14:25:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>
#include "sessionfactory.hxx"

#ifndef _CONFIGMGR_COMMONTYPES_HXX_
#include "commontypes.hxx"
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_RUNTIMEEXCEPTION_HPP_
#include <com/sun/star/uno/RuntimeException.hpp>
#endif
#ifndef _COM_SUN_STAR_CONNECTION_CONNECTIONSETUPEXCEPTION_HPP_
#include <com/sun/star/connection/ConnectionSetupException.hpp>
#endif
#ifndef _OSL_PROFILE_HXX_
#include <osl/profile.hxx>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _RTL_STRING_HXX_
#include <rtl/string.hxx>
#endif
#ifndef _OSL_PROCESS_H_
#include <osl/process.h>
#endif
#ifndef _OSL_MODULE_H_
#include <osl/module.h>
#endif
#ifndef __SGI_STL_MEMORY
#include <memory>
#endif
#ifndef _CONFIGMGR_SESSION_REMOTESESSION_HXX_
#include "remotesession.hxx"
#endif
#ifndef _CONFIGMGR_TRACER_HXX_
#include "tracer.hxx"
#endif
#ifndef CONFIGMGR_BOOTSTRAP_HXX_
#include "bootstrap.hxx"
#endif
#ifndef _CONFIGMGR_LOCAL_LOCAL_HXX_
#include "localsession.hxx"
#endif

namespace configmgr
{
	// ------------------------- Prototypes from Bootstrap -------------------------

	inline bool oslOK(::osl::FileBase::RC code) { return code == ::osl::FileBase::E_None; }
	inline bool oslOK(oslFileError code) { return code == osl_File_E_None; }

	const sal_Int32 nDefaultPort = 1024;

	// -----------------------------------------------------------------------------
	void extractRemoteParams(const ConnectionSettings& _rSettings,
							 ::rtl::OUString& _rServer, 
							 sal_Int32& _nPort, 							
							 ::rtl::OUString& _rUser, 
							 ::rtl::OUString& _rPassword)
	{
		// the simple ones
		if (_rSettings.hasUser())
			_rUser = _rSettings.getUser();
		if (_rSettings.hasPassword())
			_rPassword = _rSettings.getPassword();

		// server may need to be defaulted
		if (_rSettings.hasServer())
			_rServer = _rSettings.getServer();				

		// port may need to be defaulted
		if (_rSettings.hasPort())
			_nPort = _rSettings.getPort();
		else
		{
			_nPort = nDefaultPort;
			CFG_TRACE_INFO("session factory: no port specified for the session, defaulting to %i !", _nPort);
		}

	}

	// -----------------------------------------------------------------------------
	void extractPortalParams(const ConnectionSettings& _rSettings,
		::rtl::OUString& _rServer, sal_Int32& _nPort, ::rtl::OUString& _rUser, ::rtl::OUString& _rPassword)
	{
		// the simple ones
		if (_rSettings.hasUser())
			_rUser = _rSettings.getUser();
		if (_rSettings.hasPassword())
			_rPassword = _rSettings.getPassword();

		// server may need to be defaulted
		if (_rSettings.hasServer())
			_rServer = _rSettings.getServer();		

		// port may need to be defaulted
		if (_rSettings.hasPort())
			_nPort = _rSettings.getPort();
		else
		{
			_nPort = nDefaultPort;
			CFG_TRACE_INFO("session factory: no port specified for the session, defaulting to %i !", _nPort);
		}

	}

	// -----------------------------------------------------------------------------
	void extractTimeoutParam(const ConnectionSettings& _rSettings, TimeValue& _rTimeout, TimeValue*& _rpTimeout)
	{
		// the timeout : maybe a setting called "timeout" or a profile string
		_rTimeout.Seconds = _rTimeout.Nanosec = 0;

		sal_Int32 nTimeoutMilliSeconds = 0;	// no timeout at all
		if (_rSettings.hasTimeout())
			nTimeoutMilliSeconds = _rSettings.getTimeout();
		if (nTimeoutMilliSeconds > 0)
		{
			// we have a timeout, from whereever
			_rTimeout.Seconds += nTimeoutMilliSeconds / 1000;
			_rTimeout.Nanosec += 1000 * 1000 * (nTimeoutMilliSeconds % 1000);
			_rpTimeout = &_rTimeout;
			return;
		}
		// we don't have a timeout
		_rpTimeout = NULL;
	}

// for soplayer we don't the remote access to configuration data. There we drop the complete remote implementation -- sigh not very nice
#ifdef SVX_LIGHT
	// -----------------------------------------------------------------------------

	IConfigSession* createRemoteSession(
			uno::Reference<lang::XMultiServiceFactory> const& aServiceMgr,
			ConnectionSettings const& _rSettings)
	{
		return NULL;
	}

	// -----------------------------------------------------------------------------
	IConfigSession* createPortalSession(
			uno::Reference<lang::XMultiServiceFactory> const& aServiceMgr,
			ConnectionSettings const& _rSettings)
	{
		return NULL;
	}

#else

	// -----------------------------------------------------------------------------

	IConfigSession* createRemoteSession(
			uno::Reference<lang::XMultiServiceFactory> const& aServiceMgr,
			ConnectionSettings const& _rSettings)
	{
		// the common remote-like-session params
		::rtl::OUString sServer, sUser, sPassword;
		sal_Int32 nPort;
		extractRemoteParams(_rSettings, sServer, nPort, sUser, sPassword);

		// the timeout
		TimeValue aValue;
		TimeValue* pTimeout;
		extractTimeoutParam(_rSettings, aValue, pTimeout);

		// ------------------------------
		// got all params ... create and connect
		std::auto_ptr<ORemoteSession> pSession( new ORemoteSession(aServiceMgr) );

		sal_Bool bOpen = pSession->connect(sServer, nPort, pTimeout) &&
						 pSession->open(sUser, sPassword);
		if (!bOpen)
			throw com::sun::star::connection::ConnectionSetupException(OUString::createFromAscii("Unable to connect to the configuration registry server."),0);

		return pSession.release();
	}

// -----------------------------------------------------------------------------
	IConfigSession* createPortalSession(
			uno::Reference<lang::XMultiServiceFactory> const& aServiceMgr,
			ConnectionSettings const& _rSettings)
	{

		// the common remote-like-session params
		::rtl::OUString sServer, sUser, sPassword, sService;
		sal_Int32 nPort;
		extractRemoteParams(_rSettings, sServer, nPort, sUser, sPassword);

		// server may need to be defaulted
		if (_rSettings.hasService())
			sService = _rSettings.getService();		

		// the timeout
		TimeValue aValue;
		TimeValue* pTimeout;
		extractTimeoutParam(_rSettings, aValue, pTimeout);

		// was aquired once by getPortalConnector so it could be transported as void pointer
		std::auto_ptr<ORemoteSession> pSession( new ORemoteSession(aServiceMgr) );

		pSession->connectToPortal(aServiceMgr, sService, sServer, nPort, sUser, sPassword, pTimeout);
		return pSession.release();
	}

#endif

// -----------------------------------------------------------------------------

	IConfigSession* createLocalSession(
			uno::Reference< lang::XMultiServiceFactory > const& aServiceMgr,
			const ConnectionSettings& _rSettings)
	{
		// the update directory
		::rtl::OUString sUpdateDirectory = _rSettings.getUpdatePath();
		// the source directory
		::rtl::OUString sSourceDirectory = _rSettings.getSourcePath();

		// create it .. and connect
		std::auto_ptr<LocalSession> pLocal( new LocalSession(aServiceMgr) );
		pLocal->open(sSourceDirectory, sUpdateDirectory);		
		return pLocal.release();
	}

	// -----------------------------------------------------------------------------

	IConfigSession* createSetupSession(
			uno::Reference<lang::XMultiServiceFactory> const& aServiceMgr,
			ConnectionSettings const& _rSettings)
	{
		ConnectionSettings aSettings(_rSettings);

		// the source directory
		::rtl::OUString sSourceDirectory = _rSettings.getSourcePath();

		// create it .. and connect
		std::auto_ptr<LocalSession> pLocal( new LocalSession(aServiceMgr) );

		bool bReinitialize = _rSettings.hasReinitializeFlag() && _rSettings.getReinitializeFlag();
		pLocal->setSetupMode( bReinitialize );
		pLocal->open(sSourceDirectory, OUString());	
		return pLocal.release();
	}

// -----------------------------------------------------------------------------

//	IConfigSession* createPluginSession(
//			const uno::Reference<lang::XMultiServiceFactory>& _rxServiceMgr,
//			ConnectionSettings const& _rSettings)
//	{
//		std::auto_ptr<IConfigSession> pLocal;
//		try
//		{
//			pLocal = std::auto_ptr<IConfigSession>(createLocalSession(_pProfile, _rOfficeLocation, _rxServiceMgr, _rSettings));
//		}
//		catch(uno::Exception&) {}
//
//		if (pLocal.get())
//			return pLocal.release();
//
//		// could not open the local session -> fallback to a portal session
//		CFG_TRACE_INFO_NI("session factory: could not create a local session, using the fallback (a portal session)");
//
//		pLocal.reset();	// delete the unsuccessfull try
//
//		rtl::OUString sProfileLocation(_rOfficeLocation);
//		sProfileLocation += ::rtl::OUString::createFromAscii("/user");
//		return createPortalSession(_pProfile, sProfileLocation, _rxServiceMgr, _rSettings);
//	}

} // namespace configmgr




