/*************************************************************************
 *
 *  $RCSfile: redirector.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: dg $ $Date: 2001/05/03 11:37:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CONFIGMGR_SESSION_REDIRECTOR_HXX_
#define _CONFIGMGR_SESSION_REDIRECTOR_HXX_

#ifndef _COM_SUN_STAR_XML_SAX_XDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XDocumentHandler.hpp>
#endif
#ifndef _CONFIGMGR_SESSION_RS_TYPES_HXX_
#include "rs_types.hxx"
#endif

#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif
#ifndef _COMPHELPER_STLTYPES_HXX_ 
#include <comphelper/stl_types.hxx>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

#ifndef _CONFIGMGR_SESSION_CONFIGSESSION_HXX_
#include "configsession.hxx"
#endif

//..........................................................................
namespace configmgr
{
//..........................................................................

//==========================================================================
//= some helper structs (did not get this compiled when declared within
//= OResponseRedirector
//==========================================================================
/** to save memory, all callback interfaces are stored as <type>IRequestCallback</type> pointers, and this
	enumeration helps with identifying the correct type.
	<BR>
	You could think that this information is not needed, as the callback type is implicitly given by the data
	a response transaction contains, but this would not safe us from somebody giving us a callback of type A,
	when the response would need type B.
*/
enum CallbackType
{
	ctInvalid,			///	it's no valid callback
	ctRequest,			/// it's a simple IRequestCallback interface
	ctDataRequest,		/// it's an IDataRequestCallback
	ctObjectOpener,		/// it's an IOpenObjectCallback	
	ctNotifyRequest		/// it's an INotifyCallback	
};

/// description of a single callback
struct CallbackDescription
{
	CallbackType						eType;			/// the type of the interface pointed to by aCallback
	::vos::ORef< IRequestCallback >		aCallback;		/// the callback interface
	::vos::ORef< INotifyCallback >		aNotifyCallback;/// only used for opennodes to handle notifications
	rtl::OUString						sNodeId;		/// node id, which is only used for open node	

	CallbackDescription() : eType(ctInvalid) { }
	explicit CallbackDescription(const ::vos::ORef< IRequestCallback >& _rCB) : eType(ctRequest), aCallback(_rCB) { }
	explicit CallbackDescription(const ::vos::ORef< IDataRequestCallback >& _rCB) : eType(ctDataRequest), aCallback(_rCB.getBodyPtr()) { }	
	explicit CallbackDescription(const ::vos::ORef< IOpenObjectCallback >& _rCB,
						const ::vos::ORef< INotifyCallback >& _rNotifyCB = ::vos::ORef< INotifyCallback >()) : eType(ctObjectOpener), aCallback(_rCB.getBodyPtr()),
						aNotifyCallback(_rNotifyCB){ }	

	explicit CallbackDescription(const ::vos::ORef< INotifyCallback >& _rCB,						
						rtl::OUString _rNodeId) : eType(ctNotifyRequest), aCallback(_rCB.getBodyPtr()),
						sNodeId(_rNodeId){ }	

	// the node id is set during a response for an open node	 
	void setNodeId(const rtl::OUString& _rNodeId) {OSL_ENSURE(eType == ctObjectOpener, "Invalid callback type"); sNodeId = _rNodeId;}	
};

/** recognized elements in the structured xml stream
*/
enum ELEMENT
{
	ENVELOPE = 0,
	HEADER,
	REQUEST,
	TRANSACTION,
	BODY,
	PARAMS,
	DATA,
	VALUE,

	UNKNOWN
};

/** allowed transaction names as specified by the dtd
*/
enum TransactionType
{
	ttUnknown,

	ttRequest,
	ttResponse,
	ttError,
	ttAcknowledgment,
	ttNotification
};

/** allowed transaction types as specified by the dtd
*/
enum TransactionName
{
	tnUnknown,

	tnOpenSession,
	tnCloseSession,
	tnOpenNode,
	tnCloseNode,
	tnGetNode,
	tnUpdateNode,
	tnAddNode,
	tnDeleteNode,
	tnRequestNotify,
	tnGetStatus,
	tnCancelTransaction,
	tnAddUser,
	tnDeleteUser,
	tnAddGroup,
	tnDeleteGroup
};

/** type of a parameter
*/
enum ParamDataType
{
	pdtString,		/// <type scope="rtl">OUString</type>
	pdtInteger,		/// sal_Int32
	pdtBoolean,		/// sal_Bool
	pdtNodepath,	/// <type scope="rtl">OUString</type> describing a nodepath
	pdtNode,		/// a xml snipplet describing a node value
	pdtBinary,		/// Sequence< sal_Int8 >

	pdtUnknown		/// not recognized
};

//==========================================================================
//= OResponseRedirector
//==========================================================================
typedef ::cppu::WeakImplHelper1< ::com::sun::star::xml::sax::XDocumentHandler > OResponseRedirector_Base;
/** a class which translates responses of an remote config server into callback calls.
	<BR>
	For this purpose, it implements an <type scope="com::sun::star::xml::sax">XDocumentHandler</type> interface, which
	may be used to fed it with the xml stream as got from the config server. The implementations is rather
	sweet-tempered, as it reads over unknown elements, as long as the basic structure is as expected.
	<BR>
	The envelopes in the stream will be translated interpreted and forwarded to previously registered callbacks, which
	are (maybe derived from) <type>IRequestCallback</type> interfaces.
	<BR>
	As soon as a request is fully handled by the server (whether successull or not), the callback for this request
	is automatically deregistered.
*/
class OResponseRedirector : public OResponseRedirector_Base
{
protected:
	DECLARE_STL_USTRINGACCESS_MAP(CallbackDescription, Callbacks);
	DECLARE_STL_VECTOR( ::com::sun::star::uno::Any, Params );

	/** the interpretation of the (structured) xml stream is done by an quasi-finite :) automata (which is,
		by the definition usefull here, a finite automata with a very limited usage of a stack, some memory and
		a rather simple - nearly linear - state diagram), so we need some states.
		<BR>
		The following enumeration is not complete, as, for instance, we know the state "n levels deep within unknown
		elements" or "n levels deep within node data", where the latter means that we forward all tokens to
		a foreign <type scope="com::sun::star::xml::sax">XDocumentHandler</type>, while we just maintain the count
		mentioned.
	*/
	enum STATE
	{
		EXPECTING_ENVELOPE = 0,					/// we're outside of any envelope
		ENVELOPE_STARTED,						/// the envelope just started, we're expecting the header element
		HEADER_STARTED,							/// the header just started, we're expecting the transaction to start
		TRANS_STARTED,							/// the transaction token started, we expect it to end immediately
		TRANS_DONE,								/// the transaction token finished, we expect the end of the header
		HEADER_DONE,							/// the header is finished, we're expecting the body
		BODY_STARTED,							/// the body just started, we're expecting the parameters
		PARAMS_STARTED,							/// the parameters section just started, we're expecting a data block
		DATA_STARTED,							/// the data block started, we're expecting a value section
		VALUE_STARTED,							/// the value block started, we're expecting the "raw" data, which's interpretation depend from the param type
		VALUE_DONE,								/// we completely have read the value block
		DATA_DONE,								/// the block for a single parameter ended, we expect a new one or the end of the params section
		PARAMS_DONE,							/// the parameters section is over, we expect the end of the body
		BODY_DONE,								/// the body is finished, we expect the end of the envelope

		UNKNOWN_ELEMENT,						/// we're within an unknown structure, we just maintain <property>m_nElementDepth</property>
		FORWARDING_DATA							/// we're forwarding all tokens to a foreign <type scope="com::sun::star::xml::sax">XDocumentHandler</type> while maintaining <property>m_nElementDepth</property>
	};
	typedef ::std::pair< sal_Char*, STATE > ValidTransition;
	DECLARE_STL_VECTOR( ValidTransition, Transitions );

	/** encapsulates all informations collected from a server response header
	*/
	struct ResponseHeader
	{
		::rtl::OUString		sRequestId;		/// the id of the request the response refers to
		TransactionType		eTransType;		/// the name of the transaction
		TransactionName		eTransName;		/// the type of the transaction
		sal_Int32			nTransId;		/// the (server side) transaction id
		::rtl::OUString		sDescription;	/// may be omitted
	};

	::osl::Mutex		m_aMutex;				/// access safety
	Callbacks			m_aCallbacks;			/// map request ids to callbacks handling the reponses for the requests						

	STATE				m_eState;				/// the current state of our automata
	STATE				m_ePushedState;			/// if we're transiting to UNKNOWN_ELEMENT or FORWARDING_DATA, this remembers our previous state
	sal_Int32			m_nElementDepth;		/// if we're in state UNKNOWN_ELEMENT or FORWARDING_DATA, this is the nesting depth
	sal_Int32			m_nExpectedParams;		/// while in a params scope, this is the number of parameters we expect to follow (excluding the maybe currently opened one)
	sal_Int32			m_nCurrentParamNum;		/// the number of the currently parsed paramer, zero based
	ParamDataType		m_eCurrentParamType;	/// type of the currently parsed parameter
	ResponseHeader		m_aCurrentHeader;		/// header information of the envelope we're currently processing
	CallbacksIterator	m_aCurrentCallback;		/// callback which belongs to the request id in m_aCurrentHeader, if any, valid as soon as the header is finished
	Params				m_aCurrentBodyParams;	/// params as we parsed them in the current body
	::rtl::OUString		m_sCurrentParamValue;	/// the (accumulated) value of the current parameter
	::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XDocumentHandler >
						m_xCurrentNodeReader;	/** if we're reading a param value describing a node, we don't interpret this ourself but ask
													the responsible callback to do so - if we have one */

	sal_Bool			m_bIgnoreEnvelopeTail : 1;	/** if we're resetted within an envelope, we have to move to an
														EXPECTING_ENVELOPE state regulary while ignoring all additional
													data reading in this period
													*/	

protected:
	~OResponseRedirector();
		// no explicit destruction from outside

public:
	/** constructs the object
	*/
	OResponseRedirector();

// inserting callbacks
	/** register a simple IRequestCallback for a request
		@param		_rRequestId		the id of the request the callback is responsible for, as sent to the config server
		@param		_rCB			the callback interface
	*/
	void	registerCallback(const ::rtl::OUString& _rRequestId, const::vos::ORef< IRequestCallback >& _rCB);

	/** register a IDataRequestCallback for a request
		@param		_rRequestId		the id of the request the callback is responsible for, as sent to the config server
		@param		_rCB			the callback interface
	*/
	void	registerCallback(const ::rtl::OUString& _rRequestId, const::vos::ORef< IDataRequestCallback >& _rCB);

	/** register a IOpenObjectCallback for a request
		@param		_rRequestId		the id of the request the callback is responsible for, as sent to the config server
		@param		_rCB			the callback interface
	*/
	void	registerCallback(const ::rtl::OUString& _rRequestId, 
							 const ::vos::ORef< IOpenObjectCallback >& _rCB,
							 const ::vos::ORef< INotifyCallback >& _rNotifyCB = ::vos::ORef< INotifyCallback >());

	/** deregister notification callbacks
		@param		_rClientPath	NodeId which identifies the 
	*/
	void	removeCallback(const ::rtl::OUString& _rNodeId);		
	
	/** resets the object, which means that it (a) will move to a state where it expects a new envelope to start
		and (b) frees all it's callbacks
	*/
	void	reset();

// XDocumentHandler
	virtual void SAL_CALL startDocument(  ) throw(::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException);
	virtual void SAL_CALL endDocument(  ) throw(::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException);
	virtual void SAL_CALL startElement( const ::rtl::OUString& aName, const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList >& xAttribs ) throw(::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException);
	virtual void SAL_CALL endElement( const ::rtl::OUString& aName ) throw(::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException);
	virtual void SAL_CALL characters( const ::rtl::OUString& aChars ) throw(::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException);
	virtual void SAL_CALL ignorableWhitespace( const ::rtl::OUString& aWhitespaces ) throw(::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException);
	virtual void SAL_CALL processingInstruction( const ::rtl::OUString& aTarget, const ::rtl::OUString& aData ) throw(::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException);
	virtual void SAL_CALL setDocumentLocator( const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XLocator >& xLocator ) throw(::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException);

protected:
	/** translate the element name into an enumeration value
		@param	_rElementName	the string as got from <method>startElement</method> or <method>endElement</method>.
		@return					one of the <type>ELEMENT</type> enumeration values
	*/
	inline ELEMENT translateElement(const ::rtl::OUString& _rElementName);

	/** translate the name of a transaction into the num value
		@param	_rTransType		the transaction type as got from the attribute list in startElement
		@return					one of the <type>TransactionType</type> enumeration valuess
	*/
	inline TransactionType translateTransactionType(const ::rtl::OUString& _rTransType);

	/** translate the type of a transaction into the num value
		@param	_rTransName		the transaction name as got from the attribute list in startElement
		@return					one of the <type>TransactionName</type> enumeration valuess
	*/
	inline TransactionName translateTransactionName(const ::rtl::OUString& _rTransName);

	/** translate the type of a parameter into the num value
		@param	_rParamType		the transaction type as got from the attribute list in startElement
		@return					one of the <type>TransactionName</type> enumeration valuess
	*/
	inline ParamDataType translateParamDataType(const ::rtl::OUString& _rParamType);
};

//..........................................................................
}	// namespace configmgr
//..........................................................................

#endif // _CONFIGMGR_SESSION_REDIRECTOR_HXX_


