/*************************************************************************
 *
 *  $RCSfile: streamcompress.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: dg $ $Date: 2001/07/06 12:39:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef CONFIGMGR_STREAMCOMPRESS_HXX_
#include "streamcompress.hxx"
#endif

#ifndef _ZLIB_H
#include <zlib/zlib.h>
#endif 

#ifndef __SGI_STL_ALGORITHM
#include <algorithm>
#endif

#define ZCODEC_NO_COMPRESSION		(0x00000000UL)
#define ZCODEC_BEST_SPEED			(0x00000001UL)
#define	ZCODEC_DEFAULT_COMPRESSION	(0x00000006UL)
#define ZCODEC_BEST_COMPRESSION		(0x00000009UL)

#define ZCODEC_DEFAULT_STRATEGY		(0x00000000UL)
#define ZCODEC_ZFILTERED			(0x00000100UL)
#define ZCODEC_ZHUFFMAN_ONLY		(0x00000200UL)

#define ZCODEC_UPDATE_CRC			(0x00010000UL)
#define ZCODEC_GZ_LIB				(0x00020000UL)

#define ZCODEC_PNG_DEFAULT ( ZCODEC_NO_COMPRESSION | ZCODEC_DEFAULT_STRATEGY | ZCODEC_UPDATE_CRC )
#define ZCODEC_DEFAULT	( ZCODEC_DEFAULT_COMPRESSION | ZCODEC_DEFAULT_STRATEGY )

#define PZSTREAM static_cast<z_stream*>(m_pZipStream)
#define BUFFERSIZE 0x00008000UL

#ifdef compress
	#undef compress
#endif

namespace configmgr
{
	//------------------------------------------------------------------
	OStreamCompressor::OStreamCompressor()
					  :m_pZipStream(new z_stream())
					  ,m_aInBuf(BUFFERSIZE)
					  ,m_aOutBuf(BUFFERSIZE)
	{			
	}

	//------------------------------------------------------------------
	OStreamCompressor::~OStreamCompressor()
	{
		delete PZSTREAM;
	}

	//------------------------------------------------------------------
	void OStreamCompressor::initialize() 
	{		
		PZSTREAM->total_out = PZSTREAM->total_in = 0;	
		PZSTREAM->zalloc = ( alloc_func )0;
		PZSTREAM->zfree = ( free_func )0;
		PZSTREAM->opaque = ( voidpf )0;
		PZSTREAM->avail_out = PZSTREAM->avail_in = 0;
	}

	//------------------------------------------------------------------
	sal_Int32 OStreamCompressor::compress(const uno::Reference< io::XInputStream >& _xInput, const uno::Reference< io::XOutputStream > &_xOutput) 
		throw ( io::IOException, uno::RuntimeException )
	{		
		osl::MutexGuard aGuard(m_aMutex);
		
		initialize();				
		deflateInit2_( PZSTREAM, ZCODEC_BEST_SPEED & 0xff, Z_DEFLATED, 
				MAX_WBITS, 8, ( ZCODEC_BEST_SPEED >> 8 ) & 0xff, 
					ZLIB_VERSION, sizeof( z_stream ) );

		PZSTREAM->next_out = (sal_uInt8*) m_aOutBuf.getConstArray();
		PZSTREAM->avail_out = BUFFERSIZE;		
		
		while (( PZSTREAM->avail_in = _xInput->readBytes( m_aInBuf, BUFFERSIZE )) != 0 )
		{
			PZSTREAM->next_in = (sal_uInt8*) m_aInBuf.getConstArray();

			if ( PZSTREAM->avail_out == 0 ) 
				write(m_aOutBuf, _xOutput);

			char err = deflate( PZSTREAM, Z_NO_FLUSH );
			if ( err < 0 ) 
				throw io::IOException(rtl::OUString::createFromAscii("Error while compressing the stream"), uno::Reference < uno::XInterface >());
		};
		
		do
		{
			write(m_aOutBuf, _xOutput);
		}	while ( deflate( PZSTREAM, Z_FINISH ) != Z_STREAM_END );

		write(m_aOutBuf, _xOutput);
		deflateEnd( PZSTREAM );

		return (sal_Int32) PZSTREAM->total_in;
	}

	//------------------------------------------------------------------
	sal_Int32 OStreamCompressor::decompress(const uno::Reference< io::XInputStream > &_xInput, const uno::Reference< io::XOutputStream >& _xOutput) 
		throw ( io::IOException, uno::RuntimeException )
	{		
		osl::MutexGuard aGuard(m_aMutex);

		initialize();				
		inflateInit( PZSTREAM );

		PZSTREAM->next_out = (sal_uInt8*) m_aOutBuf.getConstArray();
		PZSTREAM->avail_out = BUFFERSIZE;	
		
		sal_uInt32 nMaxReadSize = 0xffffffff, 
				   nReadSize = 0;			

		char err;
		do
		{
			if ( PZSTREAM->avail_out == 0 ) 
				write(m_aOutBuf, _xOutput);

			if ( PZSTREAM->avail_in == 0 && nMaxReadSize )
			{		
				nReadSize = std::min( BUFFERSIZE, nMaxReadSize );

				PZSTREAM->avail_in = _xInput->readBytes( m_aInBuf, nReadSize );
				PZSTREAM->next_in = (sal_uInt8*) m_aInBuf.getConstArray();

				nMaxReadSize -= nReadSize;
			}
			err = inflate( PZSTREAM, Z_NO_FLUSH );
			if ( err < 0 )
				throw io::IOException(rtl::OUString::createFromAscii("Error while decompressing the stream"), uno::Reference < uno::XInterface >());

		}	while ( ( err != Z_STREAM_END)  && ( PZSTREAM->avail_in || nMaxReadSize ) );

		write(m_aOutBuf, _xOutput);		

		return (sal_Int32) PZSTREAM->total_out;
	}

	//------------------------------------------------------------------
	void OStreamCompressor::write(const uno::Sequence< sal_Int8>& _rData, const uno::Reference< io::XOutputStream > &_xOutput)
	{
		sal_Int32 nAvail = BUFFERSIZE - PZSTREAM->avail_out;	
		if ( nAvail )
		{			
			_xOutput->writeBytes(uno::Sequence <sal_Int8>(_rData.getConstArray(), nAvail));
			PZSTREAM->next_out = (sal_uInt8*) _rData.getConstArray();
			PZSTREAM->avail_out = BUFFERSIZE;
		}
	}
} // namespace configmgr


