/*************************************************************************
 *
 *  $RCSfile: xmlformater.hxx,v $
 *
 *  $Revision: 1.22 $
 *
 *  last change: $Author: jb $ $Date: 2001/11/14 16:45:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CONFIGMGR_XMLFORMATER_HXX
#define CONFIGMGR_XMLFORMATER_HXX

#ifndef _CONFIGMGR_TREE_VALUENODE_HXX
#include "valuenode.hxx"
#endif
#ifndef CONFIGMGR_CHANGE_HXX
#include "change.hxx"
#endif
#ifndef _CONFIGMGR_SESSION_CONFIGSESSION_HXX_
#include "configsession.hxx"
#endif
#ifndef _CONFIGMGR_STRDECL_HXX_
#include "strdecl.hxx"
#endif
#ifndef CONFIGMGR_UTILITY_HXX_
#include "utility.hxx"
#endif

#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XEXTENDEDDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XExtendedDocumentHandler.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XOutputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef _COM_SUN_STAR_SCRIPT_XTYPECONVERTER_HPP_
#include <com/sun/star/script/XTypeConverter.hpp>
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef INCLUDED_VECTOR
#include <vector>
#define INCLUDED_VECTOR
#endif

namespace configmgr
{
	namespace star = com::sun::star;
	namespace uno = com::sun::star::uno;
	namespace sax = com::sun::star::xml::sax;
	namespace script = com::sun::star::script;

	class AttributeListImpl;
	typedef node::Attributes NodeAttributes;
	typedef node::State      NodeState;

    using configuration::AbsolutePath;
	//==========================================================================
	//= CmXMLFormater
	//==========================================================================
	struct IXMLAttributeHandler
	{
        /// prepare the handler with context info: set the name of the current module
		virtual void setCurrentModule(OUString const& _sCurrentModule) = 0;

		// Handle the attributes, writing the attributes belonging to each type of node
		virtual NodeState handleAttributes(ValueNode const&, AttributeListImpl&)      = 0;
		virtual NodeState handleAttributes(ISubtree const&, AttributeListImpl&)       = 0;
		virtual NodeState handleAttributes(SubtreeChange const& , AttributeListImpl&) = 0;
		virtual NodeState handleAttributes(ValueChange const& , AttributeListImpl&)   = 0;	
        
		virtual bool      handleRemoval(RemoveNode const& , AttributeListImpl&)    = 0;

        // Handle the state/action of the node 
        virtual void handleState(NodeState , AttributeListImpl& , bool _bChanged) = 0;

		// Handle the attributes, if setting to default is to be marked via attributes
		virtual bool markDefaulted(Change const& , AttributeListImpl&)           = 0;
		
		// special handling of element name in sets
		virtual OUString translateElementName( OUString const& sNodeName, OUString const& sTypeName, 
												AttributeListImpl& ) = 0;
	};
// -----------------------------------------------------------------------------
	class OXMLAttributeHandler: public IXMLAttributeHandler
	{
	public:
		virtual ~OXMLAttributeHandler();

		OUString const& getCurrentModule() const
		{ return m_sCurrentModule; }

		// IXMLAttributeHandler
		virtual void setCurrentModule(OUString const& _sCurrentModule);

		virtual NodeState handleAttributes(ValueNode const&, AttributeListImpl&);
		virtual NodeState handleAttributes(ISubtree const&, AttributeListImpl&);
		virtual NodeState handleAttributes(SubtreeChange const& , AttributeListImpl&);
		virtual NodeState handleAttributes(ValueChange const& , AttributeListImpl&);
        
		virtual bool      handleRemoval(RemoveNode const& , AttributeListImpl&);
		
        virtual void handleState(NodeState , AttributeListImpl& , bool _bChanged);

		virtual bool markDefaulted(Change const& , AttributeListImpl&);

		// special handling of element name in sets
		virtual OUString translateElementName( OUString const& sNodeName, OUString const& sTypeName, 
												AttributeListImpl& );
	protected:
		NodeState implCommonAttributes(NodeAttributes const& aAttributes, AttributeListImpl& );
		void implValueAttributes(const uno::Type& _rType, AttributeListImpl& );
		void implLocalizedValueSetAttributes(const OUString& _rSpecialTemplateName, AttributeListImpl& );
		void implSetAttributes(OUString const& _sElementTypeName, OUString const& _sElementTypeModule, AttributeListImpl& );
		void implTypeAttributes(const OUString& _sTypeName, bool _bList, AttributeListImpl& _rList);
        void implStateAttributes(NodeState _eState, AttributeListImpl& );
	private:
		OUString m_sCurrentModule; // the module of the tree being parsed
	};
// -----------------------------------------------------------------------------
	class OXMLChangeAttributeHandler: public OXMLAttributeHandler
	{
	public:
		// IXMLAttributeHandler overrides
		virtual bool handleRemoval(RemoveNode const& , AttributeListImpl&);	

        virtual void handleState(NodeState , AttributeListImpl& , bool _bChanged);

		virtual bool markDefaulted(Change const& , AttributeListImpl&);
    };

// -----------------------------------------------------------------------------
	class ORemoteUpdateXMLAttributeHandler: public OXMLChangeAttributeHandler
	{
	public:
		// IXMLAttributeHandler overrides
		virtual NodeState handleAttributes(ISubtree const&, AttributeListImpl&);
		virtual NodeState handleAttributes(SubtreeChange const& , AttributeListImpl&);
		
        virtual void handleState(NodeState , AttributeListImpl& , bool _bChanged);

		// special handling of element name in sets
		virtual OUString translateElementName( OUString const& sNodeName, OUString const& sTypeName, 
												AttributeListImpl& );
	};

// -----------------------------------------------------------------------------
	struct XMLOutputContext
    {		
		uno::Reference < sax::XDocumentHandler >	m_xHandler;
		uno::Reference< script::XTypeConverter >	m_xTypeConverter;
	};

// -----------------------------------------------------------------------------
	struct XMLFormatContext
    {		
		XMLOutputContext	                        m_aOutput;
		rtl::OUString						        m_sLocale;		
		AttributeListImpl*							m_pAttrList; // need a ORef or similar for lifetime mgmt
		IXMLAttributeHandler*                       m_pAttributeHandler;
	};

// -----------------------------------------------------------------------------

	class XMLFormater
		:public IDOMNodeDataProvider
	{
	private:
		XMLFormatContext  m_aContext;
		const Change*     m_pChanges;

	public:
		XMLFormater(const SubtreeChange* _pChanges,
					  const vos::ORef<OOptions>& rOptions,
					 IXMLAttributeHandler& rAttrHandler);
		XMLFormater(const vos::ORef<OOptions>& rOptions, IXMLAttributeHandler& rAttrHandler);
		virtual ~XMLFormater();

        void setHandler(const uno::Reference< sax::XDocumentHandler > &rHandler);		
		uno::Reference< sax::XDocumentHandler > getSaxHandler() const {return m_aContext.m_aOutput.m_xHandler;}
		
		void setChange(const Change* _pChange) {m_pChanges = _pChange;}
		
		sal_Bool writeChange(Change const& _rChange, OUString const& sElementName, NodeState _eState) 
                    CFG_UNO_THROW1(xml::sax::SAXException);

		sal_Bool writeGroupElementChange(Change const& _rChange, NodeState _eState)                             
                    CFG_UNO_THROW1(xml::sax::SAXException);

		sal_Bool writeSetElementChange(Change const& _rChange, OUString const& sElementName, NodeState _eState) 
                    CFG_UNO_THROW1(xml::sax::SAXException);

		sal_Bool writeRootElementChange(Change const& _rChange, bool _bUseNew)               
                    CFG_UNO_THROW1(xml::sax::SAXException);

		sal_Bool writeAsFlat(AbsolutePath const& aRootNodePath, bool _bUseNew)               
                    CFG_UNO_THROW1(xml::sax::SAXException);
	protected:
		// IDOMNodeDataProvider
		virtual void writeNodeData(const uno::Reference< sax::XDocumentHandler >& _rHandler);

    private:
		void initContext(const vos::ORef<OOptions>& rOptions, IXMLAttributeHandler& rAttrHandler);
	};

// -----------------------------------------------------------------------------
} // namespace
#endif /* Header double load protection */

