/*************************************************************************
 *
 *  $RCSfile: localsession.hxx,v $
 *
 *  $Revision: 1.32 $
 *
 *  last change: $Author: jb $ $Date: 2001/11/09 11:52:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CONFIGMGR_LOCALSESSION_HXX_
#define _CONFIGMGR_LOCALSESSION_HXX_

#ifndef CONFIGMGR_TREEPROVIDER_HXX
#include "treeprovider.hxx"
#endif
#ifndef CONFIGMGR_DEFAULTPROVIDER_HXX
#include "defaultprovider.hxx"
#endif
#ifndef _CONFIGMGR_SESSION_CONFIGSESSION_HXX_
#include "configsession.hxx"
#endif
#ifndef CONFIGMGR_CHANGE_HXX
#include "change.hxx"
#endif
#ifndef CONFIGMGR_TREECHANGELIST_HXX
#include "treechangelist.hxx"
#endif
#ifndef CONFIGMGR_MISC_OPTIONS_HXX_
#include "options.hxx"
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XPARSER_HPP_
#include <com/sun/star/xml/sax/XParser.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XEXTENDEDDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XExtendedDocumentHandler.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XOutputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XACTIVEDATASOURCE_HPP_
#include <com/sun/star/io/XActiveDataSource.hpp>
#endif

#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#ifndef INCLUDED_VECTOR
#include <vector>
#define INCLUDED_VECTOR
#endif

namespace configmgr 
{
	namespace css = com::sun::star;
	namespace uno = css::uno;
	namespace io =  com::sun::star::io;
	namespace sax = css::xml::sax;
	namespace lang= css::lang;
	
	class XMLTreeBuilder;
	class OGenerateCache;
	class OLookupContext;
	struct ParserContext;
	struct FilterList;	
	
	class LocalSession : public IConfigSession,
						 public ITreeProvider,
						 public IDefaultProvider,
						 public ITemplateProvider
	{
		friend OGenerateCache;

	protected:
		::osl::Mutex							m_aMutex;				/// multi-thread access safety

		uno::Reference< sax::XParser >                  m_xParser;      // the service object for reading/parsing XML code
		uno::Reference< lang::XMultiServiceFactory >    m_xServiceProvider;		
		
		::rtl::OUString							m_aSharedURL, m_aUserURL;		
		
		sal_Int32								m_nAccessFlags;		
		TSessionError							m_eError;
		
	public:
		LocalSession(const uno::Reference< lang::XMultiServiceFactory >& _rxServiceProvider);
		virtual ~LocalSession();
		
		void setSetupMode(bool _bRecreateBinary = false);
		
		virtual TSessionError getError() const {return m_eError;}
		virtual sal_Int32   getConnectionError() const {return 0;}
		
		void open(const ::rtl::OUString& _rShareURLPath, const ::rtl::OUString& _rUserURLPath) CFG_UNO_THROW_ALL(  );
		virtual void close();
		sal_Bool isOpen();

		// 	supports the tree, default and template provider interfaces
		virtual ITreeProvider* asITreeProvider();
		virtual ITreeProvider const* asITreeProvider() const;
	    virtual IDefaultProvider* asIDefaultProvider();
        virtual ITemplateProvider* asITemplateProvider();

    	virtual sal_Bool isAutoLoadingDefaults() const;

		// ITreeProvider implementation
		virtual std::auto_ptr<ISubtree> loadSubtree( 
                                            AbsolutePath const& _aSubtreePath, 
                                            const vos::ORef < OOptions >& _xOptions, 
                                            sal_Int16 _nMinLevels = ALL_LEVELS
                                        ) CFG_UNO_THROW_ALL(  );

		virtual void updateTree(TreeChangeList& aChanges) CFG_UNO_THROW_ALL(  );

		// IDefaultProvider implementation
        virtual std::auto_ptr<ISubtree> requestDefaultData(
                                            configuration::AbsolutePath const& _aSubtreePath, 
										    const vos::ORef < OOptions >& _xOptions,
                                            sal_Int16 _nMinLevels
                                        ) CFG_UNO_THROW_ALL(  );

		// ITemplateProvider implementation
		virtual std::auto_ptr<INode> requestTemplateInstance(
                                            Name const& _aName, Name const& _aModule, 
										    const vos::ORef < OOptions >& _xOptions
                                        ) CFG_UNO_THROW_ALL(  );		
	protected:
		/// reads any kind of subtree and decide whether to load from share and from user directory
		std::auto_ptr<ISubtree> composeSubtree(OLookupContext const& _rLookup, 
											   const vos::ORef < OOptions >& _xOptions) CFG_UNO_THROW_ALL(  );
		
		/// loads a subtree. Makes the decision to read a binary file or XML file		
		std::auto_ptr<ISubtree> loadSubtree(OLookupContext const& _rLookup, 
											const vos::ORef<OOptions>& _rOptions) CFG_UNO_THROW_ALL(  );
		
		
		/// reads a changestree stored in a XML file
		bool                    loadTreeChangeFromXML(OLookupContext const& _rLookup,
													  TreeChangeList &_aChangeList) CFG_UNO_THROW_ALL(  );

		
		/// reads a substree stored in a XML file, initiates the creation of a binary file depending on the context		 
		std::auto_ptr<ISubtree> loadSubtreeFromXML(OLookupContext const& _rLookup, 
												   const vos::ORef<OOptions>& _rOptions) CFG_UNO_THROW_ALL(  );
		
		
		/// does the actual reading of the XML file, if _sCacheFileURL is set, creates a binary file during reading
		void readSubtreeFromXML(rtl::OUString const& _sFileURL, 
							    rtl::OUString const& _sCacheFileURL,
								uno::Reference< sax::XDocumentHandler > const& _xWriter,
								ParserContext & _aParserContext, 
								vector<OUString> const& _rFilter) CFG_UNO_THROW_ALL(  );		
		
		/// updates a configuration file in the default layer
		void writeSubtreeToXML(const rtl::OUString& _aTargetURL,
							   TreeChangeList& aChanges) CFG_UNO_THROW_ALL(  );				
		
		/// updates a configuration file in the user layer
		void writeTreeChangeToXML(const rtl::OUString& _aTargetURL,
								  TreeChangeList& aChanges) CFG_UNO_THROW_ALL(  );		


		
		uno::Reference< lang::XMultiServiceFactory > getServiceFactory() const {return m_xServiceProvider;}
	}; // LocalSession
// -----------------------------------------------------------------------------

	typedef ::cppu::WeakImplHelper1<sax::XDocumentHandler> CmDocumentHandler_BASE;

// -----------------------------------------------------------------------------

	class OSelectHandler :	public CmDocumentHandler_BASE
	{
	public:
		class Selector
		{
		public:
			enum State 
			{
				SEARCHING_DATA,
				IGNORING_DATA,
				HANDLING_DATA,
				DONE
			};
			enum Action
			{
				IGNORE,
                START_CONTEXT,
				START_HANDLING,
				KEEP_HANDLING,
				END_HANDLING
			};
		public:
			Selector(const std::vector< rtl::OUString > &aFilterVector);

			State state() const { return m_eState; }
			bool isHandling() const { return m_eState == HANDLING_DATA; }
			
			Action start(OUString const& aName);
			Action end();
			void reset();

		private:
			std::vector< rtl::OUString > const	m_aTarget;
			unsigned int m_nSearchDepth;
			unsigned int m_nHandleDepth;
			State		m_eState;
		};

	public:
		OSelectHandler::OSelectHandler( const uno::Reference< sax::XDocumentHandler > &xWriter,
										const std::vector<rtl::OUString> &aFilterVector,
										ParserContext& rParserContext);

		// XDocumentHandler
		virtual void SAL_CALL startDocument(void)
			throw (sax::SAXException, uno::RuntimeException);
		virtual void SAL_CALL endDocument(void)
			throw(sax::SAXException, uno::RuntimeException);
		virtual void SAL_CALL startElement(const rtl::OUString& aName,
										   const uno::Reference< sax::XAttributeList > &xAttribs)
			throw(sax::SAXException, uno::RuntimeException);
		virtual void SAL_CALL endElement(const rtl::OUString& aName)
			throw(sax::SAXException, uno::RuntimeException);
		virtual void SAL_CALL characters(const rtl::OUString& aChars)
			throw(sax::SAXException, uno::RuntimeException);

		virtual void SAL_CALL ignorableWhitespace(const rtl::OUString& aWhitespaces)
			throw(sax::SAXException, uno::RuntimeException);

		virtual void SAL_CALL processingInstruction(const rtl::OUString& aTarget,
													const rtl::OUString& aData)
			throw(sax::SAXException, uno::RuntimeException);
		virtual void SAL_CALL setDocumentLocator(const uno::Reference< sax::XLocator > &xLocator)
			throw(sax::SAXException, uno::RuntimeException);
		
	private:
		rtl::OUString getSelectName(const rtl::OUString& aName,
									const uno::Reference< sax::XAttributeList > &xAttribs);

        void updateContext(const uno::Reference< sax::XAttributeList > &xAttribs);

		Selector		 m_aSelector;
		ParserContext&   m_rParserContext;
		uno::Reference< sax::XDocumentHandler > const m_xHandler;  // the parser that handles the found substructure
	};
// -----------------------------------------------------------------------------
} // namespace configmgr

#endif // _CONFIGMGR_LOCALSESSION_HXX_
