/*************************************************************************
 *
 *  $RCSfile: encodename.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: jb $ $Date: 2001/07/05 17:05:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CONFIGMGR_API_ENCODENAME_HXX_
#define CONFIGMGR_API_ENCODENAME_HXX_

namespace rtl { class OUString; }

#ifndef _COM_SUN_STAR_UTIL_XSTRINGESCAPE_HPP_
#include <com/sun/star/util/XStringEscape.hpp>
#endif

#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif

namespace configmgr
{
	namespace css = ::com::sun::star;
	namespace uno  = css::uno;
	namespace lang = css::lang;
	namespace util = css::util;

	using ::rtl::OUString;

	//============================================================================
	//= general encoding/decoding
	namespace encodename
	{

	//============================================================================
	/** Encode an arbitrary UTF-16 string to make it conform to the pattern
		<[(ALPHA / DIGIT / "_") (ALPHA / DIGIT / "_" / "-" / ".")*]>.

		@param rSource  
			An arbitrary UTF-16 string.

		@return  A suitably encoded string (using a modified UTF-7 scheme).
	 */
		OUString encode(OUString const & rSource);

	/** Encode a pair of arbitrary UTF-16 strings to make the result conform to the pattern
		<[(ALPHA / DIGIT / "_") (ALPHA / DIGIT / "_" / "-" / ".")*]>.
        <BR/>
        The result of encode_pair(aString,"") will be the same as the result of encode(aString)

		@param rPrimary  
			An arbitrary UTF-16 string.

		@param rSecondary  
			An arbitrary UTF-16 string.

		@return  A suitably encoded string (using a modified UTF-7 scheme).
	 */
		OUString encode_pair(OUString const & rPrimary, OUString const& rSecondary);

	/** Decode a string previously encoded using encode().

		@param rSource  
			A UTF-16 string encoded by encode().

		@param rbValid  
			On exit: false if the string wasn't a valid encoded string.

		@returns  
			The decoded string; or the undecoded input, if it is not a string
			encoded by encode().
	 */
		OUString decode(OUString const & rSource, bool& rbValid);

	/** Decode a string previously encoded using encode() or encode_pair.
        <BR/>If only one string was encoded using encode(), it will be 
        returned in _rsPrimary, and _rsSecondary will be empty.

		@param rSource  
			A UTF-16 string encoded by encode() or encode_pair().

		@param rsPrimary  
			On exit: The decoded (primary) string; or the undecoded input, 
            if it is not a string encoded by encode() or encode_pair().

		@param rbValid  
			On exit: false if the string wasn't a valid encoded string.

		@param rsSecondary  
			On exit: The decoded secondary string; or an empty string, 
            if it is not a string encoded by encode_pair().

		@returns  
			True, if the string contained a full pair or at least a name that needed encoding
            False, if it contained only a single (primary) string.
	 */
		bool decode_pair(OUString const & rSource, OUString & rsPrimary, OUString & rsSecondary, bool& rbValid);

	/** Decode a list of strings previously encoded using encode().

		@param rSource  
			A UTF-16 string encoded by encode().

		@param rbValid  
			On exit: false if the string wasn't a valid encoded string.

		@returns  
			The decoded string; or the undecoded input, if it is not a string
			encoded by encode().
	 */	
		uno::Sequence< ::rtl::OUString > decode(uno::Sequence< ::rtl::OUString >const& rSource);

	//============================================================================
	/** Check whether a string conforms to the pattern
		<[(ALPHA / DIGIT / "_") (ALPHA / DIGIT / "_" / "-" / ".")*]>.

		@param rSource  
			An arbitrary UTF-16 string.

		@return  
			true if the string is allowed by the rules
	 */
		bool validate( const OUString& aString);
	}

	//============================================================================
	//= encoding/decoding wrapper for usage in an XStringEscape implementation
	namespace escaped_name 
	{
		/// check whether a name is valid (e.g. but not restricted to an escaped name) 
		void validateName( const OUString& aString, uno::XInterface* pSource = 0, sal_Int16 index = -1) throw(lang::IllegalArgumentException, uno::RuntimeException);

		// XStringEscape implementation
		OUString escapeString( const OUString& aString, util::XStringEscape* pSource = 0, sal_Int16 index = -1 ) throw(lang::IllegalArgumentException, uno::RuntimeException);

		OUString unescapeString( const OUString& aEscapedString, util::XStringEscape* pSource = 0, sal_Int16 index = -1 ) throw(lang::IllegalArgumentException, uno::RuntimeException);
	}

}

#endif CONFIGMGR_API_ENCODENAME_HXX_
