/*************************************************************************
 *
 *  $RCSfile: adminproviderimpl.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: jb $ $Date: 2001/11/09 11:23:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CONFIGMGR_API_ADMINPROVIDERIMPL_HXX_
#define CONFIGMGR_API_ADMINPROVIDERIMPL_HXX_

#ifndef CONFIGMGR_API_PROVIDERIMPL_HXX_
#include "providerimpl.hxx"
#endif

#include "template.hxx"

namespace com { namespace sun { namespace star { namespace uno {
	class Any;
	class XInterface;
	template <class> class Sequence;
	template <class> class Reference;
}	}	}	}

namespace configmgr
{
	namespace css		= ::com::sun::star;
	namespace uno		= css::uno;
	namespace script	= css::script;	
	
	class OAdminProviderImpl : public OProviderImpl			
	{		
		friend class OAdminProvider;			
		::rtl::OUString				m_sDefaultUser;
		uno::Sequence <sal_Int8>	m_aDefaultPwd;

		configuration::SpecialTemplateProvider m_aSpecialTemplateProvider;
	public:
		// factory methods
		uno::Reference<uno::XInterface>  createReadAccess( uno::Sequence<uno::Any> const& aArgs) CFG_UNO_THROW_ALL(  );
		uno::Reference<uno::XInterface>  createUpdateAccess( uno::Sequence<uno::Any> const& aArgs) CFG_UNO_THROW_ALL(  );		
		uno::Reference<uno::XInterface>  createUserAccess( uno::Sequence<uno::Any> const& aArgs ) CFG_UNO_THROW_ALL(  );
		uno::Reference<uno::XInterface>  createGroupAccess( uno::Sequence<uno::Any> const& aArgs ) CFG_UNO_THROW_ALL(  );

	private:
		OAdminProviderImpl(OAdminProvider* _pProvider, 
						   const uno::Reference< lang::XMultiServiceFactory >& _xServiceFactory);

		virtual void initFromSettings(const ConnectionSettings& _rSettings, bool& rNeedProfile);		
		virtual void initFromProfile(ISubtree const* pProfile);		
		
	public:
		virtual ~OAdminProviderImpl();

		IConfigSession*	  getSession() const 
		{ return m_pSession; }
				
		// TemplateProvider access
		configuration::SpecialTemplateProvider  getSpecialTemplateProvider() const 
		{ return m_aSpecialTemplateProvider; }

		configuration::TemplateProvider  getTemplateInstanceProvider(vos::ORef<OOptions> const& xOptions) const 
		{ return configuration::TemplateProvider( OProviderImpl::getTemplateProvider(), xOptions ); }

		uno::Sequence <sal_Int8> getDefaultPwd() const 
		{ return m_aDefaultPwd; }		
	};

} // namespace configmgr

#endif // CONFIGMGR_API_ADMINPROVIDERIMPL_HXX_


