/*************************************************************************
 *
 *  $RCSfile: storitem.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/25 13:04:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _CHAOS_STORITEM_CXX "$Revision: 1.2 $"

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _REF_HXX
#include <tools/ref.hxx>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _SFXITEMSET_HXX
#include <svtools/itemset.hxx>
#endif
#ifndef _SFXITEMPOOL_HXX
#include <svtools/itempool.hxx>
#endif
#ifndef _SFXPOOLITEM_HXX
#include <svtools/poolitem.hxx>
#endif

#ifndef _CHAOS_STORITEM_HXX
#include "storitem.hxx"
#endif
#ifndef _CHAOS_STORSTRM_HXX
#include "storstrm.hxx"
#endif

using namespace chaos;

#ifdef _CHAOS_STORITEM_REF
SV_IMPL_REF(CntStoreItemSet);
#endif

/*========================================================================
 *
 * CntStoreItemSet implementation.
 *
 *======================================================================*/
/*
 * initialize (two-phase construction).
 */
ErrCode CntStoreItemSet::initialize (
	SvLockBytes *pLockBytes,
	StreamMode   eMode)
{
	ErrCode eErrCode = ERRCODE_IO_INVALIDPARAMETER;
	if (pLockBytes)
	{
		CntStoreStream aStrm (pLockBytes, STREAM_READ);

		aStrm.SetVersion (GetPool()->GetFileFormatVersion());
		aStrm.SetNumberFormatInt (NUMBERFORMAT_INT_LITTLEENDIAN);

		Load (aStrm, TRUE);

		eErrCode = aStrm.GetErrorCode();
		if ((eErrCode == ERRCODE_NONE) && (eMode & STREAM_WRITE))
		{
			// Remember LockBytes when writeable and all is well.
			m_xLockBytes = pLockBytes;
		}
	}
	return eErrCode;
}

/*
 * ~CntStoreItemSet.
 */
CntStoreItemSet::~CntStoreItemSet (void)
{
	if (m_xLockBytes.Is() && m_bChanged)
	{
		ErrCode eErrCode = m_xLockBytes->SetSize(0);
		if (eErrCode == ERRCODE_NONE)
		{
			CntStoreStream aStrm (&m_xLockBytes, STREAM_READWRITE);

			aStrm.SetVersion (GetPool()->GetFileFormatVersion());
			aStrm.SetNumberFormatInt (NUMBERFORMAT_INT_LITTLEENDIAN);

			Store (aStrm, TRUE);
		}
	}
}

/*
 * Changed.
 */
void CntStoreItemSet::Changed (
	const SfxPoolItem &, const SfxPoolItem &)
{
	m_bChanged |= m_xLockBytes.Is();
}

/*
 * createItemSet.
 */
ErrCode CntStoreItemSet::createItemSet (
	CntStoreItemSet *&rpItemSet,
	SvLockBytes      *pLockBytes,
	StreamMode        eMode,
	SfxItemPool      &rPool,
	const USHORT     *pWhichPairTable)
{
	ErrCode eErrCode = ERRCODE_IO_INVALIDPARAMETER;
	if ((rpItemSet == NULL) && (pLockBytes != NULL))
	{
		if (pWhichPairTable)
			rpItemSet = new CntStoreItemSet (
				rPool, pWhichPairTable);
		else
			rpItemSet = new CntStoreItemSet (
				rPool, rPool.GetFrozenIdRanges());

		eErrCode = rpItemSet->initialize (pLockBytes, eMode);
		if (eErrCode != ERRCODE_NONE)
			DELETEZ (rpItemSet);
	}
	return eErrCode;
}

/*
 * loadItemSet.
 */
ErrCode CntStoreItemSet::loadItemSet (
	SfxItemSet  &rItemSet,
	SvLockBytes &rLockBytes)
{
	CntStoreStream aStrm (&rLockBytes, STREAM_READ);

	aStrm.SetVersion (rItemSet.GetPool()->GetFileFormatVersion());
	aStrm.SetNumberFormatInt (NUMBERFORMAT_INT_LITTLEENDIAN);

	rItemSet.Load (aStrm, TRUE);

	return aStrm.GetErrorCode();
}

