/*************************************************************************
 *
 *  $RCSfile: sortitem.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _COM_SUN_STAR_UCB_SORTINGINFO_HPP_
#include <com/sun/star/ucb/SortingInfo.hpp>
#endif

#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif

#ifndef _CNTPOOL_HXX
#include <cntpool.hxx>
#endif

#define _SORTITEM_CXX
#include <sortitem.hxx>

using namespace chaos;

//-------------------------------------------------------------------------

TYPEINIT1_AUTOFACTORY(CntSortingItem, SfxPoolItem);
SV_IMPL_OBJARR(CntSortingInfoArr, CntSortingInfo);

//=========================================================================

BOOL CntSortingInfo::operator==( const CntSortingInfo &rOther ) const
{
	return _nSortingWID == rOther._nSortingWID &&
		   _bAscending == rOther._bAscending;
}

//-------------------------------------------------------------------------

SvStream& chaos::operator>>( SvStream &rStream, CntSortingInfo &rInfo )
{
	return rStream >> rInfo._nSortingWID
				   >> rInfo._bAscending;
}

//-------------------------------------------------------------------------

SvStream& chaos::operator<<( SvStream &rStream, const CntSortingInfo &rInfo )
{
	return rStream << rInfo._nSortingWID
				   << rInfo._bAscending;
}

//=========================================================================

CntSortingItem::CntSortingItem( USHORT nWhich )
:	SfxPoolItem(nWhich)
{
}

//-------------------------------------------------------------------------

CntSortingItem::CntSortingItem( USHORT nWhich, SvStream &rStream )
:	SfxPoolItem( nWhich )
{
	USHORT nCount = 0;
	rStream >> nCount;
	for ( USHORT n = 0; n < nCount; ++n )
	{
		CntSortingInfo aInfo;
		rStream >> aInfo;
		Append( aInfo );
	}
}

//-------------------------------------------------------------------------

CntSortingItem::CntSortingItem( const CntSortingItem &rOrig )
:	SfxPoolItem( rOrig )
{
	for ( USHORT n = 0; n < rOrig.Count(); ++n )
		Append( rOrig[n] );
}

//-------------------------------------------------------------------------

CntSortingItem::~CntSortingItem()
{
}

//-------------------------------------------------------------------------

int CntSortingItem::operator==( const SfxPoolItem &rItem ) const
{
	const CntSortingItem& rOther = (const CntSortingItem&) rItem;
	if ( Count() != rOther.Count() )
		return FALSE;

	for ( USHORT n = 0; n < Count(); ++n )
		if ( operator[](n) != rOther[n] )
			return FALSE;

	return TRUE;
}

//-------------------------------------------------------------------------

SfxPoolItem* CntSortingItem::Clone( SfxItemPool * ) const
{
	return new CntSortingItem( *this );
}

//-------------------------------------------------------------------------

SfxPoolItem* CntSortingItem::Create(SvStream &rStream, USHORT nItemVersion) const
{
	return new CntSortingItem( Which(), rStream );
}

//-------------------------------------------------------------------------

SvStream& CntSortingItem::Store(SvStream &rStream, USHORT nItemVersion ) const
{
	rStream << Count();
	for ( USHORT n = 0; n < Count(); ++n )
		rStream << operator[](n);
	return rStream;
}

//-------------------------------------------------------------------------

void CntSortingItem::Push( const CntSortingInfo& rInfo, USHORT nMaxCount )
{
	USHORT nPos = 0;
	while( nPos < _aInfos.Count() )
	{
		if( _aInfos[ nPos ].GetSortingWID() == rInfo.GetSortingWID() )
			_aInfos.Remove( nPos );
		else
			nPos++;
	}
	_aInfos.Insert( rInfo, 0 );
	while( _aInfos.Count() > nMaxCount )
		_aInfos.Remove( _aInfos.Count()-1 );
}

//-------------------------------------------------------------------------

BOOL CntSortingItem::Contains( USHORT nWhich ) const
{
	for ( USHORT n = 0; n < Count(); ++n )
	{
		if ( operator[](n).GetSortingWID() == nWhich )
			return TRUE;
	}

	return FALSE;
}

//-------------------------------------------------------------------------

BOOL CntSortingItem::Contains( USHORT nWhich, BOOL &rAscending ) const
{
	for ( USHORT n = 0; n < Count(); ++n )
	{
		if ( operator[](n).GetSortingWID() == nWhich )
		{
			rAscending = operator[](n).GetAscending();
			return TRUE;
		}
	}

	return FALSE;
}

//----------------------------------------------------------------------------
// virtual
BOOL CntSortingItem::PutValue( const com::sun::star::uno::Any& rVal,
						   	   BYTE nMemberId )
{
	com::sun::star::uno::Sequence< com::sun::star::ucb::SortingInfo > aValue;
	if ( rVal >>= aValue )
	{
		const CntItemMap* pItemMap = CntItemPool::GetItemMap();
		if ( !pItemMap )
			return FALSE;

		// Destroy old array.
		while ( _aInfos.Count() )
			_aInfos.Remove( 0 );

		// Assemble new array.
		sal_uInt32 nCount = aValue.getLength();
		const com::sun::star::ucb::SortingInfo* pInfo =
													aValue.getConstArray();
		for ( sal_uInt32 n = 0; n < nCount; ++n )
		{
			rtl::OUString aName = pInfo[ n ].PropertyName;
			BOOL bMode = pInfo[ n ].Ascending;
			const CntItemMapEntry* pEntry =	pItemMap->Prop2Which( aName );
			if ( pEntry )
			{
				CntSortingInfo aInfo( pEntry->nWhich, bMode );
				Append( aInfo );
			}
		}
		return TRUE;
	}

	DBG_ERROR( "SfxDateTimeItem::PutValue - Wrong type!" );
	return FALSE;
}

//----------------------------------------------------------------------------
// virtual
BOOL CntSortingItem::QueryValue( com::sun::star::uno::Any& rVal,
							 	 BYTE nMemberId ) const
{
	sal_uInt32 nCount = _aInfos.Count();

	const CntItemMap* pItemMap = CntItemPool::GetItemMap();
	if ( !pItemMap && nCount )
		return FALSE;

	com::sun::star::uno::Sequence<
				com::sun::star::ucb::SortingInfo > aValue( nCount );
	com::sun::star::ucb::SortingInfo* pProps = aValue.getArray();
	sal_uInt32 nArrPos = 0;

	for ( sal_uInt32 n = 0; n < nCount; ++n )
	{
		const CntItemMapEntry* pEntry =
						pItemMap->Which2Prop( _aInfos[ n ].GetSortingWID() );
		if ( pEntry )
		{
			pProps[ nArrPos ].PropertyName
				= rtl::OUString::createFromAscii(pEntry->pName);
			pProps[ nArrPos ].Ascending    = _aInfos[ n ].GetAscending();

			++nArrPos;
		}
	}

	aValue.realloc( nArrPos );

	rVal <<= aValue;
	return TRUE;
}

